/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POS_TRANSACTIONCARD t ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class PosTransactionCardItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=false, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", i18n=true)
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="85")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pos_card_deptName", width="120")
    private String deptName;
    @Column(name="t.CARD")
    @GridColumn(label="pos_card_card", width="90")
    private String card;
    @Column(name="t.SYS_CARD_NO")
    @GridColumn(label="pos_card_accountNum", width="90")
    private Integer sysCardNo;
    @Column(name="t.CARD_SERIAL")
    @GridColumn(label="pos_card_cardSerial", width="125")
    private Integer cardSerial;
    @Column(name="t.HIDE_COLUMN")
    @GridColumn(label="pos_card_typeName", width="90", format="0=pos_op_lostCard,1=pos_op_topUp,2=pos_card_subsidy,3=pos_op_unbindHang,4=pos_card_expenditureCost,5=pos_op_refund,6=pos_op_sendCard,7=pos_card_cost,11=pos_card_manageCost,13=pos_card_rechargePrivilege,14=pos_op_noneRetreatCard,15=pos_op_retreatCard,16=pos_card_manageCard,17=pos_card_operateCard,18=pos_op_manage_card_logout,19=pos_op_operate_card_logout")
    private Integer hideColumn;
    @Column(name="t.CARD_CASH_TYPE")
    @GridColumn(label="pos_card_cardType", width="60", format="0=pos_inCome,1=pos_expenses")
    private Integer cardCashType;
    @Column(name="t.ALLOW_TYPE")
    @GridColumn(label="pos_card_subsidyType", width="90", format="0=pos_dev_addSubsidy,1=pos_dev_clearSubsidy")
    private Integer allowType;
    @Column(name="CAST(t.MONEY AS DECIMAL(18,2))")
    @GridColumn(label="pos_card_money", width="78", format="0=0.0")
    private Double money;
    @Column(name="CAST(t.SUBMONEY AS DECIMAL(18,2))")
    @GridColumn(label="pos_card_subMoney", width="88", format="0=0.0")
    private Double subMoney;
    @Column(name="CAST(t.BALANCE AS DECIMAL(18,2))")
    @GridColumn(label="pos_card_blance", width="78", format="0=0.0")
    private Double balance;
    @Column(name="CAST(t.SUBBALANCE AS DECIMAL(18,2))")
    @GridColumn(label="pos_card_subBlance", width="88", format="0=0.0")
    private Double subBalance;
    @Column(name="t.CONVEY_TIME")
    @GridColumn(label="pos_card_creatTime", width="130")
    private Date conveyTime;
    @Column(name="t.CHECK_TIME")
    @GridColumn(label="pos_card_changeTime", width="130")
    private Date checkTime;
    @Column(name="t.SN_NAME")
    @GridColumn(label="common_dev_sn", width="130")
    private String snName;
    @Column(name="t.SERIAL_NUM")
    @GridColumn(label="pos_card_serialnum", width="130")
    private Integer serialNum;
    @Column(name="t.CREATER_NAME")
    @GridColumn(label="pos_card_creatOperator", width="120")
    private String creatOperator;
    @Column(name="t.UPDATER_NAME")
    @GridColumn(label="pos_card_changeOperator", width="120")
    private String updaterName;
    @Column(name="t.LOG_FLAG")
    @GridColumn(label="pos_card_logFlag", width="150", format="1=pos_device_upload,2=pos_system_add", show=true)
    private Integer logFlag;
    @Column(name="t.CHANGE_TIME")
    @GridColumn(label="pos_transactionCard_changeTime", show=false)
    private Date changeTime;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="pos_transactionCard_creatTime", show=false)
    private Date createTime;
    @Column(name="t.STATUS")
    @GridColumn(label="pos_transactionCard_status", show=false)
    private String status;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="pos_transactionCard_deptCode", show=false)
    private String deptCode;
    @Column(name="t.DISCOUNT")
    @GridColumn(label="pos_transactionCard_discount", show=false)
    private Integer discount;
    @Column(name="t.ALLOW_BATCH")
    @GridColumn(label="pos_transactionCard_allowBatch", show=false)
    private Integer allowBatch;
    @Column(name="t.ALLOW_BASE_BATCH")
    @GridColumn(label="pos_transactionCard_allowBaseBatch", show=false)
    private Integer allowBaseBatch;
    @Column(name="t.RECHARGE_TYPE")
    @GridColumn(label="pos_transactionCard_rechargeType", show=false)
    private Integer rechargeType;
    @Column(name="t.ISSUE_DATE")
    @GridColumn(label="pos_transactionCard_issueDate", show=false)
    private Date issueDate;
    @Column(name="t.CARD_NAME")
    @GridColumn(label="pos_transactionCard_cardName", show=false)
    private String cardName;
    @Column(name="t.UNIQUE_KEY")
    @GridColumn(label="pos_transactionCard_uniqueKey", show=false)
    private String uniqueKey;
    @Column(name="t.RECORD_TYPE")
    @GridColumn(label="pos_card_typeName", show=false)
    private Integer recordType;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="pos_transactionCard_personId", show=false)
    private String personId;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="pos_transactionCard_deptId", show=false)
    private String deptId;
    @Condition(value="t.CHECK_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.CHECK_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(t.PERSON_NAME) LIKE ''%{0}%'' OR lower(t.PERSON_LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;

    public PosTransactionCardItem() {
    }

    public PosTransactionCardItem(Date createTime, Date checkTime, String status, String personId, String pin, String personName, String personLastName, String deptId, String deptCode, String deptName, String card, Integer sysCardNo, Integer cardSerial, Double money, Integer hideColumn, Double balance, Integer logFlag, Date issueDate, String cardName, Integer cardCashType, Double subMoney, Double subBalance) {
        this.createTime = createTime;
        this.checkTime = checkTime;
        this.status = status;
        this.personId = personId;
        this.personPin = pin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.deptId = deptId;
        this.deptCode = deptCode;
        this.deptName = deptName;
        this.card = card;
        this.sysCardNo = sysCardNo;
        this.cardSerial = cardSerial;
        this.money = money;
        this.hideColumn = hideColumn;
        this.balance = balance;
        this.logFlag = logFlag;
        this.issueDate = issueDate;
        this.cardName = cardName;
        this.cardCashType = cardCashType;
        this.subMoney = subMoney;
        this.subBalance = subBalance;
    }

    public PosTransactionCardItem(Boolean equals) {
        super(equals);
    }

    public PosTransactionCardItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getCard() {
        return this.card;
    }

    public Integer getSysCardNo() {
        return this.sysCardNo;
    }

    public Integer getCardSerial() {
        return this.cardSerial;
    }

    public Integer getHideColumn() {
        return this.hideColumn;
    }

    public Integer getCardCashType() {
        return this.cardCashType;
    }

    public Integer getAllowType() {
        return this.allowType;
    }

    public Double getMoney() {
        return this.money;
    }

    public Double getSubMoney() {
        return this.subMoney;
    }

    public Double getBalance() {
        return this.balance;
    }

    public Double getSubBalance() {
        return this.subBalance;
    }

    public Date getConveyTime() {
        return this.conveyTime;
    }

    public Date getCheckTime() {
        return this.checkTime;
    }

    public String getSnName() {
        return this.snName;
    }

    public Integer getSerialNum() {
        return this.serialNum;
    }

    public String getCreatOperator() {
        return this.creatOperator;
    }

    public String getUpdaterName() {
        return this.updaterName;
    }

    public Integer getLogFlag() {
        return this.logFlag;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public Integer getDiscount() {
        return this.discount;
    }

    public Integer getAllowBatch() {
        return this.allowBatch;
    }

    public Integer getAllowBaseBatch() {
        return this.allowBaseBatch;
    }

    public Integer getRechargeType() {
        return this.rechargeType;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getCardName() {
        return this.cardName;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public Integer getRecordType() {
        return this.recordType;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public PosTransactionCardItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosTransactionCardItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosTransactionCardItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosTransactionCardItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosTransactionCardItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosTransactionCardItem setCard(String card) {
        this.card = card;
        return this;
    }

    public PosTransactionCardItem setSysCardNo(Integer sysCardNo) {
        this.sysCardNo = sysCardNo;
        return this;
    }

    public PosTransactionCardItem setCardSerial(Integer cardSerial) {
        this.cardSerial = cardSerial;
        return this;
    }

    public PosTransactionCardItem setHideColumn(Integer hideColumn) {
        this.hideColumn = hideColumn;
        return this;
    }

    public PosTransactionCardItem setCardCashType(Integer cardCashType) {
        this.cardCashType = cardCashType;
        return this;
    }

    public PosTransactionCardItem setAllowType(Integer allowType) {
        this.allowType = allowType;
        return this;
    }

    public PosTransactionCardItem setMoney(Double money) {
        this.money = money;
        return this;
    }

    public PosTransactionCardItem setSubMoney(Double subMoney) {
        this.subMoney = subMoney;
        return this;
    }

    public PosTransactionCardItem setBalance(Double balance) {
        this.balance = balance;
        return this;
    }

    public PosTransactionCardItem setSubBalance(Double subBalance) {
        this.subBalance = subBalance;
        return this;
    }

    public PosTransactionCardItem setConveyTime(Date conveyTime) {
        this.conveyTime = conveyTime;
        return this;
    }

    public PosTransactionCardItem setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
        return this;
    }

    public PosTransactionCardItem setSnName(String snName) {
        this.snName = snName;
        return this;
    }

    public PosTransactionCardItem setSerialNum(Integer serialNum) {
        this.serialNum = serialNum;
        return this;
    }

    public PosTransactionCardItem setCreatOperator(String creatOperator) {
        this.creatOperator = creatOperator;
        return this;
    }

    public PosTransactionCardItem setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
        return this;
    }

    public PosTransactionCardItem setLogFlag(Integer logFlag) {
        this.logFlag = logFlag;
        return this;
    }

    public PosTransactionCardItem setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
        return this;
    }

    public PosTransactionCardItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PosTransactionCardItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public PosTransactionCardItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PosTransactionCardItem setDiscount(Integer discount) {
        this.discount = discount;
        return this;
    }

    public PosTransactionCardItem setAllowBatch(Integer allowBatch) {
        this.allowBatch = allowBatch;
        return this;
    }

    public PosTransactionCardItem setAllowBaseBatch(Integer allowBaseBatch) {
        this.allowBaseBatch = allowBaseBatch;
        return this;
    }

    public PosTransactionCardItem setRechargeType(Integer rechargeType) {
        this.rechargeType = rechargeType;
        return this;
    }

    public PosTransactionCardItem setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public PosTransactionCardItem setCardName(String cardName) {
        this.cardName = cardName;
        return this;
    }

    public PosTransactionCardItem setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
        return this;
    }

    public PosTransactionCardItem setRecordType(Integer recordType) {
        this.recordType = recordType;
        return this;
    }

    public PosTransactionCardItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosTransactionCardItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosTransactionCardItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosTransactionCardItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosTransactionCardItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosTransactionCardItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "PosTransactionCardItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", card=" + this.getCard() + ", sysCardNo=" + this.getSysCardNo() + ", cardSerial=" + this.getCardSerial() + ", hideColumn=" + this.getHideColumn() + ", cardCashType=" + this.getCardCashType() + ", allowType=" + this.getAllowType() + ", money=" + this.getMoney() + ", subMoney=" + this.getSubMoney() + ", balance=" + this.getBalance() + ", subBalance=" + this.getSubBalance() + ", conveyTime=" + this.getConveyTime() + ", checkTime=" + this.getCheckTime() + ", snName=" + this.getSnName() + ", serialNum=" + this.getSerialNum() + ", creatOperator=" + this.getCreatOperator() + ", updaterName=" + this.getUpdaterName() + ", logFlag=" + this.getLogFlag() + ", changeTime=" + this.getChangeTime() + ", createTime=" + this.getCreateTime() + ", status=" + this.getStatus() + ", deptCode=" + this.getDeptCode() + ", discount=" + this.getDiscount() + ", allowBatch=" + this.getAllowBatch() + ", allowBaseBatch=" + this.getAllowBaseBatch() + ", rechargeType=" + this.getRechargeType() + ", issueDate=" + this.getIssueDate() + ", cardName=" + this.getCardName() + ", uniqueKey=" + this.getUniqueKey() + ", recordType=" + this.getRecordType() + ", personId=" + this.getPersonId() + ", deptId=" + this.getDeptId() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ")";
    }
}

