/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.shenandoah;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.shenandoah.ShenandoahHeapRegion;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.gc_interface.CollectedHeapName;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.JLongField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ShenandoahHeap
extends CollectedHeap {
    private static CIntegerField numRegions;
    private static JLongField used;
    private static CIntegerField committed;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ShenandoahHeap");
        numRegions = type.getCIntegerField("_num_regions");
        used = type.getJLongField("_used");
        committed = type.getCIntegerField("_committed");
    }

    @Override
    public CollectedHeapName kind() {
        return CollectedHeapName.SHENANDOAH_HEAP;
    }

    public long numOfRegions() {
        return numRegions.getValue(this.addr);
    }

    @Override
    public long used() {
        return used.getValue(this.addr);
    }

    public long committed() {
        return committed.getValue(this.addr);
    }

    @Override
    public void printOn(PrintStream tty) {
        MemRegion mr = this.reservedRegion();
        tty.print("Shenandoah heap");
        tty.print(" [" + mr.start() + ", " + mr.end() + "]");
        tty.println(" region size " + ShenandoahHeapRegion.regionSizeBytes() / 1024L + " K");
    }

    public ShenandoahHeap(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ShenandoahHeap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

