/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringUtil;
import com.zkteco.zkbiosecurity.sis.router.SicmDataRouter;
import com.zkteco.zkbiosecurity.sis.util.SicmCmdPackageUtil;
import com.zkteco.zkbiosecurity.sis.util.SicmConstUtil;
import com.zkteco.zkbiosecurity.sis.util.SicmDataUtil;
import com.zkteco.zkbiosecurity.sis.websocket.SicmWebsocketInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SicmDataAnalyUtil {
    private static final Logger logger = Logger.getLogger(SicmDataAnalyUtil.class);
    private AdmsDevCmdService admsDevCmdService = (AdmsDevCmdService)SpringUtil.getBean(AdmsDevCmdService.class);
    public StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)SpringUtil.getBean((String)"stringRedisTemplate");
    private final String ADMS_CMD_ID = "ADMS_CMD_ID:";

    public void dataDistribution(String jsonContent, int jsonLength, byte[] dataBytes, String sn) {
        try {
            String func;
            JSONObject textJsonContent = JSONObject.parseObject((String)jsonContent);
            switch (func = textJsonContent.containsKey((Object)"func") ? textJsonContent.getString("func") : "") {
                case "heartbeat": {
                    SicmDataAnalyUtil.heatBeat(sn, textJsonContent);
                    break;
                }
                case "event.user.operate": {
                    SicmDataAnalyUtil.eventUserOperate(sn, textJsonContent);
                    break;
                }
                case "event.gaze": {
                    SicmDataAnalyUtil.eventGaze(sn, textJsonContent, jsonLength, dataBytes);
                    break;
                }
                case "event.package": {
                    SicmDataAnalyUtil.eventPackage(sn, textJsonContent, jsonLength, dataBytes);
                    break;
                }
                case "blacklist.upload": {
                    SicmDataAnalyUtil.eventBlackList(sn, textJsonContent);
                    break;
                }
                case "event.tipinsert": {
                    SicmDataAnalyUtil.eventTipInsert(sn, textJsonContent);
                    break;
                }
                case "tip.download": {
                    SicmDataAnalyUtil.tipDownload(sn, textJsonContent);
                    break;
                }
                case "event.alarm": {
                    SicmDataAnalyUtil.eventAlarm(sn, textJsonContent);
                    break;
                }
                case "tip.upload": {
                    SicmDataAnalyUtil.tipUpload(sn, textJsonContent, jsonLength, dataBytes);
                    break;
                }
                case "training.download": {
                    SicmDataAnalyUtil.trainingDownload(sn, textJsonContent);
                    break;
                }
                case "danger.upload": {
                    SicmDataAnalyUtil.dangerUpload(sn, textJsonContent, jsonLength, dataBytes);
                    break;
                }
                case "query.user.log": {
                    SicmDataAnalyUtil.queryUserLog(sn, textJsonContent);
                    break;
                }
                case "query.tipinsert": {
                    SicmDataAnalyUtil.queryTipInsert(sn, textJsonContent);
                    break;
                }
                case "query.gaze.log": {
                    SicmDataAnalyUtil.queryGazeLog(sn, textJsonContent);
                    break;
                }
                case "query.package": {
                    SicmDataAnalyUtil.queryPackage(sn, textJsonContent, jsonLength, dataBytes);
                    break;
                }
                case "query.package.log": {
                    SicmDataAnalyUtil.queryPackageLog(sn, textJsonContent);
                    break;
                }
                case "machine.state": {
                    SicmDataAnalyUtil.queryMachineState(sn, textJsonContent);
                    break;
                }
                case "command.result": {
                    logger.info((Object)("----------------command return----:" + textJsonContent));
                    this.commandResult(sn, textJsonContent);
                    break;
                }
                case "maintenance": {
                    this.deviceMaintenance(sn, textJsonContent);
                    break;
                }
                case "get.user.update": {
                    SicmDataAnalyUtil.updatePerson(sn);
                    break;
                }
                case "get.user.delete": {
                    SicmDataAnalyUtil.deletePersonByPin(sn);
                    break;
                }
                case "get.user.delete.all": {
                    SicmDataAnalyUtil.deleteAllPerson(sn);
                    break;
                }
                case "get.fptemplate.update": {
                    SicmDataAnalyUtil.updateFpTemplate(sn);
                    break;
                }
                case "get.fptemplate.delete": {
                    SicmDataAnalyUtil.deleteFpByPin(sn);
                    break;
                }
                case "get.fptemplate.delete.all": {
                    SicmDataAnalyUtil.deleteAllFp(sn);
                    break;
                }
                case "get.query": {
                    SicmDataAnalyUtil.query(sn, textJsonContent);
                    break;
                }
                case "get.tip.download.response": {
                    SicmDataAnalyUtil.downloadTip(sn, textJsonContent);
                    break;
                }
                case "get.tip.update": {
                    SicmDataAnalyUtil.updateTipWarehouse(sn);
                    break;
                }
                case "get.tip.delete.all": {
                    SicmDataAnalyUtil.deleteAllTip(sn);
                    break;
                }
                case "get.tipstrategy.update": {
                    SicmDataAnalyUtil.updateTipStrategy(sn);
                    break;
                }
                case "get.tipstrategy.delete": {
                    SicmDataAnalyUtil.deleteTipStrategy(sn);
                    break;
                }
                case "get.gaze.update": {
                    SicmDataAnalyUtil.updateGaze(sn);
                    break;
                }
                case "get.telecontrol": {
                    SicmDataAnalyUtil.telecontrol(sn, textJsonContent);
                    break;
                }
                case "get.ad.update": {
                    SicmDataAnalyUtil.updateAD(sn);
                    break;
                }
                case "get.ad.delete": {
                    SicmDataAnalyUtil.deleteAllAD(sn);
                    break;
                }
                case "get.client.result": {
                    logger.info((Object)("----------------get client command return----:" + textJsonContent));
                    SicmDataAnalyUtil.clientResult(sn, textJsonContent);
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"error: send message error!", (Throwable)e);
        }
    }

    public static void heatBeat(String sn, JSONObject textJsonContent) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient != null) {
                String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
                websocketClient.sendMsg(SicmCmdPackageUtil.retCmd(id, 0));
                websocketClient.updateDevConnState(1, false);
                websocketClient.updateDevOperateState("DEV_HEARTBEAT", "0");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deviceMaintenance(String sn, JSONObject textJsonContent) {
        try {
            logger.info((Object)("-----------eventUserOperate----textJsonContent:" + textJsonContent));
            if (!textJsonContent.isEmpty()) {
                String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
                new SicmDataRouter().sendRTDate(sn, textJsonContent);
                SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void eventUserOperate(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------eventUserOperate----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            new SicmDataRouter().sendRTLog(sn, textJsonContent);
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void eventTipInsert(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------eventTipInsert----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            new SicmDataRouter().sendRTLog(sn, textJsonContent);
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void eventGaze(String sn, JSONObject textJsonContent, int jsonLength, byte[] dataBytes) throws Exception {
        logger.info((Object)("-----------eventGaze----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONObject dataJson;
            int retCode = -1;
            JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            if (!dataJson.isEmpty()) {
                String fileName = dataJson.containsKey((Object)"file_name") ? dataJson.getString("file_name") : "";
                int imageLenth = dataBytes.length - (4 + jsonLength);
                logger.info((Object)("-----------eventGaze----imageLenth:" + imageLenth));
                byte[] tempImageBytes = null;
                if (StringUtils.isNotBlank((CharSequence)fileName) && imageLenth > 0) {
                    tempImageBytes = new byte[imageLenth];
                    logger.info((Object)("-----------eventGaze----dataBytes.length=" + dataBytes.length + "----tempImageBytes=" + tempImageBytes.length));
                    System.arraycopy(dataBytes, 4 + jsonLength, tempImageBytes, 0, imageLenth);
                    if (tempImageBytes != null && tempImageBytes.length > 0) {
                        String realPhotoPath = FileUtil.getLocalFullPath((String)SicmConstUtil.SICM_GAZE_FOLDER);
                        logger.info((Object)("-----------eventGaze----file path=" + realPhotoPath + File.separator + fileName));
                        if (SicmDataUtil.createFolder(realPhotoPath)) {
                            SicmDataUtil.saveFileFromBytes(tempImageBytes, realPhotoPath + File.separator + fileName);
                            new SicmDataRouter().sendRTLog(sn, textJsonContent);
                            retCode = 0;
                        } else {
                            logger.info((Object)"-----------eventGaze create folder error----------");
                        }
                    } else {
                        logger.info((Object)"-----------eventGaze image data is null----------");
                    }
                } else {
                    logger.info((Object)"-----------eventGaze file name is null----------");
                }
            } else {
                logger.info((Object)"-----------eventGaze data json is null----------");
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, retCode);
        }
    }

    public static void eventPackage(String sn, JSONObject textJsonContent, int jsonLength, byte[] dataBytes) throws Exception {
        logger.info((Object)("-----------eventPackage----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONObject dataJson;
            int retCode = -1;
            JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            if (!dataJson.isEmpty()) {
                String fileName = dataJson.containsKey((Object)"file_name") ? dataJson.getString("file_name") : "";
                int imageLenth = dataBytes.length - (4 + jsonLength);
                logger.info((Object)("-----------eventPackage----imageLenth:" + imageLenth));
                byte[] tempImageBytes = null;
                if (StringUtils.isNotBlank((CharSequence)fileName) && imageLenth > 0) {
                    tempImageBytes = new byte[imageLenth];
                    logger.info((Object)("-----------eventPackage----dataBytes.length=" + dataBytes.length + "----tempImageBytes=" + tempImageBytes.length));
                    System.arraycopy(dataBytes, 4 + jsonLength, tempImageBytes, 0, imageLenth);
                    if (tempImageBytes != null && tempImageBytes.length > 0) {
                        String realPhotoPath = FileUtil.getLocalFullPath((String)SicmConstUtil.SICM_PACKAGE_FOLDER);
                        logger.info((Object)("-----------eventPackage----file path=" + realPhotoPath + File.separator + fileName));
                        Date toDay = new Date();
                        String toDayPath = sn + "_" + DateUtil.dateToString((Date)toDay, (String)"yyyyMMdd");
                        String filePath = realPhotoPath + File.separator + toDayPath;
                        if (SicmDataUtil.createFolder(filePath)) {
                            SicmDataUtil.saveFileFromBytes(tempImageBytes, filePath + File.separator + fileName);
                            new SicmDataRouter().sendRTLog(sn, textJsonContent);
                            retCode = 0;
                        } else {
                            logger.info((Object)"-----------eventPackage create folder error----------");
                        }
                    } else {
                        logger.info((Object)"-----------eventPackage image data is null----------");
                    }
                } else {
                    logger.info((Object)"-----------eventPackage file name is null----------");
                }
            } else {
                logger.info((Object)"-----------eventPackage data json is null----------");
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, retCode);
        }
    }

    public static void eventBlackList(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------eventBlackList----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            new SicmDataRouter().sendRTLog(sn, textJsonContent);
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void tipDownload(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------tipDownload----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONObject dataJson;
            JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            if (!dataJson.isEmpty()) {
                SicmDataAnalyUtil.downloadTip(sn, textJsonContent);
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void eventAlarm(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------eventAlarm----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            new SicmDataRouter().sendRTLog(sn, textJsonContent);
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void trainingDownload(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)"-----------trainingDownload----textJsonContent:");
        if (!textJsonContent.isEmpty()) {
            JSONObject dataJson;
            JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            if (!dataJson.isEmpty()) {
                SicmDataAnalyUtil.downloadTraining(sn, textJsonContent);
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void dangerUpload(String sn, JSONObject textJsonContent, int jsonLength, byte[] dataBytes) throws Exception {
        logger.info((Object)("-----------dangerUpload----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONObject dataJson;
            JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            if (!dataJson.isEmpty()) {
                String fileName = dataJson.containsKey((Object)"file_name") ? dataJson.getString("file_name") : "";
                int imageLenth = dataBytes.length - (4 + jsonLength);
                logger.info((Object)("-----------dangerUpload----imageLenth:" + imageLenth));
                byte[] tempImageBytes = null;
                if (StringUtils.isNotBlank((CharSequence)fileName) && imageLenth > 0) {
                    tempImageBytes = new byte[imageLenth];
                    logger.info((Object)("-----------dangerUpload----dataBytes.length=" + dataBytes.length + "----tempImageBytes=" + tempImageBytes.length));
                    System.arraycopy(dataBytes, 4 + jsonLength, tempImageBytes, 0, imageLenth);
                    if (tempImageBytes != null && tempImageBytes.length > 0) {
                        String realPhotoPath = FileUtil.getLocalFullPath((String)SicmConstUtil.SICM_DANGER_FOLDER);
                        logger.info((Object)("-----------dangerUpload----file path=" + realPhotoPath + File.separator + fileName));
                        if (SicmDataUtil.createFolder(realPhotoPath)) {
                            SicmDataUtil.saveFileFromBytes(tempImageBytes, realPhotoPath + File.separator + fileName);
                            JSONArray bboxes = dataJson.getJSONArray("bboxes");
                            if (bboxes != null && bboxes.size() > 0) {
                                for (int i = 0; i < bboxes.size(); ++i) {
                                    JSONObject object = (JSONObject)bboxes.get(i);
                                    String type = object.getString("Type_Name");
                                    JSONArray coordinates = object.getJSONArray("Bbox");
                                    String path = realPhotoPath + File.separator + fileName;
                                    Integer topLeftCornerX = coordinates.getInteger(0);
                                    Integer topRightCornerY = coordinates.getInteger(1);
                                    Integer lowerLeftQuarterX = coordinates.getInteger(2);
                                    Integer lowerRightCornerY = coordinates.getInteger(3);
                                    String credibility = coordinates.getString(4);
                                    SicmDataAnalyUtil.lableImage(path, type, credibility, topLeftCornerX, topRightCornerY, lowerLeftQuarterX, lowerRightCornerY);
                                }
                            }
                            new SicmDataRouter().sendDangerLog(sn, textJsonContent);
                        } else {
                            logger.info((Object)"-----------dangerUpload create folder error----------");
                        }
                    }
                }
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void tipUpload(String sn, JSONObject textJsonContent, int jsonLength, byte[] dataBytes) throws Exception {
        logger.info((Object)("-----------tipUpload----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONObject dataJson;
            JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            if (!dataJson.isEmpty()) {
                String fileName = dataJson.containsKey((Object)"file_name") ? dataJson.getString("file_name") : "";
                int imageLenth = dataBytes.length - (4 + jsonLength);
                logger.info((Object)("-----------tipUpload----imageLenth:" + imageLenth));
                byte[] tempImageBytes = null;
                if (StringUtils.isNotBlank((CharSequence)fileName) && imageLenth > 0) {
                    tempImageBytes = new byte[imageLenth];
                    logger.info((Object)("-----------tipUpload----dataBytes.length=" + dataBytes.length + "----tempImageBytes=" + tempImageBytes.length));
                    System.arraycopy(dataBytes, 4 + jsonLength, tempImageBytes, 0, imageLenth);
                    if (tempImageBytes != null && tempImageBytes.length > 0) {
                        String realPhotoPath = FileUtil.getLocalFullPath((String)SicmConstUtil.SICM_TIP_FOLDER);
                        logger.info((Object)("-----------tipUpload----file path=" + realPhotoPath + File.separator + fileName));
                        if (SicmDataUtil.createFolder(realPhotoPath)) {
                            SicmDataUtil.saveFileFromBytes(tempImageBytes, realPhotoPath + File.separator + fileName);
                            new SicmDataRouter().sendRTLog(sn, textJsonContent);
                        } else {
                            logger.info((Object)"-----------tipUpload create folder error----------");
                        }
                    }
                }
            }
        }
    }

    public static void queryUserLog(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------queryUserLog----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONArray dataJson;
            JSONArray jSONArray = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONArray("data") : null;
            if (!dataJson.isEmpty()) {
                new SicmDataRouter().sendQueryLog(sn, textJsonContent);
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void queryTipInsert(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------queryUserLog----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONArray dataJson;
            JSONArray jSONArray = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONArray("data") : null;
            if (!dataJson.isEmpty()) {
                new SicmDataRouter().sendQueryLog(sn, textJsonContent);
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void queryGazeLog(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------queryGazeLog----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONArray dataJson;
            JSONArray jSONArray = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONArray("data") : null;
            if (!dataJson.isEmpty()) {
                new SicmDataRouter().sendQueryLog(sn, textJsonContent);
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void queryPackage(String sn, JSONObject textJsonContent, int jsonLength, byte[] dataBytes) throws Exception {
        logger.info((Object)("-----------queryPackage----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONObject dataJson;
            JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            if (!dataJson.isEmpty()) {
                String fileName = dataJson.containsKey((Object)"file_name") ? dataJson.getString("file_name") : "";
                int imageLenth = dataBytes.length - (4 + jsonLength);
                logger.info((Object)("-----------eventPackage----imageLenth:" + imageLenth));
                byte[] tempImageBytes = null;
                if (StringUtils.isNotBlank((CharSequence)fileName) && imageLenth > 0) {
                    tempImageBytes = new byte[imageLenth];
                    logger.info((Object)("-----------eventPackage----dataBytes.length=" + dataBytes.length + "----tempImageBytes=" + tempImageBytes.length));
                    System.arraycopy(dataBytes, 4 + jsonLength, tempImageBytes, 0, imageLenth);
                    if (tempImageBytes != null && tempImageBytes.length > 0) {
                        String realPhotoPath = FileUtil.getLocalFullPath((String)SicmConstUtil.SICM_QUERY_PACKAGE_FOLDER);
                        logger.info((Object)("-----------queryPackage----file path=" + realPhotoPath + File.separator + fileName));
                        Date toDay = new Date();
                        String toDayPath = sn + "_" + DateUtil.dateToString((Date)toDay, (String)"yyyyMMdd");
                        String filePath = realPhotoPath + File.separator + toDayPath;
                        if (SicmDataUtil.createFolder(filePath)) {
                            SicmDataUtil.saveFileFromBytes(tempImageBytes, filePath + File.separator + fileName);
                        } else {
                            logger.info((Object)"-----------queryPackage create folder error----------");
                        }
                    }
                }
                new SicmDataRouter().sendQueryLog(sn, textJsonContent);
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void queryPackageLog(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------queryPackageLog----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONArray dataJson;
            JSONArray jSONArray = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONArray("data") : null;
            if (!dataJson.isEmpty()) {
                new SicmDataRouter().sendQueryLog(sn, textJsonContent);
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public static void queryMachineState(String sn, JSONObject textJsonContent) throws Exception {
        logger.info((Object)("-----------queryMachineState----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            JSONObject dataJson;
            JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            if (!dataJson.isEmpty()) {
                new SicmDataRouter().sendQueryLog(sn, textJsonContent);
            }
            String id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "0";
            SicmCmdPackageUtil.sendRetCmd(sn, id, 0);
        }
    }

    public void commandResult(String sn, JSONObject textJsonContent) {
        logger.debug((Object)("-----------commandResult----textJsonContent:" + textJsonContent));
        if (!textJsonContent.isEmpty()) {
            Integer retValue = textJsonContent.getInteger("data");
            String cmdId = textJsonContent.getString("id");
            this.admsDevCmdService.saveCmdReturn(Long.valueOf(Long.parseLong(cmdId)), retValue.toString());
            if (StringUtils.isNotBlank((CharSequence)cmdId) && retValue != null) {
                List immeCmds;
                this.stringRedisTemplate.delete((Object)("ADMS_CMD_ID:" + cmdId));
                List commonCmds = this.stringRedisTemplate.opsForList().range((Object)("WEBSOCKET_DOWNLOAD_COMMON_CMD_" + sn), 0L, 10L);
                for (String cmd : commonCmds) {
                    if (!cmd.contains("C|" + cmdId + "|")) continue;
                    this.stringRedisTemplate.opsForList().remove((Object)("WEBSOCKET_DOWNLOAD_COMMON_CMD_" + sn), 1L, (Object)cmd);
                    break;
                }
                if ((immeCmds = this.stringRedisTemplate.opsForList().range((Object)("WEBSOCKET_TELECONTROL_CMD_" + sn), 0L, 10L)).size() > 0) {
                    for (String cmd : immeCmds) {
                        if (!cmd.contains("C|" + cmdId + "|")) continue;
                        this.stringRedisTemplate.opsForList().remove((Object)("WEBSOCKET_TELECONTROL_CMD_" + sn), 1L, (Object)cmd);
                        break;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updatePerson(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deletePersonByPin(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteAllPerson(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateFpTemplate(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteFpByPin(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteAllFp(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void downloadTip(String sn, JSONObject textJsonContent) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient != null) {
                String id;
                JSONObject dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
                String string = id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "";
                if (!dataJson.isEmpty()) {
                    SicmDataUtil util = new SicmDataUtil();
                    websocketClient.sendMsg(util.responseTipPic(id, dataJson, sn));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void downloadTraining(String sn, JSONObject textJsonContent) {
        try {
            String count;
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
            JSONObject dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            String string = count = dataJson.containsKey((Object)"count") ? dataJson.getString("count") : "0";
            if (dataJson.isEmpty()) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateTipWarehouse(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteAllTip(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateTipStrategy(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteTipStrategy(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateGaze(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateAD(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteAllAD(String sn) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void telecontrol(String sn, JSONObject textJsonContent) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient != null && !textJsonContent.isEmpty()) {
                String id;
                JSONObject dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
                String string = id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "66081";
                if (!dataJson.isEmpty()) {
                    int n = dataJson.containsKey((Object)"operate_type") ? dataJson.getInteger("operate_type") : -1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void maintain(String sn, JSONObject textJsonContent) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient != null && !textJsonContent.isEmpty()) {
                String id;
                JSONObject dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
                String string = id = textJsonContent.containsKey((Object)"id") ? textJsonContent.getString("id") : "66081";
                if (!dataJson.isEmpty()) {
                    int n = dataJson.containsKey((Object)"operate_type") ? dataJson.getInteger("operate_type") : -1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void query(String sn, JSONObject textJsonContent) {
        try {
            SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
            if (websocketClient != null && !textJsonContent.isEmpty()) {
                JSONObject dataJson;
                JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
                if (!dataJson.isEmpty()) {
                    String type = dataJson.containsKey((Object)"operate_type") ? dataJson.getString("operate_type") : "";
                    String startTime = dataJson.containsKey((Object)"start_time") ? dataJson.getString("start_time") : "";
                    String string = dataJson.containsKey((Object)"end_time") ? dataJson.getString("end_time") : "";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clientResult(String sn, JSONObject textJsonContent) throws JSONException {
        logger.debug((Object)("-----------clientResult----textJsonContent:" + textJsonContent));
        SicmWebsocketInfo websocketClient = SicmWebsocketInfo.totalWebsocketInfoMap.get(sn);
        if (websocketClient != null && !textJsonContent.isEmpty()) {
            JSONObject dataJson;
            JSONObject jSONObject = dataJson = textJsonContent.containsKey((Object)"data") ? textJsonContent.getJSONObject("data") : null;
            if (!dataJson.isEmpty()) {
                String string = dataJson.containsKey((Object)"id") ? dataJson.getString("id") : "";
            }
        }
    }

    public static void addTag(String width, String height, String x, String y, String type, String path) throws IOException {
        String typeCn = "\u5176\u4ed6";
        switch (type) {
            case "Cashes": {
                typeCn = "\u73b0\u91d1";
                break;
            }
            case "Explosives": {
                typeCn = "\u6613\u7206\u7269";
                break;
            }
            case "Fruits": {
                typeCn = "\u6c34\u679c";
                break;
            }
            case "Guns": {
                typeCn = "\u67aa";
                break;
            }
            case "Knives": {
                typeCn = "\u5200";
                break;
            }
            case "Others": {
                typeCn = "\u5176\u4ed6";
            }
        }
        File file = new File(path);
        if (file.exists()) {
            BufferedImage image = ImageIO.read(file);
            Graphics graphics = image.getGraphics();
            Font font = new Font("\u5b8b\u4f53", 1, 15);
            graphics.setFont(font);
            graphics.setColor(Color.RED);
            graphics.drawRect(Integer.parseInt(x), Integer.parseInt(y) + 1, Integer.parseInt(width), Integer.parseInt(height));
            graphics.drawString(typeCn, Integer.parseInt(x), Integer.parseInt(y));
            FileOutputStream out = new FileOutputStream(new File(path));
            ImageIO.write((RenderedImage)image, "jpg", out);
            out.close();
        }
    }

    public static void lableImage(String path, String typeName, String credibility, Integer topLeftCornerX, Integer topRightCornerY, Integer lowerLeftQuarterX, Integer lowerRightCornerY) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            BufferedImage image = ImageIO.read(file);
            Graphics g = image.getGraphics();
            g.setColor(Color.RED);
            g.drawRect(topLeftCornerX, topRightCornerY, lowerLeftQuarterX - topLeftCornerX, lowerRightCornerY - topRightCornerY);
            Font f = new Font("\u5b8b\u4f53", 1, 15);
            Color mycolor = Color.black;
            g.setColor(mycolor);
            g.setFont(f);
            g.drawString(typeName + "(" + credibility + "%)", (int)topLeftCornerX, (int)topRightCornerY);
            FileOutputStream out = new FileOutputStream(new File(path));
            ImageIO.write((RenderedImage)image, "jpeg", out);
            out.close();
        }
    }
}

