/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.distributor;

import com.zkteco.zkbiosecurity.sis.distributor.SisRTGateDevDataMonitorServer;
import com.zkteco.zkbiosecurity.sis.service.SisIEDTransactionService;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Order(value=112002)
public class SisRTIEDDevMonitorServer
implements CommandLineRunner {
    Logger logger = Logger.getLogger(SisRTGateDevDataMonitorServer.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private SisIEDTransactionService sisIEDTransactionService;

    public void run(String ... strings) throws Exception {
        new HandleRTLogThread("handleRTLog").start();
    }

    class HandleRTLogThread
    extends Thread {
        HandleRTLogThread(String name) {
            super.setName(name);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(30000L);
                while (true) {
                    int done = 0;
                    int exception = 0;
                    try {
                        String rtLog = (String)SisRTIEDDevMonitorServer.this.stringRedisTemplate.opsForList().leftPop((Object)"SIS_IED_RTLOG");
                        if (StringUtils.isNotBlank((CharSequence)rtLog)) {
                            String[] array = rtLog.split(";");
                            if (array[3].equalsIgnoreCase("2")) {
                                SisRTIEDDevMonitorServer.this.sisIEDTransactionService.handleTrans(array);
                                ++done;
                            }
                        } else {
                            Thread.sleep(5000L);
                        }
                    }
                    catch (Exception e) {
                        exception = 1;
                        e.printStackTrace();
                    }
                    if (done <= 0) continue;
                    SisRTIEDDevMonitorServer.this.stringRedisTemplate.opsForList().trim((Object)"SIS_IED_RTLOG", (long)(done + exception), -1L);
                }
            }
            catch (Exception e) {
                SisRTIEDDevMonitorServer.this.logger.error((Object)"SisIEDHandleRTLogThread Start Error", (Throwable)e);
                return;
            }
        }
    }
}

