/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.distributor;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.sis.constants.SisConstUtil;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisPackageTransactionService;
import com.zkteco.zkbiosecurity.sis.service.SisTipPicService;
import com.zkteco.zkbiosecurity.sis.service.SisTransactionService;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceItem;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Order(value=111000)
public class SisRTDataMonitorServer
implements CommandLineRunner {
    Logger logger = Logger.getLogger(SisRTDataMonitorServer.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private SisTransactionService sisTransactionService;
    @Autowired
    private SisPackageTransactionService sisPackageTransactionService;
    @Autowired
    private SisTipPicService sisTipPicService;
    @Autowired
    private SisDeviceService sisDeviceService;
    private final long rtLogThreadMaxFreeTime = 600000L;
    private final long queryLogThreadMaxFreeTime = 600000L;
    private final long rtLogthreadMaxNotActiveTime = 60000L;
    public static final Map<String, DealRTLogThread> rtLogDealThreadMap = new ConcurrentHashMap<String, DealRTLogThread>();
    public static final Map<String, DealDangerLogThread> dangerLogDealThreadMap = new ConcurrentHashMap<String, DealDangerLogThread>();
    public static final Map<String, DealQueryLogThread> queryLogDealThreadMap = new ConcurrentHashMap<String, DealQueryLogThread>();
    private final long queryLogthreadMaxNotActiveTime = 60000L;
    private Thread queryDataThread = null;
    ThreadPoolExecutor queryDataThreadPool = new ThreadPoolExecutor(1, 5, 3L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadPoolExecutor.CallerRunsPolicy());

    public void run(String ... strings) throws Exception {
        new CheckRTLogQuene("deal CheckRTLogQuene").start();
        new SisPackTransactionSaveThread("SisRTLogSaveToDBThread").start();
        new CheckDangerLogQuene("deal CheckDangerLogQuene").start();
        new CheckQueryLogQuene("deal CheckQueryLogQuene").start();
    }

    private void findBizEnterByEventType(JSONObject rtLogJson) {
        Set logKeys = rtLogJson.keySet();
        try {
            for (String devSn : logKeys) {
                JSONObject logData = rtLogJson.getJSONObject(devSn);
                SisDeviceItem deviceItem = this.sisDeviceService.findByDevSn(devSn);
                if (deviceItem == null) continue;
                switch (logData.getString("func")) {
                    case "event.package": {
                        this.sisPackageTransactionService.handleRTLog(devSn, logData);
                        break;
                    }
                    case "event.gaze": {
                        this.sisTransactionService.handleGazeRTLog(devSn, logData);
                        break;
                    }
                    case "event.user.operate": {
                        this.sisTransactionService.handleUserRTLog(devSn, logData);
                        break;
                    }
                    case "event.tipinsert": {
                        this.sisTransactionService.handleTipInsertRTLog(devSn, logData);
                        break;
                    }
                    case "event.alarm": {
                        this.sisTransactionService.handleAlarmRTLog(devSn, logData);
                        break;
                    }
                    case "blacklist.upload": {
                        this.sisTransactionService.handleBlackListRTLog(devSn, logData);
                        break;
                    }
                    case "query.user.log": {
                        this.sisTransactionService.handleUserQueryLog(devSn, logData);
                        break;
                    }
                    case "query.package": {
                        this.sisTransactionService.handlePackageQueryLog(devSn, logData);
                        break;
                    }
                    case "danger.upload": {
                        this.sisTransactionService.dangerUpload(devSn, logData);
                        break;
                    }
                    case "query.gaze.log": {
                        this.sisTransactionService.handleGazeQueryLog(devSn, logData);
                        break;
                    }
                    case "query.tipinsert": {
                        this.sisTransactionService.handleTipInsertQueryLog(devSn, logData);
                        break;
                    }
                    case "tip.upload": {
                        this.sisTipPicService.handleTipUpload(logData);
                        break;
                    }
                    case "maintenance": {
                        System.out.println("\u72b6\u6001\u7ef4\u62a4\u6570\u636e\u63a8\u9001\u524d\u53f0\u663e\u793a");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DealDangerLogThread
    extends Thread {
        public long threadLastActiveTime = System.currentTimeMillis();

        DealDangerLogThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            JSONObject dangerLogJson = null;
            String dangerLog = null;
            dangerLogDealThreadMap.put(this.getName(), this);
            long activeTime = System.currentTimeMillis();
            block2: while (true) {
                try {
                    while (true) {
                        this.threadLastActiveTime = System.currentTimeMillis();
                        dangerLog = (String)SisRTDataMonitorServer.this.stringRedisTemplate.opsForList().leftPop((Object)this.getName());
                        if (dangerLog != null) {
                            activeTime = System.currentTimeMillis();
                            dangerLogJson = JSONObject.parseObject((String)dangerLog);
                            Set logKeys = dangerLogJson.keySet();
                            for (String devSn : logKeys) {
                                JSONObject logData = dangerLogJson.getJSONObject(devSn);
                                SisRTDataMonitorServer.this.sisTransactionService.dangerUpload(devSn, logData);
                            }
                            dangerLog = null;
                            dangerLogJson = null;
                            continue;
                        }
                        if (System.currentTimeMillis() - activeTime > 600000L) {
                            dangerLogDealThreadMap.remove(this.getName());
                            break block2;
                        }
                        Thread.sleep(200L);
                    }
                }
                catch (Exception e) {
                    SisRTDataMonitorServer.this.logger.error((Object)("Exception DealDangerLogThread : " + this.getName() + "deal dangerLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class CheckDangerLogQuene
    extends Thread {
        CheckDangerLogQuene(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            DealDangerLogThread currentThread = null;
            Set activeQueneNameSet = null;
            while (true) {
                try {
                    while (true) {
                        activeQueneNameSet = SisRTDataMonitorServer.this.stringRedisTemplate.opsForSet().members((Object)"SIS_DANGERLOG_QUENE_NAME_SET");
                        for (String queneName : activeQueneNameSet) {
                            currentThread = dangerLogDealThreadMap.get(queneName);
                            if ((currentThread != null || !SisRTDataMonitorServer.this.stringRedisTemplate.hasKey((Object)queneName).booleanValue()) && (currentThread == null || currentThread.isAlive() && System.currentTimeMillis() - currentThread.threadLastActiveTime <= 60000L)) continue;
                            new DealDangerLogThread(queneName).start();
                        }
                        Thread.sleep(60000L);
                    }
                }
                catch (Exception e) {
                    SisRTDataMonitorServer.this.logger.error((Object)("Exception CheckDangerLogQuene : " + this.getName() + "deal dangerLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class DealQueryLogThread
    extends Thread {
        public long threadLastActiveTime = System.currentTimeMillis();

        DealQueryLogThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            JSONObject queryLogJson = null;
            String rtLog = null;
            queryLogDealThreadMap.put(this.getName(), this);
            long activeTime = System.currentTimeMillis();
            block2: while (true) {
                try {
                    while (true) {
                        this.threadLastActiveTime = System.currentTimeMillis();
                        rtLog = (String)SisRTDataMonitorServer.this.stringRedisTemplate.opsForList().leftPop((Object)this.getName());
                        if (rtLog != null) {
                            activeTime = System.currentTimeMillis();
                            queryLogJson = JSONObject.parseObject((String)rtLog);
                            SisRTDataMonitorServer.this.findBizEnterByEventType(queryLogJson);
                            rtLog = null;
                            queryLogJson = null;
                            continue;
                        }
                        if (System.currentTimeMillis() - activeTime > 600000L) {
                            queryLogDealThreadMap.remove(this.getName());
                            break block2;
                        }
                        Thread.sleep(200L);
                    }
                }
                catch (Exception e) {
                    SisRTDataMonitorServer.this.logger.error((Object)("Exception DealQueryLogThread : " + this.getName() + "deal queryLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class DealRTLogThread
    extends Thread {
        public long threadLastActiveTime = System.currentTimeMillis();

        DealRTLogThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            JSONObject rtLogJson = null;
            String rtLog = null;
            rtLogDealThreadMap.put(this.getName(), this);
            long activeTime = System.currentTimeMillis();
            block2: while (true) {
                try {
                    while (true) {
                        this.threadLastActiveTime = System.currentTimeMillis();
                        rtLog = (String)SisRTDataMonitorServer.this.stringRedisTemplate.opsForList().leftPop((Object)this.getName());
                        if (rtLog != null) {
                            activeTime = System.currentTimeMillis();
                            rtLogJson = JSONObject.parseObject((String)rtLog);
                            SisRTDataMonitorServer.this.findBizEnterByEventType(rtLogJson);
                            rtLog = null;
                            rtLogJson = null;
                            continue;
                        }
                        if (System.currentTimeMillis() - activeTime > 600000L) {
                            rtLogDealThreadMap.remove(this.getName());
                            break block2;
                        }
                        Thread.sleep(200L);
                    }
                }
                catch (Exception e) {
                    SisRTDataMonitorServer.this.logger.error((Object)("Exception DealRTLogThread : " + this.getName() + "deal rtLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class CheckQueryLogQuene
    extends Thread {
        CheckQueryLogQuene(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            DealQueryLogThread currentThread = null;
            Set activeQueneNameSet = null;
            while (true) {
                try {
                    while (true) {
                        activeQueneNameSet = SisRTDataMonitorServer.this.stringRedisTemplate.opsForSet().members((Object)"SIS_QUERYLOG_QUENE_NAME_SET");
                        for (String queneName : activeQueneNameSet) {
                            currentThread = queryLogDealThreadMap.get(queneName);
                            if ((currentThread != null || !SisRTDataMonitorServer.this.stringRedisTemplate.hasKey((Object)queneName).booleanValue()) && (currentThread == null || currentThread.isAlive() && System.currentTimeMillis() - currentThread.threadLastActiveTime <= 60000L)) continue;
                            new DealQueryLogThread(queneName).start();
                        }
                        Thread.sleep(3000L);
                    }
                }
                catch (Exception e) {
                    SisRTDataMonitorServer.this.logger.error((Object)("Exception CheckRTLogQuene : " + this.getName() + "deal rtLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class SisPackTransactionSaveThread
    extends Thread {
        SisPackTransactionSaveThread(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (SisRTDataMonitorServer.this.stringRedisTemplate.hasKey((Object)SisConstUtil.SIS_PACKAGE_TRANSACTIONS_TO_DB).booleanValue()) {
                            this.saveRtTransaction();
                            continue;
                        }
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception e) {
                    SisRTDataMonitorServer.this.logger.error((Object)("Exception SisPackageTransactionSaveThread : " + this.getName() + "deal rtLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void saveRtTransaction() {
            List transList = SisRTDataMonitorServer.this.stringRedisTemplate.opsForList().range((Object)SisConstUtil.SIS_PACKAGE_TRANSACTIONS_TO_DB, 0L, 200L);
            int except = 0;
            try {
                if (transList.size() > 0) {
                    SisRTDataMonitorServer.this.sisTransactionService.saveTrans(transList);
                }
            }
            catch (Exception e) {
                SisRTDataMonitorServer.this.logger.info((Object)("-----------------------------------get sistransaction error message:" + e.getMessage()));
                except = 1;
            }
            SisRTDataMonitorServer.this.stringRedisTemplate.opsForList().trim((Object)SisConstUtil.SIS_PACKAGE_TRANSACTIONS_TO_DB, (long)(transList.size() + except), -1L);
        }
    }

    class CheckRTLogQuene
    extends Thread {
        CheckRTLogQuene(String threadName) {
            super.setName(threadName);
        }

        @Override
        public void run() {
            DealRTLogThread currentThread = null;
            Set activeQueneNameSet = null;
            while (true) {
                try {
                    while (true) {
                        activeQueneNameSet = SisRTDataMonitorServer.this.stringRedisTemplate.opsForSet().members((Object)"SIS_RTLOG_QUENE_NAME_SET");
                        for (String queneName : activeQueneNameSet) {
                            currentThread = rtLogDealThreadMap.get(queneName);
                            if ((currentThread != null || !SisRTDataMonitorServer.this.stringRedisTemplate.hasKey((Object)queneName).booleanValue()) && (currentThread == null || currentThread.isAlive() && System.currentTimeMillis() - currentThread.threadLastActiveTime <= 60000L)) continue;
                            new DealRTLogThread(queneName).start();
                        }
                        Thread.sleep(3000L);
                    }
                }
                catch (Exception e) {
                    SisRTDataMonitorServer.this.logger.error((Object)("Exception CheckRTLogQuene : " + this.getName() + "deal rtLog error"), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

