/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.base.bean;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class SecuritySubject
implements Serializable {
    private static final long serialVersionUID = -2414700957833159618L;
    private String userId;
    private String userCode;
    private String userName;
    private Boolean isSuperuser;
    private String loginType;
    private String userType;
    private Boolean staff;
    private Set<String> permissions = new HashSet<String>();
    private Set<String> roles = new HashSet<String>();
    private Set<String> areaIds = new HashSet<String>();
    private Set<String> departmentIds = new HashSet<String>();
    private String companyId;
    private Set<String> appIds = new HashSet<String>();

    public SecuritySubject() {
    }

    public SecuritySubject(String userId, String userCode, String userName, Boolean isSuperuser) {
        this.userId = userId;
        this.userCode = userCode;
        this.userName = userName;
        this.isSuperuser = isSuperuser;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getLoginType() {
        return this.loginType;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Boolean getIsSuperuser() {
        return this.isSuperuser;
    }

    public void setIsSuperuser(Boolean isSuperuser) {
        this.isSuperuser = isSuperuser;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public boolean hasPermission(String permission) {
        if (this.isSuperuser.booleanValue()) {
            return true;
        }
        return this.permissions.contains(permission);
    }

    public boolean hasRole(String role) {
        if (this.isSuperuser.booleanValue()) {
            return true;
        }
        return this.roles.contains(role);
    }

    public Set<String> getAreaIds() {
        return this.areaIds;
    }

    public void setAreaIds(Set<String> areaIds) {
        this.areaIds = areaIds;
    }

    public Set<String> getDepartmentIds() {
        return this.departmentIds;
    }

    public void setDepartmentIds(Set<String> departmentIds) {
        this.departmentIds = departmentIds;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public Set<String> getAppIds() {
        return this.appIds;
    }

    public void setAppIds(Set<String> appIds) {
        this.appIds = appIds;
    }

    public Boolean getStaff() {
        return this.staff;
    }

    public void setStaff(Boolean staff) {
        this.staff = staff;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }
}

