/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POS_TRANSACTION T")
@GroupBy(after="T.person_pin, T.person_name,T.person_last_name")
@OrderBy(after="t.person_pin ASC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosPersonConsumeItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="80", i18n=true)
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="(sum(case when t.type_name = 6  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_conTimes", width="120")
    private Integer conTimes;
    @Column(name="cast(sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_suppleTotal", width="160", format="0=0.0")
    private Double suppletotal;
    @Column(name="cast(sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_consumTotal", width="115", format="0=0.0")
    private Double consumtotal;
    @Column(name="(sum(case when t.type_name = 9  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_errorTimes", width="170")
    private Integer errortimes;
    @Column(name="(sum(case when t.type_name = 8  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_suppleTimes", width="200")
    private Integer suppletimes;
    @Column(name="cast(sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_errorTotal", width="80", format="0=0.0")
    private Double errortotal;
    @Column(name="(sum(case when t.type_name = 10 then 1 else 0 end))")
    @GridColumn(label="pos_countTable_orderTimes", width="70")
    private Integer ordertimes;
    @Column(name="(sum(case when t.type_name = 11  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_accountTimes", width="70")
    private Integer accounttimes;
    @Column(name="cast(sum(case when t.type_name = 11  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_accountTotal", width="80", format="0=0.0")
    private Double accountTotal;
    @Column(name="(sum(case when t.type_name = 6 then 1 else 0 end)-sum(case when t.type_name = 9 then 1 else 0 end))")
    @GridColumn(label="pos_countTable_actualTimes", width="110")
    private Integer actualtimes;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_equipTotal", width="110", format="0=0.0")
    private Double equipTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_sysTotal", width="135", format="0=0.0")
    private Double sysTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 11  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_containAccTotal", width="135", format="0=0.0")
    private Double containAccTotal;
    @GridColumn(label="pos_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(t.PERSON_NAME) LIKE ''%{0}%'' OR lower(t.PERSON_LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;

    public PosPersonConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosPersonConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosPersonConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosPersonConsumeItem(Boolean equals, String id, String personPin, String personName, String personLastName, Integer conTimes, Double suppletotal, Double consumtotal, Integer errortimes, Integer suppletimes, Double errortotal, Integer ordertimes, Integer accounttimes, Double accountTotal, Integer actualtimes, Double equipTotal, Double sysTotal, Double containAccTotal) {
        this.id = id;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.conTimes = conTimes;
        this.suppletotal = suppletotal;
        this.consumtotal = consumtotal;
        this.errortimes = errortimes;
        this.suppletimes = suppletimes;
        this.errortotal = errortotal;
        this.ordertimes = ordertimes;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Double getSuppletotal() {
        return this.suppletotal;
    }

    public Double getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Double getErrortotal() {
        return this.errortotal;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Double getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Double getEquipTotal() {
        return this.equipTotal;
    }

    public Double getSysTotal() {
        return this.sysTotal;
    }

    public Double getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public PosPersonConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosPersonConsumeItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosPersonConsumeItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosPersonConsumeItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosPersonConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosPersonConsumeItem setSuppletotal(Double suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosPersonConsumeItem setConsumtotal(Double consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosPersonConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosPersonConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosPersonConsumeItem setErrortotal(Double errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosPersonConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosPersonConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosPersonConsumeItem setAccountTotal(Double accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosPersonConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosPersonConsumeItem setEquipTotal(Double equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosPersonConsumeItem setSysTotal(Double sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosPersonConsumeItem setContainAccTotal(Double containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosPersonConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosPersonConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosPersonConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosPersonConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosPersonConsumeItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "PosPersonConsumeItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", conTimes=" + this.getConTimes() + ", suppletotal=" + this.getSuppletotal() + ", consumtotal=" + this.getConsumtotal() + ", errortimes=" + this.getErrortimes() + ", suppletimes=" + this.getSuppletimes() + ", errortotal=" + this.getErrortotal() + ", ordertimes=" + this.getOrdertimes() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ")";
    }
}

