/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.pers.remote.MiniAppApiRemote;
import com.zkteco.zkbiosecurity.pers.service.wx.MiniAppApiService;
import com.zkteco.zkbiosecurity.pers.service.wx.MiniAppLoginService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.pers.vo.wx.AlarmInfoItem;
import com.zkteco.zkbiosecurity.pers.vo.wx.AppUserLoginItem;
import com.zkteco.zkbiosecurity.pers.vo.wx.EquipmentItem;
import com.zkteco.zkbiosecurity.pers.vo.wx.PersAppDeviceItem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MiniAppApiController
extends BaseController
implements MiniAppApiRemote {
    @Autowired
    private MiniAppApiService miniAppApiService;
    @Autowired
    private MiniAppLoginService loginService;

    public ZKResultMsg getIEDDataList(@RequestBody PersAppDeviceItem item) {
        return this.miniAppApiService.getIEDDataList(item);
    }

    public ZKResultMsg wechatExpressLogin(@RequestBody AppUserLoginItem item) {
        return this.loginService.wxLogin(item);
    }

    public ZKResultMsg getDeviceList(@RequestBody PersAppDeviceItem item) {
        return this.miniAppApiService.getDeviceList(item, this.request.getSession().getId());
    }

    public ZKResultMsg getAlarmInfoList() {
        return this.miniAppApiService.getAlarmInfoList();
    }

    public ZKResultMsg getSuspectAlarmInfoList(@RequestBody AlarmInfoItem alarmInfoItem) {
        return this.miniAppApiService.getSuspectAlarmInfoList(alarmInfoItem);
    }

    public ZKResultMsg getEyesAwayInfoList(@RequestBody AlarmInfoItem alarmInfoItem) {
        return this.miniAppApiService.getEyesAwayInfoList(alarmInfoItem);
    }

    public ZKResultMsg getSecurityDoorData(@RequestBody EquipmentItem equipmentItem) {
        return null;
    }

    public ZKResultMsg getSecurityMachineData(@RequestBody EquipmentItem equipmentItem) {
        return this.miniAppApiService.getSecurityMachineData(equipmentItem);
    }

    public ZKResultMsg getFluidInspectionMachineData(@RequestBody EquipmentItem equipmentItem) {
        return this.miniAppApiService.getSecurityMachineData(equipmentItem);
    }

    public ZKResultMsg getUnderCarScanningSystemDataList(@RequestBody PersAppDeviceItem persAppDeviceItem) {
        return this.miniAppApiService.getUnderCarScanningSystemDataList(persAppDeviceItem);
    }

    public ZKResultMsg getExplosiveDrugInspectionMachine(@RequestBody EquipmentItem equipmentItem) {
        return this.miniAppApiService.getExplosiveDrugInspectionMachine(equipmentItem);
    }

    public ZKResultMsg getEquipmentStatusList(@RequestBody EquipmentItem equipmentItem) {
        return this.miniAppApiService.getEquipmentStatusList(equipmentItem);
    }

    public ZKResultMsg getToolsLocationList(@RequestBody EquipmentItem equipmentItem) {
        return this.miniAppApiService.getToolsLocationList(equipmentItem);
    }

    public ZKResultMsg getPersonItemByPhone(@RequestParam String cellNum) {
        return new ZKResultMsg((Object)this.miniAppApiService.getPersonItemByPhone(cellNum));
    }

    public ZKResultMsg getPersonByItem(PersPersonItem personItem) {
        List personItemList = this.miniAppApiService.getPersonByItem(personItem);
        if (CollectionUtils.isEmpty((Collection)personItemList)) {
            return ZKResultMsg.failMsg();
        }
        return new ZKResultMsg(personItemList.get(0));
    }

    public ZKResultMsg updateDevPassword(@RequestBody PersPersonItem personItem) {
        return this.miniAppApiService.updateDevPassword(personItem) != false ? ZKResultMsg.successMsg() : ZKResultMsg.failMsg();
    }

    public ZKResultMsg changePassword(@RequestBody ZKMessage zkMessage) {
        Map map = zkMessage.getContent();
        String personPin = (String)map.get("personPin");
        String oldPassword = (String)map.get("oldPassword");
        String newPassword = (String)map.get("newPassword");
        String type = zkMessage.getMessageType();
        return this.miniAppApiService.changePassword(personPin, oldPassword, newPassword, type);
    }
}

