/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.JavaBeansAccessor;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.MXBeanMapping;
import com.sun.jmx.mbeanserver.MXBeanMappingFactory;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.InvalidObjectException;
import java.lang.annotation.ElementType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.management.ConstructorParameters;
import javax.management.JMX;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataInvocationHandler;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public class DefaultMXBeanMappingFactory
extends MXBeanMappingFactory {
    private static final Mappings mappings = new Mappings();
    private static final List<MXBeanMapping> permanentMappings = Util.newList();
    private static final String[] keyArray;
    private static final String[] keyValueArray;
    private static final Map<Type, Type> inProgress;

    static boolean isIdentity(MXBeanMapping mXBeanMapping) {
        return mXBeanMapping instanceof NonNullMXBeanMapping && ((NonNullMXBeanMapping)mXBeanMapping).isIdentity();
    }

    private static synchronized MXBeanMapping getMapping(Type type) {
        WeakReference weakReference = (WeakReference)mappings.get(type);
        return weakReference == null ? null : (MXBeanMapping)weakReference.get();
    }

    private static synchronized void putMapping(Type type, MXBeanMapping mXBeanMapping) {
        WeakReference<MXBeanMapping> weakReference = new WeakReference<MXBeanMapping>(mXBeanMapping);
        mappings.put(type, weakReference);
    }

    private static synchronized void putPermanentMapping(Type type, MXBeanMapping mXBeanMapping) {
        DefaultMXBeanMappingFactory.putMapping(type, mXBeanMapping);
        permanentMappings.add(mXBeanMapping);
    }

    @Override
    public synchronized MXBeanMapping mappingForType(Type type, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        if (inProgress.containsKey(type)) {
            throw new OpenDataException("Recursive data structure, including " + MXBeanIntrospector.typeName(type));
        }
        MXBeanMapping mXBeanMapping = DefaultMXBeanMappingFactory.getMapping(type);
        if (mXBeanMapping != null) {
            return mXBeanMapping;
        }
        inProgress.put(type, type);
        try {
            mXBeanMapping = this.makeMapping(type, mXBeanMappingFactory);
        }
        catch (OpenDataException openDataException) {
            throw DefaultMXBeanMappingFactory.openDataException("Cannot convert type: " + MXBeanIntrospector.typeName(type), openDataException);
        }
        finally {
            inProgress.remove(type);
        }
        DefaultMXBeanMappingFactory.putMapping(type, mXBeanMapping);
        return mXBeanMapping;
    }

    private MXBeanMapping makeMapping(Type type, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            return this.makeArrayOrCollectionMapping(type, type2, mXBeanMappingFactory);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isEnum()) {
                return DefaultMXBeanMappingFactory.makeEnumMapping(clazz, ElementType.class);
            }
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                return this.makeArrayOrCollectionMapping(clazz, clazz2, mXBeanMappingFactory);
            }
            if (JMX.isMXBeanInterface(clazz)) {
                return DefaultMXBeanMappingFactory.makeMXBeanRefMapping(clazz);
            }
            return this.makeCompositeMapping(clazz, mXBeanMappingFactory);
        }
        if (type instanceof ParameterizedType) {
            return this.makeParameterizedTypeMapping((ParameterizedType)type, mXBeanMappingFactory);
        }
        throw new OpenDataException("Cannot map type: " + type);
    }

    private static <T extends Enum<T>> MXBeanMapping makeEnumMapping(Class<?> clazz, Class<T> clazz2) {
        ReflectUtil.checkPackageAccess(clazz);
        return new EnumMapping((Class)Util.cast(clazz));
    }

    private MXBeanMapping makeArrayOrCollectionMapping(Type type, Type type2, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        Class<?> clazz;
        MXBeanMapping mXBeanMapping = mXBeanMappingFactory.mappingForType(type2, mXBeanMappingFactory);
        OpenType<?> openType = mXBeanMapping.getOpenType();
        ArrayType<?[]> arrayType = ArrayType.getArrayType(openType);
        Class<?> clazz2 = mXBeanMapping.getOpenClass();
        String string = clazz2.isArray() ? "[" + clazz2.getName() : "[L" + clazz2.getName() + ";";
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw DefaultMXBeanMappingFactory.openDataException("Cannot obtain array class", classNotFoundException);
        }
        if (type instanceof ParameterizedType) {
            return new CollectionMapping(type, arrayType, clazz, mXBeanMapping);
        }
        if (DefaultMXBeanMappingFactory.isIdentity(mXBeanMapping)) {
            return new IdentityMapping(type, arrayType);
        }
        return new ArrayMapping(type, arrayType, clazz, mXBeanMapping);
    }

    private MXBeanMapping makeTabularMapping(Type type, boolean bl, Type type2, Type type3, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        String string = MXBeanIntrospector.typeName(type);
        MXBeanMapping mXBeanMapping = mXBeanMappingFactory.mappingForType(type2, mXBeanMappingFactory);
        MXBeanMapping mXBeanMapping2 = mXBeanMappingFactory.mappingForType(type3, mXBeanMappingFactory);
        OpenType<?> openType = mXBeanMapping.getOpenType();
        OpenType<?> openType2 = mXBeanMapping2.getOpenType();
        CompositeType compositeType = new CompositeType(string, string, keyValueArray, keyValueArray, new OpenType[]{openType, openType2});
        TabularType tabularType = new TabularType(string, string, compositeType, keyArray);
        return new TabularMapping(type, bl, tabularType, mXBeanMapping, mXBeanMapping2);
    }

    private MXBeanMapping makeParameterizedTypeMapping(ParameterizedType parameterizedType, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        Type type = parameterizedType.getRawType();
        if (type instanceof Class) {
            boolean bl;
            Class clazz = (Class)type;
            if (clazz == List.class || clazz == Set.class || clazz == SortedSet.class) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                assert (typeArray.length == 1);
                if (clazz == SortedSet.class) {
                    DefaultMXBeanMappingFactory.mustBeComparable(clazz, typeArray[0]);
                }
                return this.makeArrayOrCollectionMapping(parameterizedType, typeArray[0], mXBeanMappingFactory);
            }
            boolean bl2 = bl = clazz == SortedMap.class;
            if (clazz == Map.class || bl) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                assert (typeArray.length == 2);
                if (bl) {
                    DefaultMXBeanMappingFactory.mustBeComparable(clazz, typeArray[0]);
                }
                return this.makeTabularMapping(parameterizedType, bl, typeArray[0], typeArray[1], mXBeanMappingFactory);
            }
        }
        throw new OpenDataException("Cannot convert type: " + parameterizedType);
    }

    private static MXBeanMapping makeMXBeanRefMapping(Type type) throws OpenDataException {
        return new MXBeanRefMapping(type);
    }

    private MXBeanMapping makeCompositeMapping(Class<?> clazz, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        Object object;
        String[] stringArray;
        boolean bl = clazz.getName().equals("com.sun.management.GcInfo") && clazz.getClassLoader() == null;
        ReflectUtil.checkPackageAccess(clazz);
        List<Method> list = MBeanAnalyzer.eliminateCovariantMethods(Arrays.asList(clazz.getMethods()));
        SortedMap<String, Method> sortedMap = Util.newSortedMap();
        for (Method methodArray2 : list) {
            stringArray = DefaultMXBeanMappingFactory.propertyName(methodArray2);
            if (stringArray == null || bl && stringArray.equals("CompositeType") || (object = sortedMap.put(DefaultMXBeanMappingFactory.decapitalize((String)stringArray), methodArray2)) == null) continue;
            String n2 = "Class " + clazz.getName() + " has method name clash: " + ((Method)object).getName() + ", " + methodArray2.getName();
            throw new OpenDataException(n2);
        }
        int n = sortedMap.size();
        if (n == 0) {
            throw new OpenDataException("Can't map " + clazz.getName() + " to an open data type");
        }
        Method[] methodArray = new Method[n];
        stringArray = new String[n];
        object = new OpenType[n];
        int n2 = 0;
        for (Map.Entry entry : sortedMap.entrySet()) {
            Method method;
            stringArray[n2] = (String)entry.getKey();
            methodArray[n2] = method = (Method)entry.getValue();
            Type type = method.getGenericReturnType();
            object[n2] = mXBeanMappingFactory.mappingForType(type, mXBeanMappingFactory).getOpenType();
            ++n2;
        }
        CompositeType compositeType = new CompositeType(clazz.getName(), clazz.getName(), stringArray, stringArray, (OpenType<?>[])object);
        return new CompositeMapping(clazz, compositeType, stringArray, methodArray, mXBeanMappingFactory);
    }

    static InvalidObjectException invalidObjectException(String string, Throwable throwable) {
        return EnvHelp.initCause(new InvalidObjectException(string), throwable);
    }

    static InvalidObjectException invalidObjectException(Throwable throwable) {
        return DefaultMXBeanMappingFactory.invalidObjectException(throwable.getMessage(), throwable);
    }

    static OpenDataException openDataException(String string, Throwable throwable) {
        return EnvHelp.initCause(new OpenDataException(string), throwable);
    }

    static OpenDataException openDataException(Throwable throwable) {
        return DefaultMXBeanMappingFactory.openDataException(throwable.getMessage(), throwable);
    }

    static void mustBeComparable(Class<?> clazz, Type type) throws OpenDataException {
        if (!(type instanceof Class) || !Comparable.class.isAssignableFrom((Class)type)) {
            String string = "Parameter class " + type + " of " + clazz.getName() + " does not implement " + Comparable.class.getName();
            throw new OpenDataException(string);
        }
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = Character.offsetByCodePoints(string, 0, 1);
        if (n < string.length() && Character.isUpperCase(string.codePointAt(n))) {
            return string;
        }
        return string.substring(0, n).toLowerCase() + string.substring(n);
    }

    static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.offsetByCodePoints(0, 1);
        return string.substring(0, n).toUpperCase() + string.substring(n);
    }

    public static String propertyName(Method method) {
        String string = null;
        String string2 = method.getName();
        if (string2.startsWith("get")) {
            string = string2.substring(3);
        } else if (string2.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
            string = string2.substring(2);
        }
        if (string == null || string.length() == 0 || method.getParameterTypes().length > 0 || method.getReturnType() == Void.TYPE || string2.equals("getClass")) {
            return null;
        }
        return string;
    }

    static {
        OpenType[] openTypeArray = new OpenType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID};
        for (int i = 0; i < openTypeArray.length; ++i) {
            Class<?> clazz;
            OpenType openType = openTypeArray[i];
            try {
                clazz = Class.forName(openType.getClassName(), false, ObjectName.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error(classNotFoundException);
            }
            IdentityMapping identityMapping = new IdentityMapping(clazz, openType);
            DefaultMXBeanMappingFactory.putPermanentMapping(clazz, identityMapping);
            if (!clazz.getName().startsWith("java.lang.")) continue;
            try {
                Field field = clazz.getField("TYPE");
                Class clazz2 = (Class)field.get(null);
                IdentityMapping identityMapping2 = new IdentityMapping(clazz2, openType);
                DefaultMXBeanMappingFactory.putPermanentMapping(clazz2, identityMapping2);
                if (clazz2 == Void.TYPE) continue;
                Class<?> clazz3 = Array.newInstance(clazz2, 0).getClass();
                ArrayType<?> arrayType = ArrayType.getPrimitiveArrayType(clazz3);
                IdentityMapping identityMapping3 = new IdentityMapping(clazz3, arrayType);
                DefaultMXBeanMappingFactory.putPermanentMapping(clazz3, identityMapping3);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
                continue;
            }
        }
        keyArray = new String[]{"key"};
        keyValueArray = new String[]{"key", "value"};
        inProgress = Util.newIdentityHashMap();
    }

    private static final class ArrayMapping
    extends NonNullMXBeanMapping {
        private final MXBeanMapping elementMapping;

        ArrayMapping(Type type, ArrayType<?> arrayType, Class<?> clazz, MXBeanMapping mXBeanMapping) {
            super(type, arrayType);
            this.elementMapping = mXBeanMapping;
        }

        @Override
        final Object toNonNullOpenValue(Object object) throws OpenDataException {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            Object[] objectArray2 = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = this.elementMapping.toOpenValue(objectArray[i]);
            }
            return objectArray2;
        }

        @Override
        final Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            Class<?> clazz;
            Object[] objectArray = (Object[])object;
            Type type = this.getJavaType();
            if (type instanceof GenericArrayType) {
                clazz = ((GenericArrayType)type).getGenericComponentType();
            } else if (type instanceof Class && ((Class)type).isArray()) {
                clazz = ((Class)type).getComponentType();
            } else {
                throw new IllegalArgumentException("Not an array: " + type);
            }
            Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.elementMapping.fromOpenValue(objectArray[i]);
            }
            return objectArray2;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.elementMapping.checkReconstructible();
        }
    }

    private static final class CollectionMapping
    extends NonNullMXBeanMapping {
        private final Class<? extends Collection<?>> collectionClass;
        private final MXBeanMapping elementMapping;

        CollectionMapping(Type type, ArrayType<?> arrayType, Class<?> clazz, MXBeanMapping mXBeanMapping) {
            super(type, arrayType);
            Class clazz2;
            this.elementMapping = mXBeanMapping;
            Type type2 = ((ParameterizedType)type).getRawType();
            Class clazz3 = (Class)type2;
            if (clazz3 == List.class) {
                clazz2 = ArrayList.class;
            } else if (clazz3 == Set.class) {
                clazz2 = HashSet.class;
            } else if (clazz3 == SortedSet.class) {
                clazz2 = TreeSet.class;
            } else {
                assert (false);
                clazz2 = null;
            }
            this.collectionClass = (Class)Util.cast(clazz2);
        }

        @Override
        final Object toNonNullOpenValue(Object object) throws OpenDataException {
            Object[] objectArray;
            Collection collection = (Collection)object;
            if (collection instanceof SortedSet && (objectArray = ((SortedSet)collection).comparator()) != null) {
                String string = "Cannot convert SortedSet with non-null comparator: " + objectArray;
                throw DefaultMXBeanMappingFactory.openDataException(string, new IllegalArgumentException(string));
            }
            objectArray = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), collection.size());
            int n = 0;
            for (Object e : collection) {
                objectArray[n++] = this.elementMapping.toOpenValue(e);
            }
            return objectArray;
        }

        @Override
        final Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            Collection collection;
            Object[] objectArray = (Object[])object;
            try {
                collection = (Collection)Util.cast(this.collectionClass.newInstance());
            }
            catch (Exception exception) {
                throw DefaultMXBeanMappingFactory.invalidObjectException("Cannot create collection", exception);
            }
            for (Object object2 : objectArray) {
                Object object3 = this.elementMapping.fromOpenValue(object2);
                if (collection.add(object3)) continue;
                String string = "Could not add " + object2 + " to " + this.collectionClass.getName() + " (duplicate set element?)";
                throw new InvalidObjectException(string);
            }
            return collection;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.elementMapping.checkReconstructible();
        }
    }

    private static abstract class CompositeBuilder {
        private final Class<?> targetClass;
        private final String[] itemNames;

        CompositeBuilder(Class<?> targetClass, String[] itemNames) {
            this.targetClass = targetClass;
            this.itemNames = itemNames;
        }

        Class<?> getTargetClass() {
            return this.targetClass;
        }

        String[] getItemNames() {
            return this.itemNames;
        }

        abstract String applicable(Method[] var1) throws InvalidObjectException;

        Throwable possibleCause() {
            return null;
        }

        abstract Object fromCompositeData(CompositeData var1, String[] var2, MXBeanMapping[] var3) throws InvalidObjectException;
    }

    private static class CompositeBuilderCheckGetters
    extends CompositeBuilder {
        private final MXBeanMapping[] getterConverters;
        private Throwable possibleCause;

        CompositeBuilderCheckGetters(Class<?> targetClass, String[] itemNames, MXBeanMapping[] getterConverters) {
            super(targetClass, itemNames);
            this.getterConverters = getterConverters;
        }

        @Override
        String applicable(Method[] getters) {
            for (int i = 0; i < getters.length; ++i) {
                try {
                    this.getterConverters[i].checkReconstructible();
                    continue;
                }
                catch (InvalidObjectException e) {
                    this.possibleCause = e;
                    return "method " + getters[i].getName() + " returns type that cannot be mapped back from OpenData";
                }
            }
            return "";
        }

        @Override
        Throwable possibleCause() {
            return this.possibleCause;
        }

        @Override
        final Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] converters) {
            throw new Error();
        }
    }

    private static class CompositeBuilderViaConstructor
    extends CompositeBuilder {
        private List<Constr> annotatedConstructors;

        CompositeBuilderViaConstructor(Class<?> targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        String[] getConstPropValues(Constructor<?> ctr) {
            ConstructorParameters ctrProps = ctr.getAnnotation(ConstructorParameters.class);
            if (ctrProps != null) {
                return ctrProps.value();
            }
            String[] vals = JavaBeansAccessor.getConstructorPropertiesValue(ctr);
            return vals;
        }

        @Override
        String applicable(Method[] getters) throws InvalidObjectException {
            Class<?> targetClass = this.getTargetClass();
            Constructor<?>[] constrs = targetClass.getConstructors();
            List<Constructor<?>> annotatedConstrList = Util.newList();
            for (Constructor<?> constr : constrs) {
                if (!Modifier.isPublic(constr.getModifiers()) || this.getConstPropValues(constr) == null) continue;
                annotatedConstrList.add(constr);
            }
            if (annotatedConstrList.isEmpty()) {
                return this.reportNoConstructor();
            }
            this.annotatedConstructors = Util.newList();
            Map<String, Integer> getterMap = Util.newMap();
            String[] itemNames = this.getItemNames();
            for (int i = 0; i < itemNames.length; ++i) {
                getterMap.put(itemNames[i], i);
            }
            Set<BitSet> getterIndexSets = Util.newSet();
            for (Constructor constructor : annotatedConstrList) {
                String matchingMechanism = this.matchingMechanism(constructor);
                String[] propertyNames = this.getConstPropValues(constructor);
                Type[] paramTypes = constructor.getGenericParameterTypes();
                if (paramTypes.length != propertyNames.length) {
                    String msg = "Number of constructor params does not match " + this.referenceMechannism(matchingMechanism) + ": " + String.valueOf(constructor);
                    throw new InvalidObjectException(msg);
                }
                int[] paramIndexes = new int[getters.length];
                for (int i = 0; i < getters.length; ++i) {
                    paramIndexes[i] = -1;
                }
                BitSet present = new BitSet();
                for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    if (!getterMap.containsKey(propertyName)) {
                        String msg = matchingMechanism + " includes name " + propertyName + " which does not correspond to a property";
                        for (String getterName : getterMap.keySet()) {
                            if (!getterName.equalsIgnoreCase(propertyName)) continue;
                            msg = msg + " (differs only in case from property " + getterName + ")";
                        }
                        msg = msg + ": " + String.valueOf(constructor);
                        throw new InvalidObjectException(msg);
                    }
                    int getterIndex = (Integer)getterMap.get(propertyName);
                    paramIndexes[getterIndex] = i;
                    if (present.get(getterIndex)) {
                        String msg = matchingMechanism + " contains property " + propertyName + " more than once: " + String.valueOf(constructor);
                        throw new InvalidObjectException(msg);
                    }
                    present.set(getterIndex);
                    Method getter = getters[getterIndex];
                    Type propertyType = getter.getGenericReturnType();
                    if (propertyType.equals(paramTypes[i])) continue;
                    String msg = matchingMechanism + " gives property " + propertyName + " of type " + String.valueOf(propertyType) + " for parameter  of type " + String.valueOf(paramTypes[i]) + ": " + String.valueOf(constructor);
                    throw new InvalidObjectException(msg);
                }
                if (!getterIndexSets.add(present)) {
                    String msg = this.reportMultipleConstructorsFoundFor(propertyNames);
                    throw new InvalidObjectException(msg);
                }
                Constr c = new Constr(constructor, paramIndexes, present);
                this.annotatedConstructors.add(c);
            }
            for (BitSet bitSet : getterIndexSets) {
                boolean seen = false;
                for (BitSet b : getterIndexSets) {
                    if (bitSet == b) {
                        seen = true;
                        continue;
                    }
                    if (!seen) continue;
                    BitSet u = new BitSet();
                    u.or(bitSet);
                    u.or(b);
                    if (getterIndexSets.contains(u)) continue;
                    TreeSet<String> names = new TreeSet<String>();
                    int i = u.nextSetBit(0);
                    while (i >= 0) {
                        names.add(itemNames[i]);
                        i = u.nextSetBit(i + 1);
                    }
                    String msg = this.reportConstructorsAmbiguousFor(names);
                    throw new InvalidObjectException(msg);
                }
            }
            return null;
        }

        String reportNoConstructor() {
            return "no constructor has either @ConstructorParameters or @ConstructorProperties annotation";
        }

        String matchingMechanism(Constructor<?> constr) {
            return constr.isAnnotationPresent(ConstructorParameters.class) ? "@ConstructorParameters" : "@ConstructorProperties";
        }

        String referenceMechannism(String matchingMechanism) {
            return matchingMechanism + " annotation";
        }

        String reportMultipleConstructorsFoundFor(String ... propertyNames) {
            return "More than one constructor has @ConstructorParameters or @ConstructorProperties annotation with this set of names: " + Arrays.toString(propertyNames);
        }

        String reportConstructorsAmbiguousFor(Set<String> names) {
            return "Constructors with @ConstructorParameters or @ConstructorProperties annotation would be ambiguous for these items: " + String.valueOf(names);
        }

        String reportNoConstructorFoundFor(Set<String> names) {
            return "No constructor has either @ConstructorParameters or @ConstructorProperties annotation for this set of items: " + String.valueOf(names);
        }

        @Override
        Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] mappings) throws InvalidObjectException {
            CompositeType ct = cd.getCompositeType();
            BitSet present = new BitSet();
            for (int i = 0; i < itemNames.length; ++i) {
                if (ct.getType(itemNames[i]) == null) continue;
                present.set(i);
            }
            Constr max = null;
            for (Constr constr : this.annotatedConstructors) {
                if (!CompositeBuilderViaConstructor.subset(constr.presentParams, present) || max != null && !CompositeBuilderViaConstructor.subset(max.presentParams, constr.presentParams)) continue;
                max = constr;
            }
            if (max == null) {
                String msg = this.reportNoConstructorFoundFor(ct.keySet());
                throw new InvalidObjectException(msg);
            }
            Object[] params = new Object[max.presentParams.cardinality()];
            for (int i = 0; i < itemNames.length; ++i) {
                if (!max.presentParams.get(i)) continue;
                Object openItem = cd.get(itemNames[i]);
                Object javaItem = mappings[i].fromOpenValue(openItem);
                int index = max.paramIndexes[i];
                if (index < 0) continue;
                params[index] = javaItem;
            }
            try {
                ReflectUtil.checkPackageAccess(max.constructor.getDeclaringClass());
                return max.constructor.newInstance(params);
            }
            catch (Exception e) {
                String msg = "Exception constructing " + this.getTargetClass().getName();
                throw DefaultMXBeanMappingFactory.invalidObjectException(msg, e);
            }
        }

        private static boolean subset(BitSet sub, BitSet sup) {
            BitSet subcopy = (BitSet)sub.clone();
            subcopy.andNot(sup);
            return subcopy.isEmpty();
        }

        private static class Constr {
            final Constructor<?> constructor;
            final int[] paramIndexes;
            final BitSet presentParams;

            Constr(Constructor<?> constructor, int[] paramIndexes, BitSet presentParams) {
                this.constructor = constructor;
                this.paramIndexes = paramIndexes;
                this.presentParams = presentParams;
            }
        }
    }

    private static final class CompositeBuilderViaFrom
    extends CompositeBuilder {
        private Method fromMethod;

        CompositeBuilderViaFrom(Class<?> targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) throws InvalidObjectException {
            Class<?> targetClass = this.getTargetClass();
            try {
                Method fromMethod = targetClass.getMethod("from", CompositeData.class);
                if (!Modifier.isStatic(fromMethod.getModifiers())) {
                    String msg = "Method from(CompositeData) is not static";
                    throw new InvalidObjectException("Method from(CompositeData) is not static");
                }
                if (fromMethod.getReturnType() != this.getTargetClass()) {
                    String msg = "Method from(CompositeData) returns " + MXBeanIntrospector.typeName(fromMethod.getReturnType()) + " not " + MXBeanIntrospector.typeName(targetClass);
                    throw new InvalidObjectException(msg);
                }
                this.fromMethod = fromMethod;
                return null;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (Exception e) {
                return "no method from(CompositeData)";
            }
        }

        @Override
        final Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] converters) throws InvalidObjectException {
            try {
                return MethodUtil.invoke(this.fromMethod, null, new Object[]{cd});
            }
            catch (Exception e) {
                String msg = "Failed to invoke from(CompositeData)";
                throw DefaultMXBeanMappingFactory.invalidObjectException("Failed to invoke from(CompositeData)", e);
            }
        }
    }

    private static final class CompositeBuilderViaProxy
    extends CompositeBuilder {
        CompositeBuilderViaProxy(Class<?> targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) {
            Class<?> targetClass = this.getTargetClass();
            if (!targetClass.isInterface()) {
                return "not an interface";
            }
            Set<Method> methods = Util.newSet(Arrays.asList(targetClass.getMethods()));
            methods.removeAll(Arrays.asList(getters));
            String bad = null;
            for (Method m : methods) {
                String mname = m.getName();
                Class<?>[] mparams = m.getParameterTypes();
                try {
                    Method om = Object.class.getMethod(mname, mparams);
                    if (Modifier.isPublic(om.getModifiers())) continue;
                    bad = mname;
                }
                catch (NoSuchMethodException e) {
                    bad = mname;
                }
            }
            if (bad != null) {
                return "contains methods other than getters (" + bad + ")";
            }
            return null;
        }

        @Override
        final Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] converters) {
            Class<?> targetClass = this.getTargetClass();
            return Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, new CompositeDataInvocationHandler(cd));
        }
    }

    private static class CompositeBuilderViaSetters
    extends CompositeBuilder {
        private Method[] setters;

        CompositeBuilderViaSetters(Class<?> targetClass, String[] itemNames) {
            super(targetClass, itemNames);
        }

        @Override
        String applicable(Method[] getters) {
            try {
                Constructor<?> constructor = this.getTargetClass().getConstructor(new Class[0]);
            }
            catch (Exception e) {
                return "does not have a public no-arg constructor";
            }
            Method[] setters = new Method[getters.length];
            for (int i = 0; i < getters.length; ++i) {
                Method setter;
                Method getter = getters[i];
                Class<?> returnType = getter.getReturnType();
                String name = DefaultMXBeanMappingFactory.propertyName(getter);
                String setterName = "set" + name;
                try {
                    setter = this.getTargetClass().getMethod(setterName, returnType);
                    if (setter.getReturnType() != Void.TYPE) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    return "not all getters have corresponding setters (" + String.valueOf(getter) + ")";
                }
                setters[i] = setter;
            }
            this.setters = setters;
            return null;
        }

        @Override
        Object fromCompositeData(CompositeData cd, String[] itemNames, MXBeanMapping[] converters) throws InvalidObjectException {
            Object o;
            try {
                Object tmp;
                Class<?> targetClass = this.getTargetClass();
                ReflectUtil.checkPackageAccess(targetClass);
                o = tmp = targetClass.newInstance();
                for (int i = 0; i < itemNames.length; ++i) {
                    if (!cd.containsKey(itemNames[i])) continue;
                    Object openItem = cd.get(itemNames[i]);
                    Object javaItem = converters[i].fromOpenValue(openItem);
                    MethodUtil.invoke(this.setters[i], o, new Object[]{javaItem});
                }
            }
            catch (Exception e) {
                throw DefaultMXBeanMappingFactory.invalidObjectException(e);
            }
            return o;
        }
    }

    private final class CompositeMapping
    extends NonNullMXBeanMapping {
        private final String[] itemNames;
        private final Method[] getters;
        private final MXBeanMapping[] getterMappings;
        private CompositeBuilder compositeBuilder;

        CompositeMapping(Class<?> clazz, CompositeType compositeType, String[] stringArray, Method[] methodArray, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
            super(clazz, compositeType);
            assert (stringArray.length == methodArray.length);
            this.itemNames = stringArray;
            this.getters = methodArray;
            this.getterMappings = new MXBeanMapping[methodArray.length];
            for (int i = 0; i < methodArray.length; ++i) {
                Type type = methodArray[i].getGenericReturnType();
                this.getterMappings[i] = mXBeanMappingFactory.mappingForType(type, mXBeanMappingFactory);
            }
        }

        @Override
        final Object toNonNullOpenValue(Object object) throws OpenDataException {
            CompositeType compositeType = (CompositeType)this.getOpenType();
            if (object instanceof CompositeDataView) {
                return ((CompositeDataView)object).toCompositeData(compositeType);
            }
            if (object == null) {
                return null;
            }
            Object[] objectArray = new Object[this.getters.length];
            for (int i = 0; i < this.getters.length; ++i) {
                try {
                    Object object2 = MethodUtil.invoke(this.getters[i], object, null);
                    objectArray[i] = this.getterMappings[i].toOpenValue(object2);
                    continue;
                }
                catch (Exception exception) {
                    throw DefaultMXBeanMappingFactory.openDataException("Error calling getter for " + this.itemNames[i] + ": " + exception, exception);
                }
            }
            return new CompositeDataSupport(compositeType, this.itemNames, objectArray);
        }

        /*
         * WARNING - void declaration
         */
        private synchronized void makeCompositeBuilder() throws InvalidObjectException {
            if (this.compositeBuilder != null) {
                return;
            }
            Class clazz = (Class)this.getJavaType();
            CompositeBuilder[][] compositeBuilderArrayArray = new CompositeBuilder[][]{{new CompositeBuilderViaFrom(clazz, this.itemNames)}, {new CompositeBuilderViaConstructor(clazz, this.itemNames)}, {new CompositeBuilderCheckGetters(clazz, this.itemNames, this.getterMappings), new CompositeBuilderViaSetters(clazz, this.itemNames), new CompositeBuilderViaProxy(clazz, this.itemNames)}};
            CompositeBuilder compositeBuilder = null;
            StringBuilder stringBuilder = new StringBuilder();
            Throwable throwable = null;
            block0: for (CompositeBuilder[] compositeBuilderArray : compositeBuilderArrayArray) {
                for (int i = 0; i < compositeBuilderArray.length; ++i) {
                    CompositeBuilder compositeBuilder2 = compositeBuilderArray[i];
                    String string = compositeBuilder2.applicable(this.getters);
                    if (string == null) {
                        compositeBuilder = compositeBuilder2;
                        break block0;
                    }
                    Throwable throwable2 = compositeBuilder2.possibleCause();
                    if (throwable2 != null) {
                        throwable = throwable2;
                    }
                    if (string.length() <= 0) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append(string);
                    if (i == 0) continue block0;
                }
            }
            if (compositeBuilder == null) {
                void var6_9;
                String string = "Do not know how to make a " + clazz.getName() + " from a CompositeData: " + stringBuilder;
                if (throwable != null) {
                    String string2 = string + ". Remaining exceptions show a POSSIBLE cause.";
                }
                throw DefaultMXBeanMappingFactory.invalidObjectException((String)var6_9, throwable);
            }
            this.compositeBuilder = compositeBuilder;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.makeCompositeBuilder();
        }

        @Override
        final Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            this.makeCompositeBuilder();
            return this.compositeBuilder.fromCompositeData((CompositeData)object, this.itemNames, this.getterMappings);
        }
    }

    private static final class EnumMapping<T extends Enum<T>>
    extends NonNullMXBeanMapping {
        private final Class<T> enumClass;

        EnumMapping(Class<T> clazz) {
            super(clazz, SimpleType.STRING);
            this.enumClass = clazz;
        }

        @Override
        final Object toNonNullOpenValue(Object object) {
            return ((Enum)object).name();
        }

        final T fromNonNullOpenValue(Object object) throws InvalidObjectException {
            try {
                return Enum.valueOf(this.enumClass, (String)object);
            }
            catch (Exception exception) {
                throw DefaultMXBeanMappingFactory.invalidObjectException("Cannot convert to enum: " + object, exception);
            }
        }
    }

    private static final class IdentityMapping
    extends NonNullMXBeanMapping {
        IdentityMapping(Type type, OpenType<?> openType) {
            super(type, openType);
        }

        @Override
        boolean isIdentity() {
            return true;
        }

        @Override
        Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            return object;
        }

        @Override
        Object toNonNullOpenValue(Object object) throws OpenDataException {
            return object;
        }
    }

    private static final class MXBeanRefMapping
    extends NonNullMXBeanMapping {
        MXBeanRefMapping(Type intf) {
            super(intf, SimpleType.OBJECTNAME);
        }

        @Override
        final Object toNonNullOpenValue(Object javaValue) throws OpenDataException {
            MXBeanLookup lookup = this.lookupNotNull(OpenDataException.class);
            ObjectName name = lookup.mxbeanToObjectName(javaValue);
            if (name == null) {
                throw new OpenDataException("No name for object: " + String.valueOf(javaValue));
            }
            return name;
        }

        @Override
        final Object fromNonNullOpenValue(Object openValue) throws InvalidObjectException {
            ObjectName name;
            MXBeanLookup lookup = this.lookupNotNull(InvalidObjectException.class);
            Object mxbean = lookup.objectNameToMXBean(name = (ObjectName)openValue, (Class)this.getJavaType());
            if (mxbean == null) {
                String msg = "No MXBean for name: " + String.valueOf(name);
                throw new InvalidObjectException(msg);
            }
            return mxbean;
        }

        private <T extends Exception> MXBeanLookup lookupNotNull(Class<T> excClass) throws T {
            MXBeanLookup lookup = MXBeanLookup.getLookup();
            if (lookup == null) {
                Exception exc;
                String msg = "Cannot convert MXBean interface in this context";
                try {
                    Constructor<T> con = excClass.getConstructor(String.class);
                    exc = (Exception)con.newInstance("Cannot convert MXBean interface in this context");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                throw exc;
            }
            return lookup;
        }
    }

    private static final class Mappings
    extends WeakHashMap<Type, WeakReference<MXBeanMapping>> {
        private Mappings() {
        }
    }

    static abstract class NonNullMXBeanMapping
    extends MXBeanMapping {
        NonNullMXBeanMapping(Type type, OpenType<?> openType) {
            super(type, openType);
        }

        @Override
        public final Object fromOpenValue(Object object) throws InvalidObjectException {
            if (object == null) {
                return null;
            }
            return this.fromNonNullOpenValue(object);
        }

        @Override
        public final Object toOpenValue(Object object) throws OpenDataException {
            if (object == null) {
                return null;
            }
            return this.toNonNullOpenValue(object);
        }

        abstract Object fromNonNullOpenValue(Object var1) throws InvalidObjectException;

        abstract Object toNonNullOpenValue(Object var1) throws OpenDataException;

        boolean isIdentity() {
            return false;
        }
    }

    private static final class TabularMapping
    extends NonNullMXBeanMapping {
        private final boolean sortedMap;
        private final MXBeanMapping keyMapping;
        private final MXBeanMapping valueMapping;

        TabularMapping(Type type, boolean bl, TabularType tabularType, MXBeanMapping mXBeanMapping, MXBeanMapping mXBeanMapping2) {
            super(type, tabularType);
            this.sortedMap = bl;
            this.keyMapping = mXBeanMapping;
            this.valueMapping = mXBeanMapping2;
        }

        @Override
        final Object toNonNullOpenValue(Object object) throws OpenDataException {
            Object object2;
            Map map = (Map)Util.cast(object);
            if (map instanceof SortedMap && (object2 = ((SortedMap)map).comparator()) != null) {
                String string = "Cannot convert SortedMap with non-null comparator: " + object2;
                throw DefaultMXBeanMappingFactory.openDataException(string, new IllegalArgumentException(string));
            }
            object2 = (TabularType)this.getOpenType();
            TabularDataSupport tabularDataSupport = new TabularDataSupport((TabularType)object2);
            CompositeType compositeType = ((TabularType)object2).getRowType();
            for (Map.Entry entry : map.entrySet()) {
                Object object3 = this.keyMapping.toOpenValue(entry.getKey());
                Object object4 = this.valueMapping.toOpenValue(entry.getValue());
                CompositeDataSupport compositeDataSupport = new CompositeDataSupport(compositeType, keyValueArray, new Object[]{object3, object4});
                tabularDataSupport.put(compositeDataSupport);
            }
            return tabularDataSupport;
        }

        @Override
        final Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            TabularData tabularData = (TabularData)object;
            Collection collection = (Collection)Util.cast(tabularData.values());
            Map<Object, Object> map = this.sortedMap ? Util.newSortedMap() : Util.newInsertionOrderMap();
            for (CompositeData compositeData : collection) {
                Object object2;
                Object object3 = this.keyMapping.fromOpenValue(compositeData.get("key"));
                if (map.put(object3, object2 = this.valueMapping.fromOpenValue(compositeData.get("value"))) == null) continue;
                String string = "Duplicate entry in TabularData: key=" + object3;
                throw new InvalidObjectException(string);
            }
            return map;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.keyMapping.checkReconstructible();
            this.valueMapping.checkReconstructible();
        }
    }
}

