/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.DIV;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Label;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Script;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Select;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@ZKUIDirective(script="ui/js/ZKCombo.js")
public class Combo
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String bodyCont;
        Writer out = env.getOut();
        JSONObject jsonData = new JSONObject();
        this.addRequestParams(jsonData);
        BeanUtil.setParamsToJson(jsonData, params);
        String uuid = BeanUtil.getUUID();
        jsonData.put("uuid", (Object)uuid);
        String id = jsonData.getString("id");
        id = StringUtils.isBlank((CharSequence)id) ? "combo" + uuid : id;
        jsonData.put("id", (Object)id);
        String title = jsonData.getString("title");
        if (StringUtils.isBlank((CharSequence)title)) {
            title = "";
        }
        out.write("<div class='search-combo-box' id='combox" + uuid + "' title='" + title + "'>");
        if (StringUtils.isEmpty((CharSequence)jsonData.getString("hideLabel"))) {
            Label label = new Label();
            if (!StringUtils.isEmpty((CharSequence)jsonData.getString("required"))) {
                title = title + "<span class='required'>*</span>";
            }
            label.text(title).addClass("search-label");
            if (!StringUtils.isEmpty((CharSequence)jsonData.getString("labelWidth"))) {
                label.width(jsonData.getString("labelWidth"));
            }
            out.write(label.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)jsonData.getString("props"))) {
            jsonData.put("props", JSONObject.parse((String)jsonData.getString("props")));
        }
        if (StringUtils.isNotBlank((CharSequence)jsonData.getString("options"))) {
            jsonData.put("options", JSONObject.parse((String)jsonData.getString("options")));
        }
        if (StringUtils.isNotBlank((CharSequence)jsonData.getString("template")) && jsonData.getString("template").trim().indexOf("{") != -1) {
            jsonData.put("template", JSONObject.parse((String)jsonData.getString("template")));
        }
        if (StringUtils.isNotBlank((CharSequence)(bodyCont = BeanUtil.getBodyContent(body))) && bodyCont.indexOf("option") != -1) {
            jsonData.put("useSelect", (Object)true);
            Select select = new Select();
            select.addAttributesOnly(params).id(id).addClass("search-combo");
            if (StringUtils.isNotBlank((CharSequence)jsonData.getString("mode"))) {
                select.attr("mode", jsonData.getString("mode"));
            }
            if (StringUtils.isEmpty((CharSequence)jsonData.getString("empty")) || jsonData.getString("empty").equals("true")) {
                if (jsonData.getString("emptyLabel") != null) {
                    select.option().text(jsonData.getString("emptyLabel")).value("");
                } else {
                    select.option().text("----------").value("");
                }
            }
            select.appendContent(bodyCont);
            out.write(select.toString());
        } else {
            DIV div = new DIV();
            div.addAttributesOnly(params).id(id);
            out.write(div.toString());
        }
        JSONObject opt = (JSONObject)env.getCurrentNamespace().toMap().get("searchParams");
        if (opt != null) {
            List combos = (List)opt.getObject("combos", List.class);
            combos.add(jsonData.getString("id"));
        }
        Script script = new Script();
        script.appendContent("new ZKUI.Combo(" + jsonData.toJSONString() + ")");
        out.write(script.toString() + "</div>");
    }

    private void addRequestParams(JSONObject opts) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("useComReq"))) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (BeanUtil.isIllegal(name) || BeanUtil.isIllegal(request.getParameter(name))) continue;
                opts.put(name, (Object)request.getParameter(name));
            }
        }
    }
}

