/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.utils;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceOpRecordService;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceOpRecordItem;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ParkI18nUtil {
    public static List<ParkDeviceOpRecordItem> setI18nResultList(List<ParkDeviceOpRecordItem> parkDeviceOpRecordItemtList) {
        ParkDeviceOpRecordService parkDeviceOpRecordService = (ParkDeviceOpRecordService)SpringContextUtil.getBean(ParkDeviceOpRecordService.class);
        for (ParkDeviceOpRecordItem parkDeviceOpRecordItemt : parkDeviceOpRecordItemtList) {
            parkDeviceOpRecordItemt.setOpTime((Date)DateUtil.getCurrentTime());
            parkDeviceOpRecordItemt.setOpTypeName(I18nUtil.i18nCode((String)parkDeviceOpRecordItemt.getOpTypeName(), (Object[])new Object[0]));
            Integer opRet = parkDeviceOpRecordItemt.getOpRet();
            parkDeviceOpRecordItemt.setOpRet(Integer.valueOf(opRet != null ? opRet : 0));
            String opRetName = parkDeviceOpRecordItemt.getOpRetName();
            parkDeviceOpRecordItemt.setOpRetName(I18nUtil.i18nCode((String)(opRetName != null ? opRetName : "common_op_succeed"), (Object[])new Object[0]));
            parkDeviceOpRecordService.saveItem(parkDeviceOpRecordItemt);
        }
        return parkDeviceOpRecordItemtList;
    }

    public static void setOfflineParamI18n(List<ParkDeviceOpRecordItem> parkDeviceOpRecordItemList) {
        for (ParkDeviceOpRecordItem parkDeviceResult : parkDeviceOpRecordItemList) {
            if (parkDeviceResult.getOpRet() < 0) continue;
            JSONObject paramsLocal = new JSONObject();
            JSONObject params = JSONObject.parseObject((String)parkDeviceResult.getData().toString());
            for (String key : params.keySet()) {
                String value = params.getString(key);
                String keyLocal = I18nUtil.i18nCode((String)("park_offlineSet_" + key.substring(0, 1).toLowerCase() + key.substring(1)), (Object[])new Object[0]);
                switch (key) {
                    case "RecordIsCover": {
                        value = value.equals("0") ? I18nUtil.i18nCode((String)"park_offlineSet_notCover", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_offlineSet_cover", (Object[])new Object[0]);
                        break;
                    }
                    case "ParkInOutFlag": {
                        value = value.equals("0") ? I18nUtil.i18nCode((String)"park_offlineSet_entrance", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_offlineSet_exit", (Object[])new Object[0]);
                        break;
                    }
                    case "RecognitionAccuracy": 
                    case "RecordMatchAccuracy": {
                        value = value.equals("99") ? I18nUtil.i18nCode((String)"park_parkingLotSet_entryPrecision_all", (Object[])new Object[0]) : value + I18nUtil.i18nCode((String)"park_offlineSet_bitPrecision", (Object[])new Object[0]);
                        break;
                    }
                    case "MissPlateListMatch": 
                    case "MissRecordListMatch": {
                        value = value.equals("0") ? I18nUtil.i18nCode((String)"park_parkingLotSet_entryPrecision_all", (Object[])new Object[0]) : value + I18nUtil.i18nCode((String)"park_offlineSet_bitPrecision", (Object[])new Object[0]);
                        break;
                    }
                    case "MonthCarToTempcarFlag": 
                    case "OneChannelMode": 
                    case "ZeroQuickOut": {
                        value = value.equals("0") ? I18nUtil.i18nCode((String)"park_offlineSet_notEnabled", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"common_enable", (Object[])new Object[0]);
                        break;
                    }
                    case "MonthCarOpenType": 
                    case "TempCarOpenType": {
                        value = value.equals("0") ? I18nUtil.i18nCode((String)"park_channel_carOpenTypeConfirm", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_channel_carOpenTypeDirect", (Object[])new Object[0]);
                        break;
                    }
                    case "TempCarForbiddenFlag": {
                        value = value.equals("0") ? I18nUtil.i18nCode((String)"park_offlineSet_authorization", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_offlineSet_notAuthorization", (Object[])new Object[0]);
                        break;
                    }
                    case "OnlineFlag": {
                        value = value.equals("0") ? I18nUtil.i18nCode((String)"park_offlineSet_offline", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_offlineSet_online", (Object[])new Object[0]);
                        break;
                    }
                    case "ScreenType": {
                        String string = value.equals("0") ? I18nUtil.i18nCode((String)"park_device_oneColor", (Object[])new Object[0]) : (value = value.equals("1") ? I18nUtil.i18nCode((String)"park_device_twoColor", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_device_fourColor", (Object[])new Object[0]));
                    }
                }
                if ("Handle".equals(key) || "SceneMode".equals(key) || "SyncTimeFromMaster".equals(key) || "ParkID".equals(key) || "Reserve".equals(key) || "ServerIP".equals(key) || "ServerPort".equals(key) || "MinChargeFlag".equals(key)) continue;
                paramsLocal.put(keyLocal, (Object)value);
            }
            parkDeviceResult.setData((Object)paramsLocal.toString());
        }
    }

    public static JSONObject setChargeI18n(String chargeDataBuf) {
        JSONObject chargeParamLocal = new JSONObject();
        String[] chargeParamArray = chargeDataBuf.replaceAll(";", "").split(",");
        String[] defaultLocal = new String[]{I18nUtil.i18nCode((String)"park_offlineSet_chargesNo", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_freeMinutes", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_includingFlag", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_bestraddleTime", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_maxfeePreday", (Object[])new Object[0])};
        chargeParamLocal.put(defaultLocal[0], (Object)chargeParamArray[0]);
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < chargeParamArray.length; ++i) {
            if (i >= 5) {
                if ("0".equals(chargeParamArray[i])) continue;
                sb.append(chargeParamArray[i] + ",");
                continue;
            }
            if (i == 2) {
                chargeParamLocal.put(defaultLocal[i], (Object)("0".equals(chargeParamArray[i]) ? I18nUtil.i18nCode((String)"park_offlineSet_notIncluded", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_offlineSet_contain", (Object[])new Object[0])));
                continue;
            }
            if (i == 3) {
                chargeParamLocal.put(defaultLocal[i], (Object)("0".equals(chargeParamArray[i]) ? I18nUtil.i18nCode((String)"park_offlineSet_notSplit", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_offlineSet_split", (Object[])new Object[0])));
                continue;
            }
            chargeParamLocal.put(defaultLocal[i], (Object)chargeParamArray[i]);
        }
        chargeParamLocal.put(I18nUtil.i18nCode((String)"park_temporaryCharge_time", (Object[])new Object[0]) + "/" + I18nUtil.i18nCode((String)"park_temporaryCharge_cycle", (Object[])new Object[0]), (Object)sb.toString());
        return chargeParamLocal;
    }

    public static JSONObject setChargeExtendI18n(String chargeExtendDataBuf) {
        JSONObject chargeParamLocal = new JSONObject();
        String[] chargeExtendArray = chargeExtendDataBuf.split(",");
        String[] defaultTimeLocal = new String[]{I18nUtil.i18nCode((String)"park_temporaryCharge_time", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_offlineSet_chargingMode", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_startTime", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_endTime", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_payPerView", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_offlineSet_unitTime", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_firsttimePerstand", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_maximumCharge", (Object[])new Object[0])};
        String[] defaultCycleLocal = new String[]{I18nUtil.i18nCode((String)"park_temporaryCharge_cycle", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_offlineSet_chargingMode", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_offlineSet_chargesCycle", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_payPerView", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_offlineSet_unitTime", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_firsttimePerstand", (Object[])new Object[0]), I18nUtil.i18nCode((String)"park_temporaryCharge_maximumCharge", (Object[])new Object[0])};
        chargeParamLocal.put(defaultTimeLocal[0], (Object)chargeExtendArray[0]);
        chargeParamLocal.put(defaultTimeLocal[1], (Object)("1".equals(chargeExtendArray[1]) ? I18nUtil.i18nCode((String)"park_temporaryCharge_chargeModeByTime", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_temporaryCharge_chargeModeByCycle", (Object[])new Object[0])));
        if ("1".equals(chargeExtendArray[1])) {
            block4: for (int i = 2; i < chargeExtendArray.length; ++i) {
                switch (i) {
                    case 2: 
                    case 3: {
                        String value = String.format("%04d", Integer.parseInt(chargeExtendArray[i]));
                        chargeParamLocal.put(defaultTimeLocal[i], (Object)(value.substring(0, 2) + ":" + value.substring(2, 4)));
                        continue block4;
                    }
                    case 4: {
                        chargeParamLocal.put(defaultTimeLocal[i], (Object)("0".equals(chargeExtendArray[i]) ? I18nUtil.i18nCode((String)"park_offlineSet_notSequence", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_offlineSet_sequence", (Object[])new Object[0])));
                        continue block4;
                    }
                    default: {
                        chargeParamLocal.put(defaultTimeLocal[i], (Object)chargeExtendArray[i]);
                    }
                }
            }
        } else {
            for (int i = 2; i < chargeExtendArray.length; ++i) {
                if (i == 3) {
                    chargeParamLocal.put(defaultTimeLocal[i], (Object)("0".equals(chargeExtendArray[i]) ? I18nUtil.i18nCode((String)"park_offlineSet_notSequence", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"park_offlineSet_sequence", (Object[])new Object[0])));
                    continue;
                }
                chargeParamLocal.put(defaultTimeLocal[i], (Object)chargeExtendArray[i]);
            }
        }
        return chargeParamLocal;
    }

    public static List<ParkDeviceOpRecordItem> setVersionParamI18n(List<ParkDeviceOpRecordItem> parkDeviceOpRecordItemList) {
        for (ParkDeviceOpRecordItem parkDeviceResult : parkDeviceOpRecordItemList) {
            parkDeviceResult.setOpTime((Date)DateUtil.getCurrentTime());
            parkDeviceResult.setOpTypeName(I18nUtil.i18nCode((String)parkDeviceResult.getOpTypeName(), (Object[])new Object[0]));
            Integer opRet = parkDeviceResult.getOpRet();
            parkDeviceResult.setOpRet(Integer.valueOf(opRet != null ? opRet : 0));
            String opRetName = parkDeviceResult.getOpRetName();
            parkDeviceResult.setOpRetName(I18nUtil.i18nCode((String)(opRetName != null ? opRetName : "common_op_succeed"), (Object[])new Object[0]));
            JSONObject paramsLocal = new JSONObject();
            JSONObject params = (JSONObject)parkDeviceResult.getData();
            Set paramsSet = params.keySet();
            for (String key : paramsSet) {
                String value = params.getString(key);
                switch (key) {
                    case "Server_version": {
                        key = I18nUtil.i18nCode((String)"park_offlineSet_server_version", (Object[])new Object[0]);
                        break;
                    }
                    case "Start": {
                        key = I18nUtil.i18nCode((String)"park_offlineSet_start", (Object[])new Object[0]);
                        break;
                    }
                    case "Now": {
                        key = I18nUtil.i18nCode((String)"park_offlineSet_now", (Object[])new Object[0]);
                    }
                }
                paramsLocal.put(key, (Object)value);
            }
            parkDeviceResult.setData((Object)paramsLocal.toString());
        }
        return parkDeviceOpRecordItemList;
    }
}

