/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkParkingMeterSideRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterSideService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterSideItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkParkingMeterSideController
extends BaseController
implements ParkParkingMeterSideRemote {
    @Autowired
    private ParkParkingMeterSideService parkParkingMeterSideService;

    @RequiresPermissions(value={"park:parkingMeterSide"})
    public ModelAndView index() {
        return new ModelAndView("park/parkingMeterSide/parkParkingMeterSide");
    }

    @RequiresPermissions(value={"park:parkingMeterSide:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkParkingMeterSideService.getItemById(id));
        }
        return new ModelAndView("park/parkingMeterSide/editParkParkingMeterSide");
    }

    @RequiresPermissions(value={"park:parkingMeterSide:edit"})
    public ZKResultMsg save(ParkParkingMeterSideItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkParkingMeterSideService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkParkingMeterSideItem codition) {
        Pager pager = this.parkParkingMeterSideService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkParkingMeterSideService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

