/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkOvertimeChargeRemote;
import com.zkteco.zkbiosecurity.park.service.ParkOvertimeChargeExtendService;
import com.zkteco.zkbiosecurity.park.service.ParkOvertimeChargeService;
import com.zkteco.zkbiosecurity.park.vo.ParkOvertimeChargeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkOvertimeChargeController
extends BaseController
implements ParkOvertimeChargeRemote {
    @Autowired
    private ParkOvertimeChargeService parkOvertimeChargeService;
    @Autowired
    private ParkOvertimeChargeExtendService parkOvertimeChargeExtendService;

    @RequiresPermissions(value={"park:overtimeCharge"})
    public ModelAndView index() {
        return new ModelAndView("park/overtimeCharge/parkOvertimeCharge");
    }

    @RequiresPermissions(value={"park:overtimeCharge:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkOvertimeChargeService.getItemById(id));
        }
        List overtimeChargeExtendList = this.parkOvertimeChargeExtendService.getOvertimeChargeExtendItemsForEdit(id);
        this.request.setAttribute("overtimeChargeExtendList", (Object)overtimeChargeExtendList);
        return new ModelAndView("park/overtimeCharge/editParkOvertimeCharge");
    }

    @RequiresPermissions(value={"park:overtimeCharge:edit"})
    @LogRequest(module="park_module", object="park_overtimeCharge", opType="park_overtimeCharge_edit", requestParams={"name"}, opContent="park_overtimeCharge_name")
    public ZKResultMsg save(ParkOvertimeChargeItem item) {
        this.parkOvertimeChargeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"park:overtimeCharge:refresh"})
    public DxGrid list(ParkOvertimeChargeItem codition) {
        Pager pager = this.parkOvertimeChargeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_overtimeCharge", opType="park_overtimeCharge_del", requestParams={"names"}, opContent="park_overtimeCharge_del")
    @RequiresPermissions(value={"park:overtimeCharge:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkOvertimeChargeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(@RequestParam(value="name") String name) {
        return this.parkOvertimeChargeService.isNotExist(name);
    }

    public ZKResultMsg isEnableOvertime(@RequestParam(value="id", required=false) String id) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String str = this.parkOvertimeChargeService.isEnableOvertime(id);
        if (str != null) {
            zkResultMsg.setData((Object)MessageFormat.format(I18nUtil.i18nCode((String)"park_overtimeCharge_existing", (Object[])new Object[0]), str));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

