/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkEntranceAreaRemote;
import com.zkteco.zkbiosecurity.park.service.ParkEntranceAreaService;
import com.zkteco.zkbiosecurity.park.vo.ParkEntranceAreaItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkEntranceAreaController
extends BaseController
implements ParkEntranceAreaRemote {
    @Autowired
    private ParkEntranceAreaService parkEntranceAreaService;

    @RequiresPermissions(value={"park:entranceArea"})
    public ModelAndView index() {
        return new ModelAndView("park/entranceArea/parkEntranceArea");
    }

    @RequiresPermissions(value={"park:entranceArea:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkEntranceAreaService.getItemById(id));
        }
        return new ModelAndView("park/entranceArea/editParkEntranceArea");
    }

    @RequiresPermissions(value={"park:entranceArea:edit"})
    @LogRequest(module="park_module", object="park_entranceArea", opType="park_entranceArea_edit", requestParams={"name"}, opContent="park_entranceArea_name")
    public ZKResultMsg save(ParkEntranceAreaItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkEntranceAreaService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkEntranceAreaItem codition) {
        Pager pager = this.parkEntranceAreaService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:entranceArea:del"})
    @LogRequest(module="park_module", object="park_entranceArea", opType="park_entranceArea_del", requestParams={"names"}, opContent="park_entranceArea_name")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkEntranceAreaService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkEntranceAreaService.isNotExist(name);
    }

    public ZKResultMsg getAllEntranceArea() {
        List selectItems = this.parkEntranceAreaService.getAllEntranceArea();
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getAreaNameByEntranceId(@RequestParam(value="parkingAreaIdNew", required=false) String parkingAreaIdNew, @RequestParam(value="parkingAreaIdOld", required=false) String parkingAreaIdOld) {
        ZKResultMsg resultMsg = this.parkEntranceAreaService.getAreaNameByEntranceId(parkingAreaIdNew, parkingAreaIdOld);
        return resultMsg;
    }

    public TreeItem getTreeByParkingAreaId(@RequestParam(value="parkingAreaId", required=false) String parkingAreaId) {
        return this.parkEntranceAreaService.getTreeByParkingAreaId(parkingAreaId);
    }
}

