/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttTripRemote;
import com.zkteco.zkbiosecurity.att.service.AttLeaveService;
import com.zkteco.zkbiosecurity.att.service.AttTripService;
import com.zkteco.zkbiosecurity.att.vo.AttTripItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttTripController
extends ExportController
implements AttTripRemote {
    @Autowired
    private AttTripService attTripService;
    @Autowired
    private AttLeaveService attLeaveService;

    @RequiresPermissions(value={"att:trip"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/trip/attTrip");
    }

    @RequiresPermissions(value={"att:trip:add"})
    public ModelAndView edit(String id) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        AttTripItem item = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.attTripService.getItemById(id);
        } else if (null != staff && staff.booleanValue()) {
            item = new AttTripItem();
            item.setPersonId(securitySubject.getUserId());
        }
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("att/trip/editAttTrip");
    }

    @RequiresPermissions(value={"att:trip:add"})
    @LogRequest(module="att_module", object="att_leftMenu_trip", opType="common_op_new", requestParams={"personPin"}, opContent="att_person_pin")
    public ZKResultMsg save(AttTripItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String personIds = this.request.getParameter("personIds");
        if (StringUtils.isBlank((CharSequence)personIds)) {
            throw new ZKBusinessException("EXCEPTIONLEVEL_WARN", "common_prompt_selectObj");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -2);
        calendar.set(5, 1);
        Date theFirstDayOfLastMonth = DateUtil.getDayBeginTime((Date)calendar.getTime());
        if (theFirstDayOfLastMonth.compareTo(item.getStartDatetime()) > 0) {
            return ZKResultMsg.getFailMsg((String)I18nUtil.i18nCode((String)"att_apply_overLastMonth", (Object[])new Object[0]));
        }
        HashMap resultMap = this.attLeaveService.getNotApplyPersonStr(personIds, "trip", item.getStartDatetime(), item.getEndDatetime());
        String notApplyPersonNameStr = (String)resultMap.get("notApplyPersonNameStr");
        if (notApplyPersonNameStr.length() > 0) {
            if (notApplyPersonNameStr.length() > 9) {
                String resultPersStr = notApplyPersonNameStr.substring(0, 9) + "...";
                throw ZKBusinessException.warnException((String)"att_admin_applyWarn", (Object[])new Object[]{resultPersStr});
            }
            throw ZKBusinessException.warnException((String)"att_admin_applyWarn", (Object[])new Object[]{notApplyPersonNameStr});
        }
        this.attTripService.saveItem(item, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:trip:refresh"})
    public DxGrid list(AttTripItem condition) {
        condition.setFlowStatus("2");
        Pager pager = this.attTripService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:trip:del"})
    @LogRequest(module="att_module", object="att_leftMenu_trip", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attTripService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:trip:export"})
    @LogRequest(module="att_module", object="att_leftMenu_trip", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttTripItem attTripItem = new AttTripItem();
        this.setConditionValue((BaseItem)attTripItem);
        attTripItem.setFlowStatus("2");
        List intemList = this.attTripService.getItemData(request.getSession().getId(), attTripItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttTripItem.class);
    }
}

