/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttPersonSchRemote;
import com.zkteco.zkbiosecurity.att.service.AttPersonSchService;
import com.zkteco.zkbiosecurity.att.util.ValidatorsUtils;
import com.zkteco.zkbiosecurity.att.vo.AttPersonSchItem;
import com.zkteco.zkbiosecurity.att.vo.AttSchPersonSelectItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.Tree;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttPersonSchController
extends BaseController
implements AttPersonSchRemote {
    @Autowired
    private AttPersonSchService attPersonSchService;

    @RequiresPermissions(value={"att:personsch"})
    public ModelAndView index() {
        return new ModelAndView("att/personSch/attPersonSch");
    }

    @RequiresPermissions(value={"att:personsch:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attPersonSchService.getItemById(id));
        }
        return new ModelAndView("att/personSch/editAttPersonSch");
    }

    @RequiresPermissions(value={"att:personsch:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_personSch", opType="common_op_new", requestParams={"id"}, opContent="att_common_id")
    public ZKResultMsg save(AttPersonSchItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attPersonSchService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(AttPersonSchItem condition) {
        String sessionId = this.request.getSession().getId();
        Pager pager = this.attPersonSchService.getAllPersonSch(sessionId, condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:personsch:del"})
    @LogRequest(module="att_module", object="att_leftMenu_personSch", opType="common_op_del", requestParams={"ids"}, opContent="att_common_id")
    public ZKResultMsg delete(String ids) {
        this.attPersonSchService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequestMapping(params={"dynaTree"}, produces={"application/xml;charset=UTF-8"})
    @ResponseBody
    public Tree dynaTree(String id) {
        String sessionId = this.request.getSession().getId();
        return this.attPersonSchService.personTree(sessionId, id);
    }

    public ZKResultMsg getAttShiftSchJsonByDate() {
        String[] splits;
        String schId = this.request.getParameter("schId");
        String dateSelected = this.request.getParameter("dateSelected");
        String personId = null;
        if (StringUtils.isNotBlank((CharSequence)schId) && "pers".equals((splits = schId.split("_"))[0])) {
            personId = splits[1];
        }
        if (StringUtils.isNotBlank((CharSequence)dateSelected)) {
            return this.attPersonSchService.getAttPersonSchJson(personId, dateSelected);
        }
        return null;
    }

    public DxGrid selectList(AttSchPersonSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.attPersonSchService.getNoPersonSch(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView attSelectPersonContent() {
        return new ModelAndView("att/personSch/attSelectPersonContent");
    }

    public ZKResultMsg getPersonWorkTime(String customerId, String date) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isDateTime(date)) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attPersonSchService.getPersonWorkTime(customerId, date));
    }
}

