/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttAreaPersonRemote;
import com.zkteco.zkbiosecurity.att.service.AttAreaPersonService;
import com.zkteco.zkbiosecurity.att.vo.AttAreaPersonItem;
import com.zkteco.zkbiosecurity.att.vo.AttAuthAreaItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttAreaPersonController
extends BaseController
implements AttAreaPersonRemote {
    @Autowired
    private AttAreaPersonService attAreaPersonService;

    @RequiresPermissions(value={"att:personArea"})
    public ModelAndView personArea() {
        return new ModelAndView("att/areaPerson/attPersonArea");
    }

    public DxGrid authAreaList(AttAuthAreaItem authAreaItem) {
        SecuritySubject authUser = this.getCurrentSubject();
        if (!authUser.getIsSuperuser().booleanValue() && authUser.getAreaIds() != null && authUser.getDepartmentIds().size() > 0) {
            authAreaItem.setAuthAreaIdIn(authUser.getAreaIds().toString().replaceAll("[\\[\\]]", "").replaceAll(" ", ""));
        }
        Pager pager = this.attAreaPersonService.authAreaList(authAreaItem, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, authAreaItem.getClass());
    }

    @RequiresPermissions(value={"att:areaPerson"})
    public ModelAndView index() {
        return new ModelAndView("att/areaPerson/attAreaPerson");
    }

    @RequiresPermissions(value={"att:areaPerson:refresh"})
    public DxGrid list(AttAreaPersonItem condition) {
        Pager pager = this.attAreaPersonService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:areaPerson:del"})
    @LogRequest(module="att_module", object="att_op_forZoneAddPers", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        this.attAreaPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:areaPerson:setUserSms"})
    public ModelAndView setUserSms(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("att/areaPerson/setUserSms");
    }

    public ZKResultMsg addSms(String ids) {
        String startTime = this.request.getParameter("startTime");
        String msg = this.request.getParameter("msg");
        String min = this.request.getParameter("min");
        ZKResultMsg zKResultMsg = this.attAreaPersonService.addSms(ids, startTime, msg, min);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"att:areaPerson:syncPerToDev"})
    public ZKResultMsg syncPerToDev(String areaId, String ids) {
        ZKResultMsg res = this.attAreaPersonService.syncPerToDev(areaId, ids);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:areaPerson:addPerson"})
    @LogRequest(module="att_module", object="att_op_forZoneAddPers", opType="common_op_new", requestParams={"personIds"}, opContent="att_areaPerson_personId")
    public ZKResultMsg addPerson() {
        String personIds = this.request.getParameter("personIds");
        String areaId = this.request.getParameter("areaId");
        ZKResultMsg res = new ZKResultMsg();
        res = this.attAreaPersonService.addPerson(personIds, areaId, "-1");
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:personArea:addArea"})
    @LogRequest(module="att_module", object="att_areaPerson_addArea", opType="common_op_new", requestParams={"areaIds"}, opContent="att_areaPerson_areaId")
    public ZKResultMsg addArea(@RequestParam(value="personId") String personId, @RequestParam(value="areaIds") String areaIds) {
        ZKResultMsg res = this.attAreaPersonService.addArea(personId, areaIds);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:personArea:delArea"})
    @LogRequest(module="att_module", object="att_areaPerson_delArea", opType="common_op_del", requestParams={"areaIds"}, opContent="att_areaPerson_areaId")
    public ZKResultMsg delArea(String personId, String areaIds) {
        this.attAreaPersonService.delArea(personId, areaIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid selectArea(AttAuthAreaItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            SecuritySubject authUser = this.getCurrentSubject();
            if (!authUser.getIsSuperuser().booleanValue() && authUser.getAreaIds() != null && authUser.getDepartmentIds().size() > 0) {
                condition.setAuthAreaIdIn(authUser.getAreaIds().toString().replaceAll("[\\[\\]]", "").replaceAll(" ", ""));
            }
            pager = this.attAreaPersonService.selectArea(condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @Deprecated
    public ZKResultMsg getAreaExtendData(String areaId) {
        ZKResultMsg res = new ZKResultMsg();
        Map personBioCountMap = this.attAreaPersonService.getAreaExtendData(areaId);
        res.setData((Object)personBioCountMap);
        return res;
    }
}

