/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.h5.controller;

import com.zkteco.zkbiosecurity.att.api.vo.AppAttAuditTaskItem;
import com.zkteco.zkbiosecurity.att.api.vo.AppAttQueryTaskItem;
import com.zkteco.zkbiosecurity.att.h5.service.AttApiH5ApplyService;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/att"})
public class AttApiH5ApplyController {
    @Autowired
    private AttApiH5ApplyService attApiH5ApplyService;

    @RequestMapping(path={"/getApplyDetailInfo"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getApplyDetailInfo(@RequestBody AppAttQueryTaskItem appAttQueryTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTaskItem.getTaskId()) && StringUtils.isBlank((CharSequence)appAttQueryTaskItem.getApplyId()) && StringUtils.isBlank((CharSequence)appAttQueryTaskItem.getApplyType())) {
            throw ZKBusinessException.errorException((String)"att_h5_taskIdNotNull", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = this.attApiH5ApplyService.getApplyDetailInfo(appAttQueryTaskItem.getTaskId(), appAttQueryTaskItem.getApplyId(), appAttQueryTaskItem.getApplyType());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/getApprovalDetailInfo"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getApprovalDetailInfo(@RequestBody AppAttQueryTaskItem appAttQueryTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTaskItem.getTaskId())) {
            throw ZKBusinessException.errorException((String)"att_h5_taskIdNotNull", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = this.attApiH5ApplyService.getApprovalDetailInfo(appAttQueryTaskItem.getTaskId());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/auditTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg auditTask(@RequestBody AppAttAuditTaskItem appAttAuditTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttAuditTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)appAttAuditTaskItem.getTaskId())) {
            throw ZKBusinessException.errorException((String)"att_h5_taskIdNotNull", (Object[])new Object[0]);
        }
        if (appAttAuditTaskItem.getResult() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_auditResultNotNull", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = this.attApiH5ApplyService.completeTask(appAttAuditTaskItem.getCustomerId(), appAttAuditTaskItem.getTaskId(), appAttAuditTaskItem.getResult(), appAttAuditTaskItem.getRemark());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/cancelApply"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg cancelApply(@RequestBody AppAttAuditTaskItem appAttAuditTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttAuditTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"app_pers_personIdNull", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)appAttAuditTaskItem.getTaskId())) {
            throw ZKBusinessException.errorException((String)"app_att_taskIdNotNull", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = this.attApiH5ApplyService.cancelApply(appAttAuditTaskItem.getCustomerId(), appAttAuditTaskItem.getTaskId(), appAttAuditTaskItem.getRemark());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

