/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="ACC_READER t LEFT JOIN ACC_DOOR ad ON ad.ID = t.DOOR_ID LEFT JOIN ACC_DEVICE dev ON dev.ID = ad.DEV_ID ")
@OrderBy(after="dev.BUSINESS_ID ASC, t.READER_NO ASC")
@GridConfig(operate=true, idField="id", winHeight=500, winWidth=550, operates={@GridOperate(type="edit", permission="acc:reader:edit", url="/accReader.do?edit", label="common_op_edit"), @GridOperate(type="custom", permission="acc:reader:bindChannel", filter="accShowBindChannel", click="accReaderBindChannel", label="acc_common_bindOrUnbindChannel")})
public class AccReaderItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", show=false)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(label="acc_readerDefine_readerName", width="150", columnType="edit", editUrl="/accReader.do?edit", editPermission="acc:reader:edit")
    private String name;
    @Column(name="t.DOOR_ID")
    @GridColumn(label="acc_door_id", show=false)
    private String doorId;
    @Column(name="ad.NAME")
    @GridColumn(label="acc_door_name", width="150")
    private String doorName;
    @Column(name="t.READER_NO")
    @GridColumn(label="common_number", sort="na")
    private Short readerNo;
    @Column(name="t.COMM_TYPE")
    @GridColumn(label="acc_reader_commType", width="100", format="0=acc_readerCommType_disable,1=acc_readerCommType_rs485,2=acc_readerCommType_wiegand,3=acc_readerCommType_wg485,4=acc_readerCommType_tcp,5=acc_readerCommType_zigbee")
    private Short commType;
    @Column(name="t.COMM_ADDRESS")
    @GridColumn(label="acc_reader_commAddress", width="100")
    private Short commAddress;
    @Column(name="t.READER_STATE")
    @GridColumn(label="acc_reader_inout", format="0=common_in,1=common_out")
    private Short readerState;
    @Column(name="t.ID")
    @GridColumn(label="acc_common_boundChannel", show=false)
    private String channelId;
    @GridColumn(label="acc_common_boundChannel", width="150", sort="na", showHeader="accShowBindChannel")
    private String channelName;
    @Column(name="t.IP")
    @GridColumn(label="acc_reader_ip", show=false)
    private String ip;
    @Column(name="t.PORT")
    @GridColumn(label="acc_reader_port", show=false)
    private Short port;
    @Column(name="t.MAC")
    @GridColumn(label="acc_reader_mac", show=false)
    private String mac;
    @Column(name="t.MULTICAST")
    @GridColumn(label="acc_reader_multicast", show=false)
    private String multicast;
    @Column(name="t.READER_ENCRYPT")
    @GridColumn(label="acc_reader_readerEncrypt", show=false)
    private Boolean readerEncrypt;
    @GridColumn(label="acc_ownedBoard", width="100", showExpression="#language!='zh_CN'")
    private String extDevName;
    @Condition(value="dev.AUTH_AREA_ID IN (%s)", formatType="quote")
    private String areaIdIn;
    @Condition(value="t.ID IN (%s)", formatType="quote")
    private String idIn;
    private String deviceId;
    @Column(name="dev.SN")
    private String deviceSn;
    private String doorNo;
    private String idCardMode;
    @Column(name="t.EXT_DEV_ID")
    private String extDevId;
    @Column(name="t.RS485_PROTOCOL_TYPE")
    private Short rs485ProtocolType;
    @Column(name="t.USER_LOCK_FUN")
    private Short userLockFun;
    private String userInfoReveal;

    public AccReaderItem() {
    }

    public AccReaderItem(Boolean equals) {
        super(equals);
    }

    public AccReaderItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AccReaderItem(String id, String name, Short readerNo, Short readerState, Short commType, Short commAddress, String ip, Short port, String mac, String multicast, Boolean readerEncrypt) {
        this.id = id;
        this.name = name;
        this.readerNo = readerNo;
        this.readerState = readerState;
        this.commType = commType;
        this.commAddress = commAddress;
        this.ip = ip;
        this.port = port;
        this.mac = mac;
        this.multicast = multicast;
        this.readerEncrypt = readerEncrypt;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDoorId() {
        return this.doorId;
    }

    public String getDoorName() {
        return this.doorName;
    }

    public Short getReaderNo() {
        return this.readerNo;
    }

    public Short getCommType() {
        return this.commType;
    }

    public Short getCommAddress() {
        return this.commAddress;
    }

    public Short getReaderState() {
        return this.readerState;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getIp() {
        return this.ip;
    }

    public Short getPort() {
        return this.port;
    }

    public String getMac() {
        return this.mac;
    }

    public String getMulticast() {
        return this.multicast;
    }

    public Boolean getReaderEncrypt() {
        return this.readerEncrypt;
    }

    public String getExtDevName() {
        return this.extDevName;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getIdIn() {
        return this.idIn;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getDoorNo() {
        return this.doorNo;
    }

    public String getIdCardMode() {
        return this.idCardMode;
    }

    public String getExtDevId() {
        return this.extDevId;
    }

    public Short getRs485ProtocolType() {
        return this.rs485ProtocolType;
    }

    public Short getUserLockFun() {
        return this.userLockFun;
    }

    public String getUserInfoReveal() {
        return this.userInfoReveal;
    }

    public AccReaderItem setId(String id) {
        this.id = id;
        return this;
    }

    public AccReaderItem setName(String name) {
        this.name = name;
        return this;
    }

    public AccReaderItem setDoorId(String doorId) {
        this.doorId = doorId;
        return this;
    }

    public AccReaderItem setDoorName(String doorName) {
        this.doorName = doorName;
        return this;
    }

    public AccReaderItem setReaderNo(Short readerNo) {
        this.readerNo = readerNo;
        return this;
    }

    public AccReaderItem setCommType(Short commType) {
        this.commType = commType;
        return this;
    }

    public AccReaderItem setCommAddress(Short commAddress) {
        this.commAddress = commAddress;
        return this;
    }

    public AccReaderItem setReaderState(Short readerState) {
        this.readerState = readerState;
        return this;
    }

    public AccReaderItem setChannelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    public AccReaderItem setChannelName(String channelName) {
        this.channelName = channelName;
        return this;
    }

    public AccReaderItem setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public AccReaderItem setPort(Short port) {
        this.port = port;
        return this;
    }

    public AccReaderItem setMac(String mac) {
        this.mac = mac;
        return this;
    }

    public AccReaderItem setMulticast(String multicast) {
        this.multicast = multicast;
        return this;
    }

    public AccReaderItem setReaderEncrypt(Boolean readerEncrypt) {
        this.readerEncrypt = readerEncrypt;
        return this;
    }

    public AccReaderItem setExtDevName(String extDevName) {
        this.extDevName = extDevName;
        return this;
    }

    public AccReaderItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public AccReaderItem setIdIn(String idIn) {
        this.idIn = idIn;
        return this;
    }

    public AccReaderItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public AccReaderItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public AccReaderItem setDoorNo(String doorNo) {
        this.doorNo = doorNo;
        return this;
    }

    public AccReaderItem setIdCardMode(String idCardMode) {
        this.idCardMode = idCardMode;
        return this;
    }

    public AccReaderItem setExtDevId(String extDevId) {
        this.extDevId = extDevId;
        return this;
    }

    public AccReaderItem setRs485ProtocolType(Short rs485ProtocolType) {
        this.rs485ProtocolType = rs485ProtocolType;
        return this;
    }

    public AccReaderItem setUserLockFun(Short userLockFun) {
        this.userLockFun = userLockFun;
        return this;
    }

    public AccReaderItem setUserInfoReveal(String userInfoReveal) {
        this.userInfoReveal = userInfoReveal;
        return this;
    }

    public String toString() {
        return "AccReaderItem(id=" + this.getId() + ", name=" + this.getName() + ", doorId=" + this.getDoorId() + ", doorName=" + this.getDoorName() + ", readerNo=" + this.getReaderNo() + ", commType=" + this.getCommType() + ", commAddress=" + this.getCommAddress() + ", readerState=" + this.getReaderState() + ", channelId=" + this.getChannelId() + ", channelName=" + this.getChannelName() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", mac=" + this.getMac() + ", multicast=" + this.getMulticast() + ", readerEncrypt=" + this.getReaderEncrypt() + ", extDevName=" + this.getExtDevName() + ", areaIdIn=" + this.getAreaIdIn() + ", idIn=" + this.getIdIn() + ", deviceId=" + this.getDeviceId() + ", deviceSn=" + this.getDeviceSn() + ", doorNo=" + this.getDoorNo() + ", idCardMode=" + this.getIdCardMode() + ", extDevId=" + this.getExtDevId() + ", rs485ProtocolType=" + this.getRs485ProtocolType() + ", userLockFun=" + this.getUserLockFun() + ", userInfoReveal=" + this.getUserInfoReveal() + ")";
    }
}

