/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ACC_TRANSACTION t ")
@Where(after="AND (t.EVENT_NO >= 20 and t.EVENT_NO < 200 OR t.EVENT_NO >= 500) ")
@OrderBy(after="t.EVENT_TIME DESC")
@GridConfig
public class AccAlarmTransactionItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(width="0", sortNo=0, show=false)
    private String id;
    @Column(name="t.LOG_ID")
    @GridColumn(label="acc_common_logEventNumber", width="70", sortNo=1)
    private Integer logId;
    @Column(name="t.EVENT_TIME")
    @GridColumn(label="common_time", width="125", sortNo=2, sort="na")
    private Date eventTime;
    @Column(name="t.DEV_ALIAS")
    @GridColumn(label="common_dev_name", width="110", sortNo=3)
    private String devAlias;
    @Column(name="t.EVENT_POINT_NAME")
    @GridColumn(label="common_eventPoint", width="125", sortNo=4)
    private String eventPointName;
    @Column(name="t.EVENT_NAME", equalTag="in")
    @GridColumn(label="common_eventDescription", width="125", sortNo=5, i18n=true)
    private String eventName;
    @Column(name="t.VID_LINKAGE_HANDLE")
    @GridColumn(label="common_mediaFile", width="100", columnType="custom", convert="convertAccVidLinkage", sortNo=6, isExportExcel=false)
    private String vidLinkageHandle;
    @Column(name="t.PIN")
    @GridColumn(label="pers_person_pin", width="100", sortNo=7)
    private String pin;
    @Column(name="t.NAME")
    @GridColumn(label="pers_person_name", width="100", sortNo=8)
    private String name;
    @Column(name="t.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="70", showExpression="#language!='zh_CN'", sortNo=9)
    private String lastName;
    @Column(name="t.CARD_NO")
    @GridColumn(label="pers_card_cardNo", width="100", sortNo=10)
    private String cardNo;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="pers_dept_deptNo", width="70", sortNo=11)
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", width="100", sortNo=12)
    private String deptName;
    @Column(name="t.READER_NAME")
    @GridColumn(label="acc_readerDefine_readerName", width="100", sortNo=13)
    private String readerName;
    @Column(name="t.VERIFY_MODE_NAME", equalTag="in")
    @GridColumn(label="common_verifyMode_entiy", width="100", sortNo=14, i18n=true)
    private String verifyModeName;
    @Column(name="t.AREA_NAME")
    @GridColumn(label="base_area_name", width="70", sortNo=15)
    private String areaName;
    @Column(name="t.DESCRIPTION")
    @GridColumn(label="common_remark", width="50", sortNo=16)
    private String description;
    @Column(name="t.DEV_ID")
    private String devId;
    @Column(name="t.DEV_SN")
    private String devSn;
    @Column(name="t.VERIFY_MODE_NO")
    private Short verifyModeNo;
    @Column(name="t.EVENT_NO")
    private Short eventNo;
    @Column(name="t.EVENT_POINT_TYPE")
    private Short eventPointType;
    @Column(name="t.EVENT_POINT_ID")
    private String eventPointId;
    @Column(name="t.READER_STATE")
    private Short readerState;
    @Column(name="t.TRIGGER_COND")
    private Short triggerCond;
    @Column(name="t.ACC_ZONE")
    private String accZone;
    @Column(name="t.EVENT_ADDR")
    private Short eventAddr;
    @Column(name="t.UNIQUE_KEY")
    private String uniqueKey;
    @Condition(value="t.EVENT_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.EVENT_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="(LOWER (t.NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Column(name="t.AREA_NAME", equalTag="in")
    private String areaNameIn;
    @Condition(value="(t.DEPT_CODE in (%s) or t.DEPT_CODE is null or t.DEPT_CODE = '')", formatType="quote")
    private String deptCodeIn;

    public AccAlarmTransactionItem() {
    }

    public AccAlarmTransactionItem(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Integer getLogId() {
        return this.logId;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public String getEventPointName() {
        return this.eventPointName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getVidLinkageHandle() {
        return this.vidLinkageHandle;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getReaderName() {
        return this.readerName;
    }

    public String getVerifyModeName() {
        return this.verifyModeName;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDevId() {
        return this.devId;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public Short getVerifyModeNo() {
        return this.verifyModeNo;
    }

    public Short getEventNo() {
        return this.eventNo;
    }

    public Short getEventPointType() {
        return this.eventPointType;
    }

    public String getEventPointId() {
        return this.eventPointId;
    }

    public Short getReaderState() {
        return this.readerState;
    }

    public Short getTriggerCond() {
        return this.triggerCond;
    }

    public String getAccZone() {
        return this.accZone;
    }

    public Short getEventAddr() {
        return this.eventAddr;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getAreaNameIn() {
        return this.areaNameIn;
    }

    public String getDeptCodeIn() {
        return this.deptCodeIn;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogId(Integer logId) {
        this.logId = logId;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public void setDevAlias(String devAlias) {
        this.devAlias = devAlias;
    }

    public void setEventPointName(String eventPointName) {
        this.eventPointName = eventPointName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setVidLinkageHandle(String vidLinkageHandle) {
        this.vidLinkageHandle = vidLinkageHandle;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setReaderName(String readerName) {
        this.readerName = readerName;
    }

    public void setVerifyModeName(String verifyModeName) {
        this.verifyModeName = verifyModeName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDevId(String devId) {
        this.devId = devId;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public void setVerifyModeNo(Short verifyModeNo) {
        this.verifyModeNo = verifyModeNo;
    }

    public void setEventNo(Short eventNo) {
        this.eventNo = eventNo;
    }

    public void setEventPointType(Short eventPointType) {
        this.eventPointType = eventPointType;
    }

    public void setEventPointId(String eventPointId) {
        this.eventPointId = eventPointId;
    }

    public void setReaderState(Short readerState) {
        this.readerState = readerState;
    }

    public void setTriggerCond(Short triggerCond) {
        this.triggerCond = triggerCond;
    }

    public void setAccZone(String accZone) {
        this.accZone = accZone;
    }

    public void setEventAddr(Short eventAddr) {
        this.eventAddr = eventAddr;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setLikeName(String likeName) {
        this.likeName = likeName;
    }

    public void setAreaNameIn(String areaNameIn) {
        this.areaNameIn = areaNameIn;
    }

    public void setDeptCodeIn(String deptCodeIn) {
        this.deptCodeIn = deptCodeIn;
    }
}

