/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttSignRemote;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.service.AttSignService;
import com.zkteco.zkbiosecurity.att.util.ValidatorsUtils;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.att.vo.AttSignItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttSignController
extends ExportController
implements AttSignRemote {
    @Autowired
    private AttSignService attSignService;
    @Autowired
    private AttPersonService attPersonService;

    @RequiresPermissions(value={"att:sign"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/sign/attSign");
    }

    @RequiresPermissions(value={"att:sign:add"})
    public ModelAndView edit(String id) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        AttSignItem item = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.attSignService.getItemById(id);
        } else if (null != staff && staff.booleanValue()) {
            item = new AttSignItem();
            item.setPersonId(securitySubject.getUserId());
        }
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("att/sign/editAttSign");
    }

    @RequiresPermissions(value={"att:sign:add"})
    @LogRequest(module="att_module", object="att_leftMenu_sign", opType="common_op_new", requestParams={"personPin"}, opContent="att_person_pin")
    public ZKResultMsg save(AttSignItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String personIds = this.request.getParameter("personIds");
        if (StringUtils.isBlank((CharSequence)personIds)) {
            throw new ZKBusinessException("EXCEPTIONLEVEL_WARN", "common_prompt_selectObj");
        }
        List persPersonList = this.attPersonService.getPersonItemByPersonIds((Collection)StrUtil.strToList((String)personIds));
        for (AttPersonItem attPersonItem : persPersonList) {
            Date hireDate = attPersonItem.getHireDate();
            if (hireDate == null || hireDate.getTime() <= item.getSignDatetime().getTime()) continue;
            res.setMsg(I18nUtil.i18nCode((String)"att_h5_persNoHire", (Object[])new Object[0]));
            res.setData((Object)"false");
            return res;
        }
        this.attSignService.saveItem(item, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:sign:refresh"})
    public DxGrid list(AttSignItem condition) {
        condition.setFlowStatus("2");
        Pager pager = this.attSignService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:sign:del"})
    @LogRequest(module="att_module", object="att_leftMenu_sign", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attSignService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:sign:export"})
    @LogRequest(module="att_module", object="att_leftMenu_sign", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttSignItem attSignItem = new AttSignItem();
        this.setConditionValue((BaseItem)attSignItem);
        attSignItem.setFlowStatus("2");
        List intemList = this.attSignService.getItemData(request.getSession().getId(), attSignItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttSignItem.class);
    }

    public ZKResultMsg verifySignTime(String signDatetime, String customerId) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attSignService.verifySignTime(signDatetime, customerId));
    }

    public ZKResultMsg getDayValidCardAndWorkTime(String customerId, String date) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isDate(date)) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attSignService.getSignDayScheduleAndRecords(customerId, date));
    }
}

