/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttRuleRemote;
import com.zkteco.zkbiosecurity.att.service.AttRuleService;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttRuleController
extends BaseController
implements AttRuleRemote {
    @Autowired
    private AttRuleService attRuleService;

    @RequiresPermissions(value={"att:rule"})
    public ModelAndView index() {
        Map attParams = this.attRuleService.getAttParams();
        if (Objects.isNull(attParams.get("att.baseRule.maxOvertimeType"))) {
            attParams.put("att.baseRule.maxOvertimeType", "notLimited");
        }
        if (Objects.isNull(attParams.get("att.baseRule.maxOvertimeMinutes"))) {
            attParams.put("att.baseRule.maxOvertimeMinutes", "0");
        }
        this.request.setAttribute("attParams", (Object)attParams);
        return new ModelAndView("att/rule/attRule");
    }

    @RequiresPermissions(value={"att:rule:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_rule", opType="common_op_edit", opContent="att_rule_baseRuleSet")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        String maxOverTimeType = params.get("att.baseRule.maxOvertimeType");
        String maxOverTimeMinutes = params.get("att.baseRule.maxOvertimeMinutes");
        String smallOvertime = params.get("att.baseRule.shortestOvertimeMinutes");
        if (!"notLimited".equals(maxOverTimeType) && Integer.valueOf(smallOvertime) > Integer.valueOf(maxOverTimeMinutes)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_rule_overtimeWarning", (Object[])new Object[0]));
        }
        this.attRuleService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

