/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttLeaveTypeRemote;
import com.zkteco.zkbiosecurity.att.service.AttLeaveTypeService;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveTypeItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.PropertiesUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttLeaveTypeController
extends BaseController
implements AttLeaveTypeRemote {
    @Autowired
    private AttLeaveTypeService attLeaveTypeService;

    @RequiresPermissions(value={"att:leaveType"})
    public ModelAndView index() {
        return new ModelAndView("att/leaveType/attLeaveType");
    }

    @RequiresPermissions(value={"att:leaveType:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AttLeaveTypeItem leaveTypeItem = this.attLeaveTypeService.getItemById(id);
            if (leaveTypeItem.getInitFlag().booleanValue()) {
                String lang = PropertiesUtil.getCurrentLanguage();
                leaveTypeItem.setLeaveTypeName(I18nUtil.i18nCode((String)leaveTypeItem.getLeaveTypeName(), (Object[])new Object[]{lang}));
            }
            this.request.setAttribute("item", (Object)leaveTypeItem);
        }
        return new ModelAndView("att/leaveType/editAttLeaveType");
    }

    @RequiresPermissions(value={"att:leaveType:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_leaveType", opType="common_op_edit", requestParams={"leaveTypeName"}, opContent="common_name")
    public ZKResultMsg save(AttLeaveTypeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attLeaveTypeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:leaveType:refresh"})
    public DxGrid list(AttLeaveTypeItem condition) {
        Pager pager = this.attLeaveTypeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:leaveType:del"})
    @LogRequest(module="att_module", object="att_leftMenu_leaveType", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        if (this.attLeaveTypeService.isInitData(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"common_prompt_initDataCanNotDel", (Object[])new Object[0]));
        }
        if (this.attLeaveTypeService.isExistFkData(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_common_relationDataCanNotDel", (Object[])new Object[0]));
        }
        this.attLeaveTypeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public String isLeaveTypeName(String leaveTypeName) {
        boolean exitTypeName = this.attLeaveTypeService.isLeaveTypeName(leaveTypeName);
        return String.valueOf(!exitTypeName);
    }

    public ZKResultMsg listJsonLeaveType() {
        return this.attLeaveTypeService.listJsonLeaveType();
    }
}

