/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttGroupSchRemote;
import com.zkteco.zkbiosecurity.att.service.AttGroupSchService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.att.vo.AttGroupSchItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttGroupSchController
extends BaseController
implements AttGroupSchRemote {
    @Autowired
    private AttGroupSchService attGroupSchService;

    @RequiresPermissions(value={"att:groupsch"})
    public ModelAndView index() {
        return new ModelAndView("att/groupSch/attGroupSch");
    }

    @RequiresPermissions(value={"att:groupsch:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("shiftIds", (Object)this.attGroupSchService.getShiftIds(id));
            AttGroupSchItem attGroupSchItem = this.attGroupSchService.getItemById(id);
            String endTime = AttDateUtils.dateToStrAsShort((Date)attGroupSchItem.getEndDate());
            String maxTime = AttDateUtils.dateToStrAsShort((Date)AttDateUtils.getMaxEndDate());
            if (endTime.equals(maxTime)) {
                attGroupSchItem.setEndDate(null);
            }
            this.request.setAttribute("item", (Object)attGroupSchItem);
        }
        return new ModelAndView("att/groupSch/editAttGroupSch");
    }

    @RequiresPermissions(value={"att:groupsch:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_groupSch", opType="common_op_edit", requestParams={"groupIds"}, opContent="att_common_groupId")
    public ZKResultMsg save(AttGroupSchItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String shiftIds = this.request.getParameter("shiftIds");
        String groupIds = this.request.getParameter("groupIds");
        this.attGroupSchService.saveItem(item, shiftIds, groupIds);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:groupsch:refresh"})
    public DxGrid list(AttGroupSchItem condition) {
        if (null == condition.getGroupId()) {
            condition.setId("-1");
        }
        Pager pager = this.attGroupSchService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:groupsch:del"})
    @LogRequest(module="att_module", object="att_leftMenu_groupSch", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        this.attGroupSchService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAttShiftSchJsonByDate() {
        String groupId = this.request.getParameter("schId");
        String dateSelected = this.request.getParameter("dateSelected");
        if (StringUtils.isNotBlank((CharSequence)dateSelected)) {
            return this.attGroupSchService.getAttGroupSchJson(groupId, dateSelected);
        }
        return null;
    }
}

