/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttGroupPersonRemote;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.vo.AttGroupPersonItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class AttGroupPersonController
extends BaseController
implements AttGroupPersonRemote {
    @Autowired
    private AttPersonService attPersonService;

    @RequiresPermissions(value={"att:groupPerson:refresh"})
    public DxGrid list(AttGroupPersonItem condition) {
        Pager pager = this.attPersonService.loadPagerByAuthFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg save() {
        ZKResultMsg res = new ZKResultMsg();
        this.attPersonService.updateAttPerson(this.request.getParameter("groupId"), this.request.getParameter("personId"), this.request.getParameter("deptIds"));
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:groupPerson:del"})
    @LogRequest(module="att_module", object="att_leftMenu_groupPerson", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids, String groupId) {
        this.attPersonService.deleteByIds(ids, groupId);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

