/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttDayDetailReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.service.AttRecordService;
import com.zkteco.zkbiosecurity.att.vo.AttDayDetailReportItem;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttDayDetailReportController
extends ExportController
implements AttDayDetailReportRemote {
    @Autowired
    private AttRecordService attRecordService;
    @Autowired(required=false)
    private AuthDepartmentService authDepartmentService;
    @Autowired
    private AttPersonService attPersonService;

    @RequiresPermissions(value={"att:dayDetailReport"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        AttPersonItem attPersonItem = this.attPersonService.getItemByPersonPin(securitySubject.getUserCode());
        if (Objects.nonNull(attPersonItem)) {
            staff = true;
        }
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/report/attDayDetail");
    }

    @RequiresPermissions(value={"att:dayDetailReport:refresh"})
    public DxGrid list(AttDayDetailReportItem condition) {
        Pager pager = this.attRecordService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:dayDetailReport:export"})
    @LogRequest(module="att_module", object="att_leftMenu_dayDetailReport", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttDayDetailReportItem attDayDetailReportItem = new AttDayDetailReportItem();
        this.setConditionValue((BaseItem)attDayDetailReportItem);
        List intemList = this.attRecordService.getDayDetailReportItemData(request.getSession().getId(), AttDayDetailReportItem.class, attDayDetailReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttDayDetailReportItem.class);
    }
}

