/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.h5.controller;

import com.zkteco.zkbiosecurity.att.api.vo.AppAttApplyTaskItem;
import com.zkteco.zkbiosecurity.att.api.vo.AppAttLeaveItem;
import com.zkteco.zkbiosecurity.att.api.vo.AppAttOvertimeItem;
import com.zkteco.zkbiosecurity.att.api.vo.AppAttQueryTeamAttItem;
import com.zkteco.zkbiosecurity.att.api.vo.AppAttSignItem;
import com.zkteco.zkbiosecurity.att.h5.service.AttApiH5WorkFlowService;
import com.zkteco.zkbiosecurity.att.util.I18nMsgUtil;
import com.zkteco.zkbiosecurity.att.util.ValidatorsUtils;
import com.zkteco.zkbiosecurity.base.vo.ZKPageResultMsg;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/att"})
public class AttApiH5WorkFlowController {
    @Autowired
    private AttApiH5WorkFlowService attApiH5WordFlowService;

    @RequestMapping(path={"/saveAppSign"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg saveAppSign(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.editAppSign(appAttApplyTaskItem));
    }

    @RequestMapping(path={"/getSignApprove"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getSignApprove(@RequestBody AppAttSignItem signItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getFirstApprove(signItem.getCustomerId(), "sign"));
    }

    @RequestMapping(path={"/getSignNotifier"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getSignNotifier(@RequestBody AppAttSignItem signItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getFirstNotifier(signItem.getCustomerId(), "sign"));
    }

    @RequestMapping(path={"/getNoApprovalSign"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovalSign(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "sign", "0", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getHandledSign"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getHandledSign(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "sign", "2", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getNoApprovalSignTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovalSignTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getNoApprovalTask(appAttApplyTaskItem.getCustomerId(), "sign", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getApprovalSignTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getApprovalSignTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getApprovalTask(appAttApplyTaskItem.getCustomerId(), "sign", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/saveAppTrip"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg saveAppTrip(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.editAppTrip(appAttApplyTaskItem));
    }

    @RequestMapping(path={"/getTripApprove"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getTripApprove(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getFirstApprove(appAttQueryTeamAttItem.getCustomerId(), "trip"));
    }

    @RequestMapping(path={"/getTripNotifier"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getTripNotifier(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getFirstNotifier(appAttQueryTeamAttItem.getCustomerId(), "trip"));
    }

    @RequestMapping(path={"/getNoApprovaTrip"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovaTrip(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "trip", "0", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getHandledTrip"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getHandledTrip(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "trip", "2", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getNoApprovalTripTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovalTripTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getNoApprovalTask(appAttApplyTaskItem.getCustomerId(), "trip", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getApprovalTripTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getApprovalTripTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getApprovalTask(appAttApplyTaskItem.getCustomerId(), "trip", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/saveAppLeave"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg saveAppLeave(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isDateTime(appAttApplyTaskItem.getStartTime()) || !ValidatorsUtils.isDateTime(appAttApplyTaskItem.getEndTime())) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.editAppLeave(appAttApplyTaskItem));
    }

    @RequestMapping(path={"/getLeaveApprove"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getLeaveApprove(@RequestBody AppAttApplyTaskItem appAttLeaveItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getLeaveApprove(appAttLeaveItem.getCustomerId(), appAttLeaveItem.getBusinessType(), appAttLeaveItem.getStartTime(), appAttLeaveItem.getEndTime()));
    }

    @RequestMapping(path={"/getLeaveNotifier"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getLeaveNotifier(@RequestBody AppAttLeaveItem appAttLeaveItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getFirstNotifier(appAttLeaveItem.getCustomerId(), "leave"));
    }

    @RequestMapping(path={"/getNoApprovalLeave"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovalLeave(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "leave", "0", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getHandledLeave"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getHandledLeave(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "leave", "2", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getNoApprovalLeaveTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovalLeaveTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getNoApprovalTask(appAttApplyTaskItem.getCustomerId(), "leave", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getApprovalLeaveTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getApprovalLeaveTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getApprovalTask(appAttApplyTaskItem.getCustomerId(), "leave", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/saveAppOut"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg saveAppOut(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.editAppOut(appAttApplyTaskItem));
    }

    @RequestMapping(path={"/getOutApprove"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getOutApprove(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getFirstApprove(appAttQueryTeamAttItem.getCustomerId(), "out"));
    }

    @RequestMapping(path={"/getOutNotifier"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getOutNotifier(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getFirstNotifier(appAttQueryTeamAttItem.getCustomerId(), "out"));
    }

    @RequestMapping(path={"/getNoApprovaOut"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovaOut(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "out", "0", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getHandledOut"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getHandledOut(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "out", "2", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getNoApprovalOutTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovalOutTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getNoApprovalTask(appAttApplyTaskItem.getCustomerId(), "out", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getApprovalOutTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getApprovalOutTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getApprovalTask(appAttApplyTaskItem.getCustomerId(), "out", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/saveOvertime"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg saveOvertime(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.editOverTime(appAttApplyTaskItem));
    }

    @RequestMapping(path={"/getOvertimeApprove"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getOvertimeApprove(@RequestBody AppAttOvertimeItem overtimeItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getFirstApprove(overtimeItem.getCustomerId(), "overtime"));
    }

    @RequestMapping(path={"/getOvertimeNotifier"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getOvertimeNotifier(@RequestBody AppAttOvertimeItem overtimeItem) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiH5WordFlowService.getFirstNotifier(overtimeItem.getCustomerId(), "overtime"));
    }

    @RequestMapping(path={"/getNoApprovalOvertime"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovalOvertime(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "overtime", "0", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getHandledOvertime"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getHandledOvertime(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getMyApply(appAttApplyTaskItem.getCustomerId(), "overtime", "2", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getNoApprovalOvertimeTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getNoApprovalOvertimeTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getNoApprovalTask(appAttApplyTaskItem.getCustomerId(), "overtime", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getApprovalOvertimeTask"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getApprovalOvertimeTask(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        if (StringUtils.isBlank((CharSequence)appAttApplyTaskItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttApplyTaskItem.getPageNo() == null || appAttApplyTaskItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5WordFlowService.getApprovalTask(appAttApplyTaskItem.getCustomerId(), "overtime", appAttApplyTaskItem.getPageNo(), appAttApplyTaskItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(value={"/checkApplyAndWorkTimeValid"})
    @ResponseBody
    public ZKResultMsg checkApplyAndWorkTimeValid(@RequestBody AppAttApplyTaskItem appAttApplyTaskItem) {
        try {
            return this.attApiH5WordFlowService.checkApplyAndWorkTimeValid(appAttApplyTaskItem);
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)e.getMessage()));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
    }
}

