/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.api.vo.AttApiApplyTaskDetailItem;
import com.zkteco.zkbiosecurity.att.service.AttWorkflowService;
import com.zkteco.zkbiosecurity.att.vo.AttCloudSignItem;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveItem;
import com.zkteco.zkbiosecurity.att.vo.AttOutItem;
import com.zkteco.zkbiosecurity.att.vo.AttOvertimeItem;
import com.zkteco.zkbiosecurity.att.vo.AttTripItem;
import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/attWorkflow"})
public class AttApiWorkflowController {
    @Autowired
    private AttWorkflowService attWorkflowService;

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/getFirstApprove"})
    @ResponseBody
    public ZKResultMsg getFirstApprove(@RequestBody ZKMessage zkMessage) {
        try {
            String personPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"personPin");
            String flowType = MapUtils.getString((Map)zkMessage.getContent(), (Object)"flowType");
            List list = this.attWorkflowService.getFirstApprove(personPin, flowType);
            return new ZKResultMsg((Object)JSONArray.toJSONString((Object)list));
        }
        catch (Exception e) {
            return ZKResultMsg.getFailMsg((String)e.getMessage());
        }
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/getLeaveApprove"})
    @ResponseBody
    public ZKResultMsg getLeaveApprove(@RequestBody ZKMessage zkMessage) {
        try {
            String personPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"personPin");
            String leaveTypeNo = MapUtils.getString((Map)zkMessage.getContent(), (Object)"leaveType");
            String startTime = MapUtils.getString((Map)zkMessage.getContent(), (Object)"startTime");
            String endTime = MapUtils.getString((Map)zkMessage.getContent(), (Object)"endTime");
            List list = this.attWorkflowService.getLeaveApprove(personPin, leaveTypeNo, startTime, endTime);
            return new ZKResultMsg((Object)JSONArray.toJSONString((Object)list));
        }
        catch (Exception e) {
            return ZKResultMsg.getFailMsg((String)e.getMessage());
        }
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/getFirstNotifier"})
    @ResponseBody
    public ZKResultMsg getFirstNotifier(@RequestBody ZKMessage zkMessage) {
        try {
            String personPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"personPin");
            String flowType = MapUtils.getString((Map)zkMessage.getContent(), (Object)"flowType");
            List list = this.attWorkflowService.getFirstNotifier(personPin, flowType);
            return new ZKResultMsg((Object)JSONArray.toJSONString((Object)list));
        }
        catch (ZKBusinessException e) {
            return ZKResultMsg.getFailMsg((String)e.getMessage());
        }
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/findApplyTask"})
    @ResponseBody
    public ZKResultMsg findApplyTask(@RequestBody ZKMessage zkMessage) {
        String personPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"personPin");
        String flowType = MapUtils.getString((Map)zkMessage.getContent(), (Object)"flowType");
        Integer taskStatus = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"taskStatus");
        Integer pageNo = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"pageNo");
        Integer pageSize = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"pageSize");
        Pager pager = this.attWorkflowService.findApplyTask(personPin, flowType, taskStatus, pageNo, pageSize);
        return new ZKResultMsg((Object)pager);
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/getWorkflowInfoByBusinessKey"})
    @ResponseBody
    public ZKResultMsg getWorkflowInfoByBusinessKey(@RequestBody ZKMessage zkMessage) {
        String businessKey = MapUtils.getString((Map)zkMessage.getContent(), (Object)"businessKey");
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return ZKResultMsg.getFailMsg((String)I18nUtil.i18nCode((String)"att_apply_withoutDetail", (Object[])new Object[0]));
        }
        try {
            AttApiApplyTaskDetailItem item = this.attWorkflowService.findByBusinessKey(businessKey);
            return new ZKResultMsg((Object)JSONObject.toJSONString((Object)item));
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return ZKResultMsg.failMsg((String)e.getMessage(), (Object[])new Object[0]);
            }
            return ZKResultMsg.failMsg();
        }
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/getWorkflowInfoByTaskId"})
    @ResponseBody
    public ZKResultMsg getWorkflowInfoByTaskId(@RequestBody ZKMessage zkMessage) {
        String taskId = MapUtils.getString((Map)zkMessage.getContent(), (Object)"taskId");
        try {
            AttApiApplyTaskDetailItem item = this.attWorkflowService.findByTaskId(taskId);
            return new ZKResultMsg((Object)JSONObject.toJSONString((Object)item));
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return ZKResultMsg.failMsg((String)e.getMessage(), (Object[])new Object[0]);
            }
            return ZKResultMsg.failMsg();
        }
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/findPersonalTask"})
    @ResponseBody
    public ZKResultMsg findPersonalTask(@RequestBody ZKMessage zkMessage) {
        String personPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"personPin");
        String flowType = MapUtils.getString((Map)zkMessage.getContent(), (Object)"flowType");
        Integer pageNo = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"pageNo");
        Integer pageSize = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"pageSize");
        Pager pager = this.attWorkflowService.findPersonalTask(personPin, flowType, pageNo, pageSize);
        return new ZKResultMsg((Object)pager);
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/findApprovedTask"})
    @ResponseBody
    public ZKResultMsg findApprovedTask(@RequestBody ZKMessage zkMessage) {
        String personPin = MapUtils.getString((Map)zkMessage.getContent(), (Object)"personPin");
        String flowType = MapUtils.getString((Map)zkMessage.getContent(), (Object)"flowType");
        Integer pageNo = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"pageNo");
        Integer pageSize = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"pageSize");
        Pager pager = this.attWorkflowService.findApprovedTask(personPin, flowType, pageNo, pageSize);
        return new ZKResultMsg((Object)pager);
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/completeTask"})
    @ResponseBody
    public ZKResultMsg completeTask(@RequestBody ZKMessage zkMessage) {
        Map content = zkMessage.getContent();
        String personPin = MapUtils.getString((Map)content, (Object)"personPin");
        String taskId = MapUtils.getString((Map)content, (Object)"taskId");
        String approve = MapUtils.getString((Map)content, (Object)"approve");
        String comment = MapUtils.getString((Map)content, (Object)"comment");
        String notifierPins = MapUtils.getString((Map)content, (Object)"notifierPins");
        this.attWorkflowService.completeTask(personPin, taskId, approve, comment, notifierPins);
        return ZKResultMsg.successMsg();
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/getPersonMonthSignCount"})
    @ResponseBody
    public ZKResultMsg getPersonMonthSignCount(@RequestBody ZKMessage zkMessage) {
        Map content = zkMessage.getContent();
        String personPin = MapUtils.getString((Map)content, (Object)"personPin");
        String month = MapUtils.getString((Map)content, (Object)"attDate");
        Integer count = this.attWorkflowService.getPersonMonthSignCount(personPin, month);
        return new ZKResultMsg((Object)count);
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/saveSignItem"})
    @ResponseBody
    public ZKResultMsg saveSignItem(@RequestBody ZKMessage zkMessage) {
        try {
            List attSignItemList = JSONArray.parseArray((String)zkMessage.getListContent().toString(), AttCloudSignItem.class);
            this.attWorkflowService.saveSignItem(attSignItemList);
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)e.getMessage()));
            }
            return ZKResultMsg.failMsg();
        }
        return ZKResultMsg.successMsg();
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/saveLeaveItem"})
    @ResponseBody
    public ZKResultMsg saveLeaveItem(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg res = null;
        try {
            List attLeaveItemList = JSONArray.parseArray((String)zkMessage.getListContent().toString(), AttLeaveItem.class);
            AttLeaveItem attLeaveItem = (AttLeaveItem)attLeaveItemList.get(0);
            res = this.attWorkflowService.isExistApply(attLeaveItem.getPersonPin(), attLeaveItem.getStartDatetime(), attLeaveItem.getEndDatetime());
            if (res.isSuccess()) {
                this.attWorkflowService.saveLeaveItem(attLeaveItemList);
            }
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)e.getMessage()));
            }
            return ZKResultMsg.failMsg();
        }
        return res;
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/saveOvertimeItem"})
    @ResponseBody
    public ZKResultMsg saveOvertimeItem(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg res = null;
        try {
            List attOvertimeItemList = JSONArray.parseArray((String)zkMessage.getListContent().toString(), AttOvertimeItem.class);
            AttOvertimeItem attOvertimeItem = (AttOvertimeItem)attOvertimeItemList.get(0);
            res = this.attWorkflowService.isExistApply(attOvertimeItem.getPersonPin(), attOvertimeItem.getStartDatetime(), attOvertimeItem.getEndDatetime());
            if (res.isSuccess()) {
                this.attWorkflowService.saveOvertimeItem(attOvertimeItemList);
            }
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)e.getMessage()));
            }
            return ZKResultMsg.failMsg();
        }
        return res;
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/saveTripItem"})
    @ResponseBody
    public ZKResultMsg saveTripItem(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg res = null;
        try {
            List attTripItemList = JSONArray.parseArray((String)zkMessage.getListContent().toString(), AttTripItem.class);
            AttTripItem attTripItem = (AttTripItem)attTripItemList.get(0);
            res = this.attWorkflowService.isExistApply(attTripItem.getPersonPin(), attTripItem.getStartDatetime(), attTripItem.getEndDatetime());
            if (res.isSuccess()) {
                this.attWorkflowService.saveTripItem(attTripItemList);
            }
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)e.getMessage()));
            }
            return ZKResultMsg.failMsg();
        }
        return res;
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/saveOutItem"})
    @ResponseBody
    public ZKResultMsg saveOutItem(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg res = null;
        try {
            List attOutItemList = JSONArray.parseArray((String)zkMessage.getListContent().toString(), AttOutItem.class);
            AttOutItem attOutItem = (AttOutItem)attOutItemList.get(0);
            res = this.attWorkflowService.isExistApply(attOutItem.getPersonPin(), attOutItem.getStartDatetime(), attOutItem.getEndDatetime());
            if (res.isSuccess()) {
                this.attWorkflowService.saveOutItem(attOutItemList);
            }
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)e.getMessage()));
            }
            return ZKResultMsg.failMsg();
        }
        return res;
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/revokeProcess"})
    @ResponseBody
    public ZKResultMsg revokeProcess(@RequestBody ZKMessage zkMessage) {
        try {
            Map content = zkMessage.getContent();
            String businessKey = MapUtils.getString((Map)content, (Object)"businessKey");
            String personPin = MapUtils.getString((Map)content, (Object)"personPin");
            String revokeReason = MapUtils.getString((Map)content, (Object)"revokeReason");
            return I18nUtil.i18nMsg((ZKResultMsg)this.attWorkflowService.revokeProcess(businessKey, personPin, revokeReason));
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)e.getMessage()));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/getAttApplyTimeLong"})
    @ResponseBody
    public ZKResultMsg getAttApplyTimeLong(@RequestBody ZKMessage zkMessage) {
        try {
            Map content = zkMessage.getContent();
            String personPin = MapUtils.getString((Map)content, (Object)"personPin");
            String startTime = MapUtils.getString((Map)content, (Object)"startTime");
            String endTime = MapUtils.getString((Map)content, (Object)"endTime");
            String timeLong = this.attWorkflowService.calcApplyTimeLong(personPin, startTime, endTime);
            return new ZKResultMsg((Object)timeLong);
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)e.getMessage()));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
    }

    @ApiPermissions(moduleCode="att", moduleName="att_module")
    @RequestMapping(value={"/checkApplyAndWorkTimeValid"})
    @ResponseBody
    public ZKResultMsg checkApplyAndWorkTimeValid(@RequestBody ZKMessage zkMessage) {
        try {
            Map content = zkMessage.getContent();
            String personPin = MapUtils.getString((Map)content, (Object)"personPin");
            String flowType = MapUtils.getString((Map)content, (Object)"flowType");
            String startTime = MapUtils.getString((Map)content, (Object)"startTime");
            String endTime = MapUtils.getString((Map)content, (Object)"endTime");
            return this.attWorkflowService.checkApplyAndWorkTimeValid(personPin, flowType, startTime, endTime);
        }
        catch (Exception e) {
            if (e instanceof ZKBusinessException) {
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)e.getMessage()));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
    }
}

