/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.service.impl;

import com.zkteco.zkbiosecurity.adms.bean.SdkResult;
import com.zkteco.zkbiosecurity.adms.service.AdmsSdkService;
import com.zkteco.zkbiosecurity.base.utils.SystemOsUtil;
import com.zkteco.zkbiosecurity.dll.LibraryService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import zk.jni.JavaToAdmsPullSDK;

@Component
@Order(value=131)
public class AdmsSdkServiceImpl
implements AdmsSdkService,
CommandLineRunner {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private static int LOADLIBRARY_FAILURE = -126;
    @Resource
    private LibraryService libraryService;

    public void run(String ... args) throws Exception {
        if (SystemOsUtil.isWindow()) {
            this.libraryService.loadLibrary("libareacode");
            this.libraryService.loadLibrary("ZKCommuCryptoClient");
            this.libraryService.loadLibrary("plcomms");
            this.libraryService.loadLibrary("plrscagent");
            this.libraryService.loadLibrary("plrscomm");
            this.libraryService.loadLibrary("pltcpcomm");
            this.libraryService.loadLibrary("plusbcomm");
            this.libraryService.loadLibrary("plcommpro");
        }
    }

    public SdkResult connect(String connectParam) {
        SdkResult sdkResult = new SdkResult();
        try {
            long result = JavaToAdmsPullSDK.Connect(connectParam);
            if (result > 0L) {
                sdkResult.setResult(result);
                sdkResult.setData(result + "");
            } else {
                long error = this.pullLastError().getResult();
                if (error >= 0L) {
                    sdkResult.setResult(0L - error);
                    sdkResult.setData(0L - error + "");
                }
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            sdkResult.setData(LOADLIBRARY_FAILURE + "");
        }
        return sdkResult;
    }

    public SdkResult connectExt(String connectParam, int[] callbackResult) {
        SdkResult sdkResult = new SdkResult();
        try {
            long result = JavaToAdmsPullSDK.ConnectExt(connectParam, callbackResult);
            if (result <= 0L) {
                sdkResult.setResult((long)callbackResult[0]);
                sdkResult.setData(callbackResult[0] + "");
            } else {
                sdkResult.setResult(result);
                sdkResult.setData(result + "");
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            sdkResult.setData(LOADLIBRARY_FAILURE + "");
        }
        return sdkResult;
    }

    public SdkResult disconnect(long hCommPro) {
        SdkResult sdkResult = new SdkResult();
        try {
            if (hCommPro > 0L) {
                int result = JavaToAdmsPullSDK.Disconnect(hCommPro);
                sdkResult.setResult((long)result);
                sdkResult.setData(result + "");
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            sdkResult.setData(LOADLIBRARY_FAILURE + "");
        }
        return sdkResult;
    }

    public SdkResult setDeviceParam(long hCommPro, String items) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.SetDeviceParam(hCommPro, items);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getDeviceParam(long hCommPro, byte[] callbackResult, String items) {
        SdkResult sdkResult = new SdkResult();
        try {
            String[] itemArray = items.split(",");
            ArrayList<String> itemList = new ArrayList<String>();
            if (itemArray.length > 25) {
                StringBuffer strBuf = new StringBuffer();
                for (int i = 0; i < itemArray.length; ++i) {
                    strBuf.append(itemArray[i] + ",");
                    if (i == 0 || i % 25 != 0) continue;
                    itemList.add(strBuf.toString().substring(0, strBuf.length() - 1));
                    strBuf = new StringBuffer();
                }
                if (strBuf.length() > 0) {
                    itemList.add(strBuf.toString().substring(0, strBuf.length() - 1));
                }
            } else {
                itemList.add(items);
            }
            int result = -1;
            for (String item : itemList) {
                result = JavaToAdmsPullSDK.GetDeviceParam(hCommPro, callbackResult, item);
                if (result < 0) continue;
                sdkResult.setData(StringUtils.isNotBlank((CharSequence)sdkResult.getData()) ? sdkResult.getData() + "," + new String(callbackResult).trim() : new String(callbackResult).trim());
                sdkResult.setResult((long)result);
                sdkResult.setSuccess(true);
            }
            if (StringUtils.isBlank((CharSequence)sdkResult.getData())) {
                sdkResult.setData("");
                sdkResult.setResult((long)result);
                sdkResult.setSuccess(true);
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult controlDevice(long hCommPro, int operationID, int param1, int param2, int param3, int param4, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.ControlDevice(hCommPro, operationID, param1, param2, param3, param4, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
            sdkResult.setSuccess(true);
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult setDeviceData(long hCommPro, String tableName, String data, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.SetDeviceData(hCommPro, tableName, data, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getDeviceData(long hCommPro, byte[] callbackResult, String tableName, String fieldNames, String filter, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetDeviceData(hCommPro, callbackResult, tableName, fieldNames, filter, options);
            sdkResult.setResult((long)result);
            sdkResult.setData(new String(callbackResult, "UTF-8").trim());
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getDeviceDataCount(long hCommPro, String tableName, String filter, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetDeviceDataCount(hCommPro, tableName, filter, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult deleteDeviceData(long hCommPro, String tableName, String data, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.DeleteDeviceData(hCommPro, tableName, data, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getRTLog(long hCommPro, byte[] callbackResult) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetRTLog(hCommPro, callbackResult);
            sdkResult.setResult((long)result);
            if (result >= 0) {
                sdkResult.setData(new String(callbackResult).trim());
            } else {
                sdkResult.setData("");
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getRTLogExt(long hCommPro, byte[] callbackResult) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetRTLogExt(hCommPro, callbackResult);
            sdkResult.setResult((long)result);
            if (result >= 0) {
                sdkResult.setData(new String(callbackResult).trim());
            } else {
                sdkResult.setData("");
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult searchDevice() {
        int bufferSize = 0x100000;
        byte[] callbackResult = new byte[bufferSize];
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.SearchDevice("UDP", "255.255.255.255", callbackResult);
            sdkResult.setResult((long)result);
            if (result > 0) {
                sdkResult.setData(new String(callbackResult).trim());
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult modifyIPAddress(String buffer) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.ModifyIPAddress("UDP", "255.255.255.255", buffer);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult pullLastError() {
        SdkResult sdkResult = new SdkResult();
        try {
            sdkResult.setResult((long)JavaToAdmsPullSDK.PullLastError());
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult setDeviceFileData(long hCommPro, String fileName, String buffer, int bufferSize, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.SetDeviceFileData(hCommPro, fileName, buffer, bufferSize, options);
            sdkResult.setResult((long)result);
            sdkResult.setData("");
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult getDeviceFileData(long hCommPro, byte[] callbackResult, String fileName, String options) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.GetDeviceFileData(hCommPro, callbackResult, fileName, options);
            sdkResult.setResult((long)result);
            if (result >= 0) {
                sdkResult.setData(new String(callbackResult).trim());
            } else {
                sdkResult.setData("");
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult processBackupData(byte[] revBuf, int fileLen, byte[] callbackResult, int outSize) {
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.ProcessBackupData(revBuf, fileLen, callbackResult, outSize);
            sdkResult.setResult((long)result);
            if (result >= 0) {
                sdkResult.setData(new String(callbackResult).trim());
            } else {
                sdkResult.setData("");
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }

    public SdkResult searchDeviceEx(String paramItems) {
        int bufferSize = 0x100000;
        byte[] callbackResult = new byte[bufferSize];
        SdkResult sdkResult = new SdkResult();
        try {
            int result = JavaToAdmsPullSDK.SearchDeviceEx("UDP", "255.255.255.255", paramItems, callbackResult);
            sdkResult.setResult((long)result);
            if (result > 0) {
                sdkResult.setData(new String(callbackResult).trim());
            }
        }
        catch (Error e) {
            sdkResult.setResult((long)LOADLIBRARY_FAILURE);
            this.log.error("error", (Throwable)e);
        }
        return sdkResult;
    }
}

