/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.remote.PosSystemParamRemote;
import com.zkteco.zkbiosecurity.pos.service.PosSystemParamService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosSystemParamController
extends BaseController
implements PosSystemParamRemote {
    @Autowired
    private PosSystemParamService posSystemParamService;

    @RequiresPermissions(value={"pos:systemParam"})
    public ModelAndView index() {
        Map posParams = this.posSystemParamService.getPosParams();
        this.request.setAttribute("posParams", (Object)posParams);
        return new ModelAndView("pos/systemParam/posSystemParam");
    }

    @RequiresPermissions(value={"pos:systemParam:edit"})
    @LogRequest(module="pos_module", object="pos_systemParam", opType="common_leftMenu_paramSet", opContent="common_leftMenu_paramSet")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        String modify = this.posSystemParamService.getValByName("pos.toModify");
        if ("false".equals(modify)) {
            modify = this.posSystemParamService.isChangeModify();
        }
        if ("true".equals(modify) || this.posSystemParamService.checkUpdate(params)) {
            this.posSystemParamService.saveItem(params);
        } else {
            res = ZKResultMsg.failMsg((String)"pos_system_cannotUpdate", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pos:systemParam"})
    public ZKResultMsg getParams() {
        ZKResultMsg res = new ZKResultMsg((Object)this.posSystemParamService.getPosParams());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getSectionList(String sector) {
        return new ZKResultMsg((Object)this.posSystemParamService.getSectionList(sector));
    }
}

