/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.monitor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.service.PsgPadMonitorRedirectService;
import com.zkteco.zkbiosecurity.psg.service.PsgPadService;
import com.zkteco.zkbiosecurity.psg.utils.PsgEnumUtil;
import com.zkteco.zkbiosecurity.psg.vo.PsgGateItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgTransactionItem;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PsgPadMonitorRedirectServiceImpl
implements PsgPadMonitorRedirectService {
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private PsgPadService psgPadService;

    public void sendPsgTransaction2RTMonitor(PsgTransactionItem psgTransactionItem) {
        JSONArray rows = new JSONArray();
        JSONObject row = new JSONObject();
        row.put("eventTime", (Object)DateUtil.dateToString((Date)psgTransactionItem.getEventTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        row.put("areaName", (Object)psgTransactionItem.getAreaName());
        row.put("devName", (Object)(psgTransactionItem.getDevAlias() != null ? psgTransactionItem.getDevAlias() + "(" + psgTransactionItem.getDevSn() + ")" : ""));
        row.put("eventName", (Object)I18nUtil.i18nCode((String)psgTransactionItem.getEventName(), (Object[])new Object[0]));
        int eventLevel = 0;
        if (psgTransactionItem.getEventNo() >= 20 && psgTransactionItem.getEventNo() <= 99) {
            eventLevel = 1;
        } else if (psgTransactionItem.getEventNo() >= 100 && psgTransactionItem.getEventNo() <= 199) {
            eventLevel = 2;
        }
        row.put("eventLevel", (Object)((short)eventLevel));
        rows.add((Object)row);
        this.messagingTemplate.convertAndSend((Object)"/topic/psgPad/getEventData", (Object)rows);
    }

    public void sendDeviceGateState2RTMonitor(List<PsgGateItem> psgGateItemList) {
        JSONObject data = new JSONObject();
        JSONArray gateStates = new JSONArray();
        JSONObject dev = null;
        JSONArray stateArray = this.psgPadService.getGateStateByItems(psgGateItemList);
        if (Objects.nonNull(stateArray) && stateArray.size() > 0) {
            for (int i = 0; i < stateArray.size(); ++i) {
                JSONObject gate = stateArray.getJSONObject(i);
                dev = this.putGateDataToMonitor(gate);
                gateStates.add((Object)dev);
            }
            data.put("gateStates", (Object)gateStates);
            int count = this.psgPadService.countAllGateInCount(psgGateItemList.get(0).getAuthAreaId());
            data.put("counter", (Object)count);
        }
        this.messagingTemplate.convertAndSend((Object)"/topic/psgPad/getDevState", (Object)data);
    }

    public void sendDeviceIrStates2RTMonitor(List<PsgGateItem> psgGateItemList) {
        JSONObject data = new JSONObject();
        JSONArray irStates = new JSONArray();
        JSONArray irStatesArray = this.psgPadService.getIrStatesByItems(psgGateItemList);
        if (Objects.nonNull(irStatesArray) && irStatesArray.size() > 0) {
            for (int i = 0; i < irStatesArray.size(); ++i) {
                JSONObject gate = irStatesArray.getJSONObject(i);
                irStates.add((Object)gate);
            }
            data.put("irStates", (Object)irStates);
        }
        this.messagingTemplate.convertAndSend((Object)"/topic/psgPad/getIrStates", (Object)data);
    }

    private JSONObject putGateDataToMonitor(JSONObject gate) {
        JSONObject data = new JSONObject();
        int alarm = gate.getIntValue("alarm");
        data.put("id", (Object)gate.getString("id"));
        data.put("name", (Object)gate.getString("name"));
        data.put("gateType", (Object)gate.getString("gateType"));
        data.put("relay", (Object)gate.getIntValue("relay"));
        data.put("alarm", (Object)PsgEnumUtil.GateImage.getAlarmState(alarm));
        data.put("gateState", (Object)gate.getIntValue("gateState"));
        data.put("connect", (Object)gate.getIntValue("connect"));
        data.put("passMode", (Object)gate.getIntValue("passMode"));
        data.put("inCount", Objects.nonNull(gate.get((Object)"inCount")) ? gate.get((Object)"inCount") : Integer.valueOf(0));
        data.put("outCount", Objects.nonNull(gate.get((Object)"outCount")) ? gate.get((Object)"outCount") : Integer.valueOf(0));
        data.put("alarmCount", Objects.nonNull(gate.get((Object)"alarmCount")) ? gate.get((Object)"alarmCount") : Integer.valueOf(0));
        return data;
    }
}

