/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_CERTIFICATE t LEFT JOIN PERS_PERSON p ON t.PERSON_ID=p.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="edit", permission="pers:certificate:edit", url="/persCertificate.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="pers:certificate:del", url="/persCertificate.do?del", label="common_op_del")})
public class PersCertificateItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="p.ID", equalTag="=")
    private String personId;
    @Column(name="p.PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String pin;
    @Column(name="p.NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String name;
    @Column(name="p.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'")
    private String lastName;
    @Column(name="t.CERT_TYPE")
    @GridColumn(label="pers_certificate_certType")
    private String certType;
    @Column(name="t.CERT_NUMBER")
    @GridColumn(label="pers_certificate_certNumber")
    private String certNumber;
    @Column(name="t.CERT_STATUS")
    @GridColumn(label="pers_certificate_certStatus")
    private Short certStatus;
    @Condition(value="p.ID", equalTag="<>")
    private String personIdNe;
    @Column(name="t.CERT_TYPE")
    @GridColumn(columnType="dic", key="certificateType", label="vis_cert_type")
    private String certName;

    public PersCertificateItem() {
    }

    public PersCertificateItem(Boolean equals) {
        super(equals);
    }

    public PersCertificateItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PersCertificateItem(String id, String certType, String certNumber, Short certStatus) {
        this.id = id;
        this.certType = certType;
        this.certNumber = certNumber;
        this.certStatus = certStatus;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public Short getCertStatus() {
        return this.certStatus;
    }

    public String getPersonIdNe() {
        return this.personIdNe;
    }

    public String getCertName() {
        return this.certName;
    }

    public PersCertificateItem setId(String id) {
        this.id = id;
        return this;
    }

    public PersCertificateItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PersCertificateItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public PersCertificateItem setName(String name) {
        this.name = name;
        return this;
    }

    public PersCertificateItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PersCertificateItem setCertType(String certType) {
        this.certType = certType;
        return this;
    }

    public PersCertificateItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public PersCertificateItem setCertStatus(Short certStatus) {
        this.certStatus = certStatus;
        return this;
    }

    public PersCertificateItem setPersonIdNe(String personIdNe) {
        this.personIdNe = personIdNe;
        return this;
    }

    public PersCertificateItem setCertName(String certName) {
        this.certName = certName;
        return this;
    }

    public String toString() {
        return "PersCertificateItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", pin=" + this.getPin() + ", name=" + this.getName() + ", lastName=" + this.getLastName() + ", certType=" + this.getCertType() + ", certNumber=" + this.getCertNumber() + ", certStatus=" + this.getCertStatus() + ", personIdNe=" + this.getPersonIdNe() + ", certName=" + this.getCertName() + ")";
    }
}

