/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.vo;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PersAttributeRuleItem {
    private String name;
    private int rowIndex;
    private int colIndex;
    private boolean primaryKey = false;
    private boolean uniqueKey = false;
    private boolean empty = true;
    private String regex;
    private String split;

    public PersAttributeRuleItem() {
    }

    public PersAttributeRuleItem(String name) {
        this.name = name;
    }

    public PersAttributeRuleItem(String name, boolean primaryKey, boolean uniqueKey, boolean empty) {
        this.name = name;
        this.primaryKey = primaryKey;
        this.uniqueKey = uniqueKey;
        this.empty = empty;
    }

    public PersAttributeRuleItem(String name, boolean primaryKey, boolean uniqueKey, boolean empty, int colIndex) {
        this.name = name;
        this.primaryKey = primaryKey;
        this.uniqueKey = uniqueKey;
        this.empty = empty;
        this.colIndex = colIndex;
    }

    public PersAttributeRuleItem(String text, int rowIndex, int colIndex) throws Exception {
        Pattern compile = Pattern.compile("\\(([a-zA-Z]+(\\.[0-9a-zA-Z]+)?(,[0-9a-zA-Z]+)*?)\\)");
        Matcher matcher = compile.matcher(text);
        if (matcher.find()) {
            String group = matcher.group(1);
            String[] split = group.split(",");
            this.name = split[0];
            if (split.length > 1) {
                this.primaryKey = Boolean.valueOf(split[1]);
            }
            if (split.length > 2) {
                this.uniqueKey = Boolean.valueOf(split[2]);
            }
            if (split.length > 3) {
                this.empty = Boolean.valueOf(split[3]);
            }
        } else {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"pers_import_commentFormat", (Object[])new Object[0]));
        }
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(int colIndex) {
        this.colIndex = colIndex;
    }

    public boolean getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean getUniqueKey() {
        return this.uniqueKey;
    }

    public void setUniqueKey(boolean uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public boolean getEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getSplit() {
        return this.split;
    }

    public void setSplit(String split) {
        this.split = split;
    }
}

