/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.web.converter;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Optional;
import org.springframework.core.convert.converter.Converter;

public class StringToTimeConverter
implements Converter<String, Time> {
    private static final String timeFormat = "HH:mm";

    public Time convert(String source) {
        return Optional.ofNullable(source).map(s -> {
            SimpleDateFormat sdf = new SimpleDateFormat(timeFormat);
            try {
                return sdf.parse((String)s);
            }
            catch (ParseException e) {
                return null;
            }
        }).map(date -> new Time(date.getTime())).orElse(null);
    }
}

