/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.sdkClient.ParkSDKTasks;
import com.zkteco.zkbiosecurity.park.service.ParkCacheService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.websocketService.ChannelService;
import com.zkteco.zkbiosecurity.park.websocketService.sendToCS.ParkCSPavilioMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ParkDefaultTask
implements ParkSDKTasks {
    private static final Logger log = LoggerFactory.getLogger(ParkDefaultTask.class);
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkCacheService parkCacheService;
    @Autowired
    private ParkCSPavilioMsg parkCSPavilioMsg;
    @Autowired
    private ChannelService channelService;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private ParkWebsocketService parkWebsocketService;

    @Override
    @Async(value="parkAsyncTaskExecutor")
    public void doTask(JSONObject json) {
        String opType;
        String key = "park:ws_msgid_";
        String dataStr = "";
        JSONObject dataObj = new JSONObject();
        JSONObject msgJson = null;
        String msgId = json.getString("MsgId");
        switch (opType = json.getString("OpType")) {
            case "OnDeviceFound": {
                this.receiveDevInfo(json);
                break;
            }
            case "OpenDevice": {
                this.updateDevInfo(json);
                break;
            }
            case "GetDeviceData": 
            case "GetOfflineParam": 
            case "ExportPlateListExt": 
            case "ExportPlateList": {
                msgJson = this.generateJsonObj(json);
                dataStr = json.getString("Data");
                if (ParkWebCommonUtil.isNotNull(dataStr)) {
                    dataObj = JSONObject.parseObject((String)Base64Util.getFromBase64((String)dataStr));
                }
                msgJson.put("Data", (Object)dataObj);
                this.parkCacheService.setJson(key + msgId, msgJson, 1200L);
                break;
            }
            case "GetDeviceFunList": {
                msgJson = this.generateJsonObj(json);
                dataStr = json.getString("Data");
                msgJson.put("Data", (Object)dataStr);
                this.parkCacheService.setJson(key + msgId, msgJson, 1200L);
                break;
            }
            default: {
                msgJson = this.generateJsonObj(json);
                if (ParkWebCommonUtil.isNotNull(json.getString("Data"))) {
                    dataObj = json.getJSONObject("Data");
                    msgJson.put("Data", (Object)dataObj);
                } else {
                    msgJson.put("Data", (Object)"");
                }
                this.parkCacheService.setJson(key + msgId, msgJson, 600L);
            }
        }
    }

    private JSONObject generateJsonObj(JSONObject json) {
        JSONObject msgJson = new JSONObject();
        String ret = json.getString("Ret");
        String opType = json.getString("OpType");
        msgJson.put("Ret", (Object)ret);
        msgJson.put("OpType", (Object)opType);
        return msgJson;
    }

    private void receiveDevInfo(JSONObject msgObj) {
        log.info("PARK_Device == OnDeviceFound msgObj = " + msgObj.toString());
        JSONObject data = msgObj.getJSONObject("Data");
        String ipAddr = data.getString("IP");
        ParkDeviceItem item = this.parkDeviceService.getByIpAddress(ipAddr);
        if (ParkWebCommonUtil.isNull(item)) {
            String code = data.getString("DeviceType");
            ParkCheckOutInfo cheOutInfo = new ParkCheckOutInfo();
            cheOutInfo.setMsgType("search");
            cheOutInfo.setDevName(data.getString("DeviceName"));
            cheOutInfo.setVendorsType(code);
            try {
                cheOutInfo.setLprDeviceType(Short.valueOf(data.getString("LprDevType")));
            }
            catch (Exception e) {
                cheOutInfo.setLprDeviceType(Short.valueOf("0"));
                e.printStackTrace();
            }
            cheOutInfo.setMsgInfo(code);
            cheOutInfo.setIpAddress(ipAddr);
            cheOutInfo.setPort(Long.valueOf(data.getString("PortListen")).longValue());
            cheOutInfo.setSn("");
            String comm = this.parkCSPavilioMsg.sendMsgToPavilio("search", cheOutInfo);
            this.channelService.groupPush(comm);
            this.messagingTemplate.convertAndSend((Object)"/topic/parkDevice/message", (Object)comm);
        }
    }

    private void updateDevInfo(JSONObject msgObj) {
        log.info("PARK_DEVICE == OpenDevice msgObj = " + msgObj.toString());
        String msgId = msgObj.getString("MsgId");
        String handle = msgObj.getString("Ret");
        String devIp = msgObj.getJSONObject("Data").getString("IpAddr");
        JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
        if (ParkWebCommonUtil.isNotNull(devObj) && Long.valueOf(handle) != 0L) {
            JSONObject data = msgObj.getJSONObject("Data");
            long serialHand = data.getLong("Serialhandle");
            devObj.put("serialHand", (Object)serialHand);
            devObj.put("handle", (Object)handle);
            devObj.put("state", (Object)"onLine");
            log.info("PARK_DEVICE == OpenDevice Update DevInfo Update Redis = " + devObj.toString());
            this.parkCacheService.setJson("park:dev_info_" + devObj.getString("ipAddr"), devObj, 0L);
            this.parkCacheService.set("park:dev_handle_" + handle, (Object)devObj.getString("ipAddr"), 0L);
            this.parkCacheService.set("park:view_defa_content_" + handle, (Object)"0", 0L);
            this.parkCacheService.setJson("park:ws_msgid_" + msgId, msgObj, 600L);
            this.parkDeviceService.startSaveOfflineRecordThread(devObj.getString("ipAddr"));
        } else {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.parkWebsocketService.reconnDevice(devIp);
        }
    }

    private JSONObject getDevObjByMsgId(String msgId) {
        String devIpStr = this.parkCacheService.getStr("park:alldev_ip");
        if (ParkWebCommonUtil.isNotNull(devIpStr)) {
            String[] devIpAry;
            for (String devIp : devIpAry = devIpStr.split(",")) {
                JSONObject devObj = this.parkCacheService.getJson("park:dev_info_" + devIp);
                if (!ParkWebCommonUtil.isNotNull(devObj) || !msgId.equals(devObj.getString("msgId"))) continue;
                return devObj;
            }
        }
        return null;
    }

    @Override
    public boolean match(JSONObject json) {
        return true;
    }

    @Override
    public long order() {
        return Long.valueOf("40");
    }
}

