/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;
import java.util.Date;

@From(after="VIS_RESERVATION t LEFT JOIN VIS_VISITOR v ON t.VISITOR_ID=v.id")
@Where(after="AND (t.IS_FROM='h5_web' OR t.IS_FROM = 'VIS_COULD_APP')")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=false, idField="id", winHeight=420, winWidth=420)
public class VisReservationAuditItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.VISIT_EMP_PIN")
    @GridColumn(label="vis_record_visitedPin", width="100", columnType="edit", editPermission="vis:reservation:edit", editUrl="visReservation.do?edit")
    private String visitEmpPin;
    @Column(name="t.VISIT_EMP_NAME")
    @GridColumn(label="vis_record_visitedName", width="100")
    private String visitEmpName;
    @Column(name="t.VISIT_EMP_LAST_NAME")
    @GridColumn(label="vis_record_visitedLastName", width="100", showExpression="#language!='zh_CN'")
    private String visitEmpLastName;
    @Column(name="t.VISIT_EMP_DEPT_NAME")
    @GridColumn(label="vis_common_visitedDept", width="120")
    private String visitEmpDeptName;
    private String visitEmpDeptCode;
    @Column(name="v.NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String visitorName;
    @Column(name="v.LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'")
    private String visitorLastName;
    @Column(name="v.CERT_TYPE")
    private String certType;
    @Column(name="v.CERT_TYPE")
    @GridColumn(columnType="dic", key="certificateType", label="vis_cert_type", width="120")
    private String certName;
    @Column(name="v.CERT_NUMBER")
    @GridColumn(label="vis_cert_number", width="150")
    private String certNumber;
    @Column(name="v.PHONE")
    @GridColumn(label="vis_export_mobilePhone", width="120")
    private String phone;
    @Column(name="v.COMPANY")
    @GridColumn(label="vis_common_company", width="120")
    private String company;
    @Column(name="t.AUDIT_STATUS")
    @GridColumn(label="vis_reservation_auditStatus", format="0=vis_reservation_notAudit,1=vis_reservation_yesAudit")
    private Short auditStatus;
    @Column(name="t.VISIT_REASON")
    @GridColumn(label="vis_reason_name", width="100")
    private String visitReason;
    @Column(name="t.VISIT_DATE")
    @DateType(type="date")
    @GridColumn(label="vis_common_date", width="120")
    private Date visitDate;
    @Column(name="t.IS_VISITED")
    @GridColumn(label="vis_emp_status", width="90", format="0=vis_reservation_hasVisited,1=vis_reservation_notVisited,2=vis_reservation_waste")
    private String isVisited;
    @Column(name="t.CREATER_NAME")
    private String createrName;
    @Column(name="t.VISIT_EMP_DEPT_ID")
    private String visitEmpDeptId;
    @Column(name="t.VISIT_EMP_ID")
    private String visitedEmpId;
    @Column(name="t.REMARK")
    private String remark;
    @Column(name="t.VISIT_NUMBER")
    private String visitNumber;
    @Column(name="t.CHANGE_OPERATOR")
    private String changeOperator;
    @Column(name="t.CHANGE_TIME")
    private Date changeTime;
    @Column(name="t.LEVEL_IDS")
    private String levelIds;
    @Column(name="v.CAR_PLATE")
    private String carPlate;
    @Column(name="v.PARK_BLACKWHITE_ID")
    private String parkBlackWhiteId;
    @Column(name="v.ID")
    private String visitorId;
    @Column(name="v.PIN")
    private String visitorPin;
    @Column(name="v.ENABLED")
    private Boolean enabled;
    @Condition(value="t.VISIT_DATE", equalTag=">=")
    private Date startDate;
    @Condition(value="t.VISIT_DATE", equalTag="<=")
    private Date endDate;
    @Column(name="t.VISITOR_COUNT")
    private Integer visitorCount;
    @Column(name="t.VISIT_END_DATE")
    private String visitEndDate;
    @Column(name="t.PHOTO_PATH")
    private String photoPath;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.APP_ID", equalTag="in")
    private String inAppId;
    @Condition(value="(LOWER (v.NAME) LIKE LOWER (''%{0}%'') OR LOWER (v.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="(LOWER (t.VISIT_EMP_NAME) LIKE LOWER (''%{0}%'') OR LOWER (t.VISIT_EMP_LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String visitedLikeName;

    public VisReservationAuditItem() {
    }

    public VisReservationAuditItem(String id) {
        this.id = id;
    }

    public VisReservationAuditItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisReservationAuditItem setVisitEmpPin(String visitEmpPin) {
        this.visitEmpPin = visitEmpPin;
        return this;
    }

    public VisReservationAuditItem setVisitEmpName(String visitEmpName) {
        this.visitEmpName = visitEmpName;
        return this;
    }

    public VisReservationAuditItem setVisitEmpLastName(String visitEmpLastName) {
        this.visitEmpLastName = visitEmpLastName;
        return this;
    }

    public VisReservationAuditItem setVisitEmpDeptName(String visitEmpDeptName) {
        this.visitEmpDeptName = visitEmpDeptName;
        return this;
    }

    public VisReservationAuditItem setVisitEmpDeptCode(String visitEmpDeptCode) {
        this.visitEmpDeptCode = visitEmpDeptCode;
        return this;
    }

    public VisReservationAuditItem setVisitorName(String visitorName) {
        this.visitorName = visitorName;
        return this;
    }

    public VisReservationAuditItem setVisitorLastName(String visitorLastName) {
        this.visitorLastName = visitorLastName;
        return this;
    }

    public VisReservationAuditItem setCertType(String certType) {
        this.certType = certType;
        return this;
    }

    public VisReservationAuditItem setCertName(String certName) {
        this.certName = certName;
        return this;
    }

    public VisReservationAuditItem setCertNumber(String certNumber) {
        this.certNumber = certNumber;
        return this;
    }

    public VisReservationAuditItem setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public VisReservationAuditItem setCompany(String company) {
        this.company = company;
        return this;
    }

    public VisReservationAuditItem setAuditStatus(Short auditStatus) {
        this.auditStatus = auditStatus;
        return this;
    }

    public VisReservationAuditItem setVisitReason(String visitReason) {
        this.visitReason = visitReason;
        return this;
    }

    public VisReservationAuditItem setVisitDate(Date visitDate) {
        this.visitDate = visitDate;
        return this;
    }

    public VisReservationAuditItem setIsVisited(String isVisited) {
        this.isVisited = isVisited;
        return this;
    }

    public VisReservationAuditItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public VisReservationAuditItem setVisitEmpDeptId(String visitEmpDeptId) {
        this.visitEmpDeptId = visitEmpDeptId;
        return this;
    }

    public VisReservationAuditItem setVisitedEmpId(String visitedEmpId) {
        this.visitedEmpId = visitedEmpId;
        return this;
    }

    public VisReservationAuditItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public VisReservationAuditItem setVisitNumber(String visitNumber) {
        this.visitNumber = visitNumber;
        return this;
    }

    public VisReservationAuditItem setChangeOperator(String changeOperator) {
        this.changeOperator = changeOperator;
        return this;
    }

    public VisReservationAuditItem setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
        return this;
    }

    public VisReservationAuditItem setLevelIds(String levelIds) {
        this.levelIds = levelIds;
        return this;
    }

    public VisReservationAuditItem setCarPlate(String carPlate) {
        this.carPlate = carPlate;
        return this;
    }

    public VisReservationAuditItem setParkBlackWhiteId(String parkBlackWhiteId) {
        this.parkBlackWhiteId = parkBlackWhiteId;
        return this;
    }

    public VisReservationAuditItem setVisitorId(String visitorId) {
        this.visitorId = visitorId;
        return this;
    }

    public VisReservationAuditItem setVisitorPin(String visitorPin) {
        this.visitorPin = visitorPin;
        return this;
    }

    public VisReservationAuditItem setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public VisReservationAuditItem setStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public VisReservationAuditItem setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public VisReservationAuditItem setVisitorCount(Integer visitorCount) {
        this.visitorCount = visitorCount;
        return this;
    }

    public VisReservationAuditItem setVisitEndDate(String visitEndDate) {
        this.visitEndDate = visitEndDate;
        return this;
    }

    public VisReservationAuditItem setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
        return this;
    }

    public VisReservationAuditItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public VisReservationAuditItem setInAppId(String inAppId) {
        this.inAppId = inAppId;
        return this;
    }

    public VisReservationAuditItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisReservationAuditItem setVisitedLikeName(String visitedLikeName) {
        this.visitedLikeName = visitedLikeName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getVisitEmpPin() {
        return this.visitEmpPin;
    }

    public String getVisitEmpName() {
        return this.visitEmpName;
    }

    public String getVisitEmpLastName() {
        return this.visitEmpLastName;
    }

    public String getVisitEmpDeptName() {
        return this.visitEmpDeptName;
    }

    public String getVisitEmpDeptCode() {
        return this.visitEmpDeptCode;
    }

    public String getVisitorName() {
        return this.visitorName;
    }

    public String getVisitorLastName() {
        return this.visitorLastName;
    }

    public String getCertType() {
        return this.certType;
    }

    public String getCertName() {
        return this.certName;
    }

    public String getCertNumber() {
        return this.certNumber;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getCompany() {
        return this.company;
    }

    public Short getAuditStatus() {
        return this.auditStatus;
    }

    public String getVisitReason() {
        return this.visitReason;
    }

    public Date getVisitDate() {
        return this.visitDate;
    }

    public String getIsVisited() {
        return this.isVisited;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public String getVisitEmpDeptId() {
        return this.visitEmpDeptId;
    }

    public String getVisitedEmpId() {
        return this.visitedEmpId;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getVisitNumber() {
        return this.visitNumber;
    }

    public String getChangeOperator() {
        return this.changeOperator;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public String getLevelIds() {
        return this.levelIds;
    }

    public String getCarPlate() {
        return this.carPlate;
    }

    public String getParkBlackWhiteId() {
        return this.parkBlackWhiteId;
    }

    public String getVisitorId() {
        return this.visitorId;
    }

    public String getVisitorPin() {
        return this.visitorPin;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Integer getVisitorCount() {
        return this.visitorCount;
    }

    public String getVisitEndDate() {
        return this.visitEndDate;
    }

    public String getPhotoPath() {
        return this.photoPath;
    }

    public String getInId() {
        return this.inId;
    }

    public String getInAppId() {
        return this.inAppId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getVisitedLikeName() {
        return this.visitedLikeName;
    }
}

