/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.client.service.impl;

import com.zkteco.business.sdk.request.pers.ApiPersPositionAddListRequest;
import com.zkteco.business.sdk.request.pers.ApiPersPositionDeleteRequest;
import com.zkteco.business.sdk.request.pers.ApiPersPositionGetListRequest;
import com.zkteco.business.sdk.vo.PersApiPositiontItem;
import com.zkteco.cloud.sdk.BaseRequest;
import com.zkteco.cloud.sdk.DefaultZKCloudClient;
import com.zkteco.cloud.sdk.ZKCouldClient;
import com.zkteco.cloud.sdk.resp.ListResponse;
import com.zkteco.cloud.sdk.resp.ObjectResponse;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ModelUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.pers.client.utils.PersUploadPageUtil;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersPositionService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonCloudItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPositionItem;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthCloudMessageSendService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.SystemPersInfo2CloudService;
import com.zkteco.zkbiosecurity.system.vo.SystemPers2ApiPositiontItem;
import com.zkteco.zkbiosecurity.system.vo.SystemPerson2CloudItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PersCloudServiceImpl
implements SystemPersInfo2CloudService {
    private static final Logger log = LoggerFactory.getLogger(PersCloudServiceImpl.class);
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseAuthCloudMessageSendService baseAuthCloudMessageSendService;
    @Autowired
    private PersPositionService persPositionService;
    @Autowired
    private PersPersonService persPersonService;
    @Value(value="${cloud.server.upload.url:https://zkcloud.xmzkteco.com/BiosecurityApp/router/rest}")
    private String serverUrl;
    private static final String PERS_PERSON_PUSH_LAST_TIME = "pers.person.lastPushTime";

    public void asyncDelPersonToCloud(List<String> pinList) {
        if (this.baseAuthCloudMessageSendService.isAllowSendBasicData() && !CollectionUtil.isEmpty(pinList)) {
            CompletableFuture.runAsync(() -> {
                List pinsList = CollectionUtil.split((Collection)pinList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("pers");
                zkMessage.setMessageId("persCloudHandleMessage#delPersonByPin");
                zkMessage.setAppId(this.baseLicenseService.getAppId());
                pinsList.forEach(pins -> {
                    zkMessage.setListContent(pins);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }

    public void asyncLeavePersonToCloud(List<String> pinList) {
        if (this.baseAuthCloudMessageSendService.isAllowSendBasicData() && !CollectionUtil.isEmpty(pinList)) {
            CompletableFuture.runAsync(() -> {
                List pinsList = CollectionUtil.split((Collection)pinList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setModuleCode("pers");
                zkMessage.setMessageId("persCloudHandleMessage#leavePersonByPin");
                zkMessage.setAppId(this.baseLicenseService.getAppId());
                pinsList.forEach(pins -> {
                    zkMessage.setListContent(pins);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }

    public Long getPersonLastPushTime() {
        String lastPushTime = this.baseSysParamService.getValByName(PERS_PERSON_PUSH_LAST_TIME);
        return StringUtils.isNotBlank((CharSequence)lastPushTime) ? Long.valueOf(Long.parseLong(lastPushTime)) : null;
    }

    public void setPersonLastPushTime() {
        this.baseSysParamService.saveValueByName(PERS_PERSON_PUSH_LAST_TIME, System.currentTimeMillis() + "");
    }

    public ZKResultMsg syncAllPositionToCloud() {
        List persPersonCloudItemList = this.persPositionService.getByCondition(new PersPositionItem());
        List<PersApiPositiontItem> persApiPositiontItemList = this.buildApiPosition(persPersonCloudItemList);
        List pers2ApiPositiontItemList = ModelUtil.copyListProperties(persApiPositiontItemList, SystemPers2ApiPositiontItem.class);
        return this.sendPersPositionToCloud(pers2ApiPositiontItemList);
    }

    public void notifyCloudSyncPersonData() {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId())) {
            ZKMessage zkMessage = new ZKMessage();
            zkMessage.setModuleCode("pers");
            zkMessage.setMessageId("persCloudHandleMessage#getAllPersons");
            this.baseLicenseClientService.sendMessage(zkMessage);
        }
    }

    public ZKResultMsg syncAllPersonToCloud() {
        if (this.baseAuthCloudMessageSendService.isAllowSendBasicData()) {
            Long personCount = this.persPersonService.getPersonCount();
            int pageNo = PersUploadPageUtil.getPage(personCount);
            for (int i = 0; i < pageNo; ++i) {
                List persPersonItemList = this.persPersonService.getPersonCloudItems(new PersPersonCloudItem(), i, 30);
                List persPerson2CloudItemList = ModelUtil.copyListProperties((Collection)persPersonItemList, SystemPerson2CloudItem.class);
                this.asyncPushPersonToCloud(persPerson2CloudItemList);
            }
        }
        return ZKResultMsg.successMsg();
    }

    public void asyncPushPersonToCloud(List<SystemPerson2CloudItem> persPersonCloudItemList) {
        if (this.baseAuthCloudMessageSendService.isAllowSendBasicData() && !CollectionUtil.isEmpty(persPersonCloudItemList)) {
            List persPersonCloudItemsList = CollectionUtil.split(persPersonCloudItemList, (int)30);
            ZKMessage zkMessage = new ZKMessage();
            zkMessage.setModuleCode("pers");
            zkMessage.setMessageId("persCloudHandleMessage#personMessageHandle");
            zkMessage.setAppId(this.baseLicenseService.getAppId());
            persPersonCloudItemsList.forEach(persPersonCloudItems -> {
                zkMessage.setListContent(persPersonCloudItems);
                this.baseLicenseClientService.sendMessage(zkMessage);
            });
        }
    }

    public ZKResultMsg syncAllPositionFromCloud() {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        String token = this.baseAuthCloudMessageSendService.createToken();
        log.info("------ getPosition access_token ------- " + token);
        ZKCouldClient couldClient = this.getSendMsgClient();
        StringBuffer msg = new StringBuffer();
        ApiPersPositionGetListRequest apiPersPositionGetListRequest = new ApiPersPositionGetListRequest();
        apiPersPositionGetListRequest.setPersApiPositiontItem(new PersApiPositiontItem());
        try {
            ListResponse rsp = (ListResponse)couldClient.execute((BaseRequest)apiPersPositionGetListRequest, token);
            Integer ret = Integer.parseInt(rsp.getCode());
            log.info("getDepartment ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
            if (ret == -27) {
                token = this.baseAuthCloudMessageSendService.refreshToken();
                rsp = (ListResponse)couldClient.execute((BaseRequest)apiPersPositionGetListRequest, token);
                ret = Integer.parseInt(rsp.getCode());
            }
            if (ret < 0) {
                msg.append("ret \uff1a" + rsp.getCode() + ", msg: " + rsp.getMsg()).append("</br>");
            } else {
                log.info("response : " + rsp.getList());
                if (!CollectionUtil.isEmpty((Collection)rsp.getList())) {
                    List persPositionItemList = ModelUtil.copyListProperties((Collection)rsp.getList(), PersPositionItem.class);
                    this.persPositionService.batchSaveItemFromCloud(persPositionItemList);
                }
            }
        }
        catch (Exception e) {
            log.error("getDepartment error !", (Throwable)e);
            msg.append(I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]) + "!").append("</br>");
        }
        if (StringUtils.isNotBlank((CharSequence)msg.toString())) {
            resultMsg = ZKResultMsg.failMsg((String)msg.toString(), (Object[])new Object[0]);
        }
        return resultMsg;
    }

    public ZKResultMsg sendPersPositionToCloud(List<SystemPers2ApiPositiontItem> persApiPositiontItems) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        if (this.baseAuthCloudMessageSendService.isMasterApp() && !CollectionUtil.isEmpty(persApiPositiontItems)) {
            StringBuffer msg = new StringBuffer();
            String token = this.baseAuthCloudMessageSendService.createToken();
            log.info("------ upload access_token ------- " + token);
            ZKCouldClient couldClient = this.getSendMsgClient();
            List apiAuthDepartmentItemList = CollectionUtil.split(persApiPositiontItems, (int)100);
            for (List items : apiAuthDepartmentItemList) {
                ApiPersPositionAddListRequest apiPersPositionAddListRequest = new ApiPersPositionAddListRequest();
                List persApiPositiontItemList = ModelUtil.copyListProperties((Collection)items, PersApiPositiontItem.class);
                apiPersPositionAddListRequest.setPersApiPositiontItems(persApiPositiontItemList);
                try {
                    ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPersPositionAddListRequest, token);
                    Integer ret = Integer.parseInt(rsp.getCode());
                    log.info("sendPersPositionToCloud ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                    if (ret == -27) {
                        token = this.baseAuthCloudMessageSendService.refreshToken();
                        rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPersPositionAddListRequest, token);
                        ret = Integer.parseInt(rsp.getCode());
                    }
                    if (ret >= 0) continue;
                    String codes = CollectionUtil.getPropertys((Collection)items, SystemPers2ApiPositiontItem::getCode);
                    msg.append(codes + ", ret \uff1a" + rsp.getCode() + ", msg: " + rsp.getMsg()).append("</br>");
                }
                catch (Exception e) {
                    log.error("sendPersPositionToCloud error !", (Throwable)e);
                    String codes = CollectionUtil.getPropertys((Collection)items, SystemPers2ApiPositiontItem::getCode);
                    msg.append(codes + ", " + I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]) + "!").append("</br>");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msg.toString())) {
                resultMsg = ZKResultMsg.failMsg((String)msg.toString(), (Object[])new Object[0]);
            }
        }
        return resultMsg;
    }

    public ZKResultMsg delPersPositionToCloud(List<String> positionCodeList) {
        if (StringUtils.isBlank((CharSequence)this.baseLicenseService.getAppId())) {
            return ZKResultMsg.failMsg((String)"auth_not_register_cloud", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        String appRelation = this.baseSysParamService.getValByName("zkteco:cloud:app:relation");
        if (this.baseAuthCloudMessageSendService.isMasterApp() && !CollectionUtil.isEmpty(positionCodeList)) {
            StringBuffer msg = new StringBuffer();
            String token = this.baseAuthCloudMessageSendService.createToken();
            log.info("------ upload access_token ------- " + token);
            ZKCouldClient couldClient = this.getSendMsgClient();
            List positionCodes = CollectionUtil.split(positionCodeList, (int)100);
            for (List codes : positionCodes) {
                ArrayList<PersApiPositiontItem> items = new ArrayList<PersApiPositiontItem>();
                for (String code : codes) {
                    PersApiPositiontItem persApiPositiontItem = new PersApiPositiontItem();
                    persApiPositiontItem.setCode(code);
                    items.add(persApiPositiontItem);
                }
                ApiPersPositionDeleteRequest apiPersPositionDeleteRequest = new ApiPersPositionDeleteRequest();
                apiPersPositionDeleteRequest.setPersApiPositiontItems(items);
                try {
                    ObjectResponse rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPersPositionDeleteRequest, token);
                    Integer ret = Integer.parseInt(rsp.getCode());
                    log.info("delPersPositionToCloud ------- result : " + rsp.getCode() + "----- msg :" + rsp.getMsg());
                    if (ret == -27) {
                        token = this.baseAuthCloudMessageSendService.refreshToken();
                        rsp = (ObjectResponse)couldClient.execute((BaseRequest)apiPersPositionDeleteRequest, token);
                        ret = Integer.parseInt(rsp.getCode());
                    }
                    if (ret >= 0) continue;
                    String codesStr = CollectionUtil.getPropertys(items, PersApiPositiontItem::getCode);
                    msg.append(codes + ", ret \uff1a" + rsp.getCode() + ", msg: " + rsp.getMsg()).append("</br>");
                }
                catch (Exception e) {
                    log.error("delPersPositionToCloud error !", (Throwable)e);
                    String codesStr = CollectionUtil.getPropertys(items, PersApiPositiontItem::getCode);
                    msg.append(codes + ", " + I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]) + "!").append("</br>");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)msg.toString())) {
                resultMsg = ZKResultMsg.failMsg((String)msg.toString(), (Object[])new Object[0]);
            }
        }
        return resultMsg;
    }

    private List<PersApiPositiontItem> buildApiPosition(List<PersPositionItem> persPositionItemList) {
        List<Object> persApiPositiontItemList = new ArrayList<PersApiPositiontItem>();
        if (!CollectionUtil.isEmpty(persPositionItemList)) {
            ArrayList rootPositionList = new ArrayList();
            List positionCode = (List)CollectionUtil.getPropertyList(persPositionItemList, PersPositionItem::getCode, (Object)"-1");
            Map<String, List<PersPositionItem>> positionMap = persPositionItemList.stream().filter(item -> {
                if (StringUtils.isBlank((CharSequence)item.getParentCode()) || !positionCode.contains(item.getParentCode())) {
                    rootPositionList.add(item);
                    return false;
                }
                return true;
            }).collect(Collectors.groupingBy(PersPositionItem::getParentCode));
            persApiPositiontItemList = ModelUtil.copyListProperties(rootPositionList, PersApiPositiontItem.class);
            for (PersPositionItem positionItem : rootPositionList) {
                if (positionMap.get(positionItem.getCode()) == null || positionMap.get(positionItem.getCode()).isEmpty()) continue;
                persApiPositiontItemList.addAll(this.buildChildPositionTree(positionItem, positionMap));
            }
        }
        return persApiPositiontItemList;
    }

    private List<PersApiPositiontItem> buildChildPositionTree(PersPositionItem positionItem, Map<String, List<PersPositionItem>> positionMap) {
        List<PersPositionItem> childrenPositionList = positionMap.get(positionItem.getCode());
        ArrayList<PersApiPositiontItem> persApiPositiontItems = new ArrayList<PersApiPositiontItem>();
        if (!CollectionUtil.isEmpty(childrenPositionList)) {
            return persApiPositiontItems;
        }
        for (PersPositionItem item : childrenPositionList) {
            ArrayList<PersApiPositiontItem> persApiPositiontItemList = new ArrayList<PersApiPositiontItem>();
            PersApiPositiontItem persApiPositiontItem = new PersApiPositiontItem();
            persApiPositiontItem.setCode(item.getCode());
            persApiPositiontItem.setName(item.getName());
            persApiPositiontItem.setParentCode(item.getParentCode());
            persApiPositiontItemList.add(persApiPositiontItem);
            if (positionMap.get(item.getCode()) != null && !positionMap.get(item.getCode()).isEmpty()) {
                persApiPositiontItemList.addAll(this.buildChildPositionTree(item, positionMap));
            }
            persApiPositiontItems.addAll(persApiPositiontItemList);
        }
        return persApiPositiontItems;
    }

    public ZKCouldClient getSendMsgClient() {
        String appId = this.baseLicenseService.getAppId();
        String appKey = this.baseSysParamService.getValByName("zkteco:cloud:appkey");
        DefaultZKCloudClient couldClient = new DefaultZKCloudClient(this.serverUrl, appId, appKey);
        return couldClient;
    }
}

