/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.enums;

import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public enum ParkViewEnum {
    VIEW_86("86", I18nUtil.i18nCode((String)"common_country_CN", (Object[])new Object[0]), "cn", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "\u5269\u4f59\u8f66\u4f4d");
            this.put("welcomeEx", "\u6b22\u8fce\u5149\u4e34");
            this.put("welcome", "\u6b22\u8fce\u5149\u4e34");
            this.put("limitCarType", "\u9650\u884c\u8f66\u8f86\u7c7b\u578b");
            this.put("blackCar", "\u7981\u6b62\u540d\u5355\u8f66\u8f86");
            this.put("noPermission", "\u6b64\u8f66\u672a\u6388\u6743");
            this.put("parkingFull", "\u8f66\u4f4d\u5df2\u6ee1");
            this.put("contactAdmin", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            this.put("outOfDate", "\u6b64\u8f66\u5df2\u8fc7\u671f");
            this.put("peace", "\u795d\u60a8\u4e00\u8def\u5e73\u5b89");
            this.put("repayment", "\u5df2\u8d85\u65f6,\u8bf7\u56de\u6536\u8d39\u5904\u7f34\u8d39");
            this.put("charge", "\u8bf7\u7f34\u8d39%s\u5143");
            this.put("validity", "\u6709\u6548\u671f%s\u5929");
            this.put("sysProcess", "\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u4e2d");
            this.put("noPaid", "\u672a\u7f34\u8d39,\u8bf7\u5230\u6536\u8d39\u5904\u7f34\u8d39");
            this.put("carTeam", "\u8f66\u961f\u6a21\u5f0f");
        }
    }),
    VIEW_44("44", I18nUtil.i18nCode((String)"common_module", (Object[])new Object[0]), "en", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Remain");
            this.put("welcomeEx", "Welcome");
            this.put("charge", "$%s");
            this.put("validity", "Valid Period %s Days");
        }
    }),
    VIEW_27("27", I18nUtil.i18nCode((String)"common_country_ZA", (Object[])new Object[0]), "es", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Remain");
            this.put("welcomeEx", "Welcome");
            this.put("charge", "$%s");
            this.put("validity", "Valid Period %s Days");
        }
    }),
    VIEW_52("52", I18nUtil.i18nCode((String)"common_country_MX", (Object[])new Object[0]), "es", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Resto");
            this.put("welcomeEx", "Bienvenido");
            this.put("charge", "$%s");
            this.put("validity", "Per\u00edodo v\u00e1lido %s d\u00edas");
        }
    }),
    VIEW_54("54", I18nUtil.i18nCode((String)"common_country_AR", (Object[])new Object[0]), "es", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Resto");
            this.put("welcomeEx", "Bienvenido");
            this.put("charge", "$%s");
            this.put("validity", "Per\u00edodo v\u00e1lido %s d\u00edas");
        }
    }),
    VIEW_56("56", I18nUtil.i18nCode((String)"common_country_CL", (Object[])new Object[0]), "es", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Resto");
            this.put("welcomeEx", "Bienvenido");
            this.put("charge", "$%s");
            this.put("validity", "Per\u00edodo v\u00e1lido %s d\u00edas");
        }
    }),
    VIEW_57("57", I18nUtil.i18nCode((String)"common_country_CO", (Object[])new Object[0]), "es", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Resto");
            this.put("welcomeEx", "Bienvenido");
            this.put("charge", "$%s");
            this.put("validity", "Per\u00edodo v\u00e1lido %s d\u00edas");
        }
    }),
    VIEW_66("66", I18nUtil.i18nCode((String)"common_country_TH", (Object[])new Object[0]), "th", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Remain");
            this.put("welcomeEx", "Welcome");
            this.put("charge", "\u0e3f%s");
            this.put("validity", "Valid Period %s Days");
        }
    }),
    VIEW_90("90", I18nUtil.i18nCode((String)"common_country_TR", (Object[])new Object[0]), "tr", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Kalmak");
            this.put("welcomeEx", "Ho\u015fgeldiniz");
            this.put("charge", "\u20ba%s");
            this.put("validity", "Ge\u00e7erli S\u00fcre %s G\u00fcn");
        }
    }),
    VIEW_967("967", I18nUtil.i18nCode((String)"common_country_SA", (Object[])new Object[0]), "es", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "\u0645\u062a\u0627\u062d\u0629 \u062d\u0627\u0644\u064a\u0627\u064b\u064b");
            this.put("welcomeEx", "\u0645\u0631\u062d\u0628\u0627");
            this.put("charge", "%s\ufdfc");
            this.put("validity", "\u0623\u064a\u0627\u0645 s% \u0627\u0644\u0641\u062a\u0631\u0629 \u0627\u0644\u0645\u0633\u0645\u0648\u062d\u0629");
        }
    }),
    VIEW_977("977", I18nUtil.i18nCode((String)"common_country_MN", (Object[])new Object[0]), "es", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "\u0421\u0443\u043b \u0437\u043e\u0433\u0441\u043e\u043e\u043b");
            this.put("welcomeEx", "\u0422\u0430\u0432\u0442\u0430\u0439 \u043c\u043e\u0440\u0438\u043b\u043d\u043e \u0443\u0443");
            this.put("charge", "\u20ae%s");
            this.put("validity", "\u0425\u04af\u0447\u0438\u043d\u0442\u044d\u0439 \u0445\u0443\u0433\u0430\u0446\u0430\u0430: %s \u0445\u043e\u043d\u043e\u0433");
        }
    }),
    VIEW_20("20", I18nUtil.i18nCode((String)"common_country_EG", (Object[])new Object[0]), "es", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "\u0645\u062a\u0627\u062d\u0629 \u062d\u0627\u0644\u064a\u0627\u064b");
            this.put("welcomeEx", "\u0645\u0631\u062d\u0628\u0627");
            this.put("charge", "%s\u062c\u0646\u064a\u0647");
            this.put("validity", "\u0627\u0644\u0641\u062a\u0631\u0629 \u0627\u0644\u0645\u0633\u0645\u0648\u062d\u0629 s% \u0623\u064a\u0627\u0645");
        }
    }),
    VIEW_51("51", I18nUtil.i18nCode((String)"common_country_PE", (Object[])new Object[0]), "es", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Resto");
            this.put("welcomeEx", "Bienvenido");
            this.put("charge", "$%s");
            this.put("validity", "Per\u00edodo v\u00e1lido %s d\u00edas");
        }
    }),
    VIEW_62("62", I18nUtil.i18nCode((String)"common_country_ID", (Object[])new Object[0]), "en", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Pengingat");
            this.put("welcomeEx", "Selamat Datang");
            this.put("charge", "Rp%s");
            this.put("validity", "Masa Berlaku %s Hari");
        }
    }),
    VIEW_60("60", I18nUtil.i18nCode((String)"common_country_MY", (Object[])new Object[0]), "en", (Map<String, String>)new HashMap<String, String>(){
        {
            this.put("remainPark", "Remain");
            this.put("welcomeEx", "Welcome");
            this.put("charge", "RM%s");
            this.put("validity", "Valid Period %s Days");
        }
    });

    private String viewCode;
    private String viewName;
    private String lang;
    private Map<String, String> map;

    public static String getLang(String viewCode) {
        for (ParkViewEnum c : ParkViewEnum.values()) {
            if (!c.getViewCode().equals(viewCode)) continue;
            return c.lang;
        }
        return null;
    }

    public static String getViewContent(String viewCode, String key) {
        String viewContent = null;
        for (ParkViewEnum parkViewEnum : ParkViewEnum.values()) {
            if (!parkViewEnum.getViewCode().equals(viewCode)) continue;
            Map<String, String> map = parkViewEnum.getMap();
            viewContent = map.containsKey(key) ? map.get(key) : ParkViewEnum.getFormatTime(viewCode);
        }
        return viewContent;
    }

    public static String getFormatTime(String viewCode) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("967".equals(viewCode)) {
            df = new SimpleDateFormat("MMM-dd-yyyy HH:mm:ss", Locale.ENGLISH);
        }
        return df.format(new Date());
    }

    public static List<SelectItem> getViewCodeSelectItem() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (ParkViewEnum parkViewEnum : ParkViewEnum.values()) {
            if (parkViewEnum.getViewCode().equals("86")) continue;
            selectItems.add(new SelectItem((Object)parkViewEnum.getViewName(), parkViewEnum.getViewCode()));
        }
        return selectItems;
    }

    public String getViewCode() {
        return this.viewCode;
    }

    public void setViewCode(String viewCode) {
        this.viewCode = viewCode;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    private ParkViewEnum(String viewCode, String viewName, String lang, Map<String, String> map) {
        this.viewCode = viewCode;
        this.viewName = viewName;
        this.lang = lang;
        this.map = map;
    }
}

