/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.api.vo.InsApiAdMediaItem;
import com.zkteco.zkbiosecurity.ins.constants.InsConstant;
import com.zkteco.zkbiosecurity.ins.service.InsAdMediaService;
import com.zkteco.zkbiosecurity.ins.vo.InsAdMediaItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/api/adMedia"})
@Api(tags={"AdMedia"}, description="ins adMedia")
public class InsApiAdMediaController {
    private static final Logger log = LoggerFactory.getLogger(InsApiAdMediaController.class);
    @Autowired
    private InsAdMediaService insAdMediaService;

    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Add Ad Media", notes="Create Or Update Ad Media", response=ApiResultMessage.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="mediaName", value="Ad Name", required=true, paramType="form", dataType="string")})
    public ApiResultMessage add(@ApiIgnore InsApiAdMediaItem adMedia, @RequestParam(value="file") MultipartFile file) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        if (file.isEmpty()) {
            return ApiResultMessage.message((int)-73, (String)I18nUtil.i18nCode((String)"ins_media_fileEmpty", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)adMedia.getMediaName())) {
            return ApiResultMessage.message((int)-74, (String)I18nUtil.i18nCode((String)"ins_media_fileNameNotNull", (Object[])new Object[0]));
        }
        try {
            InsAdMediaItem adMediaItem = this.insAdMediaService.getItemByName(adMedia.getMediaName());
            if (adMediaItem == null) {
                adMediaItem = new InsAdMediaItem();
            }
            adMediaItem.setMediaResType("1");
            adMediaItem.setMediaName(adMedia.getMediaName());
            String mediaSuffix = file.getOriginalFilename();
            String type = "";
            mediaSuffix = mediaSuffix.substring(mediaSuffix.lastIndexOf(".") + 1);
            adMediaItem.setMediaSuffix(mediaSuffix);
            if (InsConstant.pictureType.contains(mediaSuffix)) {
                type = "1";
            } else if (InsConstant.videoType.contains(mediaSuffix)) {
                type = "2";
            }
            if (StringUtils.isBlank((CharSequence)type)) {
                return ApiResultMessage.message((int)-71, (String)I18nUtil.i18nCode((String)"ins_media_type_nonsupport", (Object[])new Object[0]));
            }
            long size = file.getSize() / 1000L / 1000L;
            if (size > 50L) {
                return ApiResultMessage.message((int)-72, (String)I18nUtil.i18nCode((String)"ins_media_size_over", (Object[])new Object[0]));
            }
            String fileName = System.currentTimeMillis() + "." + mediaSuffix;
            String photoPath = FileUtil.saveFileToServer((String)"ins", (String)"adpic", (String)fileName, (MultipartFile)file);
            adMediaItem.setMediaPath(photoPath);
            adMediaItem.setMediaType(type);
            this.insAdMediaService.saveItem(adMediaItem, "");
        }
        catch (Exception e) {
            log.error("api adMedia/add error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/get/{name}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Ad Media", notes="Get Ad Media By Name", response=ApiResultMessage.class)
    public ApiResultMessage getByName(@PathVariable String name) {
        InsAdMediaItem insAdMediaItem = this.insAdMediaService.getItemByName(name);
        return ApiResultMessage.successMessage((Object)InsApiAdMediaItem.createAdMedia((InsAdMediaItem)insAdMediaItem));
    }

    @ResponseBody
    @RequestMapping(value={"/delete/{name}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Delete Ad Media", notes="Delete Ad Media By Name", response=ApiResultMessage.class)
    public ApiResultMessage deleteByName(@PathVariable String name) {
        ApiResultMessage rs = new ApiResultMessage();
        try {
            InsAdMediaItem insAdMediaItem = this.insAdMediaService.getItemByName(name);
            if (insAdMediaItem == null) {
                return ApiResultMessage.message((int)-70, (String)I18nUtil.i18nCode((String)"ins_media_notExist", (Object[])new Object[0]));
            }
            this.insAdMediaService.deleteByIds(insAdMediaItem.getId());
        }
        catch (Exception e) {
            log.error("api adMedia/delete error ", (Throwable)e);
            rs = new ApiResultMessage(-1, I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

