/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.Tree;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisTipStrategyRemote;
import com.zkteco.zkbiosecurity.sis.service.SisTipPicTypeService;
import com.zkteco.zkbiosecurity.sis.service.SisTipStrategyService;
import com.zkteco.zkbiosecurity.sis.vo.SisTipPicTypeItem;
import com.zkteco.zkbiosecurity.sis.vo.SisTipStrategyItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisTipStrategyController
extends BaseController
implements SisTipStrategyRemote {
    @Autowired
    private SisTipStrategyService sisTipStrategyService;
    @Autowired
    private SisTipPicTypeService sisTipPicTypeService;

    @RequiresPermissions(value={"sis:tipStrategy"})
    public ModelAndView index() {
        return new ModelAndView("sis/tipStrategy/sisTipStrategy");
    }

    @RequiresPermissions(value={"sis:tipStrategy:edit"})
    public ModelAndView edit(String id) {
        SisTipStrategyItem sisTipStrategyItem = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            sisTipStrategyItem = this.sisTipStrategyService.findById(id);
            this.request.setAttribute("item", (Object)sisTipStrategyItem);
        }
        return new ModelAndView("sis/tipStrategy/editSisTipStrategy");
    }

    @RequiresPermissions(value={"sis:tipStrategy:edit"})
    @LogRequest(module="sis_module", object="sis_tip_strategy", opType="common_op_edit", requestParams={"name"}, opContent="sis_tip_strategy")
    public ZKResultMsg save(SisTipStrategyItem item) {
        this.sisTipStrategyService.saveItem(item);
        ZKResultMsg res = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"sis:tipStrategy:refresh"})
    public DxGrid list(SisTipStrategyItem condition) {
        Pager pager = this.sisTipStrategyService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:tipStrategy:del"})
    @LogRequest(module="sis_module", object="sis_tip_strategy", opType="common_op_del", requestParams={"name"}, opContent="sis_tip_strategy")
    public ZKResultMsg del(String ids) {
        this.sisTipStrategyService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getTipType() {
        List result = this.sisTipPicTypeService.getByCondition(new SisTipPicTypeItem());
        return new ZKResultMsg((Object)result);
    }

    public boolean isExistName(@RequestParam(value="name") String name) {
        return this.sisTipStrategyService.isExistName(name);
    }

    public Tree strategyTree(String id) {
        List sisTipStrategyItems = this.sisTipStrategyService.getByCondition(new SisTipStrategyItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        for (SisTipStrategyItem strategyItem : sisTipStrategyItems) {
            item = new TreeItem();
            item.setId(strategyItem.getId());
            item.setText(strategyItem.getName());
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        Tree tree = new Tree(treeItems);
        tree.setId(StringUtils.isBlank((CharSequence)id) ? "0" : id);
        return tree;
    }

    public ZKResultMsg getTipStrategyList() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        List list = this.sisTipStrategyService.getByCondition(new SisTipStrategyItem());
        for (SisTipStrategyItem item : list) {
            items.add(new SelectItem((Object)item.getName(), item.getId()));
        }
        return new ZKResultMsg(items);
    }
}

