/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisIEDTransactionRemote;
import com.zkteco.zkbiosecurity.sis.service.SisIEDTransactionService;
import com.zkteco.zkbiosecurity.sis.vo.SisIEDTransactionItem;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisIEDTransactionController
extends ExportController
implements SisIEDTransactionRemote {
    @Autowired
    private SisIEDTransactionService sisIEDTransactionService;

    public ModelAndView index(String sn) {
        if (StringUtils.isNotBlank((CharSequence)sn)) {
            this.request.setAttribute("sn", (Object)sn);
        }
        return new ModelAndView("sis/reports/sisNarcoticsExplosiveTransaction");
    }

    public DxGrid list(SisIEDTransactionItem codition) {
        Pager pager = this.sisIEDTransactionService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public TreeItem getSelectList() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        List sisDeviceItemList = this.sisIEDTransactionService.getByCondition(new SisIEDTransactionItem());
        ArrayList<String> modelList = new ArrayList<String>();
        if (!sisDeviceItemList.isEmpty()) {
            TreeItem item = null;
            for (SisIEDTransactionItem iedTransactionItem : sisDeviceItemList) {
                item = new TreeItem();
                item.setId(iedTransactionItem.getModel());
                item.setText(iedTransactionItem.getModel());
                if (modelList.contains(iedTransactionItem.getModel())) continue;
                modelList.add(iedTransactionItem.getModel());
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public TreeItem getSelectListState() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        List sisDeviceItemList = this.sisIEDTransactionService.getByCondition(new SisIEDTransactionItem());
        ArrayList<String> matterList = new ArrayList<String>();
        if (!sisDeviceItemList.isEmpty()) {
            TreeItem item = null;
            for (SisIEDTransactionItem iedTransactionItem : sisDeviceItemList) {
                item = new TreeItem();
                item.setId(iedTransactionItem.getMatter());
                item.setText(iedTransactionItem.getMatter());
                if (matterList.contains(iedTransactionItem.getMatter())) continue;
                matterList.add(iedTransactionItem.getMatter());
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    @RequiresPermissions(value={"sis:NarcoticsExplosiveTransaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        SisIEDTransactionItem sisIEDTransactionItem = new SisIEDTransactionItem();
        this.setConditionValue((BaseItem)sisIEDTransactionItem);
        List itemList = this.sisIEDTransactionService.getItemData(SisIEDTransactionItem.class, sisIEDTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, SisIEDTransactionItem.class);
    }

    @RequiresPermissions(value={"sis:NarcoticsExplosiveTransaction:del"})
    public ZKResultMsg del(String ids) {
        this.sisIEDTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

