/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.auth.provider.AuthSessionProvider;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseDbBackupRemote;
import com.zkteco.zkbiosecurity.system.service.BaseDbBackupService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseDbBackupItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BaseDbBackupController
extends BaseController
implements BaseDbBackupRemote {
    @Autowired
    private BaseDbBackupService baseDbBackupService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthSessionProvider authSessionProvider;

    @RequiresPermissions(value={"system:baseDbBackup"})
    public ModelAndView index() {
        return new ModelAndView("system/baseDbBackup/baseDbBackup");
    }

    @RequiresPermissions(value={"system:baseDbBackup:refresh"})
    public DxGrid list(BaseDbBackupItem condition) {
        Pager pager = this.baseDbBackupService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"system:baseDbBackup:del"})
    @LogRequest(module="system_module", object="base_leftMenu_databaseManagement", opType="common_op_del", requestParams={"startTime"}, opContent="common_op_startTime")
    public ZKResultMsg del(String ids) {
        this.baseDbBackupService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"system:baseDbBackup:immeBackup"})
    @LogRequest(module="system_module", object="base_leftMenu_databaseManagement", opType="base_db_backup", opContent="base_db_backup")
    public ZKResultMsg immeBackup() {
        String backupFtp = this.request.getParameter("backupFtp");
        ZKResultMsg zkResultMsg = this.baseDbBackupService.immeBackupAndFtp(WebContextUtil.getCurrentSessionId(), backupFtp);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"system:baseDbBackup:planBackup"})
    public ZKResultMsg planBackup() {
        ZKResultMsg zkResultMsg = null;
        SecuritySubject securitySubject = this.authSessionProvider.getSecuritySubject(this.request.getSession().getId());
        if (securitySubject != null) {
            String startTime = this.request.getParameter("startTime");
            String intervaltime = this.request.getParameter("intervalTime");
            String dbBackupRemote = this.request.getParameter("dbBackupRemote");
            zkResultMsg = this.baseDbBackupService.planBackupAndFtp(startTime, intervaltime, dbBackupRemote);
        }
        return zkResultMsg;
    }

    public ModelAndView getStartTime() {
        String dbBackupStartTime = this.baseSysParamService.getValByName("dbBackupStartTime");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isBlank((CharSequence)dbBackupStartTime)) {
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            String startTime = simpleDateFormat.format(date);
            int hour = calendar.get(11);
            if (calendar.get(12) * 60 + calendar.get(13) > 600) {
                ++hour;
            }
            dbBackupStartTime = startTime.substring(0, startTime.indexOf(" ")) + " " + hour + ":00:00";
        }
        this.request.setAttribute("dbBackupStartTime", (Object)dbBackupStartTime);
        String dbBackupIntervalTime = this.baseSysParamService.getValByName("dbBackupIntervalTime");
        if (StringUtils.isBlank((CharSequence)dbBackupStartTime)) {
            dbBackupIntervalTime = "1";
        }
        this.request.setAttribute("dbBackupIntervalTime", (Object)dbBackupIntervalTime);
        this.request.setAttribute("dbBackupRemote", (Object)this.baseSysParamService.getValByName("dbBackupRemote"));
        try {
            this.setNextTime(dbBackupStartTime, dbBackupIntervalTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("system/baseDbBackup/opBaseDbBackup");
    }

    @RequiresPermissions(value={"system:baseDbBackup:getFtpSetting"})
    public ModelAndView getFtpSetting() {
        HashMap<String, String> ftpParams = new HashMap<String, String>();
        ftpParams.put("ftpAddr", this.baseSysParamService.getValByName("ftpAddr").trim());
        ftpParams.put("ftpPort", this.baseSysParamService.getValByName("ftpPort").trim());
        ftpParams.put("ftpDir", this.baseSysParamService.getValByName("ftpDir").trim());
        ftpParams.put("ftpUsername", this.baseSysParamService.getValByName("ftpUsername").trim());
        ftpParams.put("ftpPwd", this.baseSysParamService.getValByName("ftpPwd").trim());
        this.request.setAttribute("ftpParams", ftpParams);
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("system/baseDbBackup/opBaseDbBackupToFtp");
    }

    public ZKResultMsg saveFtpSetting(@RequestParam Map<String, String> params) {
        String ftpAddr = params.get("ftpAddr");
        String ftpPort = params.get("ftpPort");
        String ftpUsername = params.get("ftpUsername");
        String ftpPwd = params.get("ftpPwd");
        String ftpDir = params.get("ftpDir");
        this.baseDbBackupService.saveFtpSetting(ftpAddr, ftpPort, ftpDir, ftpUsername, ftpPwd);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    private void setNextTime(String dbBackupStartTime, String dbBackupIntervalTime) throws ParseException {
        this.request.setAttribute("lastdbBackupTime", (Object)this.baseSysParamService.getValByName("lastdbBackupTime"));
        String[] timeArr = dbBackupStartTime.split(" ")[1].split(":");
        Date currentDate = new Date();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sfNoHMS = new SimpleDateFormat("yyyy-MM-dd");
        Date targetDate = null;
        targetDate = sf.parse(dbBackupStartTime);
        long dateSub = 0L;
        if (currentDate.before(targetDate)) {
            dateSub = targetDate.getTime() - currentDate.getTime();
            this.request.setAttribute("nextdbBackupTime", (Object)dbBackupStartTime);
        } else {
            String curYMDStr = sfNoHMS.format(currentDate);
            String currentDateStr = sf.format(currentDate);
            String tarYMDStr = dbBackupStartTime.split(" ")[0];
            String curHMSStr = currentDateStr.split(" ")[1];
            String tarHMSStr = dbBackupStartTime.split(" ")[1];
            Date curYMDDate = null;
            Date tarYMDDate = null;
            curYMDDate = sfNoHMS.parse(curYMDStr);
            tarYMDDate = sfNoHMS.parse(tarYMDStr);
            long dimDay = (long)Math.floor((double)(curYMDDate.getTime() - tarYMDDate.getTime()) / 8.64E7);
            long leftTime = 0L;
            if (dimDay % Long.parseLong(dbBackupIntervalTime) == 0L && curHMSStr.compareTo(tarHMSStr) > 0) {
                leftTime = Long.parseLong(dbBackupIntervalTime);
            } else {
                long rightDay = Math.round((double)(currentDate.getTime() - targetDate.getTime()) / 8.64E7);
                leftTime = Long.parseLong(dbBackupIntervalTime) - rightDay % Long.parseLong(dbBackupIntervalTime);
                if (rightDay % Long.parseLong(dbBackupIntervalTime) == 0L) {
                    leftTime = 0L;
                }
            }
            Calendar nextDate = Calendar.getInstance();
            nextDate.set(11, Integer.parseInt(timeArr[0]));
            nextDate.set(12, Integer.parseInt(timeArr[1]));
            nextDate.set(13, Integer.parseInt(timeArr[2]));
            nextDate.add(5, (int)leftTime);
            dateSub = nextDate.getTimeInMillis() - currentDate.getTime();
            if (Integer.parseInt(dbBackupIntervalTime) == 1 && dateSub > 86400000L) {
                dateSub -= 86400000L;
                nextDate.add(5, -1);
            }
            this.request.setAttribute("nextdbBackupTime", (Object)sf.format(nextDate.getTime()));
        }
        long backupday = dateSub / 86400000L;
        long backuphour = dateSub / 3600000L - backupday * 24L;
        long backupmin = dateSub / 60000L - backupday * 24L * 60L - backuphour * 60L;
        long backupsed = dateSub / 1000L - backupday * 24L * 60L * 60L - backuphour * 60L * 60L - backupmin * 60L;
        this.request.setAttribute("backupday", (Object)backupday);
        this.request.setAttribute("backuphour", (Object)backuphour);
        this.request.setAttribute("backupmin", (Object)backupmin);
        this.request.setAttribute("backupsed", (Object)backupsed);
    }

    public ZKResultMsg testConnection() {
        String ftpAddr = this.request.getParameter("ftpAddr");
        String ftpPort = this.request.getParameter("ftpPort");
        String ftpUsername = this.request.getParameter("ftpUsername");
        String ftpPwd = this.request.getParameter("ftpPwd");
        String ftpDir = this.request.getParameter("ftpDir");
        boolean ret = false;
        if (StringUtils.isNotBlank((CharSequence)"ftpAddr") && StringUtils.isNotBlank((CharSequence)"ftpPort") && StringUtils.isNotBlank((CharSequence)"ftpUsername") && StringUtils.isNotBlank((CharSequence)"ftpPwd")) {
            if (StringUtils.isBlank((CharSequence)ftpDir)) {
                ftpDir = "";
            }
            ret = this.baseDbBackupService.testConnection(ftpAddr, Integer.valueOf(Integer.parseInt(ftpPort)), ftpDir, ftpUsername, ftpPwd);
        }
        if (ret) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg backupTestConnection() {
        String ftpAddr = this.baseSysParamService.getValByName("ftpAddr").trim();
        String ftpPort = this.baseSysParamService.getValByName("ftpPort").trim();
        String ftpDir = this.baseSysParamService.getValByName("ftpDir").trim();
        String ftpUsername = this.baseSysParamService.getValByName("ftpUsername").trim();
        String ftpPwd = this.baseSysParamService.getValByName("ftpPwd").trim();
        boolean ftpRet = false;
        if (StringUtils.isNotBlank((CharSequence)"ftpAddr") && StringUtils.isNotBlank((CharSequence)"ftpPort") && StringUtils.isNotBlank((CharSequence)"ftpUsername") && StringUtils.isNotBlank((CharSequence)"ftpPwd")) {
            if (StringUtils.isBlank((CharSequence)ftpDir)) {
                ftpDir = "";
            }
            ftpRet = this.baseDbBackupService.testConnection(ftpAddr, Integer.valueOf(Integer.parseInt(ftpPort)), ftpDir, ftpUsername, ftpPwd);
        }
        if (ftpRet) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }
}

