/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.utils;

import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JSONObjectUtil {
    public static void setKeyValue(JSONObject json, String key, Object value) {
        try {
            json.putOpt(key, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static Object getValueByKey(JSONObject json, String key) {
        try {
            return json.get(key);
        }
        catch (JSONException e) {
            System.err.println(json + " not key=" + key);
            return null;
        }
    }

    public static String getStrValueByKey(JSONObject json, String key) {
        try {
            return json.getString(key);
        }
        catch (JSONException e) {
            System.err.println(json + " not key=" + key);
            return null;
        }
    }

    public static Object getValueByKey(String jsonStr, String key) {
        return JSONObjectUtil.getValueByKey(JSONObjectUtil.createJson(jsonStr), key);
    }

    public static Boolean getBooleanValueByKey(Object json, String key) {
        try {
            if (json instanceof String) {
                return JSONObjectUtil.createJson(json).getBoolean(key);
            }
            if (json instanceof JSONObject) {
                return ((JSONObject)json).getBoolean(key);
            }
        }
        catch (JSONException e) {
            System.err.println(json + " not key=" + key);
        }
        return false;
    }

    public static String getStrValueByKeyWithDefault(JSONObject json, String key, String defValue) {
        try {
            return json.has(key) ? json.getString(key) : defValue;
        }
        catch (JSONException e) {
            System.err.println(json + " not key=" + key);
            return defValue;
        }
    }

    public static int getIntValueByKey(JSONObject json, String key) {
        try {
            return json.getInt(key);
        }
        catch (JSONException e) {
            System.err.println(json + " not key=" + key);
            return -1;
        }
    }

    public static JSONObject createJson(Object object) {
        try {
            if (null == object) {
                return null;
            }
            return new JSONObject(object.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Short getShortValueByKey(JSONObject json, String key) {
        try {
            return Short.valueOf(json.getString(key));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return Short.valueOf("-1");
        }
    }

    public static int getIntValueByKeyWithDefault(JSONObject json, String key, int defValue) {
        try {
            return json.has(key) ? json.getInt(key) : defValue;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static JSONObject mapToJson(Map<String, String> optionsMap) {
        JSONObject json = new JSONObject();
        for (String key : optionsMap.keySet()) {
            JSONObjectUtil.setKeyValue(json, key, optionsMap.get(key));
        }
        return json;
    }
}

