/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push;

import com.zkteco.zkbiosecurity.adms.distributor.push.http.HttpServerInitializer;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.PushProcessor;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=133000)
public class PushServer
implements CommandLineRunner {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Value(value="${adms.push.port:9999}")
    private int port;
    @Value(value="${security.require-ssl:false}")
    private String ishttps;
    @Autowired
    PushProcessor pushProcessor;
    private Channel channel;

    public void run(String ... args) throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PushServer.this.log.info("Push Server listening on " + PushServer.this.port + " port...");
                PushServer.this.startPushServer();
            }
        }, "PushServer-Thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPushServer() {
        this.log.info("Starting Push Server ......");
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpServerInitializer(this.pushProcessor, this.ishttps));
            this.channel = serverBootstrap.bind(this.port).sync().channel();
            this.channel.closeFuture().sync();
            this.log.info("Start Push Server End With Port=" + this.port);
        }
        catch (InterruptedException e) {
            this.log.error("PUSH Server Start Failed!", (Throwable)e);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public int getPort() {
        return this.port;
    }
}

