/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.pull.processor;

import com.zkteco.zkbiosecurity.adms.bean.DeviceDoorState;
import com.zkteco.zkbiosecurity.adms.bean.SdkResult;
import com.zkteco.zkbiosecurity.adms.cache.AdmsCacheManager;
import com.zkteco.zkbiosecurity.adms.distributor.utils.DeviceDataUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.JSONObjectUtil;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsSdkService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAccPullDeviceItem;
import com.zkteco.zkbiosecurity.adms.vo.AdmsDeviceItem;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullProcessor {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AdmsCacheManager admsCacheManager;
    @Autowired
    private AdmsDeviceService admsDeviceService;
    @Autowired
    private AdmsDevCmdService admsDevCmdService;
    @Autowired
    private AdmsSdkService admsSdkService;
    public static final ExecutorService executorService = Executors.newCachedThreadPool();

    public void startPullServer() {
        try {
            this.admsCacheManager.delAllRs485Device();
            List admsDeviceItemList = this.admsDeviceService.getPullList();
            if (admsDeviceItemList != null && admsDeviceItemList.size() > 0) {
                for (AdmsDeviceItem admsDeviceItem : admsDeviceItemList) {
                    this.addDevToPullMonitor(admsDeviceItem.getSn());
                }
            }
        }
        catch (Exception e) {
            this.log.error("PullServer Exception", (Object)e.getMessage());
        }
    }

    public void addDevToPullMonitor(String sn) {
        String devInfo = this.admsCacheManager.getDeviceInfo(sn);
        if (StringUtils.isNotBlank((CharSequence)devInfo)) {
            JSONObject devJson = JSONObjectUtil.createJson(devInfo);
            String commType = JSONObjectUtil.getStrValueByKey(devJson, "CommType");
            if (1 == Short.valueOf(commType)) {
                this.addDevToTcpIpMonitor(sn);
            } else if (2 == Short.valueOf(commType)) {
                String commPort = JSONObjectUtil.getStrValueByKey(devJson, "ComPort");
                this.addDevToRs485Monitor(sn, Short.valueOf(commPort));
            }
        }
    }

    public void addDevToTcpIpMonitor(String sn) {
        executorService.execute(new tcpIpPullDevMonitor(sn));
    }

    public void addDevToRs485Monitor(String sn, Short comPort) {
        if (comPort != null && comPort > 0) {
            Set<String> allRs485CacheKeySet = this.admsCacheManager.getAllRs485CacheKeySet();
            if (allRs485CacheKeySet != null && allRs485CacheKeySet.size() > 0) {
                this.admsCacheManager.setRs485Device(comPort, sn);
            } else {
                this.admsCacheManager.setRs485Device(comPort, sn);
                executorService.execute(new rs485PullDevMonitor());
            }
        }
    }

    private long connect(String sn) {
        String devJsonString = this.admsCacheManager.getDeviceInfo(sn);
        if (StringUtils.isEmpty((CharSequence)devJsonString)) {
            return -1L;
        }
        JSONObject devJson = JSONObjectUtil.createJson(devJsonString);
        String connectParam = "";
        if (JSONObjectUtil.getIntValueByKey(devJson, "CommType") == 1) {
            connectParam = "protocol=TCP,ipaddress=%s,port=%s,timeout=3000,passwd=%s";
            connectParam = String.format(connectParam, JSONObjectUtil.getValueByKey(devJson, "IPAddress"), JSONObjectUtil.getValueByKey(devJson, "IpPort"), devJson.has("CommPwd") ? JSONObjectUtil.getValueByKey(devJson, "CommPwd") : "");
        } else if (JSONObjectUtil.getIntValueByKey(devJson, "CommType") == 2) {
            connectParam = "protocol=RS485,port=COM%s,baudrate=%sbps,deviceid=%s,timeout=4000,passwd=%s";
            connectParam = String.format(connectParam, JSONObjectUtil.getValueByKey(devJson, "ComPort"), JSONObjectUtil.getValueByKey(devJson, "Baudrate"), JSONObjectUtil.getValueByKey(devJson, "ComAddress"), devJson.has("CommPwd") ? JSONObjectUtil.getValueByKey(devJson, "CommPwd") : "");
        }
        int[] callbackResult = new int[4];
        SdkResult sdkResult = this.admsSdkService.connectExt(connectParam, callbackResult);
        return sdkResult.getResult();
    }

    private void processCmd(Long hcommpro, String sn) {
        String cmdContent = this.admsDeviceService.getCmd(sn, 1);
        if (StringUtils.isNotBlank((CharSequence)cmdContent)) {
            if (cmdContent.endsWith("\r\n\r\n")) {
                cmdContent = cmdContent.replaceAll("\r\n\r\n", "");
            }
            String[] cmd = cmdContent.split(":", 3);
            String cmdId = cmd[1];
            String cmdStr = cmd[2];
            SdkResult sdkResult = new SdkResult();
            String actionName = cmdStr;
            if (cmdStr.startsWith("SET OPTIONS")) {
                sdkResult = this.setOptions(hcommpro, cmdStr);
                actionName = "SET OPTIONS";
            } else if (cmdStr.startsWith("DATA UPDATE")) {
                sdkResult = this.dataUpdate(hcommpro, cmdStr);
            } else if (cmdStr.startsWith("CONTROL DEVICE")) {
                sdkResult = this.controlDevice(hcommpro, cmdStr);
                actionName = "CONTROL DEVICE";
            } else if (cmdStr.startsWith("DATA DELETE")) {
                sdkResult = this.delDevData(hcommpro, cmdStr);
            } else if (cmdStr.startsWith("DATA QUERY")) {
                sdkResult = this.getDevData(hcommpro, sn, cmdId, cmdStr);
            } else if (cmdStr.startsWith("DATA COUNT")) {
                sdkResult = this.getDevDataCount(hcommpro, sn, cmdId, cmdStr);
            } else if (cmdStr.startsWith("GET OPTIONS")) {
                sdkResult = this.getDevOption(hcommpro, sn, cmdId, cmdStr);
            } else if (cmdStr.startsWith("UPGRADE")) {
                sdkResult = this.upgradeFirmware(hcommpro, cmdStr);
            } else {
                sdkResult.setResult(0L);
                sdkResult.setData("unknown command");
            }
            this.admsDeviceService.updateDevOperateState(sn, actionName, "0");
            if (sdkResult != null) {
                long rsInt = sdkResult.getResult();
                this.admsDevCmdService.setCmdResult(sn, Long.valueOf(cmdId), Integer.valueOf((int)rsInt));
                this.admsCacheManager.removeCommCmd(sn, cmdContent);
            }
        }
    }

    private long getRtLog(Long hcommpro, String sn) {
        SdkResult sdkResult = this.admsSdkService.getRTLogExt(hcommpro.longValue(), new byte[16384]);
        long result = sdkResult.getResult();
        if (result < 0L) {
            return result;
        }
        String data = sdkResult.getData();
        String devStr = this.admsCacheManager.getDeviceInfo(sn);
        if (StringUtils.isNotBlank((CharSequence)data) && StringUtils.isNotBlank((CharSequence)devStr)) {
            JSONObject tempDevJson = JSONObjectUtil.createJson(devStr);
            String deviceType = JSONObjectUtil.getStrValueByKey(tempDevJson, "DeviceType");
            if (data.contains("type=rtstate")) {
                String[] dataArray;
                data = data.replaceAll("type=rtstate", "").trim();
                for (String devRTData : dataArray = data.split("\r\n")) {
                    Map<String, String> dataMap = DeviceDataUtil.formateStrToMap(devRTData, "\t");
                    int lockCount = JSONObjectUtil.getIntValueByKey(tempDevJson, "LockCount");
                    if (lockCount > 0) {
                        DeviceDoorState deviceDoorState = new DeviceDoorState();
                        deviceDoorState.setSn(dataMap.containsKey("sn") ? dataMap.get("sn") : sn);
                        deviceDoorState.setSensor(DeviceDataUtil.getNewBinary(dataMap.get("sensor"), lockCount, 2, false, deviceType));
                        deviceDoorState.setRelay(dataMap.containsKey("relay") ? DeviceDataUtil.getNewBinary(dataMap.get("relay"), lockCount, 1, false, deviceType) : null);
                        deviceDoorState.setConnect(String.valueOf(1));
                        deviceDoorState.setDoor(dataMap.containsKey("door") ? DeviceDataUtil.getNewBinary(dataMap.get("door"), lockCount, 8, true, deviceType) : null);
                        deviceDoorState.setAlarm(dataMap.containsKey("alarm") ? DeviceDataUtil.getNewBinary(dataMap.get("alarm"), lockCount, 8, true, deviceType) : null);
                        this.admsDeviceService.updateDeviceDoorStates(deviceType, deviceDoorState);
                    }
                    this.admsDeviceService.updateDevOperateState(sn, "DEVICE GET", "0");
                }
            } else if (data.length() >= 97) {
                if (deviceType.equals("acc")) {
                    this.admsCacheManager.cacheAccRtLog(sn, data);
                } else if (deviceType.equals("ele")) {
                    this.admsCacheManager.cacheEleRtLog(sn, data);
                }
                this.admsDeviceService.updateDevOperateState(sn, "GET_RT_LOG", "0");
            }
        }
        return hcommpro;
    }

    private SdkResult setOptions(Long hcommpro, String cmdStr) {
        String[] paramStr = cmdStr.split(" ");
        String optItem = paramStr[2].replace("\t", ",").trim();
        return this.admsSdkService.setDeviceParam(hcommpro.longValue(), optItem);
    }

    private SdkResult dataUpdate(Long hcommpro, String cmdStr) {
        String[] paramStr = cmdStr.split(" ");
        String tableName = paramStr[2];
        String strTmp = cmdStr.substring(cmdStr.indexOf(tableName) + tableName.length() + 1);
        String cmdContent = strTmp.replace("\\", "\r");
        return this.admsSdkService.setDeviceData(hcommpro.longValue(), tableName.trim(), cmdContent.trim(), "");
    }

    private SdkResult controlDevice(Long hcommpro, String commParam) {
        SdkResult sdkResult = new SdkResult();
        String[] cmdArray = commParam.split("\r\n");
        for (int i = 0; i < cmdArray.length; ++i) {
            String[] paramStr = cmdArray[i].split(" ");
            int actionType = Integer.parseInt(paramStr[2].trim());
            int no = Integer.parseInt(paramStr[3].trim());
            int interval = Integer.parseInt(paramStr[5].trim());
            int type = Integer.parseInt(paramStr[4].trim());
            sdkResult = this.admsSdkService.controlDevice(hcommpro.longValue(), actionType, no, type, interval, 0, "");
        }
        return sdkResult;
    }

    private SdkResult delDevData(Long hcommpro, String cmdStr) {
        String[] paramStr = cmdStr.split(" ");
        String tableName = paramStr[2];
        return this.admsSdkService.deleteDeviceData(hcommpro.longValue(), tableName, cmdStr.substring(cmdStr.indexOf(tableName) + tableName.length() + 1), "");
    }

    private SdkResult getDevData(Long hcommpro, String sn, String cmdId, String cmdStr) {
        String[] paramStr = cmdStr.split("\r\n")[0].split(" ")[2].split(",");
        String tableName = paramStr[0].split("=", 2)[1];
        String fieldName = paramStr[1].split("=", 2)[1];
        String filterParam = paramStr[2].split("=", 2)[1];
        String options = "";
        if (tableName.equalsIgnoreCase("transaction") && filterParam.equals("NewRecord")) {
            filterParam = "*";
            options = "NewRecord";
        }
        int bufferSize = this.getNeedMemory(hcommpro, tableName);
        byte[] callbackResult = new byte[bufferSize];
        SdkResult sdkResult = this.admsSdkService.getDeviceData(hcommpro.longValue(), callbackResult, tableName, fieldName, filterParam, options);
        if (sdkResult.getResult() >= 0L) {
            JSONObject json = new JSONObject();
            JSONObjectUtil.setKeyValue(json, "type", "tabledata");
            JSONObjectUtil.setKeyValue(json, "table", tableName);
            JSONObjectUtil.setKeyValue(json, "count", sdkResult.getResult());
            JSONObjectUtil.setKeyValue(json, "cmdId", cmdId);
            JSONObjectUtil.setKeyValue(json, "packcnt", "1");
            JSONObjectUtil.setKeyValue(json, "packIdx", "1");
            JSONObjectUtil.setKeyValue(json, "data", sdkResult.getData());
            JSONObjectUtil.setKeyValue(json, "sn", sn);
            String devJson = this.admsCacheManager.getDeviceInfo(sn);
            JSONObjectUtil.setKeyValue(json, "commType", JSONObjectUtil.getValueByKey(devJson, "CommType"));
            Object deviceType = JSONObjectUtil.getValueByKey(devJson, "DeviceType");
            if (deviceType.equals("acc")) {
                this.admsCacheManager.cacheQueryData(sn, json.toString());
            } else if (deviceType.equals("ele")) {
                this.admsCacheManager.cacheEleQueryData(sn, json.toString());
            }
        }
        return sdkResult;
    }

    private int getNeedMemory(Long hcommpro, String tableName) {
        int memory = 0x800000;
        if (tableName.equalsIgnoreCase("templatev10") || tableName.equalsIgnoreCase("FACE") || tableName.equalsIgnoreCase("facev7") || tableName.equalsIgnoreCase("fvtemplate")) {
            SdkResult sdkResult = this.admsSdkService.getDeviceDataCount(hcommpro.longValue(), tableName, "", "");
            long count = sdkResult.getResult();
            if (count > 0L) {
                if (tableName.equalsIgnoreCase("templatev10")) {
                    memory = (int)((double)count * 2.3 * 1024.0) + 100;
                } else if (tableName.equalsIgnoreCase("FACE")) {
                    memory = (int)count * 2 * 15 * 1024 + 100;
                } else if (tableName.equalsIgnoreCase("facev7")) {
                    memory = (int)count * 2 * 15 * 1024 + 100;
                } else if (tableName.equalsIgnoreCase("fvtemplate")) {
                    memory = (int)count * 1 * 3 * 1024 + 100;
                }
            }
        } else if (tableName.equalsIgnoreCase("user")) {
            memory = 0x1200000;
        }
        return memory;
    }

    private SdkResult getDevOption(Long hcommpro, String sn, String cmdId, String cmdStr) {
        String[] paramStr = cmdStr.split(" ");
        String optItem = paramStr[2];
        byte[] callbackResult = new byte[2048];
        SdkResult sdkResult = this.admsSdkService.getDeviceParam(hcommpro.longValue(), callbackResult, optItem.trim());
        if (sdkResult.getResult() >= 0L) {
            String data = sdkResult.getData();
            Map<String, String> devOptions = DeviceDataUtil.formateStrToMap(data.trim(), ",");
            this.admsDeviceService.updateDeviceOptions(sn, devOptions, "options", cmdId);
        }
        return sdkResult;
    }

    private SdkResult getDevDataCount(Long hcommpro, String sn, String cmdId, String cmdStr) {
        String[] paramStr = cmdStr.split(" ");
        String tableName = paramStr[2];
        SdkResult sdkResult = this.admsSdkService.getDeviceDataCount(hcommpro.longValue(), tableName, "", "");
        if (sdkResult.getResult() >= 0L) {
            HashMap<String, String> devOptions = new HashMap<String, String>();
            devOptions.put(tableName, String.valueOf(sdkResult.getResult()));
            this.admsDeviceService.updateDeviceOptions(sn, devOptions, "count", cmdId);
        }
        return sdkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SdkResult upgradeFirmware(Long hcommpro, String cmdStr) {
        SdkResult ret = new SdkResult();
        BufferedInputStream bufferedInPutStream = null;
        StringBuffer buffer = new StringBuffer();
        try {
            String[] paramStr = cmdStr.split(",");
            String fileUrl = paramStr[1].split("=")[1].replace("*", ":").replace("\\", "/");
            if (fileUrl.contains("emfw.cfg")) {
                int fileSize = Integer.parseInt(paramStr[2].split("=")[1].trim());
                bufferedInPutStream = new BufferedInputStream(new URL(fileUrl).openStream());
                byte[] tempbytes = new byte[5120];
                int cursor = 0;
                while ((cursor = bufferedInPutStream.read(tempbytes)) != -1) {
                    buffer.append(new String(tempbytes, 0, cursor, "UTF-8"));
                }
                ret = this.admsSdkService.setDeviceFileData(hcommpro.longValue(), "emfw.cfg", buffer.toString(), fileSize, "");
            } else {
                ret.setResult((long)Integer.parseInt("-25"));
            }
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        finally {
            try {
                buffer = null;
                if (bufferedInPutStream != null) {
                    bufferedInPutStream.close();
                }
            }
            catch (IOException e) {
                this.log.error("exception", (Throwable)e);
            }
        }
        return ret;
    }

    class rs485PullDevMonitor
    extends Thread {
        private Map<String, AdmsAccPullDeviceItem> pullDeviceItemMap;

        public rs485PullDevMonitor() {
            super("rs485PullDevMonitor");
            this.pullDeviceItemMap = new HashMap<String, AdmsAccPullDeviceItem>();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Set<String> allRs485CacheKeySet;
                    while ((allRs485CacheKeySet = PullProcessor.this.admsCacheManager.getAllRs485CacheKeySet()) != null && allRs485CacheKeySet.size() > 0) {
                        for (String key : allRs485CacheKeySet) {
                            Set<String> sns = PullProcessor.this.admsCacheManager.getRs485Device(key);
                            if (!Objects.nonNull(sns) || sns.size() <= 0) continue;
                            this.updateCacheRs485ByKey(key, sns);
                            for (String sn : sns) {
                                AdmsAccPullDeviceItem admsAccPullDeviceItem = this.pullDeviceItemMap.get(sn);
                                if (admsAccPullDeviceItem == null) {
                                    admsAccPullDeviceItem = new AdmsAccPullDeviceItem();
                                }
                                if (!PullProcessor.this.admsCacheManager.getDevEnabledState(sn)) {
                                    PullProcessor.this.log.debug("Device has been disabled :" + sn);
                                    Thread.sleep(5000L);
                                    continue;
                                }
                                long hcommpro = 0L;
                                if (admsAccPullDeviceItem.isConnected()) {
                                    PullProcessor.this.admsCacheManager.updateDevHeartbeat(sn);
                                    PullProcessor.this.processCmd(admsAccPullDeviceItem.getHcommpro(), sn);
                                    Thread.sleep(1500L);
                                    if (!PullProcessor.this.admsCacheManager.getDevEnabledState(sn)) {
                                        PullProcessor.this.log.debug("Device has been disabled :" + sn);
                                        continue;
                                    }
                                    hcommpro = PullProcessor.this.getRtLog(admsAccPullDeviceItem.getHcommpro(), sn);
                                    this.setConnected(sn, hcommpro);
                                } else {
                                    hcommpro = PullProcessor.this.connect(sn);
                                    this.setConnected(sn, hcommpro);
                                    if (hcommpro > 0L) {
                                        PullProcessor.this.admsCacheManager.updateDevHeartbeat(sn);
                                    } else {
                                        admsAccPullDeviceItem = this.pullDeviceItemMap.get(sn);
                                        if (Objects.nonNull(admsAccPullDeviceItem)) {
                                            hcommpro = admsAccPullDeviceItem.getHcommpro();
                                        }
                                        PullProcessor.this.admsSdkService.disconnect(hcommpro);
                                        Thread.sleep(5000L);
                                    }
                                }
                                Thread.sleep(1000L);
                            }
                        }
                    }
                    if (this.pullDeviceItemMap.size() > 0) {
                        for (AdmsAccPullDeviceItem admsAccPullDeviceItem : this.pullDeviceItemMap.values()) {
                            PullProcessor.this.admsSdkService.disconnect(admsAccPullDeviceItem.getHcommpro());
                        }
                    }
                    return;
                }
                catch (Exception e) {
                    PullProcessor.this.log.error("PullDevMonitor Error:", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void setConnected(String sn, long hcommpro) {
            AdmsAccPullDeviceItem admsPullDeviceItem;
            if (Objects.isNull(this.pullDeviceItemMap)) {
                this.pullDeviceItemMap = new HashMap<String, AdmsAccPullDeviceItem>();
            }
            if (Objects.isNull(admsPullDeviceItem = this.pullDeviceItemMap.get(sn))) {
                admsPullDeviceItem = new AdmsAccPullDeviceItem();
            }
            admsPullDeviceItem.setSn(sn);
            admsPullDeviceItem.setConnected(hcommpro > 0L);
            if (hcommpro > 0L) {
                admsPullDeviceItem.setHcommpro(hcommpro);
            }
            this.pullDeviceItemMap.put(sn, admsPullDeviceItem);
        }

        private void updateCacheRs485ByKey(String key, Set<String> sns) {
            for (String monitorSn : sns) {
                if (PullProcessor.this.admsCacheManager.hasDeviceInfo(monitorSn)) continue;
                PullProcessor.this.admsCacheManager.delRs485Device(key, monitorSn);
                if (!Objects.nonNull(this.pullDeviceItemMap) || !this.pullDeviceItemMap.containsKey(monitorSn)) continue;
                PullProcessor.this.admsSdkService.disconnect(this.pullDeviceItemMap.get(monitorSn).getHcommpro());
                this.pullDeviceItemMap.remove(monitorSn);
            }
        }
    }

    class tcpIpPullDevMonitor
    extends Thread {
        private String sn;
        private long hcommpro = 0L;
        private boolean connected = false;

        public tcpIpPullDevMonitor(String sn) {
            this.sn = sn;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (!PullProcessor.this.admsCacheManager.hasDeviceInfo(this.sn)) {
                            PullProcessor.this.admsSdkService.disconnect(this.hcommpro);
                            return;
                        }
                        if (!PullProcessor.this.admsCacheManager.getDevEnabledState(this.sn)) {
                            PullProcessor.this.log.debug("Device has been disabled :" + this.sn);
                            Thread.sleep(5000L);
                            continue;
                        }
                        if (this.connected) {
                            PullProcessor.this.admsCacheManager.updateDevHeartbeat(this.sn);
                            PullProcessor.this.processCmd(this.hcommpro, this.sn);
                            Thread.sleep(1500L);
                            if (!PullProcessor.this.admsCacheManager.getDevEnabledState(this.sn)) {
                                PullProcessor.this.log.debug("Device has been disabled :" + this.sn);
                                continue;
                            }
                            this.hcommpro = PullProcessor.this.getRtLog(this.hcommpro, this.sn);
                            this.setConnected(this.hcommpro);
                        } else {
                            this.hcommpro = PullProcessor.this.connect(this.sn);
                            this.setConnected(this.hcommpro);
                            if (this.connected) {
                                PullProcessor.this.admsCacheManager.updateDevHeartbeat(this.sn);
                            } else {
                                PullProcessor.this.admsSdkService.disconnect(this.hcommpro);
                                Thread.sleep(5000L);
                            }
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception e) {
                    PullProcessor.this.log.error("PullDevMonitor Exception:" + this.sn, (Throwable)e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        PullProcessor.this.log.error("PullDevMonitor Sleep Exception1:" + this.sn, (Throwable)e1);
                    }
                    continue;
                }
                catch (Error e) {
                    PullProcessor.this.log.error("PullDevMonitor Error:" + this.sn, (Throwable)e);
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        PullProcessor.this.log.error("PullDevMonitor Sleep Exception2:" + this.sn, (Throwable)e2);
                        continue;
                    }
                }
                break;
            }
        }

        private void setConnected(long hcommpro) {
            this.hcommpro = hcommpro;
            this.connected = hcommpro > 0L;
        }
    }
}

