/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolTransactionRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolTransactionService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolTransactionController
extends ExportController
implements PatrolTransactionRemote {
    @Autowired
    private PatrolTransactionService patrolTransactionService;

    @RequiresPermissions(value={"patrol:transaction"})
    public ModelAndView index() {
        return new ModelAndView("patrol/transaction/patrolTransaction");
    }

    @RequiresPermissions(value={"patrol:transaction:edit"})
    public ZKResultMsg save(PatrolTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.patrolTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"patrol:transaction:refresh"})
    public DxGrid list(PatrolTransactionItem condition) {
        Pager pager = this.patrolTransactionService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"patrol:transaction:del"})
    public ZKResultMsg del(String ids) {
        this.patrolTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"patrol:transaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PatrolTransactionItem patrolTransactionItem = new PatrolTransactionItem();
        this.setConditionValue((BaseItem)patrolTransactionItem);
        List intemList = this.patrolTransactionService.getItemData(PatrolTransactionItem.class, (BaseItem)patrolTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, PatrolTransactionItem.class);
    }
}

