/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.license.init;

import com.zkteco.zkbiosecurity.auth.provider.AuthInitDataProvider;
import com.zkteco.zkbiosecurity.base.utils.SystemOsUtil;
import com.zkteco.zkbiosecurity.dll.LibraryService;
import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleCode;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.vo.IModuleAuth;
import com.zkteco.zkbiosecurity.license.vo.LicenseCheckInnerInvoke;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class LicenseInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(LicenseInit.class);
    @Autowired
    private AuthInitDataProvider authInitDataProvider;
    @Autowired(required=false)
    private IModuleAuth[] moduleAuths;
    @Value(value="${system.language:zh_CN}")
    private String language;
    @Value(value="${system.installDate}")
    private String installDate;
    @Value(value="${system.key}")
    private String systemKey;
    @Value(value="${system.devMode}")
    private String devMode;
    @Value(value="${system.productCode}")
    private String productCode;
    @Value(value="${system.oem}")
    private String systemOem;
    @Value(value="${system.trialDays:}")
    private String trialDays;
    @Autowired
    private LibraryService libraryService;
    @Autowired(required=false)
    private LicenseCheckInnerInvoke[] licenseCheckInnerInvoke;
    @Autowired(required=false)
    private BaseLicenseProvider baseLicenseProvider;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;

    public void run(String ... args) throws Exception {
        ModuleCode.installDate = this.installDate;
        ModuleCode.language = this.language;
        ModuleCode.systemKey = this.systemKey;
        ModuleCode.devMode = this.devMode;
        ModuleCode.productCode = this.productCode;
        ModuleCode.systemOem = this.systemOem;
        ModuleCode.trialDays = this.trialDays;
        if (SystemOsUtil.isWindow()) {
            this.libraryService.loadLibrary("license/zklicclient");
        } else if (SystemOsUtil.isLinux()) {
            this.libraryService.loadLibrary("zklicclient");
        }
        LicenseUtil.initLicense((IModuleAuth[])this.moduleAuths);
        LicenseUtil.licenseCheckExpired((LicenseCheckInnerInvoke[])this.licenseCheckInnerInvoke);
        this.launchWebsocket();
    }

    private void launchWebsocket() {
        String licenseId = this.baseLicenseProvider.getLicenseId();
        if (StringUtils.isNotBlank((CharSequence)licenseId)) {
            this.baseLicenseClientService.reconnectionWebsocket();
        } else {
            log.info("LicenseId is null,so can not start  cloud websocket!");
        }
    }
}

