/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.acc.constants.AccConstants;
import com.zkteco.zkbiosecurity.acc.remote.AccDeviceRemote;
import com.zkteco.zkbiosecurity.acc.service.AccBaseDictionaryService;
import com.zkteco.zkbiosecurity.acc.service.AccDSTimeService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceOptionService;
import com.zkteco.zkbiosecurity.acc.service.AccDeviceService;
import com.zkteco.zkbiosecurity.acc.service.AccDoorService;
import com.zkteco.zkbiosecurity.acc.service.AccLevelService;
import com.zkteco.zkbiosecurity.acc.service.AccParamService;
import com.zkteco.zkbiosecurity.acc.service.AccReaderService;
import com.zkteco.zkbiosecurity.acc.vo.AccAuthorizeChildDevItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDSTimeItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceExportItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceOptionItem;
import com.zkteco.zkbiosecurity.acc.vo.AccDeviceParamItem;
import com.zkteco.zkbiosecurity.acc.vo.AccHepParamItem;
import com.zkteco.zkbiosecurity.acc.vo.AccQueryDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccReaderItem;
import com.zkteco.zkbiosecurity.acc.vo.AccSearchAddDeviceItem;
import com.zkteco.zkbiosecurity.acc.vo.AccSearchDeviceItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.constants.BaseConstants;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.IpUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccDeviceController
extends ExportController
implements AccDeviceRemote {
    @Autowired
    private AccDeviceService accDeviceService;
    @Autowired
    private AccParamService accParamService;
    @Autowired
    private AccDeviceOptionService accDeviceOptionService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AccBaseDictionaryService accBaseDictionaryService;
    @Autowired
    private AccDSTimeService accDSTimeService;
    @Autowired
    private AccReaderService accReaderService;
    @Autowired
    private AccDoorService accDoorService;
    @Autowired
    private AccLevelService accLevelService;
    @Value(value="${adms.push.port:8088}")
    private int hostPort;
    @Value(value="${server.port:8098}")
    private int serverPort;
    @Value(value="${security.require-ssl:false}")
    private String isSupportHttps;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    @Value(value="${system.productCode}")
    private String productCode;
    private static final String DEV_UPGRADEFIRMWARE_FILENAME = "emfw.cfg";
    private static final String READER_UPGRADEFIRMWARE_FILENAME = "reader.bin";
    private static final int defWaitCount = 5;
    private static final int maxWaitCount = 12;

    @RequiresPermissions(value={"acc:device"})
    public ModelAndView index() {
        return new ModelAndView("acc/device/accDevice");
    }

    @RequiresPermissions(value={"acc:device:edit"})
    public ModelAndView edit(String id) {
        this.request.setAttribute("accParams", (Object)this.accParamService.getAccParams());
        this.request.setAttribute("persParams", (Object)this.accParamService.getPersParams());
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccDeviceItem accDeviceItem = this.accDeviceService.getItemById(id);
            if (Objects.nonNull(accDeviceItem)) {
                if (accDeviceItem.getMachineType() == 40) {
                    accDeviceItem.setAcpanelType(AccConstants.ACPANEL_1_DOOR);
                }
                if (this.accDeviceOptionService.isSupportFun(accDeviceItem.getSn(), "MachineTZFunOn")) {
                    this.request.setAttribute("supportTimeZone", (Object)1);
                }
                this.request.setAttribute("masterSlave", (Object)this.accDeviceOptionService.getMasterSlave(accDeviceItem.getSn()));
                if (StringUtils.isNotBlank((CharSequence)accDeviceItem.getWgReaderId())) {
                    String readerName = "";
                    AccReaderItem accReader = this.accReaderService.getItemById(accDeviceItem.getWgReaderId());
                    if (Objects.nonNull(accReader)) {
                        readerName = accReader.getName();
                    }
                    this.request.setAttribute("readerName", (Object)readerName);
                }
            }
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("tempAccDevice", (Object)accDeviceItem);
        }
        return new ModelAndView("acc/device/editAccDevice");
    }

    @RequiresPermissions(value={"acc:device:edit"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_op_edit", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg save(AccDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (item.getFourToTwo() == null) {
            item.setFourToTwo(Boolean.valueOf(false));
        }
        if (StringUtils.isEmpty((CharSequence)item.getId())) {
            String acpanelOptions = this.request.getParameter("acpanelOptions");
            String accLevelId = this.request.getParameter("levelId");
            String clearAllData = this.request.getParameter("clearAllData");
            AccSearchAddDeviceItem tempInfo = new AccSearchAddDeviceItem();
            tempInfo.setLevelId(accLevelId);
            if (clearAllData != null) {
                tempInfo.setClearAllData("true");
            }
            this.accDeviceService.addPullDevice(item, acpanelOptions, tempInfo);
        } else {
            AccReaderItem accReaderItem;
            AccDeviceItem oldDev = this.accDeviceService.getItemById(item.getId());
            if (StringUtils.isNotBlank((CharSequence)(item = this.accDeviceService.saveItem(item)).getWgReaderId()) && !item.getWgReaderId().equals(oldDev.getWgReaderId()) && Objects.nonNull(accReaderItem = this.accReaderService.getItemById(item.getWgReaderId()))) {
                List delLevelIdList = this.accLevelService.getLevelByDevId(item.getId());
                List doorIdList = this.accDoorService.getIdByDevId(item.getId());
                List addLevelIdList = this.accLevelService.getLevelIdByDoorId(accReaderItem.getDoorId());
                if (Objects.nonNull(delLevelIdList) && !delLevelIdList.isEmpty() && Objects.nonNull(addLevelIdList) && !addLevelIdList.isEmpty()) {
                    ArrayList retainList = new ArrayList();
                    retainList.addAll(delLevelIdList);
                    retainList.retainAll(addLevelIdList);
                    if (!retainList.isEmpty()) {
                        delLevelIdList.removeAll(retainList);
                        addLevelIdList.removeAll(retainList);
                    }
                }
                if (Objects.nonNull(delLevelIdList) && !delLevelIdList.isEmpty()) {
                    delLevelIdList.forEach(delLevelId -> this.accLevelService.immeDelLevelDoor(delLevelId, doorIdList));
                }
                if (Objects.nonNull(addLevelIdList) && !addLevelIdList.isEmpty()) {
                    addLevelIdList.forEach(addLevelId -> this.accLevelService.addLevelDoor(addLevelId, doorIdList));
                    this.accLevelService.issuedDownloadToDev("levelType", StringUtils.join((Iterable)addLevelIdList, (String)","));
                }
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:device:refresh"})
    public DxGrid list(AccDeviceItem condition) {
        Pager pager = this.accDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:device:del"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_op_del", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg del(String ids) {
        this.accDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:device:export"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AccDeviceExportItem accDeviceItem = new AccDeviceExportItem();
        this.setConditionValue((BaseItem)accDeviceItem);
        String areaIds = this.accDeviceService.getAreaIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)areaIds)) {
            accDeviceItem.setAreaIdIn(areaIds);
        }
        List accDeviceItemList = this.accDeviceService.getExportItemList(accDeviceItem, this.getBeginIndex(), this.getEndIndex());
        HashMap commTypeValue = Maps.newHashMap();
        HashMap netConnectModeValue = Maps.newHashMap();
        HashMap ableValue = Maps.newHashMap();
        commTypeValue.put("1", "TCP/IP");
        commTypeValue.put("2", "RS485");
        commTypeValue.put("3", "HTTP");
        netConnectModeValue.put("0", I18nUtil.i18nCode((String)"acc_dev_netModeWired", (Object[])new Object[0]));
        netConnectModeValue.put("1", I18nUtil.i18nCode((String)"acc_dev_netMode4G", (Object[])new Object[0]));
        netConnectModeValue.put("2", I18nUtil.i18nCode((String)"acc_dev_netModeWifi", (Object[])new Object[0]));
        ableValue.put("0", I18nUtil.i18nCode((String)"common_offline", (Object[])new Object[0]));
        ableValue.put("1", I18nUtil.i18nCode((String)"common_online", (Object[])new Object[0]));
        ableValue.put("2", I18nUtil.i18nCode((String)"common_disable", (Object[])new Object[0]));
        Map authAreaMap = this.accDeviceService.getAuthAreaByDev(accDeviceItemList);
        accDeviceItemList.stream().forEach(item -> {
            if (item.getAuthAreaId() != null) {
                item.setAuthAreaName((String)authAreaMap.get(item.getAuthAreaId()));
            }
            item.setCommType((String)commTypeValue.get(item.getCommType()));
            item.setConnectState((String)ableValue.get(this.accDeviceService.getStatus(item.getSn())));
            if ("0".equals(item.getIsRegistrationDevice()) || "f".equals(item.getIsRegistrationDevice())) {
                item.setIsRegistrationDevice(I18nUtil.i18nCode((String)"common_no", (Object[])new Object[0]));
            } else {
                item.setIsRegistrationDevice(I18nUtil.i18nCode((String)"common_yes", (Object[])new Object[0]));
            }
            if (item.getComPort() != null && item.getComAddress() != null) {
                String rs485Param = String.format("COM%s(%s) %s", item.getComPort(), item.getComAddress(), item.getBaudrate());
                item.setRs485Param(rs485Param);
            }
            String NetConnectMode = this.accDeviceOptionService.getValueByNameAndDevSn(item.getSn(), "NetConnectMode");
            item.setNetConnectMode((String)netConnectModeValue.get(NetConnectMode));
        });
        this.excelExport(accDeviceItemList, AccDeviceExportItem.class);
    }

    public boolean isExistByAlias(String alias) {
        AccDeviceItem accDeviceItem = new AccDeviceItem();
        accDeviceItem.setAlias(alias);
        return this.accDeviceService.getByCondition(accDeviceItem).size() <= 0;
    }

    public ZKResultMsg getAllIPSn() {
        JSONObject devInfoJson = new JSONObject();
        List accDeviceItemList = this.accDeviceService.getByCondition(new AccDeviceItem());
        JSONArray ipArray = new JSONArray();
        JSONArray snArray = new JSONArray();
        accDeviceItemList.stream().forEach(item -> {
            ipArray.add((Object)item.getIpAddress());
            snArray.add((Object)item.getSn());
        });
        devInfoJson.put("ipAddress", (Object)ipArray);
        devInfoJson.put("sn", (Object)snArray);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    @RequiresPermissions(value={"acc:device:searchDev"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_searchDev", opContent="common_dev_searchDev")
    public ZKResultMsg searchDev(Long nowTime) {
        JSONObject devInfoJson = new JSONObject();
        try {
            List deviceItems = this.accDeviceService.searchDeviceList();
            devInfoJson.put("ret", (Object)"ok");
            devInfoJson.put("devCount", (Object)deviceItems.size());
            JSONArray jsonArray = new JSONArray();
            ArrayList macList = Lists.newArrayList();
            for (AccSearchDeviceItem item : deviceItems) {
                JSONObject rowData = new JSONObject();
                rowData.put("IP", (Object)item.getIp());
                if (item.getMacAddress() != null && !"".equals(item.getMacAddress())) {
                    if (macList.contains(item.getMacAddress())) {
                        rowData.put("exception", (Object)(I18nUtil.i18nCode((String)"common_dev_macAddress", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_duplicateData", (Object[])new Object[0])));
                    } else {
                        rowData.put("MAC", (Object)item.getMacAddress());
                        macList.add(item.getMacAddress());
                    }
                }
                rowData.put("NetMask", (Object)item.getSubnetMask());
                rowData.put("GATEIPAddress", (Object)item.getGateway());
                if (StringUtils.isNotBlank((CharSequence)item.getSn())) {
                    rowData.put("SN", (Object)item.getSn());
                } else {
                    rowData.put("exception", (Object)I18nUtil.i18nCode((String)"common_dev_snNull", (Object[])new Object[0]));
                }
                rowData.put("Device", (Object)item.getDeviceName());
                rowData.put("Authorize", (Object)item.getAuthFlag());
                rowData.put("Protype", (Object)item.getProtype());
                rowData.put("ModeType", (Object)item.getModeType());
                rowData.put("IsSupportSSL", (Object)item.getIsSupportSSL());
                rowData.put("DNSFunOn", (Object)item.getDnsFunOn());
                if (item.getDns() != null) {
                    rowData.put("DNS", (Object)item.getDns());
                }
                if (item.getServerUrl() != null) {
                    rowData.put("WebServerURL", (Object)item.getServerUrl());
                }
                if (item.getIsSupportMultiCard() != null) {
                    rowData.put("isSupportMultiCard", (Object)item.getIsSupportMultiCard().toString());
                }
                if (item.getMaxMCUCardBits() != null) {
                    rowData.put("MaxMCUCardBits", (Object)item.getMaxMCUCardBits());
                }
                if (item.getMachineType() != null) {
                    rowData.put("MachineType", (Object)item.getMachineType());
                }
                if (item.getSubControlOn() != null) {
                    rowData.put("SubControlOn", (Object)item.getSubControlOn());
                }
                if (item.getMasterControlOn() != null) {
                    rowData.put("MasterControlOn", (Object)item.getMasterControlOn());
                }
                if (item.getRegDeviceType() != null) {
                    rowData.put("RegDeviceType", (Object)item.getRegDeviceType());
                }
                jsonArray.add((Object)rowData);
            }
            devInfoJson.put("devData", (Object)jsonArray);
            devInfoJson.put("nowTime", (Object)nowTime);
            devInfoJson.put("isSupportHttps", (Object)this.isSupportHttps);
            devInfoJson.put("hostAddress", (Object)InetAddress.getLocalHost().getHostAddress());
            devInfoJson.put("hostPort", (Object)this.hostPort);
        }
        catch (Exception e) {
            this.log.error("search dev error", (Throwable)e);
            throw new ZKBusinessException((Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    @RequiresPermissions(value={"acc:device:searchDev"})
    public ModelAndView getSearchDevInfo() {
        this.request.setAttribute("accParams", (Object)this.accParamService.getAccParams());
        this.request.setAttribute("persParams", (Object)this.accParamService.getPersParams());
        this.request.setAttribute("hostPort", (Object)this.hostPort);
        return new ModelAndView("acc/device/opAccSearchDev");
    }

    @RequiresPermissions(value={"acc:device:updateMThreshold"})
    public ModelAndView getDevMThresholdInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    @RequiresPermissions(value={"acc:device:updateIpAddr"})
    public ModelAndView getDevIPAddressInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    @RequiresPermissions(value={"acc:device:updateCommPwd"})
    public ModelAndView getDevCommPwdInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    @RequiresPermissions(value={"acc:device:updateNetConnectMode"})
    public ModelAndView getDevNetConnectModeInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    @RequiresPermissions(value={"acc:device:addChildDevice"})
    public ModelAndView addChildDeviceInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    @RequiresPermissions(value={"acc:device:modParentDevice"})
    public ModelAndView modParentDeviceInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    @RequiresPermissions(value={"acc:device:configParentDevice"})
    public ModelAndView configParentDeviceInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    @RequiresPermissions(value={"acc:device:setDevIOState"})
    public ModelAndView getDevIOStateInfo(String ids, String type) {
        return this.getById(ids, type);
    }

    private ModelAndView getById(String id, String type) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AccDeviceItem accDeviceItem = this.accDeviceService.getItemById(id);
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("tempAccDevice", (Object)accDeviceItem);
            if (StringUtils.isNotBlank((CharSequence)type)) {
                AccDeviceOptionItem devOpt;
                String status;
                if (accDeviceItem != null && !(status = this.accDeviceService.getStatus(accDeviceItem.getSn())).equals(String.valueOf(1))) {
                    this.request.setAttribute("failedReason", (Object)status);
                    return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
                }
                if (type.equals("updateIpAddr")) {
                    if (this.accDeviceOptionService.isSupportFunList(accDeviceItem.getSn(), 28)) {
                        this.request.setAttribute("isSupportDualCard", (Object)true);
                        devOpt = this.accDeviceOptionService.getDevOptValueBySnAndName(accDeviceItem.getSn(), "IPAddress1");
                        if (devOpt != null) {
                            this.request.setAttribute(devOpt.getName(), (Object)devOpt.getValue());
                        }
                        if ((devOpt = this.accDeviceOptionService.getDevOptValueBySnAndName(accDeviceItem.getSn(), "NetMask1")) != null) {
                            this.request.setAttribute(devOpt.getName(), (Object)devOpt.getValue());
                        }
                        if ((devOpt = this.accDeviceOptionService.getDevOptValueBySnAndName(accDeviceItem.getSn(), "GATEIPAddress1")) != null) {
                            this.request.setAttribute(devOpt.getName(), (Object)devOpt.getValue());
                        }
                    }
                    return new ModelAndView("acc/device/opAccUpdateIpAddr");
                }
                if (type.equals("updateCommPwd")) {
                    boolean isExistOldPwd = true;
                    if (accDeviceItem.getMachineType().equals((short)101)) {
                        this.request.setAttribute("isSupportChar", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
                        if (accDeviceItem.getCommPwd() == null || "".equals(accDeviceItem.getCommPwd()) || "0".equals(accDeviceItem.getCommPwd())) {
                            isExistOldPwd = false;
                        }
                    } else if (accDeviceItem.getCommPwd() == null || "".equals(accDeviceItem.getCommPwd())) {
                        isExistOldPwd = false;
                    }
                    this.request.setAttribute("isExistOldPwd", (Object)isExistOldPwd);
                    return new ModelAndView("acc/device/opAccUpdateCommPwd");
                }
                if (type.equals("updateMThreshold")) {
                    boolean supportUpdateMThreshold = this.accDeviceOptionService.isSupportFun(accDeviceItem.getSn(), "FingerFunOn");
                    if ("TF1700".equals(accDeviceItem.getDeviceName()) || accDeviceItem.getMachineType() != 101 && !this.accDeviceOptionService.isSupportFun(accDeviceItem.getSn(), "~IsOnlyRFMachine")) {
                        supportUpdateMThreshold = true;
                    }
                    if (!supportUpdateMThreshold || accDeviceItem.getMachineType() == 40) {
                        this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
                        return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
                    }
                    String mThreshold = "";
                    AccDeviceOptionItem accDeviceOpt = this.accDeviceOptionService.getDevOptValueBySnAndName(accDeviceItem.getSn(), "MThreshold");
                    if (accDeviceOpt != null) {
                        mThreshold = accDeviceOpt.getValue();
                    }
                    this.request.setAttribute("mThreshold", (Object)mThreshold);
                    return new ModelAndView("acc/device/opAccUpdateMThreshold");
                }
                if (type.equals("updateNetConnectMode")) {
                    AccDeviceOptionItem devOpt2;
                    boolean isSupportWifi = this.accDeviceOptionService.getAccSupportFunListVal(accDeviceItem.getId(), 24);
                    boolean isSupport4G = this.accDeviceOptionService.getAccSupportFunListVal(accDeviceItem.getId(), 25);
                    if (!isSupportWifi && !isSupport4G) {
                        this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
                        return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
                    }
                    this.request.setAttribute("isSupportWifi", (Object)isSupportWifi);
                    this.request.setAttribute("isSupport4G", (Object)isSupport4G);
                    int netConnectMode = Integer.parseInt(this.accDeviceOptionService.getValueByNameAndDevSn(accDeviceItem.getSn(), "NetConnectMode"));
                    if (2 == netConnectMode && (devOpt2 = this.accDeviceOptionService.getDevOptValueBySnAndName(accDeviceItem.getSn(), "WirelessSSID")) != null) {
                        this.request.setAttribute("wirelessSSID", (Object)devOpt2.getValue());
                    }
                    this.request.setAttribute("netConnectMode", (Object)netConnectMode);
                    return new ModelAndView("acc/device/opAccUpdateNetConnectMode");
                }
                if ("configParentDevice".equals(type) || "modParentDevice".equals(type)) {
                    this.request.setAttribute("type", (Object)type);
                    devOpt = this.accDeviceOptionService.getDevOptValueBySnAndName(accDeviceItem.getSn(), "WebServerURL");
                    if (Objects.nonNull(devOpt)) {
                        this.request.setAttribute("webServerURL", (Object)devOpt.getValue());
                    }
                    return new ModelAndView("acc/device/opAccConfigParentDev");
                }
                if ("queryAuthorizeList".equals(type)) {
                    long cmdId = this.accDeviceService.queryAuthorizeListFromDev(accDeviceItem.getId());
                    this.request.setAttribute("cmdId", (Object)cmdId);
                    this.request.setAttribute("devId", (Object)accDeviceItem.getId());
                    return new ModelAndView("acc/device/opAccDeviceAuthorize");
                }
                if ("setDevIOState".equals(type)) {
                    devOpt = this.accDeviceOptionService.getDevOptValueBySnAndName(accDeviceItem.getSn(), "Reader1IOState");
                    if (devOpt == null || accDeviceItem.getMachineType() != 101) {
                        this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
                        return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
                    }
                    this.request.setAttribute("devId", (Object)accDeviceItem.getId());
                    this.request.setAttribute("devIOState", (Object)devOpt.getValue());
                    return new ModelAndView("acc/device/opAccSetDevIOState");
                }
            }
        }
        return null;
    }

    public ZKResultMsg validPushDevCount(String sn, String machineType) {
        ZKResultMsg resultMsg = this.accDeviceService.validPushDevCount(sn, machineType);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg modifyIPAddress(AccSearchAddDeviceItem item) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String mac = item.getMac();
        String door4ToDoor2 = item.getDoor4ToDoor2();
        String options = "";
        if (item.getType().equals("devIP") || item.getType().equals("")) {
            String newIP = item.getNewIP();
            String ip = IpUtil.getLocalIpAddr((HttpServletRequest)this.request);
            List ipList = IpUtil.getAllIPAddr();
            if (newIP.equals(ip) || ipList.contains(newIP)) {
                resultMsg.setRet("500");
                resultMsg.setMsg("acc_dev_addDevIpTip");
                return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
            }
            String subnetMask = item.getSubnetMask();
            String gateway = item.getGateway();
            String commPwd = item.getCommPwd() != null ? item.getCommPwd() : "";
            options = String.format("MAC=%s,ComPwd=%s,IPAddress=%s,GATEIPAddress=%s,NetMask=%s,Reboot=1", mac, commPwd, newIP, gateway, subnetMask);
        } else {
            String webServerIP = item.getWebServerIP();
            String webServerPort = item.getWebServerPort();
            String newPwd = item.getNewPwd();
            String newWebServerType = item.getNewWebServerType();
            String newDNS = item.getNewDNS();
            String newWebServerURL = item.getNewWebServerURL();
            String isSupportSSL = item.getIsSupportSSL();
            options = StringUtils.isNotBlank((CharSequence)newWebServerType) && newWebServerType.equals("2") ? (this.isSupportHttps.equals("true") ? String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,DNS=%s,WebServerURLModel=1", mac, newPwd, "https://" + newWebServerURL + ":" + webServerPort, newDNS) : String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,DNS=%s,WebServerURLModel=1", mac, newPwd, "http://" + newWebServerURL + ":" + webServerPort, newDNS)) : (this.isSupportHttps.equals("true") ? String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,WebServerURLModel=1", mac, newPwd, "https://" + webServerIP + ":" + webServerPort) : (isSupportSSL.equals("true") ? String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,WebServerURLModel=1", mac, newPwd, "http://" + webServerIP + ":" + webServerPort) : String.format("MAC=%s,ComPwd=%s,WebServerIP=%s,WebServerPort=%s,WebServerURLModel=0", mac, newPwd, webServerIP, webServerPort)));
            if (StringUtils.isNotBlank((CharSequence)door4ToDoor2)) {
                options = options + ",Door4ToDoor2=" + door4ToDoor2;
            }
            if (StringUtils.isNotBlank((CharSequence)options)) {
                options = options + ",Reboot=1";
            }
        }
        String msgStr = "acc_dev_rebootAfterOperate";
        int ret = this.accDeviceService.modifyDeviceOptions(options);
        if (ret < 0) {
            msgStr = "devIP".equals(item.getType()) && "-14".equals(String.valueOf(ret)) ? "common_dev_modifyAndCommPwdError" : ("webServerIP".equals(item.getType()) && "-14".equals(String.valueOf(ret)) ? "common_commStatus_commPwdError" : this.accBaseDictionaryService.getCommReason(ret));
            if ("".equals(msgStr)) {
                msgStr = I18nUtil.i18nCode((String)"common_unknown", (Object[])new Object[0]);
            }
            resultMsg.setRet("pwdError");
            resultMsg.setMsg(msgStr);
        } else if ("webServerIP".equals(item.getType())) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                this.log.error(e.getMessage());
            }
            this.accDeviceService.authDevice(item.getSn(), item);
            resultMsg.setMsg(msgStr);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"acc:device:enable"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_enable", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg setDevEnable(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        this.accDeviceService.setDevEnable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"acc:device:disable"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_disable", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg setDevDisable(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        this.accDeviceService.setDevDisable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"acc:device:syncAllData"})
    public ModelAndView getDevIdsBySyncData(String ids, String type) {
        if (type != null && !type.isEmpty()) {
            List list = this.accDeviceService.getItemByIds(ids);
            StringBuffer devName = new StringBuffer("");
            StringBuffer disabledDevName = new StringBuffer("");
            AccDeviceItem dev = null;
            StringBuffer retIds = new StringBuffer();
            HashMap<String, StringBuffer> devNameMap = new HashMap<String, StringBuffer>();
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                dev = (AccDeviceItem)list.get(i);
                short machineType = dev.getMachineType();
                if (this.accDeviceService.isEnabled(dev.getSn())) {
                    retIds.append(dev.getId()).append(",");
                    String devTypeName = (String)AccConstants.MACHINETYPE_DEVTYPE.get(machineType);
                    if (devTypeName == null) {
                        devTypeName = (String)AccConstants.MACHINETYPE_DEVTYPE.get(AccConstants.DEVICE_CONTROL);
                    }
                    if (devNameMap.containsKey(devTypeName)) {
                        ((StringBuffer)devNameMap.get(devTypeName)).append(dev.getAlias() + "&" + dev.getId() + ",");
                        continue;
                    }
                    StringBuffer devNameBuf = new StringBuffer(devTypeName + "-" + I18nUtil.i18nCode((String)((String)AccConstants.DEV_NAME_MAP.get(devTypeName)), (Object[])new Object[0]) + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                    devNameMap.put(devTypeName, devNameBuf);
                    continue;
                }
                disabledDevName.append(dev.getAlias() + ",");
            }
            for (StringBuffer nameBuf : devNameMap.values()) {
                devName.append(nameBuf.substring(0, nameBuf.length() - 1) + ";");
            }
            this.request.setAttribute("devIds", retIds.length() > 0 ? retIds.substring(0, retIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
            this.request.setAttribute("disabledDevName", disabledDevName.length() > 0 ? disabledDevName.substring(0, disabledDevName.length() - 1) : null);
            if ("syncAllData".equals(type)) {
                return new ModelAndView("acc/device/opAccSyncAllData");
            }
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:upgradeFirmware"})
    public ModelAndView getDevIdsByUpgradeFirmware(String type, String checkOffline, String ids) {
        if (type != null && !type.isEmpty()) {
            List list = this.accDeviceService.getItemByIds(ids);
            HashMap<String, String> devNameMap = new HashMap<String, String>();
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer offlineDevName = new StringBuffer("");
            StringBuffer supportDevFun = new StringBuffer("");
            AccDeviceItem dev = null;
            StringBuffer retIds = new StringBuffer();
            HashMap<String, String> regExMap = new HashMap<String, String>();
            regExMap.put("(?i)(Inbio)(1|2|4)60", "InBioX60");
            regExMap.put("(?i)(Inbio)(2|4)80", "InBioX80");
            regExMap.put("(?i)(C)3-(1|2|4)00", "C3");
            regExMap.put("(?i)(K)2-(1|2|4)00", "K2");
            regExMap.put("^F20", "F20");
            regExMap.put("^TF2000", "TF2000");
            regExMap.put("^TA1200", "TA1200");
            regExMap.put("^FV300", "FV300");
            regExMap.put("^V300", "V300");
            for (int i = 0; i < list.size(); ++i) {
                String value;
                String name;
                dev = (AccDeviceItem)list.get(i);
                if (String.valueOf(1).equals(this.accDeviceService.getStatus(dev.getSn()))) {
                    value = name = dev.getDeviceName();
                    for (String regEx : regExMap.keySet()) {
                        if (!Pattern.compile(regEx).matcher(dev.getDeviceName()).find()) continue;
                        name = regEx;
                        value = (String)regExMap.get(regEx);
                        break;
                    }
                    retIds.append(dev.getId()).append(",");
                    devNameMap.put(name, value);
                    continue;
                }
                if (String.valueOf(2).equals(this.accDeviceService.getStatus(dev.getSn()))) {
                    disabledDevName.append(dev.getAlias()).append(",");
                } else if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
                    value = name = dev.getDeviceName();
                    devNameMap.put(name, value);
                } else {
                    offlineDevName.append(dev.getAlias()).append(",");
                }
                list.remove(i);
                --i;
            }
            StringBuffer devName = new StringBuffer("");
            boolean isNeed = false;
            for (String key : devNameMap.keySet()) {
                devName.append((String)devNameMap.get(key)).append(":");
                int innerLen = list.size();
                for (int j = 0; j < innerLen; ++j) {
                    if (!Pattern.compile(key).matcher(((AccDeviceItem)list.get(j)).getDeviceName()).find() && !key.equals(((AccDeviceItem)list.get(j)).getDeviceName()) || !String.valueOf(1).equals(this.accDeviceService.getStatus(((AccDeviceItem)list.get(j)).getSn()))) continue;
                    isNeed = true;
                    devName.append(((AccDeviceItem)list.get(j)).getAlias() + "&" + ((AccDeviceItem)list.get(j)).getId()).append(",");
                }
                if (isNeed) {
                    devName.append(";");
                    continue;
                }
                if (devName.indexOf(";") < 0) {
                    devName = new StringBuffer("");
                    continue;
                }
                devName.substring(0, devName.lastIndexOf(";") - 1);
            }
            this.request.setAttribute("retIds", (Object)(retIds.toString().equals("") ? "" : retIds.substring(0, retIds.length() - 1)));
            this.request.setAttribute("devicesName", (Object)(devName.toString().equals("") ? "" : devName.substring(0, devName.length() - 1)));
            this.request.setAttribute("disabledDevName", (Object)(disabledDevName.toString().equals("") ? "" : disabledDevName.substring(0, disabledDevName.length() - 1)));
            this.request.setAttribute("offlineDevName", (Object)(offlineDevName.toString().equals("") ? "" : offlineDevName.substring(0, offlineDevName.length() - 1)));
            this.request.setAttribute("supportDevFun", (Object)(supportDevFun.toString().equals("") ? "" : supportDevFun.substring(0, supportDevFun.toString().length() - 1)));
            if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
                this.request.setAttribute("checkOffline", (Object)checkOffline);
            }
            if ("upgradeFirmware".equals(type)) {
                return new ModelAndView("acc/device/opAccUpgradeFirmware");
            }
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:rebootDevice"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_reboot", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg rebootDevice(String ids) {
        String offline = "";
        ArrayList<String> rebootDevIdList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List devList = this.accDeviceService.getItemByIds(ids);
            for (AccDeviceItem dev : devList) {
                if (!String.valueOf(1).equals(this.accDeviceService.getStatus(dev.getSn()))) {
                    offline = offline + dev.getAlias() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ",";
                    continue;
                }
                rebootDevIdList.add(dev.getId());
            }
            this.accDeviceService.rebootDevice(rebootDevIdList, false);
            if (StringUtils.isNotBlank((CharSequence)offline)) {
                offline = offline.substring(0, offline.length() - 1);
                throw new ZKBusinessException(offline);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:device:getOptFromDev"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_getDevOpt", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg getOptFromDev(String ids) {
        StringBuffer failedDev = new StringBuffer("");
        ZKResultMsg resultMsg = new ZKResultMsg();
        String retStr = "ok";
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                List devList = this.accDeviceService.getItemByIds(ids);
                ArrayList<Long> cmdIdList = new ArrayList<Long>();
                HashMap<Long, String> cmdIdAndDevNameMap = new HashMap<Long, String>();
                for (AccDeviceItem dev : devList) {
                    if (!this.accDeviceService.getStatus(dev.getSn()).equals(String.valueOf(1))) {
                        failedDev.append(dev.getAlias() + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + "</br>");
                        retStr = "500";
                        resultMsg.setRet(retStr);
                        resultMsg.setMsg(failedDev.substring(0, failedDev.length() - 1));
                        continue;
                    }
                    long cmdIdTemp = 0L;
                    int optionCount = 3;
                    if (this.accDeviceService.isNewAccessControlDevice(dev.getMachineType().shortValue(), dev.getDeviceName())) {
                        optionCount = 4;
                    }
                    block3: for (int i = 1; i < optionCount; ++i) {
                        List cmdIds = this.accDeviceService.getOptFromDev(dev.getSn(), i);
                        Iterator iterator = cmdIds.iterator();
                        while (iterator.hasNext()) {
                            long cmdId = (Long)iterator.next();
                            if (cmdId < 0L) {
                                if (cmdIdTemp != 0L) {
                                    cmdIdList.remove(cmdIdTemp);
                                    cmdIdAndDevNameMap.remove(cmdIdTemp);
                                }
                                String describe = i == 1 ? I18nUtil.i18nCode((String)"acc_dev_baseOptionTip", (Object[])new Object[0]) : I18nUtil.i18nCode((String)"acc_dev_funOptionTip", (Object[])new Object[0]);
                                failedDev.append(dev.getAlias() + ":" + describe + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
                                retStr = "400";
                                resultMsg.setRet(retStr);
                                resultMsg.setMsg(I18nUtil.i18nCode((String)"acc_dev_sendComandoTip", (Object[])new Object[0]));
                                continue block3;
                            }
                            cmdIdTemp = cmdId;
                            cmdIdList.add(cmdId);
                            cmdIdAndDevNameMap.put(cmdId, dev.getAlias());
                        }
                    }
                }
                if (cmdIdList.size() > 0) {
                    Iterator iterator = cmdIdList.iterator();
                    while (iterator.hasNext()) {
                        long cmdId = (Long)iterator.next();
                        Map resultMap = this.accDeviceService.getCmdResultById(Long.valueOf(cmdId), 30);
                        if (!Objects.nonNull(resultMap)) continue;
                        Integer result = Integer.valueOf((String)resultMap.get("result"));
                        if (failedDev.indexOf((String)cmdIdAndDevNameMap.get(cmdId)) != -1) continue;
                        if (Objects.isNull(result)) {
                            failedDev.append((String)cmdIdAndDevNameMap.get(cmdId) + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + "<br>");
                            retStr = "400";
                            continue;
                        }
                        if (result >= 0) continue;
                        String failedInfo = this.accBaseDictionaryService.getCommReason(result.intValue());
                        failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                        failedDev.append((String)cmdIdAndDevNameMap.get(cmdId) + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "<br>");
                        retStr = "400";
                    }
                    if (retStr.equals("400")) {
                        resultMsg.setRet(retStr);
                        resultMsg.setMsg(I18nUtil.i18nCode((String)"common_dev_getDevOptFails", (Object[])new Object[0]));
                    }
                }
            }
        }
        catch (Exception e) {
            throw ZKBusinessException.errorException((String)I18nUtil.i18nCode((String)"common_dev_getDevOptFails", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg syncAllDataByDevType(String devType, String devId) {
        JSONArray dataArray = new JSONArray();
        LinkedHashSet<String> funcSet = new LinkedHashSet<String>();
        if ("CONTROL".equals(devType)) {
            funcSet = new LinkedHashSet(AccConstants.DEVICE_CONTROL_FUNCTION);
        } else if (!"FINGERVEIN".equals(devType)) {
            if ("ONEMACHINE".equals(devType)) {
                funcSet = new LinkedHashSet(AccConstants.DEVICE_ACCESS_FUNCTION);
            } else if ("WLOCK".equals(devType)) {
                funcSet = new LinkedHashSet(AccConstants.DEVICE_WIRELESS_LOCK_FUNCTION);
            }
        }
        List devList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)devId) && !devId.equals("undefined")) {
            devList = this.accDeviceService.getItemByIds(devId);
        }
        for (AccDeviceItem dev : devList) {
            if (this.accDeviceOptionService.isSupportFun(dev.getSn(), "~CardFormatFunOn")) {
                funcSet.add(AccConstants.AccSyncDataType.WIEGANDFMT.getValue());
            }
            if (this.accDeviceOptionService.isSupportFun(dev.getSn(), "OutRelaySetFunOn")) {
                funcSet.add(AccConstants.AccSyncDataType.OUTRELAYSET.getValue());
            }
            if ("ZKBioSecurity".equals(this.productCode) && dev.getCommType().equals((short)3) && dev.getMachineType() != 40) {
                funcSet.add(AccConstants.AccSyncDataType.BACKGROUNDVERIFYPARAM.getValue());
            }
            if (101 == dev.getMachineType() && !funcSet.contains(AccConstants.AccSyncDataType.FIRSTPERSON.getValue())) {
                funcSet.add(AccConstants.AccSyncDataType.FIRSTPERSON.getValue());
            }
            if (this.accDeviceOptionService.isSupportFunList(dev.getSn(), 8)) {
                funcSet.add(AccConstants.AccSyncDataType.AUXINSET.getValue());
            }
            if (!"ZKBioSecurity".equals(this.productCode) || !this.accDeviceOptionService.isSupportFunList(dev.getSn(), 12)) continue;
            funcSet.add(AccConstants.AccSyncDataType.VERIFYMODERULE.getValue());
        }
        if (funcSet.size() > 0) {
            for (String func : funcSet) {
                dataArray.add((Object)func);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)dataArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"acc:device:syncAllData"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_syncAllDataToDev", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg syncAllData(String devIds, String optBoxValue) {
        try {
            String[] optBox = optBoxValue.split(",");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            List devList = this.accDeviceService.getItemByIdsAndMoveUpParentDev(devIds);
            int size = devList.size();
            for (int i = 0; i < size; ++i) {
                AccDeviceItem dev = (AccDeviceItem)devList.get(i);
                int total = (int)((float)(i + 1) / (float)size * 100.0f);
                int lastTotal = (int)(((double)i + 0.3) / (double)size * 100.0);
                this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_syncPrompt", (Object[])new Object[0]) + "<br/>"));
                this.accDeviceService.syncDataToDev(dev.getSn(), optBox);
                List asWgReaderDevSnList = this.accDeviceService.getDevAsWGReaderByDevId(dev.getId());
                for (AccDeviceItem deviceItem : asWgReaderDevSnList) {
                    this.accDeviceService.syncDataToDev(deviceItem.getSn(), new String[]{AccConstants.AccSyncDataType.ACCLEVEL.getValue(), AccConstants.AccSyncDataType.TIMEZONEANDHOLIDAY.getValue()});
                }
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_syncSuccess", (Object[])new Object[0]) + "<br/>"));
            }
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_progress_syncAllDataTip", (Object[])new Object[0]));
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:syncTime"})
    public ModelAndView getDevSyncTimeInfo(String ids, String type, String checkOffline) {
        return this.getDevIds(ids, type, checkOffline);
    }

    @RequiresPermissions(value={"acc:device:uploadPersonInfo"})
    public ModelAndView getUploadPersonInfo(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            AccDeviceItem dev = this.accDeviceService.getItemById(ids);
            HashMap<String, String> devNameMap = new HashMap<String, String>();
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer offlineDevName = new StringBuffer("");
            StringBuffer supportDevFun = new StringBuffer("");
            StringBuffer retIds = new StringBuffer();
            if (String.valueOf(1).equals(this.accDeviceService.getStatus(dev.getSn()))) {
                if (dev.getParentDeviceId() != null) {
                    this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
                    return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
                }
                this.request.setAttribute("devicesName", (Object)(dev.getDeviceName() + ":" + dev.getAlias()));
                retIds.append(dev.getId());
                devNameMap.put(dev.getDeviceName(), dev.getDeviceName());
                AccDeviceOptionItem bioDataSupport = this.accDeviceOptionService.getDevOptValueBySnAndName(dev.getSn(), "MultiBioDataSupport");
                if (bioDataSupport != null) {
                    supportDevFun.append(bioDataSupport.getValue());
                } else {
                    String authority = "0";
                    AccDeviceOptionItem fingerFunOn = this.accDeviceOptionService.getDevOptValueBySnAndName(dev.getSn(), "FingerFunOn");
                    AccDeviceOptionItem isOnlyRFMachine = this.accDeviceOptionService.getDevOptValueBySnAndName(dev.getSn(), "~IsOnlyRFMachine");
                    if (fingerFunOn != null) {
                        authority = authority + ":" + fingerFunOn.getValue();
                    } else if (isOnlyRFMachine != null) {
                        authority = authority + ("1".equals(isOnlyRFMachine.getValue()) ? ":0" : ":1");
                    }
                    authority = this.accDeviceOptionService.isSupportFun(dev.getSn(), "BioPhotoFun") ? authority + ":0" : authority + (this.accDeviceOptionService.isSupportFun(dev.getSn(), "FaceFunOn") ? ":1" : ":0");
                    authority = authority + ":0:0:0:0";
                    authority = authority + (this.accDeviceOptionService.isSupportFun(dev.getSn(), "FvFunOn") ? ":1" : ":0");
                    authority = authority + (this.accDeviceOptionService.isSupportFun(dev.getSn(), "PvFunOn") ? ":1" : ":0");
                    authority = authority + (this.accDeviceOptionService.isSupportFun(dev.getSn(), "BioPhotoFun") ? ":1" : ":0");
                    supportDevFun.append(authority);
                }
            } else if (String.valueOf(2).equals(this.accDeviceService.getStatus(dev.getSn()))) {
                disabledDevName.append(dev.getAlias());
            } else {
                offlineDevName.append(dev.getAlias());
            }
            this.request.setAttribute("retIds", (Object)(retIds.toString().equals("") ? "" : retIds));
            this.request.setAttribute("disabledDevName", (Object)(disabledDevName.toString().equals("") ? "" : disabledDevName));
            this.request.setAttribute("offlineDevName", (Object)(offlineDevName.toString().equals("") ? "" : offlineDevName));
            this.request.setAttribute("supportDevFun", (Object)(supportDevFun.toString().equals("") ? "" : supportDevFun));
        }
        return new ModelAndView("acc/device/opAccUploadPersonInfo");
    }

    @RequiresPermissions(value={"acc:device:uploadTransaction"})
    public ModelAndView getUploadTransactionInfo(String ids, String type, String checkOffline) {
        return this.getDevIds(ids, type, checkOffline);
    }

    private ModelAndView getDevIds(String ids, String type, String checkOffline) {
        if (StringUtils.isNotBlank((CharSequence)ids) && StringUtils.isNotBlank((CharSequence)type)) {
            List list = this.accDeviceService.getItemByIds(ids);
            HashMap<String, String> devNameMap = new HashMap<String, String>();
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer warnInfoDevName = new StringBuffer("");
            StringBuffer offlineDevName = new StringBuffer("");
            StringBuffer supportDevFun = new StringBuffer("");
            AccDeviceItem dev = null;
            StringBuffer retIds = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                String name;
                dev = (AccDeviceItem)list.get(i);
                if (String.valueOf(1).equals(this.accDeviceService.getStatus(dev.getSn()))) {
                    name = dev.getDeviceName();
                    if (type.equals("uploadTransaction")) {
                        retIds.append(dev.getId()).append(",");
                        if (devNameMap.containsKey(name)) continue;
                        String isSupportAccount = "0";
                        devNameMap.put(name, name);
                        supportDevFun.append(name + ":" + isSupportAccount + ",");
                        continue;
                    }
                    if ("syncTime".equals(type) && dev.getParentDeviceId() != null) {
                        warnInfoDevName.append(dev.getAlias()).append(",");
                        continue;
                    }
                    retIds.append(dev.getId()).append(",");
                    devNameMap.put(name, name);
                    continue;
                }
                if (String.valueOf(2).equals(this.accDeviceService.getStatus(dev.getSn()))) {
                    disabledDevName.append(dev.getAlias()).append(",");
                } else if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
                    name = dev.getDeviceName();
                    devNameMap.put(name, name);
                } else {
                    offlineDevName.append(dev.getAlias()).append(",");
                }
                list.remove(i);
                --i;
            }
            StringBuffer devName = new StringBuffer("");
            boolean isNeed = false;
            for (String key : devNameMap.keySet()) {
                devName.append((String)devNameMap.get(key)).append(":");
                int innerLen = list.size();
                for (int j = 0; j < innerLen; ++j) {
                    if (!Pattern.compile(key).matcher(((AccDeviceItem)list.get(j)).getDeviceName()).find() && !key.equals(((AccDeviceItem)list.get(j)).getDeviceName()) || !String.valueOf(1).equals(this.accDeviceService.getStatus(((AccDeviceItem)list.get(j)).getSn()))) continue;
                    isNeed = true;
                    devName.append(((AccDeviceItem)list.get(j)).getAlias() + "&" + ((AccDeviceItem)list.get(j)).getId()).append(",");
                }
                if (isNeed) {
                    devName.append(";");
                    continue;
                }
                if (devName.indexOf(";") < 0) {
                    devName = new StringBuffer("");
                    continue;
                }
                devName.substring(0, devName.lastIndexOf(";") - 1);
            }
            this.request.setAttribute("retIds", (Object)(retIds.toString().equals("") ? "" : retIds.substring(0, retIds.length() - 1)));
            this.request.setAttribute("devicesName", (Object)(devName.toString().equals("") ? "" : devName.substring(0, devName.length() - 1)));
            this.request.setAttribute("disabledDevName", (Object)(disabledDevName.toString().equals("") ? "" : disabledDevName.substring(0, disabledDevName.length() - 1)));
            this.request.setAttribute("offlineDevName", (Object)(offlineDevName.toString().equals("") ? "" : offlineDevName.substring(0, offlineDevName.length() - 1)));
            this.request.setAttribute("warnInfoDevName", (Object)(warnInfoDevName.toString().equals("") ? "" : warnInfoDevName.substring(0, warnInfoDevName.length() - 1)));
            this.request.setAttribute("supportDevFun", (Object)(supportDevFun.toString().equals("") ? "" : supportDevFun.substring(0, supportDevFun.toString().length() - 1)));
            if (StringUtils.isNotBlank((CharSequence)checkOffline)) {
                this.request.setAttribute("checkOffline", (Object)checkOffline);
            }
            switch (type) {
                case "uploadTransaction": {
                    return new ModelAndView("acc/device/opAccUploadTransaction");
                }
                case "syncTime": {
                    return new ModelAndView("acc/device/opAccSyncTime");
                }
            }
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:issueBGVerifyParam"})
    public ModelAndView getDevIdsByIssueBgValid(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List accDeviceItemList = this.accDeviceService.getItemByIds(ids);
            String offlineRule = "";
            StringBuffer open = new StringBuffer("open:");
            StringBuffer close = new StringBuffer("close:");
            StringBuffer idsBuffer = new StringBuffer();
            StringBuffer devNameBuffer = new StringBuffer();
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer noSupportDevName = new StringBuffer("");
            StringBuffer offlineDevName = new StringBuffer("");
            for (AccDeviceItem dev : accDeviceItemList) {
                if (this.accDeviceOptionService.isSupportFun(dev.getSn(), "AutoServerFunOn") && dev.getMachineType() != 40) {
                    if (this.accDeviceService.getStatus(dev.getSn()).equals(String.valueOf(2))) {
                        disabledDevName.append(dev.getAlias() + ",");
                        continue;
                    }
                    if (this.accDeviceService.getStatus(dev.getSn()).equals(String.valueOf(1))) {
                        if (this.accDeviceOptionService.isSupportDevParam(dev.getSn(), "AutoServerMode")) {
                            close.append(dev.getAlias()).append("&").append(dev.getId()).append(",");
                            AccDeviceOptionItem accDeviceOptionItem = this.accDeviceOptionService.getDevOptValueBySnAndName(dev.getSn(), "ReaderOfflineRule");
                            if (Objects.nonNull(accDeviceOptionItem) && "".equals(offlineRule)) {
                                offlineRule = accDeviceOptionItem.getValue();
                            }
                        } else {
                            open.append(dev.getAlias()).append("&").append(dev.getId()).append(",");
                        }
                        idsBuffer.append(dev.getId()).append(",");
                        devNameBuffer.append(dev.getAlias()).append(",");
                        continue;
                    }
                    offlineDevName.append(dev.getAlias() + ",");
                    continue;
                }
                noSupportDevName.append(dev.getAlias() + ",");
            }
            if (idsBuffer.length() > 0) {
                this.request.setAttribute("ids", (Object)idsBuffer.substring(0, idsBuffer.length() - 1).toString());
                this.request.setAttribute("alias", (Object)devNameBuffer.substring(0, devNameBuffer.length() - 1).toString());
            }
            String ret = "";
            ret = open.length() > 6 ? open.substring(0, open.length() - 1) + ";" + close.substring(0, close.length() - 1) : close.substring(0, close.length() - 1) + ";" + open.substring(0, open.length() - 1);
            this.request.setAttribute("devicesName", (Object)ret);
            this.request.setAttribute("offlineRule", (Object)(StringUtils.isNotBlank((CharSequence)offlineRule) ? offlineRule : "0"));
            this.request.setAttribute("disabledDevName", disabledDevName.length() > 0 ? disabledDevName.substring(0, disabledDevName.length() - 1) : null);
            this.request.setAttribute("noSupportDevName", noSupportDevName.length() > 0 ? noSupportDevName.substring(0, noSupportDevName.length() - 1) : null);
            this.request.setAttribute("offlineDevName", offlineDevName.length() > 0 ? offlineDevName.substring(0, offlineDevName.length() - 1) : null);
            this.request.setAttribute("validity", (Object)(this.accDeviceService.checkIsSupportAdvancdacc() ? 1 : 0));
            return new ModelAndView("acc/device/opAccIssueVerifyParam");
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:issueBGVerifyParam"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_issueVerifyParam", requestParams={"devName"}, opContent="common_dev_name")
    public ZKResultMsg issueBGVerifyParam(String devIds, String verifyParam, String offlineRule) {
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            List accDeviceItemList = new ArrayList();
            HashMap<Long, AccDeviceItem> accDeviceItemMap = new HashMap<Long, AccDeviceItem>();
            if (StringUtils.isNotBlank((CharSequence)devIds)) {
                accDeviceItemList = this.accDeviceService.getItemByIds(devIds);
            }
            StringBuffer retCmdBuf = new StringBuffer();
            for (int i = 0; i < accDeviceItemList.size(); ++i) {
                AccDeviceItem dev = (AccDeviceItem)accDeviceItemList.get(i);
                long ret = this.accDeviceService.issueVerifyParamToDev(dev.getId(), verifyParam, offlineRule, true);
                if (ret > 0L) {
                    retCmdBuf.append(ret).append(",");
                    accDeviceItemMap.put(ret, dev);
                }
                int lastTotal = (i + 1) * (50 / accDeviceItemList.size());
                this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>" + I18nUtil.i18nCode((String)"common_dev_waitResults", (Object[])new Object[0]) + "<br/>"));
            }
            String[] cmdIdArray = retCmdBuf.toString().split(",");
            int cmdIdArrayLen = cmdIdArray.length;
            AccDeviceItem devItem = null;
            for (int index = 0; index < cmdIdArrayLen; ++index) {
                if (cmdIdArray[index].equals("")) continue;
                long cmdId = Long.parseLong(cmdIdArray[index]);
                int i = 1;
                int total = i * (50 / accDeviceItemList.size());
                Map reslutMap = this.accDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.nonNull(reslutMap)) {
                    Integer ret = Integer.parseInt((String)reslutMap.get("result"));
                    if (ret >= 0) {
                        devItem = (AccDeviceItem)accDeviceItemMap.get(cmdId);
                        this.progressCache.setProcess(new ProcessBean(100, total, devItem.getAlias() + ":" + I18nUtil.i18nCode((String)"acc_dev_verifyParamSuccess", (Object[])new Object[0]) + "<br/>"));
                        this.accDeviceOptionService.setDevOptValByName(devItem.getId(), "AutoServerMode", verifyParam);
                        this.accDeviceOptionService.setDevOptValByName(devItem.getId(), "ReaderOfflineRule", offlineRule);
                    } else {
                        String failedInfo = this.accBaseDictionaryService.getCommReason(ret.intValue());
                        failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : String.valueOf(ret);
                        this.progressCache.setProcess(new ProcessBean(100, total, I18nUtil.i18nCode((String)"acc_dev_getInfoFail", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "</br>"));
                    }
                } else {
                    this.progressCache.setProcess(new ProcessBean(100, total, I18nUtil.i18nCode((String)"acc_dev_getInfoFail", (Object[])new Object[0])));
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
        return null;
    }

    public ZKResultMsg checkVerifyParam(String verifyParam) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (!this.accDeviceService.checkIsSupportAdvancdacc() && verifyParam.equals(AccConstants.ENABLE.toString())) {
            resultMsg.setRet("500");
            resultMsg.setMsg(I18nUtil.i18nCode((String)"acc_validity_period", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg checkCombOpenDoor(String devIds) {
        String devAlias;
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devIds) && StringUtils.isNotBlank((CharSequence)(devAlias = this.accDeviceService.checkCombOpenDoor(devIds)))) {
            String msg = I18nUtil.i18nCode((String)"acc_dev_combOpenDoorTip", (Object[])new Object[]{devAlias.length() > 0 ? devAlias.substring(0, devAlias.length() - 1) : ""});
            resultMsg.setMsg(msg);
            resultMsg.setRet("hasBeenSetCombOpenDoor");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg isOnline(String deviceId) {
        List accDeviceItemList = this.accDeviceService.getItemByIds(deviceId);
        StringBuffer offLineAlias = new StringBuffer("");
        StringBuffer offLineIds = new StringBuffer("");
        JSONObject retJson = new JSONObject();
        for (AccDeviceItem dev : accDeviceItemList) {
            if (!this.accDeviceService.getStatus(dev.getSn()).equals(String.valueOf(0))) continue;
            offLineIds.append(dev.getId()).append(",");
            offLineAlias.append(dev.getAlias()).append(",");
        }
        retJson.put("ids", (Object)(offLineIds.length() > 0 ? offLineIds.substring(0, offLineIds.length() - 1) : offLineIds.toString()));
        retJson.put("alias", (Object)(offLineAlias.length() > 0 ? offLineAlias.substring(0, offLineAlias.length() - 1) : offLineAlias.toString()));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)retJson));
    }

    public boolean isExistIpAddress(String ipAddress) {
        return this.accDeviceService.isExistIpAddress(ipAddress);
    }

    public boolean isExistAlias(String alias) {
        return this.accDeviceService.isExistAlias(alias);
    }

    public boolean checkOperPwd(String operationPwd) {
        String checkPwd = DateUtil.dateToString((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYYMMDD);
        String key = this.accParamService.getParamValByName("acc.addDeviceOperKeyword");
        if ((this.encryKey(key) + this.sortStr(checkPwd)).equals(operationPwd)) {
            this.request.getSession().setAttribute("operationPwd", (Object)operationPwd);
            return true;
        }
        this.request.getSession().removeAttribute("operationPwd");
        return false;
    }

    private String encryKey(String key) {
        StringBuffer sb = new StringBuffer("");
        if (!"xxx".equals(key)) {
            String s = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            int index = 0;
            for (int i = 0; i < key.length(); ++i) {
                index = s.indexOf(key.charAt(i));
                sb.append((index + 1) % 10);
            }
        }
        return sb.toString();
    }

    private String sortStr(String str) {
        char[] s1 = str.toCharArray();
        for (int i = 0; i < s1.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (s1[i] >= s1[j]) continue;
                char temp = s1[i];
                s1[i] = s1[j];
                s1[j] = temp;
            }
        }
        return String.valueOf(s1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"acc:device:upgradeFirmware"})
    public ZKResultMsg upgradeFirmware(String devIds, MultipartFile devFile, String upgradeType, String devRadio) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devIds) && StringUtils.isNotBlank((CharSequence)upgradeType)) {
            String ret = "ok";
            try {
                this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
                List deviceItemList = this.accDeviceService.getItemByIds(devIds);
                this.progressCache.setProcess(new ProcessBean(100, 0, "<font color='black'>" + I18nUtil.i18nCode((String)"acc_dev_transferFilesTip", (Object[])new Object[0]) + "...</font><br/>"));
                File filePath = null;
                if (devFile.getName() != null && devFile != null) {
                    String fileName = "";
                    switch (upgradeType) {
                        case "device": {
                            fileName = DEV_UPGRADEFIRMWARE_FILENAME;
                            break;
                        }
                        case "reader": {
                            fileName = READER_UPGRADEFIRMWARE_FILENAME;
                        }
                    }
                    filePath = this.saveFile(devFile, fileName);
                }
                this.progressCache.setProcess(new ProcessBean(100, 45, "<font color='black'>" + I18nUtil.i18nCode((String)"common_dev_fileUploadSuccess", (Object[])new Object[0]) + "...</font><br/>"));
                List cmdIdList = this.accDeviceService.upgradeFirmware(devIds, filePath, "localhost", this.serverPort);
                this.progressCache.setProcess(new ProcessBean(100, 50, "<font color='black'>" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_upgrade", (Object[])new Object[0]) + "...</font><br/>"));
                if (StringUtils.isNotBlank((CharSequence)upgradeType) && !upgradeType.equals("device")) {
                    String string = I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
                    return string;
                }
                ArrayList<AccDeviceItem> successDevList = new ArrayList<AccDeviceItem>();
                ArrayList<String> devIdList = new ArrayList<String>();
                for (int index = 0; index < cmdIdList.size(); ++index) {
                    long cmdId = (Long)cmdIdList.get(index);
                    Map resultMap = this.accDeviceService.getCmdResultById(Long.valueOf(cmdId), 1800);
                    if (!Objects.nonNull(resultMap)) continue;
                    int total = 50 / deviceItemList.size() * (index + 1) + 30;
                    Integer result = Integer.parseInt((String)resultMap.get("result"));
                    AccDeviceItem dev = this.accDeviceService.getItemByDevSn((String)resultMap.get("sn"));
                    if (result >= 0) {
                        this.progressCache.setProcess(new ProcessBean(70, total, "<font color='black'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeSuccess", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_reboot", (Object[])new Object[0]) + "...</font><br/>"));
                        AccDeviceItem accDev = (AccDeviceItem)deviceItemList.get(index);
                        if (StringUtils.isNotBlank((CharSequence)accDev.getParentDeviceId())) {
                            successDevList.add(accDev);
                            devIdList.add(accDev.getId());
                            continue;
                        }
                        successDevList.add(dev);
                        devIdList.add(dev.getId());
                        continue;
                    }
                    String failedInfo = this.accBaseDictionaryService.getCommReason(result.intValue());
                    failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                    this.progressCache.setProcess(new ProcessBean(total + 20, total + 20, "<font color='red'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeFail", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "...</font><br/>"));
                }
                if (devIdList.size() > 0) {
                    this.accDeviceService.rebootDevice(devIdList, true);
                }
                if (successDevList.size() > 0) {
                    int count = 5;
                    for (int i = 1; i <= count; ++i) {
                        if (i == 12) {
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i, "<font color='black'>...</font><br/>"));
                            break;
                        }
                        if (i == 1) {
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i, "<font color='black'>" + I18nUtil.i18nCode((String)"common_devOpType_connect", (Object[])new Object[0]) + "...</font><br/>"));
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i, I18nUtil.i18nCode((String)"common_dev_dealTimeout", (Object[])new Object[]{3 + I18nUtil.i18nCode((String)"common_minutes", (Object[])new Object[0])}) + "<br/>"));
                        } else {
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i));
                            if (Short.parseShort(this.accDeviceService.getStatus(((AccDeviceItem)deviceItemList.get(0)).getSn())) != 1) {
                                ++count;
                            }
                        }
                        Thread.sleep(15000L);
                    }
                    for (AccDeviceItem dev : successDevList) {
                        this.progressCache.setProcess(new ProcessBean(85, 85, "<font color='black'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_devOpType_dataUpdate", (Object[])new Object[0]) + "...</font><br/>"));
                        int optionCount = 3;
                        if (this.accDeviceService.isNewAccessControlDevice(dev.getMachineType().shortValue(), dev.getDeviceName())) {
                            optionCount = 4;
                        }
                        for (int i = 1; i < optionCount; ++i) {
                            this.accDeviceService.getOptFromDev(dev.getSn(), i);
                        }
                        this.progressCache.setProcess(new ProcessBean(90, 90, "<font color='black'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeSuccess", (Object[])new Object[0]) + "</font><br/>"));
                    }
                }
            }
            catch (Exception e) {
                ret = "error";
                resultMsg.setRet(ret);
                resultMsg.setMsg("common_dev_upgradeFail");
                this.log.error("exception ", (Throwable)e);
            }
            finally {
                if (ret.equals("error")) {
                    this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"common_dev_upgradeFail", (Object[])new Object[0]) + "...</font><br/>");
                } else {
                    this.progressCache.finishProcess("<font color='black'>" + I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "</font><br/>");
                }
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    private File saveFile(MultipartFile devFile, String fileName) throws Exception {
        File file;
        String realPath = this.systemFilePath + "/upload/acc/firmware";
        File tempFile = new File(realPath);
        if (!tempFile.isAbsolute()) {
            realPath = ClassUtil.getRootPath() + "/" + realPath;
            tempFile = new File(realPath);
        }
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        if ((file = new File(realPath + "/" + fileName)).exists()) {
            file.delete();
        }
        devFile.transferTo(file);
        return file;
    }

    @RequiresPermissions(value={"acc:device:uploadPersonInfo"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_getPersonInfo", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg uploadPersonInfo(String devIds, String dataType, String tempClientId) {
        if (!tempClientId.equals(this.request.getSession().getAttribute("beforeClientId"))) {
            this.request.getSession().setAttribute("beforeClientId", (Object)tempClientId);
            if (dataType.equals("0")) {
                this.getPersonInfoFromDev(devIds);
            } else {
                this.uploadPersonInfoFromDev(devIds, dataType);
            }
        }
        return null;
    }

    private void uploadPersonInfoFromDev(String devIds, String dataType) {
        ArrayList devIdList = Lists.newArrayList((Object[])devIds.split(","));
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        ArrayList cmdIdList = Lists.newArrayList();
        String devId = null;
        Map dataMap = null;
        int total = 0;
        int devSize = devIdList.size();
        for (int i = 0; i < devSize; ++i) {
            devId = (String)devIdList.get(i);
            dataMap = this.accDeviceService.getPersonInfoFromDev(devId, dataType);
            if (dataMap.containsKey("cmdIds") && !((String)dataMap.get("cmdIds")).equals("")) {
                String[] cmdIdArray;
                String cmdIds = (String)dataMap.get("cmdIds");
                for (String cmdId : cmdIdArray = cmdIds.split(",")) {
                    cmdIdList.add(cmdId);
                }
            }
            this.progressCache.setProcess(new ProcessBean(100, total, (String)dataMap.get("devName") + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
        }
        ArrayList cmdIdArray = Lists.newArrayList((Iterable)cmdIdList);
        int ret = this.dealQueryDataFromRedis(cmdIdArray, 1800000, this.progressCache, false, false);
        if (ret == 0) {
            for (String cmdId : cmdIdList) {
                String key = "acc:queryConflictCard:" + cmdId;
                String conflictCard = this.accDeviceService.getQueryData(key);
                if ("".equals(conflictCard)) continue;
                String msg = I18nUtil.i18nCode((String)"acc_dev_conflictCardNo", (Object[])new Object[]{conflictCard});
                this.progressCache.setProcess(new ProcessBean(100, 99, "<font color='red'>" + msg + "</font><br/>"));
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        } else if (ret == -1) {
            this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"common_progress_getDataFailed", (Object[])new Object[0]) + "...</font><br/>");
        } else if (ret == 1) {
            this.progressCache.finishProcess("<font color='#E57A14'>" + I18nUtil.i18nCode((String)"common_progress_busyFailed", (Object[])new Object[0]) + "</font><br/>");
        }
    }

    private void getPersonInfoFromDev(String devId) {
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        AccDeviceItem accDeviceItem = this.accDeviceService.getItemById(devId);
        int cmdCount = 1;
        if (this.accDeviceOptionService.isSupportDevParam(accDeviceItem.getSn(), "UserOpenDoorDelayFunOn") || this.accDeviceOptionService.isSupportFunList(accDeviceItem.getSn(), 5)) {
            ++cmdCount;
        }
        if (this.accDeviceOptionService.isSupportFunList(accDeviceItem.getSn(), 7)) {
            ++cmdCount;
        }
        int everyProcess = 100 / cmdCount;
        int currentProcess = 0;
        int ret = 0;
        Long cmdId = this.accDeviceService.getAllPersonFromDev(accDeviceItem);
        this.progressCache.setProcess(new ProcessBean(100, currentProcess, I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
        ret = this.dealQueryDataFromRedis(cmdId, 900000, this.progressCache, currentProcess, currentProcess + everyProcess);
        if (ret == 0) {
            cmdId = this.accDeviceService.getAllPersonCardFromDev(accDeviceItem);
            if (cmdId != -1L) {
                this.progressCache.setProcess(new ProcessBean(100, currentProcess, I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
                this.dealQueryDataFromRedis(cmdId, 900000, this.progressCache, currentProcess += everyProcess, currentProcess + everyProcess);
            }
            if ((cmdId = this.accDeviceService.getAllPersonExtInfoFromDev(accDeviceItem)) != -1L) {
                this.progressCache.setProcess(new ProcessBean(100, currentProcess, I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
                this.dealQueryDataFromRedis(cmdId, 1800000, this.progressCache, currentProcess += everyProcess, currentProcess + everyProcess);
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
    }

    private int dealQueryDataFromRedis(Long cmdId, int timeout, ProgressCache dealRate, int currentProgress, int maxProgress) {
        int ret = 0;
        dealRate.setProcess(new ProcessBean(100, currentProgress, I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "<br/>"));
        try {
            int time;
            for (time = timeout; time > 0; time -= 4000) {
                int process = 0;
                String key = "acc:queryData:" + cmdId;
                String queryData = this.accDeviceService.getQueryData(key);
                if (!"".equals(queryData)) {
                    JSONObject tempJson = JSONObject.parseObject((String)queryData);
                    AccQueryDeviceItem dev = this.accDeviceService.getQueryItemBySn(tempJson.getString("sn"));
                    if (tempJson.containsKey((Object)"exception")) {
                        dealRate.setProcess(new ProcessBean(100, maxProgress, "<font color='red'>" + I18nUtil.i18nCode((String)"acc_dev_getInfoFail", (Object[])new Object[0]) + "</font><br/><font color='red'>" + I18nUtil.i18nCode((String)tempJson.getString("exception"), (Object[])new Object[0]) + "</font><br/>"));
                        this.accDeviceService.delQueryData(key);
                        break;
                    }
                    if (tempJson.getIntValue("packIdx") <= tempJson.getIntValue("packCnt")) {
                        if (tempJson.getIntValue("packCnt") != 0) {
                            process = (maxProgress - currentProgress) * tempJson.getIntValue("packIdx") / tempJson.getIntValue("packCnt");
                        }
                        process = (process += currentProgress) >= maxProgress ? maxProgress - 1 : process;
                        dealRate.setProcess(new ProcessBean(100, process));
                        if (tempJson.getIntValue("packCnt") == tempJson.getIntValue("packIdx")) {
                            String tableDesc = "";
                            if (tempJson.containsKey((Object)"table")) {
                                tableDesc = StringUtils.defaultString((String)I18nUtil.i18nCode((String)((String)this.accBaseDictionaryService.getBaseDictionaryMap("opType").get(tempJson.getString("table"))), (Object[])new Object[0]), (String)"");
                            }
                            StringBuffer desc = new StringBuffer("");
                            if (tempJson.getIntValue("packCnt") == 0) {
                                desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"acc_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>").append(" " + I18nUtil.i18nCode((String)"acc_dev_noData", (Object[])new Object[0]) + "<br/>");
                            } else if (Long.parseLong(tempJson.getString("count")) == 0L) {
                                desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"acc_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>");
                                if (tempJson.getString("table").equals("transaction")) {
                                    desc.append(" " + I18nUtil.i18nCode((String)"acc_dev_noNewData", (Object[])new Object[0]) + "<br/>");
                                } else {
                                    desc.append(" " + I18nUtil.i18nCode((String)"acc_dev_noData", (Object[])new Object[0]) + "<br/>");
                                }
                            } else {
                                desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"acc_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>").append(I18nUtil.i18nCode((String)"common_dev_getTotal", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("count"))).append(" " + I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0])).append("," + I18nUtil.i18nCode((String)"common_dev_duplicateData", (Object[])new Object[0])).append(" " + (Long.parseLong(tempJson.getString("count")) - Long.parseLong(tempJson.getString("update")) - Long.parseLong(tempJson.getString("insert")))).append(" " + I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + ",").append(I18nUtil.i18nCode((String)"common_dev_insertData", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("insert")) + " ").append(I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + ",").append(I18nUtil.i18nCode((String)"common_dev_updateData", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("update")) + " ").append(I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + "<br/>");
                            }
                            dealRate.setProcess(new ProcessBean(100, maxProgress, desc.toString()));
                            this.accDeviceService.delQueryData(key);
                            break;
                        }
                    }
                }
                Thread.sleep(4000L);
            }
            if (time <= 0) {
                ret = 1;
                dealRate.setProcess(new ProcessBean(100, maxProgress, "<font color='#E57A14'>" + I18nUtil.i18nCode((String)"common_progress_busyFailed", (Object[])new Object[0]) + "</font><br/>"));
            }
        }
        catch (Exception e) {
            ret = -1;
            dealRate.setProcess(new ProcessBean(100, maxProgress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_progress_getDataFailed", (Object[])new Object[0]) + "...</font><br/>"));
            this.log.error("exception ", (Throwable)e);
        }
        return ret;
    }

    private int dealQueryDataFromRedis(List<String> cmdIdList, int timeout, ProgressCache dealRate, boolean newLog, boolean isAccount) {
        int ret = 0;
        String key = null;
        AccQueryDeviceItem dev = null;
        int cmdLen = cmdIdList.size();
        int time = timeout;
        try {
            if (isAccount) {
                this.accDeviceService.dealAccountDataFromRedis(cmdIdList);
            }
            dealRate.setProcess(new ProcessBean(100, 0, I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "<br/>"));
            int everyProcess = 100 / cmdLen;
            while (time > 0 && cmdIdList.size() != 0) {
                for (int j = 0; j < cmdIdList.size(); ++j) {
                    key = "acc:queryData:" + cmdIdList.get(j);
                    String queryData = this.accDeviceService.getQueryData(key);
                    if ("".equals(queryData)) continue;
                    JSONObject tempJson = JSONObject.parseObject((String)queryData);
                    dev = this.accDeviceService.getQueryItemBySn(tempJson.getString("sn"));
                    int process = everyProcess * (cmdLen - cmdIdList.size());
                    if (dev != null) {
                        if (tempJson.containsKey((Object)"exception")) {
                            dealRate.setProcess(new ProcessBean(100, 99, "<font color='red'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"acc_dev_getInfoFail", (Object[])new Object[0]) + "</font><br/><font color='red'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)tempJson.getString("exception"), (Object[])new Object[0]) + "</font><br/>"));
                            this.accDeviceService.delQueryData(key);
                            cmdIdList.remove(j);
                            continue;
                        }
                        if (tempJson.getIntValue("packIdx") > tempJson.getIntValue("packCnt")) continue;
                        if (tempJson.getIntValue("packCnt") != 0) {
                            process = everyProcess * (cmdLen - cmdIdList.size()) + everyProcess * tempJson.getIntValue("packIdx") / tempJson.getIntValue("packCnt");
                        }
                        process = process == 100 ? process - 1 : process;
                        dealRate.setProcess(new ProcessBean(100, process));
                        if (tempJson.getIntValue("packCnt") != tempJson.getIntValue("packIdx")) continue;
                        String tableDesc = "";
                        if (tempJson.containsKey((Object)"table")) {
                            tableDesc = StringUtils.defaultString((String)I18nUtil.i18nCode((String)((String)this.accBaseDictionaryService.getBaseDictionaryMap("opType").get(tempJson.getString("table"))), (Object[])new Object[0]), (String)"");
                        }
                        StringBuffer desc = new StringBuffer("");
                        if (tempJson.getIntValue("packCnt") == 0) {
                            desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"acc_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>").append(" " + I18nUtil.i18nCode((String)"acc_dev_noData", (Object[])new Object[0]) + "<br/>");
                        } else if (Long.parseLong(tempJson.getString("count")) == 0L) {
                            desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"acc_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>");
                            if (tempJson.getString("table").equals("transaction")) {
                                desc.append(" " + I18nUtil.i18nCode((String)"acc_dev_noNewData", (Object[])new Object[0]) + "<br/>");
                            } else {
                                desc.append(" " + I18nUtil.i18nCode((String)"acc_dev_noData", (Object[])new Object[0]) + "<br/>");
                            }
                        } else {
                            desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"acc_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>").append(I18nUtil.i18nCode((String)"common_dev_getTotal", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("count"))).append(" " + I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0])).append("," + I18nUtil.i18nCode((String)"common_dev_duplicateData", (Object[])new Object[0])).append(" " + (Long.parseLong(tempJson.getString("count")) - Long.parseLong(tempJson.getString("update")) - Long.parseLong(tempJson.getString("insert")))).append(" " + I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + ",").append(I18nUtil.i18nCode((String)"common_dev_insertData", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("insert")) + " ").append(I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + ",").append(I18nUtil.i18nCode((String)"common_dev_updateData", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("update")) + " ").append(I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + "<br/>");
                        }
                        dealRate.setProcess(new ProcessBean(100, process, desc.toString()));
                        this.accDeviceService.delQueryData(key);
                        cmdIdList.remove(j);
                        continue;
                    }
                    dealRate.setProcess(new ProcessBean(100, process, "<font color='red'>" + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]) + ", SN=" + tempJson.getString("sn") + "</font><br/>"));
                    this.accDeviceService.delQueryData(key);
                    cmdIdList.remove(j);
                }
                Thread.sleep(4000L);
                time -= 4000;
            }
            if (time <= 0) {
                ret = 1;
            }
        }
        catch (Exception e) {
            ret = -1;
            this.log.error("exception ", (Throwable)e);
        }
        return ret;
    }

    @RequiresPermissions(value={"acc:device:uploadTransaction"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_getTrans", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg uploadTransaction(String devIds, String records) {
        String[] devIdArray;
        boolean newLog = "1".equals(records);
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        ArrayList<String> cmdIdList = new ArrayList<String>();
        int total = 0;
        for (String devId : devIdArray = devIds.split(",")) {
            Integer ret;
            Long cmdId;
            Map resultMap;
            if (this.accDeviceOptionService.getAccSupportFunListVal(devId, 30) && Objects.nonNull(resultMap = this.accDeviceService.getCmdResultById(cmdId = this.accDeviceService.getIdentityCardInfo(devId), 20)) && (ret = Integer.valueOf((String)resultMap.get("result"))) < 0) continue;
            Map devDataMap = this.accDeviceService.uploadTransaction(devId, records);
            cmdIdList.addAll(Lists.newArrayList((Object[])((String)devDataMap.get("cmdId")).split(",")));
            this.progressCache.setProcess(new ProcessBean(100, total, (String)devDataMap.get("alias") + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
        }
        int ret = this.dealQueryDataFromRedis(cmdIdList, 3600000, this.progressCache, newLog, "3".equals(records));
        if (ret == 0) {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        } else if (ret == -1) {
            this.progressCache.finishProcess("<font color='red'>" + I18nUtil.i18nCode((String)"common_commStatus_getEventFailed", (Object[])new Object[0]) + "...</font><br/>");
        } else if (ret == 1) {
            this.progressCache.finishProcess("<font color='#E57A14'>" + I18nUtil.i18nCode((String)"common_progress_busyFailed", (Object[])new Object[0]) + "</font><br/>");
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:syncTime"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_syncTime", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg syncTime(String devIds) {
        List accDeviceItemList;
        if (StringUtils.isNotBlank((CharSequence)devIds) && (accDeviceItemList = this.accDeviceService.getItemByIds(devIds)) != null && !accDeviceItemList.isEmpty()) {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            StringBuffer cmdIdBuf = new StringBuffer();
            HashMap devDataMap = Maps.newHashMap();
            AccDeviceItem dev = null;
            int len = accDeviceItemList.size();
            for (int i = 0; i < len; ++i) {
                dev = (AccDeviceItem)accDeviceItemList.get(i);
                int total = (int)((double)(i + 1) * 0.5 / (double)accDeviceItemList.size() * 100.0);
                long cmdId = this.accDeviceService.syncTime(dev.getSn());
                cmdIdBuf.append(cmdId).append(",");
                devDataMap.put(cmdId, dev.getAlias());
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + " : " + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "...<br/>"));
            }
            this.progressCache.setProcess(new ProcessBean(10, 50, I18nUtil.i18nCode((String)"common_dev_syncTime", (Object[])new Object[0]) + "...<br/>"));
            int j = 1;
            String[] cmdIdArray = cmdIdBuf.toString().split(",");
            int cmdIdArrayLen = cmdIdArray.length;
            for (int index = 0; index < cmdIdArrayLen; ++index) {
                if (cmdIdArray[index].equals("") || Long.parseLong(cmdIdArray[index]) <= 0L) continue;
                long cmdId = Long.parseLong(cmdIdArray[index]);
                int total = (int)(((double)j * 0.5 + 1.0) / (double)accDeviceItemList.size() * 100.0);
                Map resultMap = this.accDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                String alias = (String)devDataMap.get(cmdId);
                if (Objects.nonNull(resultMap)) {
                    Integer ret = Integer.valueOf((String)resultMap.get("result"));
                    if (ret >= 0) {
                        this.progressCache.setProcess(new ProcessBean(100, total, alias + ":" + I18nUtil.i18nCode((String)"common_dev_syncTimeSuccess", (Object[])new Object[0]) + "...<br/>"));
                    } else {
                        String failedInfo = StringUtils.isNotBlank((CharSequence)this.accBaseDictionaryService.getCommReason(ret.intValue())) ? I18nUtil.i18nCode((String)this.accBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]) : ret.toString();
                        this.progressCache.setProcess(new ProcessBean(100, total, alias + ":" + I18nUtil.i18nCode((String)"common_dev_syncTimeFail", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "...<br/>"));
                    }
                } else {
                    this.progressCache.setProcess(new ProcessBean(100, total, alias + ":" + I18nUtil.i18nCode((String)"common_dev_syncTimeFail", (Object[])new Object[0]) + "...<br/>"));
                }
                ++j;
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return null;
    }

    public ZKResultMsg isExistsIp(String id, String ipAddress) {
        boolean isExist = true;
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            isExist = this.accDeviceService.isExistsIp(id, ipAddress);
        }
        resultMsg.setData((Object)isExist);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg isExistsSecondIp(String id, String newIp) {
        boolean isExist = true;
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            isExist = this.accDeviceService.isExistsSecondIp(id, newIp);
        }
        resultMsg.setData((Object)isExist);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"acc:device:updateIpAddr"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_modifyIPAddress", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateIpAddr(String devId, String ipAddress, String subnetMask, String gateway, String ipAddressSec, String netMaskSec, String gateIPAddressSec) {
        Map resultMap;
        Long cmdId;
        Map resultMap2;
        ZKResultMsg resultMsg = new ZKResultMsg();
        String msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]);
        Integer ret = null;
        int result = -1;
        AccDeviceItem device = this.accDeviceService.getItemById(devId);
        Long updateIpAddrCmdId = this.accDeviceService.updateIpAddr(devId, ipAddress, subnetMask, gateway);
        if (updateIpAddrCmdId != null && updateIpAddrCmdId > 0L && Objects.nonNull(resultMap2 = this.accDeviceService.getCmdResultById(updateIpAddrCmdId, 20))) {
            result = Integer.parseInt((String)resultMap2.get("result"));
        }
        if (result < 0) {
            throw new ZKBusinessException("400", "common_op_failed");
        }
        device.setIpAddress(ipAddress);
        device.setSubnetMask(subnetMask);
        device.setGateway(gateway);
        this.accDeviceService.saveAccDevice(device);
        this.accDeviceService.updateAdmsDevIpAddr(device.getSn(), ipAddress, subnetMask, gateway);
        this.accDeviceService.updateDevIpAddrForOtherModule(device.getSn(), ipAddress);
        if (this.accDeviceOptionService.getAccSupportFunListVal(devId, 28) && (cmdId = this.accDeviceService.updateIpAddrEx(devId, ipAddressSec, netMaskSec, gateIPAddressSec, "")) != null && cmdId > 0L && Objects.nonNull(resultMap = this.accDeviceService.getCmdResultById(cmdId, 20))) {
            ret = Integer.valueOf((String)resultMap.get("result"));
            if (ret >= 0) {
                this.accDeviceOptionService.setDevOptValByName(devId, "IPAddress1", ipAddressSec);
                this.accDeviceOptionService.setDevOptValByName(devId, "GATEIPAddress1", gateIPAddressSec);
                this.accDeviceOptionService.setDevOptValByName(devId, "NetMask1", netMaskSec);
                if (device.getMachineType() == 40) {
                    this.accDeviceOptionService.setDevOptValByName(devId, "ServerCommIP", ipAddressSec);
                }
            } else {
                String failedInfo = StringUtils.isNotBlank((CharSequence)this.accBaseDictionaryService.getCommReason(ret.intValue())) ? I18nUtil.i18nCode((String)this.accBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]) : ret.toString();
                msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo;
                throw new ZKBusinessException("400", msgStr);
            }
        }
        this.accDeviceService.rebootDevice((List)Lists.newArrayList((Object[])new String[]{devId}), false);
        resultMsg.setMsg("acc_dev_rebootAfterOperate");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"acc:device:setRegistrationDevice"})
    public ModelAndView getDevIdsBySetRegistrationDevice(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            AccDeviceItem accDeviceItem = this.accDeviceService.getItemById(ids);
            if (accDeviceItem.getMachineType() != 101 || Short.valueOf(accDeviceItem.getCommType()) != 3) {
                this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
                return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
            }
            this.request.setAttribute("isRegistrationDevice", (Object)accDeviceItem.getIsRegistrationDevice());
            this.request.setAttribute("alias", (Object)accDeviceItem.getAlias());
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("devId", (Object)ids);
            return new ModelAndView("acc/device/opAccSetRegistrationDevice");
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:setRegistrationDevice"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_setRegistrationDevice", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg setRegistrationDevice(String devId, String isRegistrationSel) {
        if (StringUtils.isNotBlank((CharSequence)devId) && StringUtils.isNotBlank((CharSequence)isRegistrationSel)) {
            boolean isRegist = Boolean.valueOf(isRegistrationSel);
            this.accDeviceService.setRegistrationDevice(devId, isRegist);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:device:queryDevRule"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_accessRules", requestParams={"alias"}, opContent="common_dev_name")
    public ModelAndView queryDevRule(String ids) {
        AccDeviceItem tempDev = this.accDeviceService.getItemById(ids);
        if (tempDev.getMachineType() == 40) {
            this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
            return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
        }
        List ruleList = this.accDeviceService.queryDevRule(ids);
        this.request.setAttribute("ruleList", (Object)ruleList);
        return new ModelAndView("acc/device/opAccQueryDevRule");
    }

    @RequiresPermissions(value={"acc:device:queryDevUsage"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_queryDevVolume", requestParams={"alias"}, opContent="common_dev_name")
    public ModelAndView queryDevUsage(String ids) {
        List retList = this.accDeviceService.queryDevInfo(ids);
        this.request.setAttribute("retList", (Object)retList);
        StringBuffer devIds = new StringBuffer();
        for (List list : retList) {
            if (list.get(8) == null || list.get(8) != "") continue;
            devIds.append((String)list.get(7) + ",");
        }
        if (devIds.length() > 0) {
            this.request.setAttribute("devIds", (Object)devIds.substring(0, devIds.length() - 1));
        } else {
            this.request.setAttribute("getAll", (Object)"disabled='disabled'");
        }
        return new ModelAndView("acc/device/opAccQueryDevUsage");
    }

    @RequiresPermissions(value={"acc:device:queryDevUsage"})
    public ZKResultMsg getDevUsage(String devId) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject retObject = new JSONObject();
        JSONObject userJson = new JSONObject();
        JSONObject fingerJson = new JSONObject();
        JSONObject fvJson = new JSONObject();
        JSONObject faceJson = new JSONObject();
        JSONObject bioPhotoJson = new JSONObject();
        JSONObject palmJson = new JSONObject();
        JSONObject faceBiodataJson = new JSONObject();
        fingerJson.put(devId, (Object)"false");
        fvJson.put(devId, (Object)"false");
        faceJson.put(devId, (Object)"false");
        bioPhotoJson.put(devId, (Object)"false");
        faceBiodataJson.put(devId, (Object)"false");
        palmJson.put(devId, (Object)"false");
        retObject.put("id", (Object)devId);
        AccDeviceItem dev = this.accDeviceService.getItemById(devId);
        Map cmdMap = this.accDeviceService.getDevUserAndTempCounts(devId);
        String fingerVersion = this.accDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~ZKFPVersion");
        AccDeviceOptionItem maxMultiBioPhotoCount = this.accDeviceOptionService.getDevOptValueBySnAndName(dev.getSn(), "MaxMultiBioPhotoCount");
        AccDeviceOptionItem maxMultiBioDataCount = this.accDeviceOptionService.getDevOptValueBySnAndName(dev.getSn(), "MaxMultiBioDataCount");
        String fvVersion = "";
        String faceVersion = "";
        String pvVersion = "";
        String vislightFaceVersion = "";
        Map devOptionMap = this.accDeviceOptionService.getDevOptionBySn(dev.getSn());
        if (devOptionMap.containsKey("MultiBioVersion")) {
            String multiBioVersion = (String)devOptionMap.get("MultiBioVersion");
            String[] multiBioVersionAry = multiBioVersion.split(":");
            if (multiBioVersionAry != null) {
                fingerVersion = multiBioVersionAry[BaseConstants.BaseBioType.FP_BIO_TYPE].equals("0") ? "" : multiBioVersionAry[BaseConstants.BaseBioType.FP_BIO_TYPE];
                fvVersion = multiBioVersionAry[BaseConstants.BaseBioType.VEIN_BIO_TYPE].equals("0") ? "" : multiBioVersionAry[BaseConstants.BaseBioType.VEIN_BIO_TYPE];
                faceVersion = multiBioVersionAry[BaseConstants.BaseBioType.FACE_BIO_TYPE].equals("0") ? "" : multiBioVersionAry[BaseConstants.BaseBioType.FACE_BIO_TYPE];
                pvVersion = multiBioVersionAry[BaseConstants.BaseBioType.PALM_BIO_TYPE].equals("0") ? "" : multiBioVersionAry[BaseConstants.BaseBioType.PALM_BIO_TYPE];
                vislightFaceVersion = multiBioVersionAry[BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE].equals("0") ? "" : multiBioVersionAry[BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE];
            }
        } else {
            if (devOptionMap.containsKey("FvVersion")) {
                fvVersion = (String)devOptionMap.get("FvVersion");
            }
            if (devOptionMap.containsKey("FaceVersion")) {
                faceVersion = (String)devOptionMap.get("FaceVersion");
            }
            if (devOptionMap.containsKey("PvVersion")) {
                pvVersion = (String)devOptionMap.get("PvVersion");
            }
        }
        fingerVersion = StringUtils.isNotBlank((CharSequence)fingerVersion) && fingerVersion.indexOf(".") != -1 ? fingerVersion : fingerVersion + ".0";
        fvVersion = StringUtils.isNotBlank((CharSequence)fvVersion) && fvVersion.indexOf(".") != -1 ? fvVersion : fvVersion + ".0";
        faceVersion = StringUtils.isNotBlank((CharSequence)faceVersion) && faceVersion.indexOf(".") != -1 ? faceVersion : faceVersion + ".0";
        pvVersion = StringUtils.isNotBlank((CharSequence)pvVersion) && pvVersion.indexOf(".") != -1 ? pvVersion : pvVersion + ".0";
        vislightFaceVersion = StringUtils.isNotBlank((CharSequence)vislightFaceVersion) && vislightFaceVersion.indexOf(".") != -1 ? vislightFaceVersion : vislightFaceVersion + ".0";
        for (String key : cmdMap.keySet()) {
            Integer ret;
            Map resultMap;
            String[] cmdIdKey = key.split("_");
            Long cmdId = (Long)cmdMap.get(key);
            if (cmdId <= 0L || !Objects.nonNull(resultMap = this.accDeviceService.getCmdResultById(cmdId, 20)) || (ret = Integer.valueOf((String)resultMap.get("result"))) < 0) continue;
            if ("".equals(this.accDeviceService.getQueryData("IS_ERROR_USER"))) {
                JSONObject dataCountJson = null;
                if (!"".equals(this.accDeviceService.getQueryData("acc:dataCount:" + cmdId))) {
                    dataCountJson = JSONObject.parseObject((String)this.accDeviceService.getQueryData("acc:dataCount:" + cmdId));
                    if (dataCountJson.containsKey((Object)"user")) {
                        String maxUserCountOpt = this.accDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxUserCount");
                        int maxUserCount = Integer.parseInt(!"0".equals(maxUserCountOpt) ? maxUserCountOpt : (Short.valueOf(dev.getCommType()) == 3 ? "90" : "300")) * 100;
                        userJson.put(devId, (Object)(dataCountJson.get((Object)"user").toString() + "/" + maxUserCount));
                    } else if (dataCountJson.containsKey((Object)"templatev10") || dataCountJson.containsKey((Object)"biodata") && cmdIdKey.length > 1 && BaseConstants.BaseBioType.FP_BIO_TYPE == Short.parseShort(cmdIdKey[1])) {
                        int maxFingerCount = 0;
                        if (maxMultiBioDataCount != null) {
                            maxFingerCount = Integer.parseInt(maxMultiBioDataCount.getValue().split(":")[BaseConstants.BaseBioType.FP_BIO_TYPE]);
                            fingerJson.put(devId, (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxFingerCount));
                        } else {
                            String maxFingerCountOpt = this.accDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxFingerCount");
                            if (maxFingerCountOpt != null) {
                                maxFingerCount = Integer.parseInt(maxFingerCountOpt) * 100;
                            }
                            if ("12".equals(fingerVersion)) {
                                fingerJson.put(devId, (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxFingerCount));
                            } else {
                                fingerJson.put(devId, (Object)(dataCountJson.get((Object)"templatev10").toString() + "/" + maxFingerCount));
                            }
                        }
                        fingerJson.put("fingerVersion", (Object)("V" + fingerVersion));
                    } else if (dataCountJson.containsKey((Object)"fvtemplate")) {
                        int maxFvCount = 0;
                        if (maxMultiBioDataCount != null) {
                            maxFvCount = Integer.parseInt(maxMultiBioDataCount.getValue().split(":")[BaseConstants.BaseBioType.VEIN_BIO_TYPE]);
                            fvJson.put(devId, (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxFvCount));
                        } else {
                            String maxFvCountOpt = this.accDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxFvCount");
                            if (maxFvCountOpt != null) {
                                maxFvCount = Integer.parseInt(maxFvCountOpt) * 100;
                            }
                            fvJson.put(devId, (Object)(dataCountJson.get((Object)"fvtemplate").toString() + "/" + maxFvCount));
                        }
                        fvJson.put("fvVersion", (Object)("V" + fvVersion));
                    } else if (dataCountJson.containsKey((Object)"biophoto")) {
                        int maxBiophotoCount = 0;
                        if (maxMultiBioPhotoCount != null) {
                            maxBiophotoCount = Integer.parseInt(maxMultiBioPhotoCount.getValue().split(":")[BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE]);
                        } else {
                            String maxBiophotoCountOpt = this.accDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxBioPhotoCount");
                            if (maxBiophotoCountOpt != null) {
                                maxBiophotoCount = Integer.parseInt(maxBiophotoCountOpt);
                            }
                        }
                        bioPhotoJson.put(devId, (Object)(dataCountJson.get((Object)"biophoto").toString() + "/" + maxBiophotoCount));
                    } else if (dataCountJson.containsKey((Object)"facev7") || dataCountJson.containsKey((Object)"biodata") && cmdIdKey.length > 1 && BaseConstants.BaseBioType.FACE_BIO_TYPE == Short.parseShort(cmdIdKey[1])) {
                        int maxFaceCount = 0;
                        if (maxMultiBioDataCount != null) {
                            maxFaceCount = Integer.parseInt(maxMultiBioDataCount.getValue().split(":")[BaseConstants.BaseBioType.FACE_BIO_TYPE]);
                            faceJson.put(devId, (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxFaceCount));
                        } else {
                            String maxFaceCountOpt = this.accDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxFaceCount");
                            if (maxFaceCountOpt != null) {
                                maxFaceCount = Integer.parseInt(maxFaceCountOpt);
                            }
                            faceJson.put(devId, (Object)(dataCountJson.get((Object)"facev7").toString() + "/" + maxFaceCount));
                        }
                        faceJson.put("faceVersion", (Object)("V" + faceVersion));
                    } else if (dataCountJson.containsKey((Object)"biodata") && cmdIdKey.length > 1 && BaseConstants.BaseBioType.PALM_BIO_TYPE == Short.parseShort(cmdIdKey[1])) {
                        int maxPalmCount = 0;
                        if (maxMultiBioDataCount != null) {
                            maxPalmCount = Integer.parseInt(maxMultiBioDataCount.getValue().split(":")[BaseConstants.BaseBioType.PALM_BIO_TYPE]);
                        } else {
                            String maxPalmCountOpt = this.accDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxPvCount");
                            if (maxPalmCountOpt != null) {
                                maxPalmCount = Integer.parseInt(maxPalmCountOpt);
                            }
                        }
                        palmJson.put(devId + "", (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxPalmCount));
                        palmJson.put("pvVersion", (Object)("V" + pvVersion));
                    } else if (dataCountJson.containsKey((Object)"biodata") && cmdIdKey.length > 1 && BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE == Short.parseShort(cmdIdKey[1])) {
                        int maxVislightFaceTempCount = 0;
                        if (maxMultiBioDataCount != null) {
                            maxVislightFaceTempCount = Integer.parseInt(maxMultiBioDataCount.getValue().split(":")[BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE]);
                        } else {
                            String maxBiophotoCountOpt = this.accDeviceOptionService.getValueByNameAndDevSn(dev.getSn(), "~MaxFaceCount");
                            if (maxBiophotoCountOpt != null) {
                                maxVislightFaceTempCount = Integer.parseInt(maxBiophotoCountOpt);
                            }
                        }
                        faceBiodataJson.put(devId, (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxVislightFaceTempCount));
                        faceBiodataJson.put("vislightFaceVersion", (Object)("V" + vislightFaceVersion));
                    }
                    this.accDeviceService.delQueryData("acc:dataCount:" + cmdId);
                }
                this.accDeviceService.delQueryData("SUM_RECORD_USER");
            }
            this.accDeviceService.delQueryData("IS_ERROR_USER");
        }
        retObject.put("user", (Object)userJson);
        retObject.put("finger", (Object)fingerJson);
        retObject.put("fv", (Object)fvJson);
        retObject.put("face", (Object)faceJson);
        retObject.put("biophoto", (Object)bioPhotoJson);
        retObject.put("palm", (Object)palmJson);
        retObject.put("faceBiodata", (Object)faceBiodataJson);
        resultMsg.setData((Object)retObject);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg checkPinLenAndCardLen(String commTypeVal, String maxMCUCardBits) {
        String pinLen = this.accParamService.getParamValByName("pers.pinLen");
        String cardLen = this.accParamService.getParamValByName("pers.cardLen");
        String pinSupportLetter = this.accParamService.getParamValByName("pers.pinSupportLetter");
        if (Integer.parseInt(maxMCUCardBits) < Integer.parseInt(cardLen)) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_dev_beyondCardLen", (Object[])new Object[]{maxMCUCardBits}));
        }
        if ((commTypeVal.equals("1") || commTypeVal.equals("2")) && (Integer.parseInt(pinLen) > 9 || pinSupportLetter.equals("true"))) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_dev_deviceNotSupportPin", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"acc:device:updateMThreshold"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_modifyFPThreshold", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateMThreshold(String devId, String mThreshold) {
        Long cmdId;
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devId) && StringUtils.isNotBlank((CharSequence)mThreshold) && (cmdId = this.accDeviceService.updateMThreshold(devId, mThreshold)) != null && cmdId > 0L) {
            Map resultMap = this.accDeviceService.getCmdResultById(cmdId, 20);
            if (Objects.nonNull(resultMap)) {
                Integer ret = Integer.valueOf((String)resultMap.get("result"));
                if (ret < 0) {
                    String failedInfo = this.accBaseDictionaryService.getCommReason(ret.intValue());
                    failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : ret.toString();
                    String msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo;
                    throw new ZKBusinessException("400", msgStr);
                }
                this.accDeviceOptionService.setDevOptValByName(devId, "MThreshold", mThreshold);
                this.accDeviceService.rebootDevice((List)Lists.newArrayList((Object[])new String[]{devId}), false);
                resultMsg.setMsg("acc_dev_rebootAfterOperate");
            } else {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg checkPwd(String oldCommPwd, String devId) {
        AccDeviceItem tempDevice;
        ZKResultMsg resultMsg = new ZKResultMsg();
        boolean isExist = false;
        if (StringUtils.isNotBlank((CharSequence)oldCommPwd) && StringUtils.isNotBlank((CharSequence)devId) && (tempDevice = this.accDeviceService.getItemById(devId)) != null && (tempDevice.getCommPwd() == null || oldCommPwd.equals(tempDevice.getCommPwd()) || oldCommPwd.equals(""))) {
            isExist = true;
        }
        resultMsg.setData((Object)isExist);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"acc:device:updateCommPwd"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="common_dev_modifyCommPwd", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateCommPwd(String devId, String newCommPwd) {
        Map resultMap;
        AccDeviceItem device = this.accDeviceService.getItemById(devId);
        int ret = -1;
        Long cmdId = this.accDeviceService.updateCommPwd(devId, newCommPwd);
        if (cmdId != null && cmdId > 0L && Objects.nonNull(resultMap = this.accDeviceService.getCmdResultById(cmdId, 20))) {
            ret = Integer.parseInt((String)resultMap.get("result"));
        }
        if (ret < 0) {
            throw new ZKBusinessException("400", "common_op_failed");
        }
        device.setCommPwd(newCommPwd);
        this.accDeviceService.saveAccDevice(device);
        this.accDeviceService.updateAdmsDeviecPwd(device.getSn(), newCommPwd);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"acc:device:updateRs485Addr"})
    public ModelAndView getRs485Addr(String ids) {
        AccDeviceItem dev;
        if (StringUtils.isNotBlank((CharSequence)ids) && (dev = this.accDeviceService.getItemById(ids)) != null) {
            if (Short.valueOf(dev.getCommType()) == 3 || !AccConstants.DEVICE_SUPPORT_MODIFY_RS485_ADDRESS.contains(dev.getMachineType())) {
                this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
                return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
            }
            short devConnectState = Short.valueOf(this.accDeviceService.getStatus(dev.getSn()));
            if (devConnectState != 1) {
                this.request.setAttribute("failedReason", (Object)devConnectState);
                return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
            }
            this.request.setAttribute("accDev", (Object)dev);
            this.request.setAttribute("editPage", (Object)true);
            return new ModelAndView("acc/device/opAccUpdateRs485Addr");
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:updateRs485Addr"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_modifyRS485Addr", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateRs485Addr(String devId, String comAddr) {
        Long cmdId;
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devId) && StringUtils.isNotBlank((CharSequence)comAddr) && (cmdId = this.accDeviceService.updateRs485Addr(devId, comAddr)) != null && cmdId > 0L) {
            Map resultMap = this.accDeviceService.getCmdResultById(cmdId, 20);
            Integer ret = Integer.valueOf((String)resultMap.get("result"));
            if (ret >= 0) {
                this.accDeviceService.rebootDevice((List)Lists.newArrayList((Object[])new String[]{devId}), false);
                AccDeviceItem accDeviceItem = new AccDeviceItem();
                accDeviceItem.setId(devId);
                accDeviceItem.setComAddress(comAddr);
                this.accDeviceService.updateItemByParam(accDeviceItem);
                this.accDeviceService.updateAdmsComAddress(accDeviceItem.getSn(), comAddr);
            } else {
                String failedInfo = this.accBaseDictionaryService.getCommReason(ret.intValue());
                failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : ret.toString();
                String msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo;
                throw new ZKBusinessException("400", msgStr);
            }
        }
        resultMsg.setMsg("acc_dev_rebootAfterOperate");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public TreeItem tree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        List accDeviceItemList = this.accDeviceService.getByCondition(new AccDeviceItem());
        if (!accDeviceItemList.isEmpty()) {
            TreeItem item = null;
            for (AccDeviceItem accDeviceItem : accDeviceItemList) {
                item = new TreeItem();
                item.setId(accDeviceItem.getId());
                item.setText(accDeviceItem.getAlias());
                item.setParent(new TreeItem("0"));
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    @RequiresPermissions(value={"acc:device:setTimeZone"})
    public ModelAndView getDevIdsBySetTimeZone(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List accDeviceItemList = this.accDeviceService.getItemByIds(ids);
            StringBuffer devName = new StringBuffer("");
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer warnInfoDevName = new StringBuffer("");
            StringBuffer noSupportDevName = new StringBuffer("");
            ArrayList timeZoneKeyList = Lists.newArrayList();
            StringBuffer devIds = new StringBuffer();
            HashMap tzNameMap = Maps.newHashMap();
            accDeviceItemList.stream().forEach(dev -> {
                String status = this.accDeviceService.getStatus(dev.getSn());
                if (!String.valueOf(2).equals(status)) {
                    if (dev.getParentDeviceId() != null) {
                        warnInfoDevName.append(dev.getAlias()).append(",");
                    } else if (this.accDeviceOptionService.isSupportFun(dev.getSn(), "MachineTZFunOn")) {
                        devIds.append(dev.getId()).append(",");
                        String tzVal = dev.getTimeZone();
                        if (StringUtils.isNotBlank((CharSequence)tzVal)) {
                            String tzKey = this.getTZKeyByVal(tzVal);
                            if (!timeZoneKeyList.contains(tzVal)) {
                                timeZoneKeyList.add(tzVal);
                            }
                            if (tzNameMap.containsKey(tzKey)) {
                                ((StringBuffer)tzNameMap.get(tzKey)).append(dev.getAlias() + "&" + dev.getId() + ",");
                            } else {
                                StringBuffer dstNameBuf = new StringBuffer(tzKey + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                                tzNameMap.put(tzKey, dstNameBuf);
                            }
                        } else {
                            String tzNotSet = I18nUtil.i18nCode((String)"acc_dev_notSetDst", (Object[])new Object[0]);
                            if (tzNameMap.containsKey(tzNotSet)) {
                                ((StringBuffer)tzNameMap.get(tzNotSet)).append(dev.getAlias() + "&" + dev.getId() + ",");
                            } else {
                                StringBuffer tzNameBuf = new StringBuffer(tzNotSet + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                                tzNameMap.put(tzNotSet, tzNameBuf);
                            }
                        }
                    } else {
                        noSupportDevName.append(dev.getAlias()).append(",");
                    }
                } else {
                    disabledDevName.append(dev.getAlias()).append(",");
                }
            });
            tzNameMap.forEach((k, v) -> devName.append(v.substring(0, v.length() - 1) + ";"));
            this.request.setAttribute("timeZoneKey", devName.length() > 0 ? (timeZoneKeyList.size() > 0 ? timeZoneKeyList.get(0) : "+0800") : "");
            this.request.setAttribute("devIds", devIds.length() > 0 ? devIds.substring(0, devIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
            this.request.setAttribute("disabledDevName", disabledDevName.length() > 0 ? disabledDevName.substring(0, disabledDevName.length() - 1) : null);
            this.request.setAttribute("warnInfoDevName", warnInfoDevName.length() > 0 ? warnInfoDevName.substring(0, warnInfoDevName.length() - 1) : null);
            this.request.setAttribute("noSupportDevName", noSupportDevName.length() > 0 ? noSupportDevName.substring(0, noSupportDevName.length() - 1) : null);
            return new ModelAndView("acc/device/opAccDevSetTimeZone");
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:setTimeZone"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_setTimeZone", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg setTimeZone(String devIds, String timeZone) {
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
        List accDeviceItemList = this.accDeviceService.getItemByIds(devIds);
        int size = accDeviceItemList.size();
        AccDeviceItem dev = null;
        for (int i = 0; i < size; ++i) {
            dev = (AccDeviceItem)accDeviceItemList.get(i);
            int total = (int)((float)(i + 1) / (float)size * 100.0f);
            int lastTotal = (int)(((double)i + 0.3) / (double)size * 100.0);
            this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"acc_dev_timeZoneSetting", (Object[])new Object[0]) + "<br/>"));
            this.accDeviceService.setDeviceTimeZoneToDev(dev, timeZone);
            this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"acc_dev_timeZoneCmdSuccess", (Object[])new Object[0]) + "<br/>"));
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"acc:device:setDSTime"})
    public ModelAndView getDevIdsBySetDstimeSortByDstime(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            StringBuffer devName = new StringBuffer("");
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer noSupportDevName = new StringBuffer("");
            StringBuffer warnInfoDevName = new StringBuffer("");
            StringBuffer devIds = new StringBuffer();
            List accDeviceItemLists = this.accDeviceService.getItemByIds(ids);
            HashMap dstNameMap = Maps.newHashMap();
            accDeviceItemLists.stream().forEach(dev -> {
                String status = this.accDeviceService.getStatus(dev.getSn());
                if (!String.valueOf(2).equals(status)) {
                    if (StringUtils.isNotBlank((CharSequence)dev.getParentDeviceId())) {
                        warnInfoDevName.append(dev.getAlias()).append(",");
                    } else if (this.accDeviceOptionService.isSupportDevParam(dev.getSn(), "DSTFunOn") || this.accDeviceOptionService.isSupportDevParam(dev.getSn(), "~DSTF")) {
                        String devDSTimeName;
                        devIds.append(dev.getId()).append(",");
                        String string = devDSTimeName = StringUtils.isNotBlank((CharSequence)dev.getAccDSTimeId()) ? this.accDSTimeService.getItemById(dev.getAccDSTimeId()).getName() : null;
                        if (devDSTimeName == null) {
                            String dstNotSet = I18nUtil.i18nCode((String)"acc_dev_notSetDst", (Object[])new Object[0]);
                            if (dstNameMap.containsKey(dstNotSet)) {
                                ((StringBuffer)dstNameMap.get(dstNotSet)).append(dev.getAlias() + "&" + dev.getId() + ",");
                            } else {
                                StringBuffer dstNameBuf = new StringBuffer(dstNotSet + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                                dstNameMap.put(dstNotSet, dstNameBuf);
                            }
                        } else {
                            String dstKey = devDSTimeName + "-" + dev.getAccDSTimeId();
                            if (dstNameMap.containsKey(dstKey)) {
                                ((StringBuffer)dstNameMap.get(dstKey)).append(dev.getAlias() + "&" + dev.getId() + ",");
                            } else {
                                StringBuffer dstNameBuf = new StringBuffer(dstKey + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                                dstNameMap.put(dstKey, dstNameBuf);
                            }
                        }
                    } else {
                        noSupportDevName.append(dev.getAlias()).append(",");
                    }
                } else {
                    disabledDevName.append(dev.getAlias()).append(",");
                }
            });
            dstNameMap.forEach((k, v) -> devName.append(v.substring(0, v.length() - 1) + ";"));
            this.request.setAttribute("devIds", devIds.length() > 0 ? devIds.substring(0, devIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
            this.request.setAttribute("disabledDevName", disabledDevName.length() > 0 ? disabledDevName.substring(0, disabledDevName.length() - 1) : null);
            this.request.setAttribute("warnInfoDevName", warnInfoDevName.length() > 0 ? warnInfoDevName.substring(0, warnInfoDevName.length() - 1) : null);
            this.request.setAttribute("noSupportDevName", noSupportDevName.length() > 0 ? noSupportDevName.substring(0, noSupportDevName.length() - 1) : null);
            return new ModelAndView("acc/device/opAccDevSetDstime");
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:setDSTime"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_setDstime", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg setDSTime(String devIds, String dstimeId) {
        if (StringUtils.isNotBlank((CharSequence)devIds)) {
            List accDeviceItemList = this.accDeviceService.getItemByIds(devIds);
            AccDSTimeItem accDSTimeItem = null;
            if (StringUtils.isNotBlank((CharSequence)dstimeId)) {
                accDSTimeItem = this.accDSTimeService.getItemById(dstimeId);
            }
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            int size = accDeviceItemList.size();
            AccDeviceItem dev = null;
            for (int i = 0; i < size; ++i) {
                dev = (AccDeviceItem)accDeviceItemList.get(i);
                int total = (int)((float)(i + 1) / (float)size * 100.0f);
                int lastTotal = (int)(((double)i + 0.3) / (double)size * 100.0);
                if (accDSTimeItem != null) {
                    this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"acc_dev_dstSettingTip", (Object[])new Object[0]) + "<br/>"));
                    this.accDeviceService.setOrDelDST(dev, accDSTimeItem, "set");
                } else {
                    this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"acc_dev_dstDelTip", (Object[])new Object[0]) + "<br/>"));
                    this.accDeviceService.setOrDelDST(dev, accDSTimeItem, "del");
                }
                this.accDeviceService.saveDSTime(dev, accDSTimeItem);
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"acc_dev_dstCmdSuccess", (Object[])new Object[0]) + "<br/>"));
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    private String getTZKeyByVal(String tzVal) {
        int tempNum = Integer.parseInt(tzVal);
        String deliveryVal = "";
        if (tempNum % 100 != 0) {
            deliveryVal = Math.abs(tempNum % 100) + "";
        }
        return "UTC" + tzVal.substring(0, 1) + Math.abs(tempNum / 100) + deliveryVal + "_" + tzVal;
    }

    private int verComparison(String curVersion, String defVersion, int deviceType) {
        String[] fullStr = curVersion.split(" ");
        if (deviceType == 0) {
            curVersion = fullStr[2].split("\\.").length > 3 ? fullStr[2].substring(0, fullStr[2].lastIndexOf(".")) : fullStr[2];
        } else if (deviceType == 1) {
            curVersion = fullStr[1].substring(0, fullStr[1].lastIndexOf("."));
        }
        int result = 0;
        String[] curStr = curVersion.split("\\.");
        String[] defStr = defVersion.split("\\.");
        if (defVersion.equalsIgnoreCase(curVersion)) {
            return result;
        }
        for (int i = 0; i < curStr.length; ++i) {
            if (curStr[i].compareToIgnoreCase(defStr[i]) > 0) {
                result = 1;
                break;
            }
            if (curStr[i].compareToIgnoreCase(defStr[i]) >= 0) continue;
            result = -1;
            break;
        }
        return result;
    }

    public ModelAndView searchWifiList(String devId) {
        if (StringUtils.isNotBlank((CharSequence)devId)) {
            Map dataMap = this.accDeviceService.searchWifiListFromDev(devId);
            if (dataMap.containsKey("failedReason")) {
                this.request.setAttribute("failedReason", dataMap.get("failedReason"));
                return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
            }
            this.request.setAttribute("cmdId", dataMap.get("cmdId"));
            this.request.setAttribute("devId", (Object)devId);
        }
        return new ModelAndView("acc/device/opAccSearchWifi");
    }

    public ZKResultMsg getWifiList(String cmdId) {
        ZKResultMsg resultMsg = this.accDeviceService.getWifiList(cmdId);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg searchWifiListAgain(String devId) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devId)) {
            Map dataMap = this.accDeviceService.searchWifiListFromDev(devId);
            resultMsg.setData(dataMap.get("cmdId"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg switchNetWorkTest(String devId, String currentMode, String netConnectMode, String wirelessSSID, String wirelessKey) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devId)) {
            if (netConnectMode == null) {
                throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_commStatus_dataParamError", (Object[])new Object[0]));
            }
            Long cmdId = this.accDeviceService.switchNetWorkTest(devId, currentMode, netConnectMode, wirelessSSID, wirelessKey);
            resultMsg.setData((Object)cmdId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getCmdResultById(String devId, String cmdId, String type) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)cmdId)) {
            Integer ret;
            Map resultMap = this.accDeviceService.getCmdResultById(Long.valueOf(Long.parseLong(cmdId)), 25);
            Integer n = ret = Objects.isNull(resultMap) ? Integer.valueOf("-2") : Integer.valueOf((String)resultMap.get("result"));
            if ("identityCard".equals(type)) {
                if (ret != null && ret > 0) {
                    // empty if block
                }
            } else if ("testNetConnect".equals(type) && ret != null && ret != 0) {
                if (ret == Integer.parseInt("-2")) {
                    resultMsg.setRet("500");
                } else {
                    resultMsg.setRet("400");
                }
            }
            resultMsg.setData((Object)ret);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"acc:device:updateNetConnectMode"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_updateNetConnectMode", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateNetConnectMode(String devId, String netConnectMode, String wirelessSSID, String wirelessKey) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devId)) {
            if (StringUtils.isBlank((CharSequence)netConnectMode)) {
                throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_commStatus_dataParamError", (Object[])new Object[0]));
            }
            Long cmdId = this.accDeviceService.updateNetConnectMode(devId, netConnectMode, wirelessSSID, wirelessKey);
            Map resultMap = this.accDeviceService.getCmdResultById(cmdId, 20);
            Integer ret = Integer.valueOf((String)resultMap.get("result"));
            if (ret >= 0) {
                this.accDeviceService.rebootDevice((List)Lists.newArrayList((Object[])new String[]{devId}), false);
                this.accDeviceOptionService.setDevOptValByName(devId, "NetConnectMode", netConnectMode);
                if (netConnectMode.equals("2")) {
                    this.accDeviceOptionService.setDevOptValByName(devId, "WirelessSSID", wirelessSSID);
                    this.accDeviceOptionService.setDevOptValByName(devId, "WirelessKey", wirelessKey);
                }
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg grantAuthority(AccSearchAddDeviceItem item) {
        if (StringUtils.isNotBlank((CharSequence)item.getClearAllData())) {
            item.setClearAllData("true");
        }
        this.accDeviceService.grantAuthority(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"acc:device:addChildDevice"})
    public DxGrid getAuthorizeChildDevList(AccAuthorizeChildDevItem accAuthorizeChildDevItem) {
        Pager pager = new Pager();
        List accAuthorizeChildDevItemList = this.accDeviceService.getAuthorizeChildDevList(accAuthorizeChildDevItem);
        pager.setData(accAuthorizeChildDevItemList);
        pager.setTotal(accAuthorizeChildDevItemList.size());
        pager.setPage(this.getPageNo());
        pager.setSize(this.getPageSize());
        return GridUtil.convert((Pager)pager, accAuthorizeChildDevItem.getClass());
    }

    public ZKResultMsg validChildDevCount(String devId, String devSns) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devId)) {
            Map resultMap;
            long cmdId;
            int devCount = 0;
            int doorCount = 0;
            AccDeviceItem accDevice = this.accDeviceService.getItemById(devId);
            String data = this.accDeviceService.getDeviceAuthorize(accDevice.getSn());
            if (StringUtils.isNotBlank((CharSequence)data) && (cmdId = this.accDeviceService.queryAuthorizeListFromDev(devId).longValue()) > 0L && Objects.nonNull(resultMap = this.accDeviceService.getCmdResultById(Long.valueOf(cmdId), 60)) && Integer.parseInt((String)resultMap.get("result")) > 0) {
                data = this.accDeviceService.getDeviceAuthorize(accDevice.getSn());
            }
            if (StringUtils.isNotBlank((CharSequence)data)) {
                ArrayList devSnList = Lists.newArrayList(Arrays.asList(devSns.split(",")));
                JSONObject json = JSONObject.parseObject((String)data);
                JSONArray jsonArr = json.getJSONArray("data");
                if (jsonArr.size() > 0) {
                    for (int i = 0; i < jsonArr.size(); ++i) {
                        JSONObject devJson = jsonArr.getJSONObject(i);
                        if (!devSnList.contains(devJson.getString("SN"))) continue;
                        ++devCount;
                        doorCount += devJson.getIntValue("LockCount");
                    }
                }
            }
            resultMsg = this.accDeviceService.validChildDevCount(devCount, doorCount);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg getParentDevList() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        List deviceItemList = this.accDeviceService.getByMachineTypeAndAuth(this.request.getSession().getId(), Short.valueOf((short)40));
        SelectItem selectItem = null;
        if (Objects.nonNull(deviceItemList) && deviceItemList.size() > 0) {
            for (AccDeviceItem accDeviceItem : deviceItemList) {
                selectItem = new SelectItem();
                selectItem.setValue(accDeviceItem.getId());
                selectItem.setText((Object)accDeviceItem.getAlias());
                selectItems.add(selectItem);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg(selectItems));
    }

    @RequiresPermissions(value={"acc:device:modParentDevice", "acc:device:configParentDevice"})
    public ZKResultMsg configParentDevice(String id, String parentDevId, String webServerURL) {
        Long cmdId = this.accDeviceService.configParentDevice(id, parentDevId, webServerURL);
        if (Objects.nonNull(cmdId)) {
            Long rebootId;
            int ret;
            if (cmdId < 0L && StringUtils.isNotBlank((CharSequence)parentDevId)) {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"acc_dev_maxSubCount", (Object[])new Object[]{-1L * cmdId}));
            }
            Map resultMap = this.accDeviceService.getCmdResultById(cmdId, 60);
            if (Objects.nonNull(resultMap) && (ret = Integer.parseInt((String)resultMap.get("result"))) == 0 && Objects.nonNull(rebootId = (Long)this.accDeviceService.rebootDevice((List)Lists.newArrayList((Object[])new String[]{id}), true).get(0))) {
                Map rebootMap = this.accDeviceService.getCmdResultById(rebootId, 60);
                if (Integer.parseInt((String)rebootMap.get("result")) == 0) {
                    if (StringUtils.isBlank((CharSequence)parentDevId)) {
                        this.accDeviceService.changeParentDevice(id);
                    } else {
                        this.accDeviceService.updateParentDevice(id, parentDevId);
                    }
                } else {
                    if (Integer.parseInt((String)rebootMap.get("result")) == Integer.parseInt("-2")) {
                        throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_commStatus_cmdTimeOut", (Object[])new Object[0]));
                    }
                    throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
                }
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkDevExist() {
        int count = this.accDeviceService.getByCondition(new AccDeviceItem()).size();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)count));
    }

    public ZKResultMsg getDevTreeJson(String type, String area, String getDstime) {
        boolean getTime = StringUtils.isNotBlank((CharSequence)getDstime);
        JSONObject devsJson = new JSONObject();
        devsJson.put("id", (Object)0);
        JSONArray devJsonArray = new JSONArray();
        AccDeviceItem accDeviceItem = new AccDeviceItem();
        String areaIds = this.accDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)areaIds)) {
            if (StringUtils.isNotBlank((CharSequence)area)) {
                areaIds = areaIds + "," + area;
            }
            accDeviceItem.setAreaIdIn(areaIds);
        } else if (StringUtils.isNotBlank((CharSequence)area)) {
            accDeviceItem.setAreaIdIn(area);
        }
        List accDeviceItemList = this.accDeviceService.getByCondition(accDeviceItem);
        JSONObject devInfoJson = null;
        for (AccDeviceItem dev : accDeviceItemList) {
            if (getTime) {
                if (!this.accDeviceOptionService.isSupportFun(dev.getSn(), "DSTFunOn") && !this.accDeviceOptionService.isSupportDevParam(dev.getSn(), "~DSTF") || dev.getParentDeviceId() != null) continue;
                devInfoJson = new JSONObject();
                devInfoJson.put("id", (Object)dev.getId());
                devInfoJson.put("text", (Object)dev.getAlias());
                devInfoJson.put("open", (Object)1);
                devJsonArray.add((Object)devInfoJson);
                continue;
            }
            devInfoJson = new JSONObject();
            devInfoJson.put("id", (Object)dev.getId());
            devInfoJson.put("text", (Object)dev.getAlias());
            devInfoJson.put("open", (Object)1);
            devJsonArray.add((Object)devInfoJson);
        }
        if (type != null && type.equals("all")) {
            if (devJsonArray.size() > 0) {
                JSONObject childJson = new JSONObject();
                JSONArray childArray = new JSONArray();
                childJson.put("id", (Object)"-1");
                childJson.put("open", (Object)"1");
                childJson.put("text", (Object)I18nUtil.i18nCode((String)"common_all", (Object[])new Object[0]));
                childJson.put("item", (Object)devJsonArray);
                childArray.add((Object)childJson);
                devsJson.put("item", (Object)childArray);
            } else {
                devsJson.put("item", (Object)new JSONArray());
            }
        } else {
            devsJson.put("item", (Object)devJsonArray);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devsJson));
    }

    @RequiresPermissions(value={"acc:device:addChildDevice"})
    public ZKResultMsg authorizeChildDevice(String devId, String devSns) {
        ZKResultMsg resultMsg = this.accDeviceService.authorizeChildDevice(devId, devSns);
        if ("subEmpty".equals(resultMsg.getRet())) {
            throw ZKBusinessException.errorException((String)I18nUtil.i18nCode((String)resultMsg.getMsg(), (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if ("noLicense".equals(resultMsg.getRet())) {
            throw ZKBusinessException.errorException((String)String.format(I18nUtil.i18nCode((String)resultMsg.getMsg(), (Object[])new Object[0]), resultMsg.getData()), (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg checkServerConnection(String devId, String parentDevId, String serverAddress) {
        ZKResultMsg resultMsg = ZKResultMsg.failMsg();
        if (StringUtils.isNotBlank((CharSequence)devId) && "fail".equals((resultMsg = this.accDeviceService.checkServerConnection(devId, parentDevId, serverAddress)).getRet()) && Objects.nonNull(resultMsg.getData())) {
            resultMsg.setMsg(String.format(I18nUtil.i18nCode((String)resultMsg.getMsg(), (Object[])new Object[0]), resultMsg.getData()));
        }
        return resultMsg;
    }

    public ZKResultMsg isOnlineByDevSn(String devSns) {
        ZKResultMsg zkResultMsg = ZKResultMsg.failMsg();
        if (StringUtils.isNotBlank((CharSequence)devSns)) {
            JSONArray stateArray = new JSONArray();
            ArrayList snList = Lists.newArrayList((Object[])devSns.split(","));
            snList.stream().forEach(sn -> {
                JSONObject devStatus = new JSONObject();
                String status = this.accDeviceService.getStatus(sn);
                devStatus.put("connectState", (Object)status);
                devStatus.put("sn", sn);
                stateArray.add((Object)devStatus);
            });
            zkResultMsg = ZKResultMsg.successMsg();
            zkResultMsg.setData((Object)stateArray);
        }
        return zkResultMsg;
    }

    public ZKResultMsg getDevInfo(AccDeviceParamItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.accDeviceService.getDevInfo(item));
    }

    public ModelAndView lookUpChildDeviceInfo(String id) {
        this.request.setAttribute("parentDevId", (Object)id);
        return new ModelAndView("acc/device/opAccChildDevList");
    }

    public DxGrid getChildDevList(String parentDevId) {
        Pager pager = new Pager();
        List deviceItemList = this.accDeviceService.getChildDevList(parentDevId);
        pager.setData(deviceItemList);
        pager.setTotal(deviceItemList.size());
        pager.setPage(this.getPageNo());
        pager.setSize(this.getPageSize());
        return GridUtil.convert((Pager)pager, AccDeviceItem.class);
    }

    public ZKResultMsg isSupportClearAdministrator(String devIds) {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        AccDeviceItem dev = this.accDeviceService.getItemById(devIds);
        if (dev != null && dev.getMachineType() != 101) {
            zkResultMsg.setRet("400");
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"acc_dev_devNotSupportFunction", (Object[])new Object[0]));
        }
        return zkResultMsg;
    }

    public ZKResultMsg clearAdministrator(String devIds) {
        return this.accDeviceService.clearAdministrator(devIds);
    }

    public ZKResultMsg setDevIOState() {
        String devId = this.request.getParameter("devId");
        String devIOState = this.request.getParameter("InOrOutState");
        if (StringUtils.isNotBlank((CharSequence)devId)) {
            Map resultMap;
            AccDeviceItem device = this.accDeviceService.getItemById(devId);
            int ret = -1;
            Long cmdId = this.accDeviceService.setDevIOState(devId, devIOState);
            if (cmdId != null && cmdId > 0L && Objects.nonNull(resultMap = this.accDeviceService.getCmdResultById(cmdId, 20))) {
                ret = Integer.parseInt((String)resultMap.get("result"));
            }
            if (ret >= 0) {
                this.accDeviceOptionService.setDevOptValByName(devId, "Reader1IOState", devIOState);
                this.accDoorService.setDoorHostStatus(devId, devIOState);
            } else {
                throw new ZKBusinessException("400", "common_op_failed");
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg validDevRegDeviceType(String regDeviceType) {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        zkResultMsg.setData((Object)this.accDeviceService.validDevRegDeviceType(regDeviceType));
        return zkResultMsg;
    }

    public ZKResultMsg getRemoteRegistDev() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String optionName = this.request.getParameter("optionName");
        List deviceIdList = this.accDeviceOptionService.getDevIdByOptNameAndOptValAndAuthFilter(optionName, "1", this.request.getSession().getId());
        if ("FingerFunOn".equals(optionName)) {
            List deviceIdFVList = this.accDeviceOptionService.getDevIdByOptNameAndOptValAndAuthFilter("FvFunOn", "1", this.request.getSession().getId());
            deviceIdList.removeAll(deviceIdFVList);
        }
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        for (String deviceId : deviceIdList) {
            AccDeviceItem device = this.accDeviceService.getItemById(deviceId);
            String status = this.accDeviceService.getStatus(device.getSn());
            if (!this.accDeviceOptionService.getAccSupportFunListVal(deviceId, 40) || !status.equals(String.valueOf(1))) continue;
            item = new TreeItem();
            item.setId(device.getId());
            item.setText(device.getAlias());
            items.add(item);
        }
        if (items.size() > 0) {
            zkResultMsg = new ZKResultMsg(items);
        }
        return zkResultMsg;
    }

    public ZKResultMsg remoteRegistration() {
        String devId = this.request.getParameter("devId");
        String templateType = this.request.getParameter("templateType");
        String templateNo = this.request.getParameter("templateNo");
        String pin = this.request.getParameter("pin");
        Long cmdId = this.accDeviceService.remoteRegistration(devId, Integer.parseInt(templateType), Integer.parseInt(templateNo), pin);
        return new ZKResultMsg((Object)cmdId);
    }

    public ZKResultMsg getRemoteTemplate() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        long sendTime = System.currentTimeMillis();
        Long cmdId = Long.parseLong(this.request.getParameter("cmdId"));
        if (cmdId != null && cmdId > 0L) {
            int ret = -1;
            Map resultMap = this.accDeviceService.getCmdResultById(cmdId, 30);
            if (Objects.nonNull(resultMap)) {
                ret = Integer.parseInt((String)resultMap.get("result"));
            }
            if (ret != 0) {
                zkResultMsg.setRet("400");
                zkResultMsg.setMsg(I18nUtil.i18nCode((String)"base_remote_cancle", (Object[])new Object[0]));
                if (ret == 6) {
                    zkResultMsg.setMsg(I18nUtil.i18nCode((String)"base_remote_cancle", (Object[])new Object[0]));
                } else if (ret == 4) {
                    zkResultMsg.setMsg(I18nUtil.i18nCode((String)"base_remote_qualified", (Object[])new Object[0]));
                } else if (ret == 2 || ret == 5) {
                    zkResultMsg.setMsg(I18nUtil.i18nCode((String)"base_remote_repeat", (Object[])new Object[0]));
                } else if (ret == -12) {
                    zkResultMsg.setMsg(I18nUtil.i18nCode((String)"base_remote_busyDevice", (Object[])new Object[0]));
                }
            } else {
                String personPin = this.request.getParameter("personPin");
                String fpvType = this.request.getParameter("fpvType");
                zkResultMsg = this.accDeviceService.getRemoteTemplate(personPin, fpvType, sendTime);
            }
        }
        return zkResultMsg;
    }

    public ZKResultMsg getReadIDCardInfo() {
        ZKResultMsg result = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)this.request.getParameter("cmdId"))) {
            String type = this.request.getParameter("type");
            result = this.accDeviceService.getReadIDCardInfo(Long.valueOf(Long.parseLong(this.request.getParameter("cmdId"))), type);
        }
        return result;
    }

    @RequiresPermissions(value={"acc:device:updateDevHepParam"})
    public ModelAndView getDevHepInfo(String ids) {
        AccDeviceItem device = this.accDeviceService.getItemById(ids);
        short devConnectState = Short.valueOf(this.accDeviceService.getStatus(device.getSn()));
        if (devConnectState != 1) {
            this.request.setAttribute("failedReason", (Object)devConnectState);
            return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
        }
        if (device != null && this.accDeviceOptionService.isSupportFun(device.getSn(), "MaskDetectionFunOn") && this.accDeviceOptionService.isSupportFun(device.getSn(), "IRTempDetectionFunOn")) {
            this.request.setAttribute("editPage", (Object)true);
            AccHepParamItem accHepParamItem = new AccHepParamItem();
            accHepParamItem.setDevId(device.getId());
            accHepParamItem.setAlias(device.getAlias());
            accHepParamItem.setEnableIRTempDetection(this.accDeviceOptionService.getValueByNameAndDevSn(device.getSn(), "EnalbeIRTempDetection"));
            accHepParamItem.setEnableNormalIRTempPass(this.accDeviceOptionService.getValueByNameAndDevSn(device.getSn(), "EnableNormalIRTempPass"));
            accHepParamItem.setEnableMaskDetection(this.accDeviceOptionService.getValueByNameAndDevSn(device.getSn(), "EnalbeMaskDetection"));
            accHepParamItem.setEnableWearMaskPass(this.accDeviceOptionService.getValueByNameAndDevSn(device.getSn(), "EnableWearMaskPass"));
            accHepParamItem.setEnableUnregisterPass(this.accDeviceOptionService.getValueByNameAndDevSn(device.getSn(), "EnableUnregisterPass"));
            accHepParamItem.setEnableTriggerAlarm(this.accDeviceOptionService.getValueByNameAndDevSn(device.getSn(), "EnableTriggerAlarm"));
            String tempIrTempThreshold = this.accDeviceOptionService.getValueByNameAndDevSn(device.getSn(), "IRTempThreshold");
            BigDecimal irTempThreshold = new BigDecimal(tempIrTempThreshold).divide(new BigDecimal(100), 2, 4);
            accHepParamItem.setIrTempThreshold(irTempThreshold);
            String tempIrTempCorrection = this.accDeviceOptionService.getValueByNameAndDevSn(device.getSn(), "IRTempCorrection");
            BigDecimal irTempCorrection = new BigDecimal(tempIrTempCorrection).divide(new BigDecimal(100), 2, 4);
            accHepParamItem.setIrTempCorrection(irTempCorrection);
            accHepParamItem.setIrTempUnit(this.accDeviceOptionService.getValueByNameAndDevSn(device.getSn(), "IRTempUnit"));
            this.request.setAttribute("item", (Object)accHepParamItem);
            return new ModelAndView("acc/device/opAccHep");
        }
        this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
        return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
    }

    @RequiresPermissions(value={"acc:device:updateDevHepParam"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_setHep", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateDevHepParam(AccHepParamItem accHepParamItem) {
        Map resultMap;
        ZKResultMsg resultMsg = new ZKResultMsg();
        int result = -1;
        accHepParamItem.setIrTempThreshold(accHepParamItem.getIrTempThreshold().multiply(new BigDecimal(100)).setScale(0, 4));
        accHepParamItem.setIrTempCorrection(accHepParamItem.getIrTempCorrection().multiply(new BigDecimal(100)).setScale(0, 4));
        Long updateDevHepParamCmdId = this.accDeviceService.updateDevHepParam(accHepParamItem);
        if (updateDevHepParamCmdId != null && updateDevHepParamCmdId > 0L && Objects.nonNull(resultMap = this.accDeviceService.getCmdResultById(updateDevHepParamCmdId, 20))) {
            result = Integer.parseInt((String)resultMap.get("result"));
        }
        if (result < 0) {
            throw new ZKBusinessException("400", "common_op_failed");
        }
        this.accDeviceOptionService.setDevOptValByName(accHepParamItem.getDevId(), "EnalbeIRTempDetection", accHepParamItem.getEnableIRTempDetection());
        this.accDeviceOptionService.setDevOptValByName(accHepParamItem.getDevId(), "EnableNormalIRTempPass", accHepParamItem.getEnableNormalIRTempPass());
        this.accDeviceOptionService.setDevOptValByName(accHepParamItem.getDevId(), "EnalbeMaskDetection", accHepParamItem.getEnableMaskDetection());
        this.accDeviceOptionService.setDevOptValByName(accHepParamItem.getDevId(), "EnableWearMaskPass", accHepParamItem.getEnableWearMaskPass());
        this.accDeviceOptionService.setDevOptValByName(accHepParamItem.getDevId(), "IRTempThreshold", accHepParamItem.getIrTempThreshold().toString());
        this.accDeviceOptionService.setDevOptValByName(accHepParamItem.getDevId(), "IRTempCorrection", accHepParamItem.getIrTempCorrection().toString());
        this.accDeviceOptionService.setDevOptValByName(accHepParamItem.getDevId(), "IRTempUnit", accHepParamItem.getIrTempUnit());
        this.accDeviceOptionService.setDevOptValByName(accHepParamItem.getDevId(), "EnableUnregisterPass", accHepParamItem.getEnableUnregisterPass());
        this.accDeviceOptionService.setDevOptValByName(accHepParamItem.getDevId(), "EnableTriggerAlarm", accHepParamItem.getEnableTriggerAlarm());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public Boolean isShowSetHepParam() {
        return this.accDeviceService.isShowSetHepParam();
    }

    public ModelAndView getDevExtendInfo(String ids) {
        boolean isExistAccOption;
        AccDeviceItem device = this.accDeviceService.getItemById(ids);
        short devConnectState = Short.valueOf(this.accDeviceService.getStatus(device.getSn()));
        if (devConnectState != 1) {
            this.request.setAttribute("failedReason", (Object)devConnectState);
            return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
        }
        List<String> faceUiOption = Arrays.asList("VOLUME,EnableShowRegResult,FVInterval,EnableShowIP,EnableShowMacAddress,timeFormat,DtFmt".split(","));
        List<String> faceOption = Arrays.asList("~FaceMThr,FacePitchThreshold,FaceRollYawThreshold,ModifyClarityCond,FaceMinThreshold,IsSupportFaceAntiFake,EnableIRTempImage,AttributeFunOn,EnalbeIRTempDetection,IRTempLowThreshold,IRTempThreshold,EnableNormalIRTempPass,EnalbeMaskDetection,EnableWearMaskPass,IRTempUnit,EnableUnregisterPass,EnableTriggerAlarm,IRTempCorrection".split(","));
        List<String> accOption = Arrays.asList("ChannelMode".split(","));
        List faceUiOptionItemList = this.accDeviceOptionService.getDevExtendParams(ids, faceUiOption);
        List faceOptionItemList = this.accDeviceOptionService.getDevExtendParams(ids, faceOption);
        List accOptionItemList = this.accDeviceOptionService.getDevExtendParams(ids, accOption);
        boolean isExistFaceUiOption = Objects.nonNull(faceUiOptionItemList) && !faceUiOptionItemList.isEmpty();
        boolean isExistFaceOption = Objects.nonNull(faceOptionItemList) && !faceOptionItemList.isEmpty();
        boolean bl = isExistAccOption = Objects.nonNull(accOptionItemList) && !accOptionItemList.isEmpty();
        if (isExistFaceUiOption || isExistFaceOption || isExistAccOption) {
            HashMap<String, String> faceUiParamMap = new HashMap<String, String>(16);
            for (Object item : faceUiOptionItemList) {
                faceUiParamMap.put(item.getName(), item.getValue());
            }
            this.request.setAttribute("faceUiParamMap", faceUiParamMap);
            HashMap<String, String> faceParamMap = new HashMap<String, String>(16);
            for (AccDeviceOptionItem item : faceOptionItemList) {
                faceParamMap.put(item.getName(), item.getValue());
            }
            this.request.setAttribute("faceParamMap", faceParamMap);
            HashMap<String, String> accParamMap = new HashMap<String, String>(16);
            for (AccDeviceOptionItem item : accOptionItemList) {
                accParamMap.put(item.getName(), item.getValue());
            }
            this.request.setAttribute("accParamMap", accParamMap);
            this.request.setAttribute("item", (Object)device);
            return new ModelAndView("acc/device/opAccSetExtendParam");
        }
        this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
        return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
    }

    @RequiresPermissions(value={"acc:device:updateDevExtendParam"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_setExtendParam", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateDevExtendParam(@RequestParam Map<String, String> params) {
        ZKResultMsg resultMsg = this.accDeviceService.updateDevExtendParam(params);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"acc:device:setIntercomServer"})
    public ModelAndView getIntercomServerParams(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            ArrayList devIds = Lists.newArrayList();
            ArrayList devNames = Lists.newArrayList();
            List accDeviceItemList = this.accDeviceService.getItemByIds(ids);
            for (AccDeviceItem item : accDeviceItemList) {
                boolean showConfigure;
                String status = this.accDeviceService.getStatus(item.getSn());
                if (!status.equals(String.valueOf(1))) {
                    this.request.setAttribute("failedReason", (Object)status);
                    return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
                }
                String visualIntercomFunOn = this.accDeviceOptionService.getOptVal(item.getSn(), "VisualIntercomFunOn");
                String videoProtocol = this.accDeviceOptionService.getOptVal(item.getSn(), "VideoProtocol");
                boolean bl = showConfigure = StringUtils.isNotBlank((CharSequence)videoProtocol) && (Integer.parseInt(videoProtocol) & 4) != 0;
                if (!String.valueOf(0).equals(visualIntercomFunOn) && showConfigure) {
                    devIds.add(item.getId());
                    devNames.add(item.getAlias());
                    continue;
                }
                this.request.setAttribute("failedReason", (Object)AccConstants.DEV_NOT_SUPPORT_FEATURE);
                return new ModelAndView("acc/device/opDevNotSupportFeatureTips");
            }
            this.request.setAttribute("devIds", (Object)StringUtils.join((Iterable)devIds, (String)","));
            this.request.setAttribute("devicesName", (Object)StringUtils.join((Iterable)devNames, (String)","));
            return new ModelAndView("acc/device/opAccDevSetIntercomServer");
        }
        return null;
    }

    @RequiresPermissions(value={"acc:device:setIntercomServer"})
    @LogRequest(module="acc_module", object="common_leftMenu_device", opType="acc_dev_setIntercomServer", requestParams={"devName"}, opContent="common_dev_name")
    public ZKResultMsg setIntercomServerParams(String devIds, String ip, String port) {
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
        List accDeviceItemList = this.accDeviceService.getItemByIds(devIds);
        int size = accDeviceItemList.size();
        for (int i = 0; i < size; ++i) {
            AccDeviceItem dev = (AccDeviceItem)accDeviceItemList.get(i);
            int total = (int)((float)(i + 1) / (float)size * 100.0f);
            this.accDeviceService.setIntercomServerParams(dev, ip, port);
            this.progressCache.setProcess(new ProcessBean(60, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/><font>" + I18nUtil.i18nCode((String)"common_dev_reboot", (Object[])new Object[0]) + "...</font><br/>"));
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public Boolean isShowSetIntercomServer() {
        return this.accDeviceService.isShowSetIntercomServer();
    }
}

