/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.api.controller;

import com.zkteco.zkbiosecurity.acc.service.AccTransactionService;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/transaction"})
@Api(tags={"AccTransaction"}, description="acc transaction")
public class AccApiTransactionController {
    @Autowired
    private AccTransactionService accTransactionService;

    @ApiOperation(value="Get Transaction List By Sn", notes="Return Transactions", response=ApiResultMessage.class)
    @RequestMapping(value={"/device/{deviceSn}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getTransactionsByDeviceSn(@PathVariable(name="deviceSn") String deviceSn, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        return this.accTransactionService.getAccApiTransactionsBySn(deviceSn, startTime, endTime, pageNo.intValue(), pageSize.intValue());
    }

    @ApiOperation(value="Get Transaction List By Pin", notes="Return Transactions", response=ApiResultMessage.class)
    @RequestMapping(value={"/person/{pin}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getTransactionsByPin(@PathVariable(name="pin") String pin, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        return this.accTransactionService.getAccApiTransactionsByPin(pin, startTime, endTime, pageNo.intValue(), pageSize.intValue());
    }

    @ApiOperation(value="Monitor", notes="Return Transactions", response=ApiResultMessage.class)
    @RequestMapping(value={"/monitor"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage monitor(@RequestParam(name="timestamp") String timestamp) {
        List apiTransactions = this.accTransactionService.getRTMonitorData(timestamp);
        return ApiResultMessage.successMessage((Object)apiTransactions);
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Transactions List", notes="Return Transactions List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="personPin", required=false) String personPin, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        List apiTransactions = this.accTransactionService.getAccApiTransactionList(personPin, startTime, endTime, pageNo.intValue(), pageSize.intValue());
        return ApiResultMessage.successMessage((Object)apiTransactions);
    }

    private ApiResultMessage checkParam(String startDate, String endDate, Integer pageNo, Integer pageSize) {
        Date startTime = null;
        Date endTime = null;
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
            if (startTime == null || endTime == null) {
                return ApiResultMessage.message((int)-100, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
            }
            if (startTime.getTime() > endTime.getTime()) {
                return ApiResultMessage.message((int)-101, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
            }
        }
        return null;
    }

    @ApiOperation(value="Get FirstInAndLastOut List By Pin", notes="Return FirstInAndLastOut List", response=ApiResultMessage.class)
    @RequestMapping(value={"/firstInAndLastOut/{pin}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getFirstInLastOutByPin(@PathVariable(name="pin") String pin, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        return this.accTransactionService.getAccApiFirstInLastOutByPin(pin, startTime, endTime, pageNo.intValue(), pageSize.intValue());
    }
}

