/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security.xss;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.xss.XssHttpServletRequestWrapper;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
@WebFilter(urlPatterns={"/*"}, filterName="asecurityFilter")
public class XssFilter
implements Filter {
    @Value(value="${system.isRequestTargetAllow:false}")
    private boolean isAllowRequestTarget;
    @Value(value="${system.requestTargetAllowSpecial:}")
    private String requestTargetAllowSpecial;
    @Value(value="${system.sqlRegex:}")
    private String sqlRegex;
    private static Pattern keyPattern1 = Pattern.compile("[+]*(and|or)([+]|[\\s]+)", 2);
    private static Pattern keyPattern2 = Pattern.compile("[+]*(and|or)(([+][+])|([\\s]+'))", 2);
    private static Pattern htmlPattern = Pattern.compile("<([^>]*)>");
    private static Pattern keyPattern3 = Pattern.compile("((like|and|or|xor|rlike|not)[\\s]*[%'])|([%'][\\s]*(like|and|or|xor|rlike|not)[\\W]+)|(\\|\\|)|(&&)", 2);
    private static Pattern keyPattern4 = null;
    private static Pattern dqPattern = Pattern.compile("[\"]+(.)*[\"]+");
    private static Pattern bdqPattern = Pattern.compile("\\{\"");

    public void init(FilterConfig config) throws ServletException {
    }

    private boolean isBase64(String s) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean isBase64 = s.matches(base64Pattern);
        return isBase64;
    }

    private boolean validDQ(String queryString) {
        try {
            String _queryString;
            if (StringUtils.isNotBlank((CharSequence)queryString) && dqPattern.matcher(_queryString = URLDecoder.decode(queryString, "utf-8")).find() && !bdqPattern.matcher(_queryString).find()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        String requestStr = "";
        String requestPath = servletRequest.getServletPath().toString();
        String queryString = servletRequest.getQueryString();
        requestStr = queryString != null ? requestPath + "?" + queryString : requestPath;
        try {
            Enumeration names;
            Matcher matcher = htmlPattern.matcher(requestStr);
            boolean result1 = matcher.find();
            if (result1) {
                throw new ZKBusinessException("common_xss_error_info");
            }
            keyPattern4 = StringUtils.isNotBlank((CharSequence)this.sqlRegex) ? Pattern.compile(this.sqlRegex, 2) : null;
            if (StringUtils.isNotBlank((CharSequence)queryString)) {
                if (keyPattern1.matcher(queryString).find() || this.validDQ(queryString) || keyPattern3.matcher(queryString).find() || keyPattern4 != null && keyPattern4.matcher(queryString).find()) {
                    throw new ZKBusinessException("common_xss_error_info");
                }
                if (this.isAllowRequestTarget) {
                    String key3 = "[]{}";
                    if (StringUtils.isNotBlank((CharSequence)this.requestTargetAllowSpecial)) {
                        for (int k = 0; k < this.requestTargetAllowSpecial.length(); ++k) {
                            key3.replace(this.requestTargetAllowSpecial.charAt(k) + "", "");
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)key3)) {
                        String _queryString = URLDecoder.decode(queryString, "utf-8");
                        for (int k = 0; k < key3.length(); ++k) {
                            if (_queryString.indexOf(key3.charAt(k)) == -1) continue;
                            throw new ZKBusinessException("common_xss_error_info");
                        }
                    }
                }
            }
            if ((names = servletRequest.getParameterNames()) != null) {
                while (names.hasMoreElements()) {
                    String paramName = (String)names.nextElement();
                    String paramValue = request.getParameter(paramName);
                    if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                    if (paramValue.length() < 255 && keyPattern2.matcher(paramValue).find() && !this.isBase64(paramValue)) {
                        throw new ZKBusinessException("common_xss_error_info");
                    }
                    if (!keyPattern3.matcher(paramValue).find() && (keyPattern4 == null || !keyPattern4.matcher(paramValue).find())) continue;
                    throw new ZKBusinessException("common_xss_error_info");
                }
            }
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            String enctype = request.getContentType();
            if (StringUtils.isNotEmpty((CharSequence)enctype) && enctype.contains("application/json")) {
                String params = new String(xssRequest.getBody(), "UTF-8");
                if (StringUtils.isBlank((CharSequence)params)) {
                    params = XssHttpServletRequestWrapper.readAsChars((HttpServletRequest)xssRequest);
                }
                if (StringUtils.isNotBlank((CharSequence)params)) {
                    HashSet<String> jsonSet = new HashSet<String>();
                    Object object = JSON.parse((String)params);
                    XssFilter.parseJsonToSet(object, jsonSet);
                    for (String paramValue : jsonSet) {
                        if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                        if (paramValue.length() < 255 && keyPattern2.matcher(paramValue).find() && !this.isBase64(paramValue)) {
                            throw new ZKBusinessException("common_xss_error_info");
                        }
                        if (keyPattern3.matcher(paramValue).find()) {
                            throw new ZKBusinessException("common_xss_error_info");
                        }
                        if (keyPattern4 == null || !keyPattern4.matcher(paramValue).find()) continue;
                        throw new ZKBusinessException("common_xss_error_info");
                    }
                }
            }
            chain.doFilter((ServletRequest)xssRequest, response);
        }
        catch (ZKBusinessException e) {
            e.printStackTrace();
            HttpServletResponse resp = (HttpServletResponse)response;
            resp.setContentType("text/html;charset=UTF-8");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(403);
            resp.getWriter().print(JSONObject.toJSONString((Object)ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]), (Object[])new Object[0])));
            return;
        }
    }

    private static void parseJsonToSet(Object object, Set<String> jsonSet) {
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            for (String entry2 : jsonObject.keySet()) {
                XssFilter.parseJsonToSet(jsonObject.get((Object)entry2), jsonSet);
            }
        } else if (object instanceof JSONArray) {
            JSONArray list = (JSONArray)object;
            for (int i = 0; i < list.size(); ++i) {
                XssFilter.parseJsonToSet(list.get(i), jsonSet);
            }
        } else {
            jsonSet.add(object + "");
        }
    }

    public void destroy() {
    }
}

